/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JPathField;
import com.sonicsw.ma.gui.util.JPathFieldAdapter;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPlugin;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import modelobjects.framework.EditRule;
import modelobjects.framework.IntToStringConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.ModelObjectPropagator;
import modelobjects.framework.model.ModelObjectValidator;
import modelobjects.framework.model.ModelPropagationException;
import modelobjects.framework.model.ModelValidationException;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JSpinnerViewAspectAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

public final class JPreferencesDialog
extends JPropSheetTabbedDialog {
    public static final String GENERAL_PREFS = "preferences.general";
    public static final String METRIC_PREFS = "preferences.metrics";
    public static final String NOTIFICATION_PREFS = "preferences.notifications";
    public static final String MESSAGE_PREFS = "preferences.messages";
    public static final String SAVE_WINDOW_SIZES = "saveWindowSizes";
    public static final String SAVE_WINDOW_POSITIONS = "saveWindowPositions";
    public static final String AM_POLL_FREQUENCY = "amPollFrequencySecs";
    public static final String USE_SPECIFIC_EDITOR_FOR_PROPERTIES = "useSpecificEditorForProperties";
    public static final String PROPERTY_FILE_EDITOR_CMD = "propertyFileEditorCmd";
    public static final int DEFAULT_AM_POLL_FREQUENCY = 30;
    private JCheckBox m_saveWindowSizes;
    private JCheckBox m_useSpecificEditorForProperties;
    private JCheckBox m_saveWindowPositions;
    private JTextField m_amPollFrequency;
    private JTextField m_propertyFileEditorCmd;
    private JTextField m_pollFrequency;
    private JTextField m_maxPlotPoints;
    private JTextField m_aggrPollFrequency;
    public static final String POLL_FREQUENCY = "pollFrequencySecs";
    public static final String MAX_PLOT_POINTS = "defaultMaxPlotPoints";
    public static final String AGGREGATE_POLL_FREQUENCY = "aggrPollFrequencySecs";
    public static final int DEFAULT_POLL_FREQUENCY = 30;
    public static final int DEFAULT_MAX_PLOT_POINTS = 500;
    public static final int DEFAULT_AGGREGATE_POLL_FREQUENCY = 60;
    private JTextField m_maxNotifications;
    public static final String MAX_NOTIFICATIONS = "maxNotifications";
    public static final int DEFAULT_MAX_NOTIFICATIONS = 200;
    private JPathField m_logFilePath;
    private JCheckBox m_logFile;
    private JSpinner m_logScreenShow;
    private JTextField m_connTimeout = new JTextField();
    private JTextField m_connCacheSize = new JTextField(2);
    public static final String LOG_FILE = "logFile";
    public static final String LOG_FILEPATH = "logFilePath";
    public static final String LOG_SCREENSHOW = "logScreenShowLast";
    private Model m_model;

    public JPreferencesDialog(JMAFrame parent, PreferenceManager pManager) {
        super(parent, "preferences", Model.class);
        this.setValidator(new Validator());
        this.setPropagator(new Propagator());
        this.m_model = new Model(pManager);
    }

    @Override
    public void maInitialize() {
        super.maInitialize();
        try {
            this.editInstance(null, this.m_model, false);
        }
        catch (Exception e) {
            MgmtConsole.displayMessage(4, "Error initializing the dialog.", e, true);
        }
    }

    @Override
    public void editInstance(IPlugin plugin, Object model, boolean isNew) throws Exception {
        super.editInstance(plugin, model, isNew);
    }

    @Override
    public void initUI() throws Exception {
        this.addTabPanel("General", this.createGeneralPanel());
        this.addTabPanel("Message Viewer", this.createMessagesPanel());
        this.addTabPanel("Metrics", this.createMetricsPanel());
        this.addTabPanel("Notifications", this.createNotificationsPanel());
    }

    @Override
    public void initForm() throws Exception {
        new JCheckBoxAdapter(ModelAspectId.forName(SAVE_WINDOW_SIZES), this.m_saveWindowSizes, EditRule.ALWAYS, null, this.getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName(SAVE_WINDOW_POSITIONS), this.m_saveWindowPositions, EditRule.ALWAYS, null, this.getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName(USE_SPECIFIC_EDITOR_FOR_PROPERTIES), this.m_useSpecificEditorForProperties, EditRule.ALWAYS, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName(PROPERTY_FILE_EDITOR_CMD), this.m_propertyFileEditorCmd, EditRule.ALWAYS, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("amPollFrequency"), this.m_amPollFrequency, EditRule.ALWAYS, new IntToStringConverter(), this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("connectionTimeout"), this.m_connTimeout, EditRule.ALWAYS, new IntToStringConverter(), this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("maxConnections"), this.m_connCacheSize, EditRule.ALWAYS, new IntToStringConverter(), this.getMediator());
        this.m_propertyFileEditorCmd.setEnabled(this.m_useSpecificEditorForProperties.isSelected());
        new JTextFieldAdapter(ModelAspectId.forName("pollFrequency"), this.m_pollFrequency, EditRule.ALWAYS, new IntToStringConverter(), this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("maxPlotPoints"), this.m_maxPlotPoints, EditRule.ALWAYS, new IntToStringConverter(), this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("aggrPollFrequency"), this.m_aggrPollFrequency, EditRule.ALWAYS, new IntToStringConverter(), this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName(MAX_NOTIFICATIONS), this.m_maxNotifications, EditRule.ALWAYS, new IntToStringConverter(), this.getMediator());
        new JSpinnerViewAspectAdapter(ModelAspectId.forName("logScreenShow"), this.m_logScreenShow, EditRule.ALWAYS, null, this.getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName(LOG_FILE), this.m_logFile, EditRule.ALWAYS, null, this.getMediator());
        new JPathFieldAdapter(ModelAspectId.forName(LOG_FILEPATH), this.m_logFilePath, EditRule.ALWAYS, null, this.getMediator());
    }

    private JPanel createMetricsPanel() {
        String unitSec = ResourceManager.getString(this.getClass(), new Object[]{"unit", "seconds"});
        JPartitionPanel res = new JPartitionPanel(true, "p,p", null);
        JPartitionPanel plotPanel = new JPartitionPanel("Metric Data");
        this.m_pollFrequency = new JTextField(3);
        this.m_maxPlotPoints = new JTextField(5);
        this.m_aggrPollFrequency = new JTextField(5);
        plotPanel.addRow("Poll Frequency", (JComponent)this.m_pollFrequency, unitSec);
        plotPanel.addRow("Default Max Plot Points", (JComponent)this.m_maxPlotPoints);
        plotPanel.addRow("Aggregate Poll Frequency", (JComponent)this.m_aggrPollFrequency, unitSec);
        res.add(plotPanel);
        return res;
    }

    private JPanel createNotificationsPanel() {
        JPartitionPanel res = new JPartitionPanel(true, "p", null);
        JPartitionPanel watchPanel = new JPartitionPanel("Watch Data");
        this.m_maxNotifications = new JTextField(3);
        watchPanel.addRow("Default Max Notifications", (JComponent)this.m_maxNotifications);
        res.add(watchPanel);
        return res;
    }

    private JPanel createMessagesPanel() {
        JPartitionPanel res = new JPartitionPanel(true, "p,p", null);
        JPartitionPanel screenPanel = new JPartitionPanel("Screen");
        this.m_logScreenShow = new JSpinner(new SpinnerNumberModel(1, 1, 1000, 1));
        screenPanel.addRow("Show last N messages", (JComponent)this.m_logScreenShow);
        res.add(screenPanel);
        JPartitionPanel filePanel = new JPartitionPanel("File");
        this.m_logFile = new JCheckBox();
        this.m_logFilePath = new JPathField(16);
        this.m_logFilePath.setButtonAction(new LogFileAction());
        filePanel.addRow("Log to file", (JComponent)this.m_logFile);
        filePanel.addRow("Log path", (JComponent)this.m_logFilePath);
        filePanel.addRow(this.createClearLogFilePanel());
        res.add(filePanel);
        return res;
    }

    private JPanel createClearLogFilePanel() {
        JPartitionPanel res = new JPartitionPanel(false, "p, r", null);
        res.add(new JButton(new LogFileClearAction()));
        res.add(new JPanel());
        return res;
    }

    private JPanel createGeneralPanel() {
        String unitSec = ResourceManager.getString(this.getClass(), new Object[]{"unit", "seconds"});
        JPartitionPanel res = new JPartitionPanel(true, "p,p,p,p,p", null);
        JPartitionPanel generalPanel = new JPartitionPanel(true, "p,p", "Window Size / Position");
        this.m_saveWindowSizes = new JCheckBox(ResourceManager.getString(this.getClass(), "JPreferencesDialog.SaveWindowSizes"));
        generalPanel.add(this.m_saveWindowSizes);
        this.m_saveWindowPositions = new JCheckBox(ResourceManager.getString(this.getClass(), "JPreferencesDialog.SaveWindowPositions"));
        generalPanel.add(this.m_saveWindowPositions);
        JPartitionPanel pollPanel = new JPartitionPanel(false, "p,r,p", "Agent Manager");
        this.m_amPollFrequency = new JTextField(4);
        pollPanel.addRow(ResourceManager.getString(this.getClass(), "JPreferencesDialog.AMPollFrequency"), (JComponent)this.m_amPollFrequency, unitSec);
        JPartitionPanel resetPanel = new JPartitionPanel(false, "r,p", "User Preferences");
        resetPanel.add(new JLabel("Delete all stored user preferences"));
        resetPanel.add(new JButton(new ResetAction()));
        this.m_useSpecificEditorForProperties = new JCheckBox();
        this.m_propertyFileEditorCmd = new JTextField(50);
        this.m_useSpecificEditorForProperties.addItemListener(new PropertyFileEditorCmdListener(this.m_propertyFileEditorCmd));
        JPartitionPanel propertyEditorPanel = new JPartitionPanel(false, "p,r", ResourceManager.getString(this.getClass(), "JPreferencesDialog.PropertyFileEditor"));
        propertyEditorPanel.addRow(ResourceManager.getString(this.getClass(), "JPreferencesDialog.UseSpecificFileEditor"), (JComponent)this.m_useSpecificEditorForProperties);
        propertyEditorPanel.addRow(ResourceManager.getString(this.getClass(), "JPreferencesDialog.FileEditorCmd"), (JComponent)this.m_propertyFileEditorCmd);
        res.add(generalPanel);
        res.add(pollPanel);
        res.add(this.createGeneralConnectionPanel());
        res.add(resetPanel);
        res.add(propertyEditorPanel);
        return res;
    }

    private JPanel createGeneralConnectionPanel() {
        JPartitionPanel panel = new JPartitionPanel("Connection");
        String unitSec = ResourceManager.getString(this.getClass(), new Object[]{"unit", "seconds"});
        panel.addRow(ResourceManager.getString(this.getClass(), "JPreferencesDialog.Connection.Timeout"), (JComponent)this.m_connTimeout, unitSec);
        panel.addRow("Maximum cache size", (JComponent)this.m_connCacheSize);
        return panel;
    }

    public class ResetAction
    extends BasicGuiAction {
        public ResetAction() {
            super("JPreferencesDialog.reset");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String message = ResourceManager.getString(this.getClass(), "JPreferencesDialog.ResetWarning");
            int result = JOptionPane.showConfirmDialog(null, message, this.getValue("Name") + " " + JPreferencesDialog.this.getTitle(), 0, 2);
            if (result == 0) {
                JPreferencesDialog.this.setVisible(false);
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        PreferenceManager prefMgr = PreferenceManager.getInstance();
                        prefMgr.resetUserPreferences();
                        JPreferencesDialog.this.m_model = new Model(prefMgr);
                        try {
                            JPreferencesDialog.this.editInstance(null, JPreferencesDialog.this.m_model, false);
                            JPreferencesDialog.this.initForm();
                            BasicAction action = JPreferencesDialog.this.getDefaultOKAction();
                            if (action != null) {
                                action.setEnabled(true);
                                JButton button = ((JButtonPanel)JPreferencesDialog.this.getButtonPanel()).getButton((String)action.getValue("ActionCommandKey"));
                                if (button != null) {
                                    button.doClick();
                                }
                            }
                        }
                        catch (Exception e) {
                            MgmtConsole.displayMessage(4, e.toString(), e, true);
                        }
                    }
                });
                t.start();
            }
        }
    }

    private static class Propagator
    implements ModelObjectPropagator {
        private Propagator() {
        }

        @Override
        public void propagateModelEdit(ModelObjectAdapter adapter) throws ModelPropagationException {
            Model model = (Model)adapter.getModelObject();
            model.m_pManager.setBoolean(JPreferencesDialog.GENERAL_PREFS, JPreferencesDialog.SAVE_WINDOW_SIZES, model.getSaveWindowSizes(), false);
            model.m_pManager.setBoolean(JPreferencesDialog.GENERAL_PREFS, JPreferencesDialog.SAVE_WINDOW_POSITIONS, model.getSaveWindowPositions(), false);
            model.m_pManager.setBoolean(JPreferencesDialog.GENERAL_PREFS, JPreferencesDialog.USE_SPECIFIC_EDITOR_FOR_PROPERTIES, model.getUseSpecificEditorForProperties(), false);
            model.m_pManager.setString(JPreferencesDialog.GENERAL_PREFS, JPreferencesDialog.PROPERTY_FILE_EDITOR_CMD, model.getPropertyFileEditorCmd(), false);
            model.m_pManager.setInt(JPreferencesDialog.GENERAL_PREFS, JPreferencesDialog.AM_POLL_FREQUENCY, model.getAmPollFrequency(), false);
            model.m_pManager.setInt(JPreferencesDialog.GENERAL_PREFS, DomainConnectionModel.PREFS_TIMEOUT, model.getConnectionTimeout(), false);
            model.m_pManager.setInt(JPreferencesDialog.GENERAL_PREFS, DomainConnectionModel.PREFS_MAX_CONNECTIONS, model.getMaxConnections(), false);
            model.m_pManager.setInt(JPreferencesDialog.METRIC_PREFS, JPreferencesDialog.POLL_FREQUENCY, model.getPollFrequency(), false);
            model.m_pManager.setInt(JPreferencesDialog.METRIC_PREFS, JPreferencesDialog.MAX_PLOT_POINTS, model.getMaxPlotPoints(), false);
            model.m_pManager.setInt(JPreferencesDialog.METRIC_PREFS, JPreferencesDialog.AGGREGATE_POLL_FREQUENCY, model.getAggrPollFrequency(), false);
            model.m_pManager.setInt(JPreferencesDialog.NOTIFICATION_PREFS, JPreferencesDialog.MAX_NOTIFICATIONS, model.getMaxNotifications(), false);
            model.m_pManager.setBoolean(JPreferencesDialog.MESSAGE_PREFS, JPreferencesDialog.LOG_FILE, model.getLogFile(), false);
            model.m_pManager.setString(JPreferencesDialog.MESSAGE_PREFS, JPreferencesDialog.LOG_FILEPATH, model.getLogFilePath(), false);
            model.m_pManager.setInt(JPreferencesDialog.MESSAGE_PREFS, JPreferencesDialog.LOG_SCREENSHOW, model.getLogScreenShow(), false);
            MgmtConsole.resetLogToFile(false);
            model.m_pManager.flush();
        }

        @Override
        public void propagateModelCreation(ModelObjectAdapter modelObjectAdapter) throws ModelPropagationException {
        }

        @Override
        public void propagateModelDeletion(ModelObjectAdapter modelObjectAdapter) throws ModelPropagationException {
        }
    }

    private static class Validator
    implements ModelObjectValidator {
        private Validator() {
        }

        @Override
        public void validateModelEdit(ModelObjectAdapter adapter) throws ModelValidationException {
            String path;
            Model model = (Model)adapter.getModelObject();
            if (model.getAmPollFrequency() < 5) {
                throw new ModelValidationException("The Agent Manager poll frequency must be >= 5 seconds");
            }
            if (model.getConnectionTimeout() < 0) {
                throw new ModelValidationException("The connection timeout must be a positive number");
            }
            if (model.getMaxConnections() < 1) {
                throw new ModelValidationException("The recently used cache size must be >= 1");
            }
            if (model.getMaxConnections() > 100) {
                throw new ModelValidationException("The recently used cache size must be <= 100");
            }
            if (model.getPollFrequency() < 10) {
                throw new ModelValidationException("The poll frequency must be >= 10 seconds");
            }
            if (model.getPollFrequency() > 900) {
                throw new ModelValidationException("The poll frequency must be <= 900 seconds");
            }
            if (model.getMaxPlotPoints() < 2) {
                throw new ModelValidationException("The default maximum number of plot points must be >= 2");
            }
            if (model.getMaxPlotPoints() > 10000) {
                throw new ModelValidationException("The default maximum number of plot points must be <= 10000");
            }
            if (model.getAggrPollFrequency() < 60) {
                throw new ModelValidationException("The aggregate poll frequency must be >= 60 seconds");
            }
            if (model.getMaxNotifications() < 1) {
                throw new ModelValidationException("The maximum number of notifications per watch window must be > 0");
            }
            if (model.getMaxNotifications() > 1000) {
                throw new ModelValidationException("The maximum number of notifications per watch window must be <= 1000");
            }
            if (model.getLogFile() && ((path = model.getLogFilePath()) == null || path.length() == 0)) {
                throw new ModelValidationException("Log file path can't be an empty string");
            }
        }

        @Override
        public void validateModelCreation(ModelObjectAdapter adapter) throws ModelValidationException {
            throw new ModelValidationException("Create invalid");
        }

        @Override
        public void validateModelDeletion(ModelObjectAdapter adapter) throws ModelValidationException {
            throw new ModelValidationException("Delete invalid");
        }
    }

    public class Model {
        protected PreferenceManager m_pManager;
        private boolean m_saveWindowSizes = false;
        private boolean m_saveWindowPositions = false;
        private boolean m_useSpecificEditorForProperties = false;
        private int m_amPollFrequency;
        private int m_connTimeout;
        private int m_maxConnections;
        private String m_propertyFileEditorCmd;
        private int m_pollFrequency;
        private int m_maxPlotPoints;
        private int m_aggrPollFrequency;
        private int m_secondsPerPixel;
        private int m_width;
        private int m_height;
        private int m_maxNotifications;
        private int m_logScreenShow;
        private String m_logFilePath;
        private boolean m_logFile;

        private Model(PreferenceManager pManager) {
            this.m_pManager = pManager;
            this.m_saveWindowSizes = pManager.getBoolean(JPreferencesDialog.GENERAL_PREFS, JPreferencesDialog.SAVE_WINDOW_SIZES, true);
            this.m_saveWindowPositions = pManager.getBoolean(JPreferencesDialog.GENERAL_PREFS, JPreferencesDialog.SAVE_WINDOW_POSITIONS, true);
            this.m_useSpecificEditorForProperties = pManager.getBoolean(JPreferencesDialog.GENERAL_PREFS, JPreferencesDialog.USE_SPECIFIC_EDITOR_FOR_PROPERTIES, false);
            this.m_propertyFileEditorCmd = pManager.getString(JPreferencesDialog.GENERAL_PREFS, JPreferencesDialog.PROPERTY_FILE_EDITOR_CMD, "");
            this.m_amPollFrequency = pManager.getInt(JPreferencesDialog.GENERAL_PREFS, JPreferencesDialog.AM_POLL_FREQUENCY, 30);
            this.m_connTimeout = pManager.getInt(JPreferencesDialog.GENERAL_PREFS, DomainConnectionModel.PREFS_TIMEOUT, 30);
            this.m_maxConnections = pManager.getInt(JPreferencesDialog.GENERAL_PREFS, DomainConnectionModel.PREFS_MAX_CONNECTIONS, 10);
            this.m_pollFrequency = pManager.getInt(JPreferencesDialog.METRIC_PREFS, JPreferencesDialog.POLL_FREQUENCY, 30);
            this.m_maxPlotPoints = pManager.getInt(JPreferencesDialog.METRIC_PREFS, JPreferencesDialog.MAX_PLOT_POINTS, 500);
            this.m_aggrPollFrequency = pManager.getInt(JPreferencesDialog.METRIC_PREFS, JPreferencesDialog.AGGREGATE_POLL_FREQUENCY, 60);
            this.m_maxNotifications = pManager.getInt(JPreferencesDialog.NOTIFICATION_PREFS, JPreferencesDialog.MAX_NOTIFICATIONS, 200);
            this.m_logFile = pManager.getBoolean(JPreferencesDialog.MESSAGE_PREFS, JPreferencesDialog.LOG_FILE, false);
            this.m_logFilePath = pManager.getString(JPreferencesDialog.MESSAGE_PREFS, JPreferencesDialog.LOG_FILEPATH, System.getProperty("user.home") + File.separator + "console.log");
            this.m_logScreenShow = pManager.getInt(JPreferencesDialog.MESSAGE_PREFS, JPreferencesDialog.LOG_SCREENSHOW, 100);
        }

        public boolean getSaveWindowSizes() {
            return this.m_saveWindowSizes;
        }

        public void setSaveWindowSizes(boolean value) {
            this.m_saveWindowSizes = value;
        }

        public boolean getSaveWindowPositions() {
            return this.m_saveWindowPositions;
        }

        public void setSaveWindowPositions(boolean value) {
            this.m_saveWindowPositions = value;
        }

        public boolean getUseSpecificEditorForProperties() {
            return this.m_useSpecificEditorForProperties;
        }

        public void setUseSpecificEditorForProperties(boolean value) {
            this.m_useSpecificEditorForProperties = value;
        }

        public String getPropertyFileEditorCmd() {
            return this.m_propertyFileEditorCmd;
        }

        public void setPropertyFileEditorCmd(String value) {
            this.m_propertyFileEditorCmd = value;
        }

        public int getAmPollFrequency() {
            return this.m_amPollFrequency;
        }

        public void setAmPollFrequency(int pollFrequency) {
            this.m_amPollFrequency = pollFrequency;
        }

        public int getConnectionTimeout() {
            return this.m_connTimeout;
        }

        public void setConnectionTimeout(int value) {
            this.m_connTimeout = value;
        }

        public int getMaxConnections() {
            return this.m_maxConnections;
        }

        public void setMaxConnections(int value) {
            this.m_maxConnections = value;
        }

        public int getPollFrequency() {
            return this.m_pollFrequency;
        }

        public void setPollFrequency(int pollFrequency) {
            this.m_pollFrequency = pollFrequency;
        }

        public int getMaxPlotPoints() {
            return this.m_maxPlotPoints;
        }

        public void setMaxPlotPoints(int maxPlotPoints) {
            this.m_maxPlotPoints = maxPlotPoints;
        }

        public int getAggrPollFrequency() {
            return this.m_aggrPollFrequency;
        }

        public void setAggrPollFrequency(int aggrPollFrequency) {
            this.m_aggrPollFrequency = aggrPollFrequency;
        }

        public int getSecondsPerPixel() {
            return this.m_secondsPerPixel;
        }

        public void setSecondsPerPixel(int secondsPerPixel) {
            this.m_secondsPerPixel = secondsPerPixel;
        }

        public int getWidth() {
            return this.m_width;
        }

        public void setWidth(int width) {
            this.m_width = width;
        }

        public int getHeight() {
            return this.m_height;
        }

        public void setHeight(int height) {
            this.m_height = height;
        }

        public int getMaxNotifications() {
            return this.m_maxNotifications;
        }

        public void setMaxNotifications(int maxNotifications) {
            this.m_maxNotifications = maxNotifications;
        }

        public boolean getLogFile() {
            return this.m_logFile;
        }

        public void setLogFile(boolean logFile) {
            this.m_logFile = logFile;
        }

        public String getLogFilePath() {
            return this.m_logFilePath;
        }

        public void setLogFilePath(String logFilePath) {
            this.m_logFilePath = logFilePath;
        }

        public Integer getLogScreenShow() {
            return new Integer(this.m_logScreenShow);
        }

        public void setLogScreenShow(Integer logScreenShow) {
            this.m_logScreenShow = logScreenShow;
        }
    }

    class LogFileAction
    extends BasicGuiAction {
        LogFileAction() {
            super("tool.prefs.log.file.browse");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(new File(JPreferencesDialog.this.m_logFilePath.getText()));
            chooser.setApproveButtonText("OK");
            chooser.setDialogTitle("Choose log path");
            int res = chooser.showSaveDialog(JPreferencesDialog.this);
            if (res == 0) {
                JPreferencesDialog.this.m_logFilePath.setText(chooser.getSelectedFile().getPath());
            }
        }
    }

    class PropertyFileEditorCmdListener
    implements ItemListener {
        private final JComponent propertyFileEditorCmdComponent;

        PropertyFileEditorCmdListener(JComponent propertyFileEditorCmdComponent) {
            this.propertyFileEditorCmdComponent = propertyFileEditorCmdComponent;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object evnSourceObj;
            if (this.propertyFileEditorCmdComponent != null && (evnSourceObj = e.getSource()) instanceof AbstractButton) {
                boolean isSelected = ((AbstractButton)evnSourceObj).getModel().isSelected();
                this.propertyFileEditorCmdComponent.setEnabled(isSelected);
            }
        }
    }

    class LogFileClearAction
    extends BasicGuiAction {
        LogFileClearAction() {
            super("tool.prefs.log.file.clear");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            String logFilePath = JPreferencesDialog.this.m_logFilePath.getText();
            JWaitCursor wc = new JWaitCursor(JPreferencesDialog.this);
            try {
                File logFile = new File(logFilePath);
                logFile.delete();
                Toolkit.getDefaultToolkit().beep();
                JPreferencesDialog.this.m_logFilePath.setText("");
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to clear log file: " + logFilePath, e, false);
            }
            finally {
                wc.release();
            }
        }
    }
}

