/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IConfigType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class JTypeManagerDialog
extends JMADialog {
    private JTree m_tree = new JTree();
    private JSplitPane m_split = new JSplitPane(1);
    private JTabbedPane m_tab = new JTabbedPane();

    public JTypeManagerDialog(JMAFrame parent, IDirectoryAdminService ds) {
        super(parent, "typeManager");
        this.m_tree.setModel(this.buildTreeModel(ds));
        this.m_tree.setCellRenderer(new TMCellRenderer());
    }

    @Override
    public void maInitialize() {
        this.setJMenuBar(this.createMenuBar());
        this.m_tree.expandRow(0);
        this.m_tree.setRootVisible(false);
        this.m_tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int row;
                if (evt.isPopupTrigger()) {
                    System.out.println("Popup Menu");
                } else if (evt.getClickCount() == 2 && (row = JTypeManagerDialog.this.m_tree.getRowForLocation(evt.getX(), evt.getY())) >= 0) {
                    TreePath path = JTypeManagerDialog.this.m_tree.getPathForRow(row);
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    TypeModel typeModel = (TypeModel)node.getUserObject();
                    if (typeModel.m_type == null) {
                        return;
                    }
                    int tabIndex = JTypeManagerDialog.this.m_tab.indexOfTab(typeModel.m_name);
                    if (tabIndex >= 0) {
                        JTypeManagerDialog.this.m_tab.setSelectedIndex(tabIndex);
                    } else {
                        JTextArea text = new JTextArea();
                        text.setEditable(false);
                        try {
                            IConfigServer server = MgmtConsole.getMgmtConsole().getSelectedWorkspaceWindow().getContext().getConfigContext().getConfigServer();
                            IConfigType type = server.loadConfigType(typeModel.m_name, typeModel.m_version);
                            text.setText(type.toString());
                        }
                        catch (Exception e) {
                            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                            e.printStackTrace();
                        }
                        JTypeManagerDialog.this.m_tab.addTab(typeModel.m_name, ResourceManager.getTypeIcon(typeModel.m_type), new JScrollPane(text));
                        JTypeManagerDialog.this.m_tab.setSelectedIndex(JTypeManagerDialog.this.m_tab.indexOfTab(typeModel.m_name));
                    }
                }
            }
        });
        this.m_split.setLeftComponent(new JScrollPane(this.m_tree));
        this.m_split.setRightComponent(this.m_tab);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_split, "Center");
    }

    @Override
    public void maCleanup() {
    }

    private JMenuBar createMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu mFile = new JMenu("File");
        JMenuItem mFileImport = new JMenuItem("Import...");
        JMenuItem mFileExport = new JMenuItem("Export...");
        JMenuItem mFileClose = new JMenuItem("Close");
        mFileImport.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser iChooser = new JFileChooser();
                iChooser.setApproveButtonText("OK");
                int res = iChooser.showOpenDialog(JTypeManagerDialog.this);
                if (res == 0) {
                    String typeUrl = iChooser.getSelectedFile().getPath();
                    WorkspaceWindow ww = ((MgmtConsole)JTypeManagerDialog.this.getParent()).getSelectedWorkspaceWindow();
                    ConfigServerUtility csu = null;
                    try {
                        csu = new ConfigServerUtility();
                        csu.connect(ww.getContext().getConnectionInfo().getDirectoryService(), true);
                        csu.importType(typeUrl, "http://www.sonicsw.com/sonicmf", true);
                    }
                    catch (ConfigServiceException e) {
                        MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                        e.printStackTrace();
                        Exception linked = e.getLinkedException();
                        if (linked != null) {
                            linked.printStackTrace();
                            if (linked instanceof ConfigServiceException) {
                                Exception inner = ((ConfigServiceException)((Object)linked)).getLinkedException();
                                inner.printStackTrace();
                            }
                        }
                    }
                    finally {
                        if (csu != null) {
                            try {
                                csu.disconnect();
                            }
                            catch (ConfigServiceException e) {
                                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
        mFileExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        mFile.add(mFileImport);
        mFile.add(mFileExport);
        mFile.addSeparator();
        mFile.add(mFileClose);
        JMenu mEdit = new JMenu("Edit");
        JMenuItem mEditDelete = new JMenuItem("Delete");
        mEditDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        mEdit.add(mEditDelete);
        mb.add(mFile);
        mb.add(mEdit);
        return mb;
    }

    private TreeModel buildTreeModel(IDirectoryAdminService ds) {
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(new TypeModel()));
        try {
            IDirIdentity[] dId = ds.listDirectories("/mx/configTypes/");
            MutableTreeNode rootNode = (MutableTreeNode)treeModel.getRoot();
            for (int i = 0; i < dId.length; ++i) {
                String idName = dId[i].getName();
                String newName = idName.substring(idName.lastIndexOf(47) + 1);
                DefaultMutableTreeNode newdNode = new DefaultMutableTreeNode(new TypeModel(newName, null), true);
                IElementIdentity[] eId = ds.listElements(idName);
                for (int j = 0; j < eId.length; ++j) {
                    String eIdName = eId[j].getName();
                    String neweName = eIdName.substring(eIdName.lastIndexOf(47) + 1);
                    MutableTreeNode parentNode = newdNode;
                    int index = neweName.indexOf(95);
                    if (index > 0) {
                        parentNode = this.getParentWithName(treeModel, newdNode, neweName.substring(0, index));
                    }
                    String sVersion = newName;
                    DefaultMutableTreeNode neweNode = new DefaultMutableTreeNode(new TypeModel(neweName, neweName, sVersion), false);
                    treeModel.insertNodeInto(neweNode, parentNode, this.findInsertPosition(parentNode, neweName));
                }
                treeModel.insertNodeInto(newdNode, rootNode, this.findInsertPosition(rootNode, newName));
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            e.printStackTrace();
        }
        return treeModel;
    }

    private MutableTreeNode getParentWithName(DefaultTreeModel treeModel, MutableTreeNode parentNode, String name) {
        Enumeration<? extends TreeNode> en = parentNode.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)en.nextElement();
            TypeModel model = (TypeModel)childNode.getUserObject();
            if (!model.m_name.equals(name)) continue;
            return childNode;
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new TypeModel(name, null));
        treeModel.insertNodeInto(newNode, parentNode, this.findInsertPosition(parentNode, name));
        return newNode;
    }

    private int findInsertPosition(MutableTreeNode node, String name) {
        int res = -1;
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            TypeModel childModel = (TypeModel)childNode.getUserObject();
            if (childModel.m_name.compareTo(name) <= 0) continue;
            res = i;
            break;
        }
        return res == -1 ? node.getChildCount() : res;
    }

    class TMCellRenderer
    extends DefaultTreeCellRenderer {
        TMCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            TypeModel typeModel = (TypeModel)((DefaultMutableTreeNode)value).getUserObject();
            if (typeModel != null) {
                c.setText(typeModel.m_name);
                if (typeModel.m_type != null) {
                    c.setIcon(ResourceManager.getTypeIcon(typeModel.m_type));
                }
            }
            return c;
        }
    }

    class TypeModel {
        public String m_name;
        public String m_type;
        public String m_version;

        public TypeModel() {
            this("Root", null);
        }

        public TypeModel(String name, String type) {
            this(name, type, null);
        }

        public TypeModel(String name, String type, String version) {
            this.m_name = name;
            this.m_type = type;
            this.m_version = version;
        }

        public String toString() {
            return "TypeModel : " + this.m_name;
        }
    }
}

