/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui;

import com.sonicsw.ma.gui.JWorkspacePanel;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.ConfigDomainFolderPlugin;
import com.sonicsw.ma.gui.config.ConfigPluginFilter;
import com.sonicsw.ma.gui.config.ConfigPluginTreeCellRenderer;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.util.FilterTreeModel;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.ClasspathToolInfo;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.PluginAttributes;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class JWorkspaceConfigPanel
extends JWorkspacePanel {
    public static final String PANEL_NAME = "Configure";

    public JWorkspaceConfigPanel() {
        this.setProperties();
    }

    private void setProperties() {
        this.setName(PANEL_NAME);
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon(this.getClass(), "configure");
    }

    private AbstractGUIPlugin instantiateDomainPlugin(IPluginContext context, Class pluginClass) {
        try {
            Constructor cESBDomain = pluginClass.getConstructor(IPluginContext.class);
            return (AbstractGUIPlugin)cESBDomain.newInstance(context);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to instantiate root configuration node", e, false);
            return null;
        }
    }

    @Override
    public void initialize(IPluginContext context) {
        ConfigDomainFolderPlugin rootNode = new ConfigDomainFolderPlugin(context);
        rootNode.setFilter(new ConfigPluginFilter());
        RootConfigPlugin realRootNode = new RootConfigPlugin(context);
        realRootNode.add(rootNode);
        HashMap toolsMap = context.getLibrary().getToolsMap();
        for (Map.Entry entry : toolsMap.entrySet()) {
            ClasspathToolInfo toolInfo;
            AbstractGUIPlugin rootDomainPlugin;
            if (!(entry.getValue() instanceof ClasspathToolInfo) || (rootDomainPlugin = this.instantiateDomainPlugin(context, (toolInfo = (ClasspathToolInfo)entry.getValue()).getRootPluginClass())) == null) continue;
            realRootNode.add(rootDomainPlugin);
        }
        this.m_tree.setRootVisible(false);
        this.m_tree.setCellRenderer(new ConfigPluginTreeCellRenderer());
        this.m_tree.setModel(new FilterTreeModel(realRootNode, false, true));
        this.m_tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
                if (!JWorkspaceConfigPanel.this.m_context.getConnectionInfo().isConnected()) {
                    throw new ExpandVetoException(evt, "Cannot expand - no connection");
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
            }
        });
        super.initialize(context);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public JComponent[] getMenuItems(int type) {
        return new JComponent[0];
    }

    @Override
    public AbstractButton[] getToolbarItems() {
        return new AbstractButton[0];
    }

    @Override
    public Object getSelectedItem() {
        Component fc = this.getFocusComponent();
        if (fc instanceof JTree) {
            return ((JTree)fc).getSelectionPath().getLastPathComponent();
        }
        if (fc instanceof JTable) {
            int row = ((JTable)fc).getSelectedRow();
            IModelTableModel tableModel = (IModelTableModel)((JTable)fc).getModel();
            return tableModel.getRowModel(row);
        }
        return null;
    }

    @Override
    public Object[] getSelectedItems() {
        Component fc = this.getFocusComponent();
        if (fc instanceof JTree) {
            TreePath[] entry = ((JTree)fc).getSelectionPaths();
            Object[] res = new Object[entry.length];
            for (int i = 0; i < entry.length; ++i) {
                res[i] = entry[i].getLastPathComponent();
            }
            return res;
        }
        if (fc instanceof JTable) {
            int[] rows = ((JTable)fc).getSelectedRows();
            IModelTableModel tableModel = (IModelTableModel)((JTable)fc).getModel();
            Object[] res = new Object[rows.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = tableModel.getRowModel(rows[i]);
            }
            return res;
        }
        return null;
    }

    @Override
    protected void doExpansionImpl(DefaultMutableTreeNode node, boolean bForceRefresh, boolean isSelectionChange) {
        if (!this.m_context.getConnectionInfo().isConnected()) {
            return;
        }
        super.doExpansionImpl(node, bForceRefresh, isSelectionChange);
    }

    @Override
    protected String getCorrectConfigPath(String name) {
        return "/Configured Objects" + name;
    }

    private class RootConfigPlugin
    extends AbstractGUIPlugin {
        public RootConfigPlugin(IPluginContext context) {
            super(context, "<not visible>");
            this.setProperties();
        }

        private void setProperties() {
            this.setAttributes(new PluginAttributes());
        }

        @Override
        public boolean expand() {
            return true;
        }

        @Override
        public Object getModel() {
            return null;
        }

        @Override
        public JPropSheetDialog getPropSheetDialog() {
            return null;
        }

        @Override
        protected JWorkspacePanel getWorkspacePanel() {
            return this.getPluginContext().getWorkspace().getWorkspacePanel(JWorkspaceConfigPanel.PANEL_NAME);
        }

        @Override
        public IPlugin goToPlugin(String path) {
            return super.goToPlugin(JWorkspaceConfigPanel.this.getCorrectConfigPath(path));
        }
    }
}

