/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.AbstractConfigPlugin;
import com.sonicsw.ma.gui.table.AbstractTableContentPane;
import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.table.ITableContentPane;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.PluginMouseClickListener;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.SwingWorker;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IFolderPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginChangeListener;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mx.config.ConfigChange;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class JWorkspacePanel
extends JPanel
implements TreeSelectionListener,
ListSelectionListener,
FocusListener,
IConfigChangeListener {
    protected IPluginContext m_context;
    protected JSplitPane m_split;
    protected JTree m_tree;
    protected JRowTable m_tableCurrent = null;
    protected boolean m_bIsInitialized = false;
    private JComponent m_defaultContentPane = null;
    private Component m_lastFocus = null;
    private PluginTreeExpansionListener m_tel = null;

    public JWorkspacePanel() {
        super(new BorderLayout());
        this.setWSPanelBorder();
        this.m_split = new JSplitPane(1, true);
        this.m_split.setDividerLocation(250);
        this.m_tree = new JTree(){

            @Override
            public boolean isFixedRowHeight() {
                return true;
            }

            @Override
            public String getToolTipText(MouseEvent evt) {
                TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
                String text = null;
                if (path != null && path.getLastPathComponent() instanceof IPlugin) {
                    text = ((AbstractGUIPlugin)path.getLastPathComponent()).getToolTipText();
                }
                return text;
            }
        };
        this.m_tel = new PluginTreeExpansionListener();
        this.m_tree.addTreeWillExpandListener(this.m_tel);
        this.m_tree.addMouseListener(new PluginMouseClickListener(this.m_tree));
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        this.m_split.setLeftComponent(new ExtendedJScrollPane(this.m_tree));
        this.m_split.setFocusable(false);
        this.m_tree.getSelectionModel().setSelectionMode(4);
        this.m_tree.addTreeSelectionListener(this);
        this.m_tree.addFocusListener(this);
        this.setContentPane(null);
        this.addSplitProperty();
    }

    private void setWSPanelBorder() {
        this.setBorder(BorderFactory.createEmptyBorder(JPartitionPanel.BORDER_SIZE, JPartitionPanel.BORDER_SIZE, JPartitionPanel.BORDER_SIZE, JPartitionPanel.BORDER_SIZE));
    }

    private void addSplitProperty() {
        this.add((Component)this.m_split, "Center");
    }

    public boolean isInitialized() {
        return this.m_bIsInitialized;
    }

    public boolean getTreeExpansionMode() {
        return this.m_tel.getAsyncMode();
    }

    public void setTreeExpansionMode(boolean bAsync) {
        this.m_tel.setAsyncMode(bAsync);
    }

    public Icon getIcon() {
        return null;
    }

    public void initialize(IPluginContext context) {
        if (!this.isInitialized()) {
            this.m_context = context;
            this.m_tree.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
                    Object root;
                    Object node = evt.getPath().getLastPathComponent();
                    if (node.equals(root = JWorkspacePanel.this.m_tree.getModel().getRoot())) {
                        throw new ExpandVetoException(evt, "Can't collapse the root");
                    }
                }
            });
            ((DefaultMutableTreeNode)this.m_tree.getModel().getRoot()).setParent(null);
            context.getConfigContext().getConfigServer().addConfigChangeListener(null, (IConfigChangeListener)this, null, null);
            boolean bOldMode = this.getTreeExpansionMode();
            this.setTreeExpansionMode(false);
            for (int i = this.m_tree.getVisibleRowCount() - 1; i >= 0; --i) {
                this.m_tree.collapseRow(i);
                this.m_tree.expandRow(i);
            }
            this.setTreeExpansionMode(bOldMode);
            this.m_bIsInitialized = true;
        }
    }

    public void dispose() {
        if (this.m_tree != null) {
            this.m_tree.removeFocusListener(this);
            this.m_tree.removeTreeSelectionListener(this);
            ToolTipManager.sharedInstance().unregisterComponent(this.m_tree);
            this.m_tree = null;
        }
        if (this.m_tableCurrent != null) {
            this.m_tableCurrent.cleanup();
        }
        this.removeAll();
        this.m_context = null;
        this.m_defaultContentPane = null;
        this.m_lastFocus = null;
    }

    public abstract Object[] getSelectedItems();

    public abstract Object getSelectedItem();

    public abstract AbstractButton[] getToolbarItems();

    public abstract JComponent[] getMenuItems(int var1);

    public boolean isPluginActive(IPlugin plugin) {
        IContentPane pane = this.getContentPane();
        return pane.getPlugin() == plugin;
    }

    public IContentPane getContentPane() {
        Component c = this.m_split.getRightComponent();
        return c instanceof IContentPane ? (IContentPane)((Object)c) : null;
    }

    public IContentPane getContentPaneIfShown(IPlugin plugin) {
        IContentPane pane = this.getContentPane();
        return pane != null && pane.getPlugin() == plugin ? pane : null;
    }

    public IContentPane refreshContentPaneIfShown(IPlugin plugin, IPlugin childPlugin) {
        IContentPane pane = this.getContentPaneIfShown(plugin);
        if (pane != null) {
            if (pane instanceof IPluginChangeListener) {
                ((IPluginChangeListener)((Object)pane)).onUpdated(childPlugin);
            } else {
                pane.refresh();
            }
        }
        return pane;
    }

    public IContentPane refreshContentPaneIfShown(IPlugin plugin) {
        IContentPane pane = this.getContentPaneIfShown(plugin);
        if (pane != null) {
            pane.refresh();
        }
        return pane;
    }

    public JTree getTree() {
        return this.m_tree;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        DefaultMutableTreeNode node = null;
        if (this.m_tree.getSelectionCount() > 0) {
            node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
        }
        return node;
    }

    public Component getFocusComponent() {
        return this.m_lastFocus;
    }

    public void elementAdded(ConfigChange evt) {
        Helper.logDebugMessage(this.getClass().getName() + "::elementAdded " + evt.getName());
        this._elementAdded(evt.getName());
    }

    private void _elementAdded(final String name) {
        SwingWorker sw = new SwingWorker(){
            IPlugin m_parentPlugin;
            {
                this.m_parentPlugin = JWorkspacePanel.this.getPathToPluginParent(name);
            }

            @Override
            public Object construct() {
                Map attributes = null;
                if (this.m_parentPlugin != null) {
                    if (JWorkspacePanel.this.getPathToPlugin(name) != null) {
                        return null;
                    }
                    try {
                        attributes = JWorkspacePanel.this.m_context.getConfigContext().getConfigServer().getMetaAttributes(name);
                    }
                    catch (Exception e) {
                        MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                        e.printStackTrace();
                    }
                }
                return attributes;
            }

            @Override
            public void finished() {
                Map attributes = (Map)this.getValue();
                if (JWorkspacePanel.this.getPathToPlugin(name) != null) {
                    return;
                }
                if (attributes != null && this.m_parentPlugin != null) {
                    this.m_parentPlugin.onAdded(name, attributes);
                }
            }
        };
        sw.start();
    }

    public void elementUpdated(final ConfigChange evt) {
        Helper.logDebugMessage(this.getClass().getName() + "::elementUpdated " + evt.getName());
        Helper.invoke(new Runnable(){

            @Override
            public void run() {
                IPlugin plugin = JWorkspacePanel.this.getPathToPlugin(evt.getName());
                if (plugin != null) {
                    plugin.onUpdated();
                } else {
                    JWorkspacePanel.this._elementAdded(evt.getName());
                }
            }
        });
    }

    public void elementReplaced(ConfigChange evt) {
        Helper.logDebugMessage(this.getClass().getName() + "::elementReplaced " + evt.getName());
        System.out.println("JWorkspacePanel::elementReplaced not implemented");
    }

    public void elementDeleted(ConfigChange evt) {
        Helper.logDebugMessage(this.getClass().getName() + "::elementDeleted " + evt.getName());
        this._elementDeleted(evt.getName());
    }

    private void _elementDeleted(final String name) {
        Helper.invoke(new Runnable(){

            @Override
            public void run() {
                IPlugin parentPlugin;
                IPlugin plugin = JWorkspacePanel.this.getPathToPlugin(name);
                if (plugin != null && (parentPlugin = (IPlugin)((Object)((AbstractGUIPlugin)plugin).getParent())) != null) {
                    parentPlugin.onDeleted(plugin);
                }
            }
        });
    }

    public void folderAdded(ConfigChange evt) {
        Helper.logDebugMessage(this.getClass().getName() + "::folderAdded " + evt.getName());
        this._elementAdded(evt.getName());
    }

    public void folderDeleted(ConfigChange evt) {
        Helper.logDebugMessage(this.getClass().getName() + "::folderDeleted " + evt.getName());
        this._elementDeleted(evt.getName());
    }

    public void rename(final ConfigChange evt) {
        Helper.logDebugMessage(this.getClass().getName() + "::rename " + evt.getName() + " to " + evt.getNewName());
        Helper.invoke(new Runnable(){

            @Override
            public void run() {
                IPlugin plugin = JWorkspacePanel.this.getPathToPlugin(evt.getName());
                if (plugin != null) {
                    plugin.onRenamed(evt.getNewName());
                } else {
                    JWorkspacePanel.this._elementAdded(evt.getNewName());
                }
            }
        });
    }

    private boolean productVersionSupported(IPlugin plugin, String productVersion) {
        if (productVersion == null) {
            return true;
        }
        PluginAttributes pa = plugin.getAttributes().getParent();
        String[] pVersions = pa.getProductVersions();
        for (int i = 0; i < pVersions.length; ++i) {
            if (!productVersion.equals(pVersions[i])) continue;
            return true;
        }
        return false;
    }

    public void metaAttributesChanged(final ConfigChange evt) {
        Helper.logDebugMessage(this.getClass().getName() + "::metaAttributeChanged " + evt.getName());
        Helper.invoke(new Runnable(){

            @Override
            public void run() {
                String name = evt.getName();
                IPlugin plugin = JWorkspacePanel.this.getPathToPlugin(name);
                boolean basicUpdate = false;
                if (plugin == null) {
                    IPlugin parentPlugin = JWorkspacePanel.this.getPathToPluginParent(name);
                    if (parentPlugin != null) {
                        parentPlugin.onAdded(name, evt.getMetaAttributes());
                    }
                } else if (plugin instanceof IConfigPlugin) {
                    if (plugin instanceof IFolderPlugin) {
                        JWorkspacePanel.this._elementReplaced(name, plugin, JWorkspacePanel.this.getPathToPluginParent(name), evt.getMetaAttributes());
                    } else if (plugin.getAttributes().isUpgradeable()) {
                        String newVersion;
                        String oldVersion = plugin.getAttributes().getConfigVersion();
                        if (!oldVersion.equals(newVersion = (String)evt.getMetaAttributes().get("CONFIG_VERSION")) || !JWorkspacePanel.this.productVersionSupported(plugin, (String)evt.getMetaAttributes().get("PRODUCT_VERSION"))) {
                            JWorkspacePanel.this._elementUpgraded(name);
                        } else {
                            basicUpdate = true;
                        }
                    }
                } else {
                    basicUpdate = true;
                }
                if (basicUpdate && plugin != null) {
                    PluginAttributes pa = ((AbstractGUIPlugin)plugin).getAttributes();
                    pa.put(evt.getMetaAttributes());
                }
            }
        });
    }

    protected void _elementUpgraded(final String name) {
        Helper.logDebugMessage(this.getClass().getName() + "::elementUpgraded " + name);
        SwingWorker sw = new SwingWorker(){
            IPlugin m_plugin;
            IPlugin m_parentPlugin;
            {
                this.m_plugin = JWorkspacePanel.this.getPathToPlugin(name);
                this.m_parentPlugin = JWorkspacePanel.this.getPathToPluginParent(name);
            }

            @Override
            public Object construct() {
                Map attributes = null;
                if (this.m_parentPlugin != null) {
                    try {
                        attributes = JWorkspacePanel.this.m_context.getConfigContext().getConfigServer().getMetaAttributes(name);
                    }
                    catch (Exception e) {
                        MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                    }
                }
                return attributes;
            }

            @Override
            public void finished() {
                Map attributes = (Map)this.getValue();
                JWorkspacePanel.this._elementReplaced(name, this.m_plugin, this.m_parentPlugin, attributes);
                if (this.m_plugin != null && this.m_parentPlugin != null && attributes != null) {
                    JWorkspacePanel.this._upgradeRuntimePlugin(name);
                }
            }
        };
        sw.start();
    }

    private void _elementReplaced(String name, IPlugin plugin, IPlugin parentPlugin, Map attributes) {
        Helper.logDebugMessage(this.getClass().getName() + "::_elementReplaced " + name);
        if (plugin != null && parentPlugin != null) {
            boolean isSelected = this.getTree().isPathSelected(new TreePath(((DefaultMutableTreeNode)((Object)plugin)).getPath()));
            parentPlugin.onDeleted(plugin);
            if (attributes != null) {
                ((AbstractGUIPlugin)parentPlugin).onAdded(name, attributes);
                if (isSelected) {
                    TreeNode node;
                    String tail = null;
                    if (name.endsWith("_Default")) {
                        tail = name.substring(name.lastIndexOf(47) + 1);
                    }
                    if ((node = ((AbstractGUIPlugin)parentPlugin).findChildNode(tail = name.substring(name.lastIndexOf(47) + 1))) != null) {
                        this.getTree().setSelectionPath(new TreePath(((DefaultMutableTreeNode)node).getPath()));
                        this.refreshContentPaneIfShown((IPlugin)((Object)node));
                        if (node instanceof AbstractConfigPlugin) {
                            try {
                                ConfigBeanModel model;
                                AbstractConfigPlugin newPlugin = (AbstractConfigPlugin)node;
                                if (newPlugin.getModel() instanceof ConfigBeanModel && (model = (ConfigBeanModel)newPlugin.getModel()) != null && model.getData() instanceof IConfigBean) {
                                    ((IConfigBean)model.getData()).refresh();
                                }
                            }
                            catch (Exception e) {
                                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                            }
                        }
                    } else {
                        this.getTree().setSelectionPath(new TreePath(((DefaultMutableTreeNode)((Object)parentPlugin)).getPath()));
                    }
                }
            }
        }
    }

    private void _upgradeRuntimePlugin(String name) {
        JWorkspacePanel panel = this.m_context.getWorkspace().getWorkspacePanel("Manage");
        if (!panel.isInitialized()) {
            return;
        }
        IPlugin rootNode = (IPlugin)((DefaultTreeModel)panel.getTree().getModel()).getRoot();
        if (rootNode != null) {
            rootNode.refresh();
        }
    }

    public void doExpansion(DefaultMutableTreeNode node, boolean bForceRefresh, boolean isSelectionChange) {
        this.doExpansion(node, bForceRefresh, isSelectionChange, true);
    }

    public void doExpansion(final DefaultMutableTreeNode node, final boolean bForceRefresh, final boolean isSelectionChange, boolean bAsync) {
        if (bAsync) {
            Helper.asyncExec(new Runnable(){

                @Override
                public void run() {
                    JWorkspacePanel.this.doExpansionImpl(node, bForceRefresh, isSelectionChange);
                }
            });
        } else {
            this.doExpansionImpl(node, bForceRefresh, isSelectionChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCollapse(DefaultMutableTreeNode node) {
        JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
        try {
            DefaultMutableTreeNode flag;
            DefaultMutableTreeNode defaultMutableTreeNode = flag = node.isLeaf() ? null : (DefaultMutableTreeNode)node.getFirstChild();
            if (flag != null && !(flag.getUserObject() instanceof Boolean)) {
                this.m_tree.setSelectionPath(new TreePath(node.getPath()));
                node.removeAllChildren();
                node.add(new DefaultMutableTreeNode(Boolean.TRUE));
                node.add(flag);
                ((DefaultTreeModel)this.m_tree.getModel()).nodeStructureChanged(node);
            }
        }
        finally {
            wc.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doContentPane(DefaultMutableTreeNode node) {
        JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
        try {
            IContentPane contentPane;
            if (node instanceof IPlugin) {
                contentPane = ((IPlugin)((Object)node)).getPluginContentPane();
                if (contentPane != null) {
                    contentPane.refresh();
                }
            } else {
                contentPane = null;
            }
            this.setContentPane(contentPane);
        }
        finally {
            wc.release();
        }
    }

    private void debugPluginAttributes(IPlugin plugin) {
        if (plugin != null) {
            StringBuffer buffer = new StringBuffer();
            if (plugin.getPluginName() != null) {
                buffer.append(plugin.getPluginName());
            } else {
                buffer.append("<PLUGIN NAME NOT DEFINED>");
            }
            buffer.append(" > ");
            buffer.append(plugin.getAttributes().toString());
            PluginAttributes parent = plugin.getAttributes().getParent();
            if (parent != null) {
                buffer.append(" [ParentAttributes ");
                buffer.append(parent.toString());
                buffer.append("]");
            }
            Helper.logDebugMessage(buffer.toString());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode node;
        TreePath path = evt.getNewLeadSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = node = path != null ? (DefaultMutableTreeNode)path.getLastPathComponent() : null;
        if (node != null) {
            if (node instanceof AbstractGUIPlugin) {
                IPlugin plugin = (IPlugin)((Object)node);
                MgmtConsole.getMgmtConsole().getToolBar().setActions(node);
                plugin.getPluginContext().getWorkspace().updateDescription(plugin.getPluginPath());
            }
            this.doExpansion(node, false, true);
        }
    }

    private JComponent getDefaultContentPane() {
        if (this.m_defaultContentPane == null) {
            JLabel c = new JLabel(ResourceManager.getApplicationLogo(this.getClass(), "logo"));
            c.setOpaque(true);
            c.setBackground(Color.white);
            this.m_defaultContentPane = c;
        }
        return this.m_defaultContentPane;
    }

    private void setContentPane(final IContentPane contentPane) {
        Helper.invoke(new Runnable(){

            @Override
            public void run() {
                if (JWorkspacePanel.this.m_split.getRightComponent() instanceof ITableContentPane) {
                    ITableContentPane oldContentPane = (ITableContentPane)((Object)JWorkspacePanel.this.m_split.getRightComponent());
                    JWorkspacePanel.this.m_tableCurrent = oldContentPane.getTable();
                    if (JWorkspacePanel.this.m_tableCurrent != null) {
                        JWorkspacePanel.this.m_tableCurrent.removeFocusListener(JWorkspacePanel.this);
                        JWorkspacePanel.this.m_tableCurrent.getSelectionModel().removeListSelectionListener(JWorkspacePanel.this);
                        JWorkspacePanel.this.m_tableCurrent.cleanup();
                    }
                }
                int nPos = JWorkspacePanel.this.m_split.getDividerLocation();
                JWorkspacePanel.this.m_split.setRightComponent(contentPane != null ? contentPane.getComponent() : JWorkspacePanel.this.getDefaultContentPane());
                JWorkspacePanel.this.m_split.setDividerLocation(nPos);
                if (contentPane instanceof ITableContentPane) {
                    JWorkspacePanel.this.m_tableCurrent = ((ITableContentPane)contentPane).getTable();
                    JWorkspacePanel.this.m_tableCurrent.addFocusListener(JWorkspacePanel.this);
                    JWorkspacePanel.this.m_tableCurrent.getSelectionModel().addListSelectionListener(JWorkspacePanel.this);
                    JWorkspacePanel.this.m_tableCurrent.loadColumnPrefs();
                }
                if (JWorkspacePanel.this.m_split.getLastDividerLocation() > JWorkspacePanel.this.m_split.getMinimumDividerLocation()) {
                    JWorkspacePanel.this.m_split.setDividerLocation(JWorkspacePanel.this.m_split.getLastDividerLocation());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExpansionImpl(final DefaultMutableTreeNode node, boolean bForceRefresh, boolean isSelectionChange) {
        JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
        try {
            DefaultMutableTreeNode flag;
            if (node == null) {
                System.out.println("We have a null node");
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = flag = node.getChildCount() > 0 ? (DefaultMutableTreeNode)node.getFirstChild() : null;
            if (bForceRefresh || flag != null && flag.getUserObject() instanceof Boolean) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = node;
                synchronized (defaultMutableTreeNode2) {
                    Helper.invoke(new Runnable(){

                        @Override
                        public void run() {
                            node.removeAllChildren();
                        }
                    }, true);
                    if (!((AbstractGUIPlugin)node).expand()) {
                        this.m_tree.collapsePath(new TreePath(node.getPath()));
                    }
                    Helper.invoke(new Runnable(){

                        @Override
                        public void run() {
                            ((DefaultTreeModel)JWorkspacePanel.this.m_tree.getModel()).nodeStructureChanged(node);
                        }
                    }, true);
                }
            }
            if (isSelectionChange) {
                this.doContentPane(node);
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            e.printStackTrace();
        }
        finally {
            wc.release();
        }
    }

    public IPlugin getPathToPlugin(String path) {
        return this._getPathToPlugin(this.getCorrectConfigPath(path));
    }

    protected String getCorrectConfigPath(String name) {
        return name;
    }

    protected IPlugin _getPathToPlugin(String path) {
        TreeNode parent = (TreeNode)this.m_tree.getModel().getRoot();
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            TreeNode newParent = null;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                TreeNode child = parent.getChildAt(i);
                if (!(child instanceof AbstractGUIPlugin) || !token.equals(((AbstractGUIPlugin)child).getPluginName()) && !token.equals(((AbstractGUIPlugin)child)._getPluginName())) continue;
                newParent = child;
                break;
            }
            if (newParent == null) {
                return null;
            }
            parent = newParent;
        }
        return (IPlugin)((Object)parent);
    }

    public IPlugin getPathToPluginParent(String path) {
        return this.getPathToPlugin(this.stripTerminalNode(path));
    }

    @Override
    public void focusGained(FocusEvent evt) {
        if (evt.isTemporary() && this.m_lastFocus == evt.getSource()) {
            return;
        }
        this.m_lastFocus = (Component)evt.getSource();
        MgmtConsole console = MgmtConsole.getMgmtConsole();
        console.getToolBar().clearActions();
        if (evt.getSource() == this.m_tree) {
            console.getToolBar().setActions(this.getSelectedNode());
        } else {
            for (Container container = (Container)evt.getSource(); container != null; container = container.getParent()) {
                if (!(container instanceof IContentPane)) continue;
                console.getToolBar().setActions((IContentPane)((Object)container));
                break;
            }
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        IContentPane cp = this.getContentPane();
        if (cp != null && cp instanceof AbstractTableContentPane) {
            MgmtConsole.getMgmtConsole().getToolBar().setActions(cp);
        }
    }

    public void updateToolbarIfRequired(IPlugin plugin) {
        DefaultMutableTreeNode node;
        if (this.m_tree == this.getFocusComponent() && this.isShowing() && this.m_tree.getSelectionCount() > 0 && (node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent()) == plugin) {
            MgmtConsole.getMgmtConsole().getToolBar().setActions(node);
        }
    }

    private String stripTerminalNode(String strPath) {
        String strNewPath = strPath;
        int index = strPath.lastIndexOf(47);
        if (index != -1) {
            strNewPath = strPath.substring(0, index);
        }
        return strNewPath;
    }

    class PluginTreeExpansionListener
    implements TreeWillExpandListener {
        private boolean m_bAsync = true;

        PluginTreeExpansionListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent evt) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
            JWorkspacePanel.this.doExpansion(node, false, false, this.m_bAsync);
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent evt) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
            JWorkspacePanel.this.doCollapse(node);
        }

        public void setAsyncMode(boolean bAsync) {
            this.m_bAsync = bAsync;
        }

        public boolean getAsyncMode() {
            return this.m_bAsync;
        }
    }
}

