/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui;

import com.sonicsw.ma.gui.JWorkspacePanel;
import com.sonicsw.ma.gui.domain.AgentManagerConnection;
import com.sonicsw.ma.gui.domain.StateChangeEvent;
import com.sonicsw.ma.gui.domain.StateChangeListener;
import com.sonicsw.ma.gui.runtime.AbstractRuntimePlugin;
import com.sonicsw.ma.gui.runtime.RuntimeDomainFolderPlugin;
import com.sonicsw.ma.gui.runtime.RuntimePluginFilter;
import com.sonicsw.ma.gui.runtime.RuntimePluginTreeCellRenderer;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IIdentity;
import com.sonicsw.mf.common.runtime.IState;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class JWorkspaceRuntimePanel
extends JWorkspacePanel
implements StateChangeListener {
    public static final String PANEL_NAME = "Manage";
    private AgentManagerConnection m_agentManager;

    public JWorkspaceRuntimePanel() {
        this.setProperties();
    }

    private void setProperties() {
        this.setName(PANEL_NAME);
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon(this.getClass(), "monitor1");
    }

    @Override
    public void initialize(IPluginContext context) {
        this.m_agentManager = context.getConnectionInfo().getAgentManagerConnection();
        if (this.m_agentManager != null) {
            this.m_agentManager.addStateChangeListener(this);
        }
        RuntimeDomainFolderPlugin rootNode = new RuntimeDomainFolderPlugin(context);
        rootNode.setFilter(new RuntimePluginFilter());
        this.m_tree.setCellRenderer(new RuntimePluginTreeCellRenderer());
        ((DefaultTreeModel)this.m_tree.getModel()).setRoot(rootNode);
        super.initialize(context);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_agentManager != null) {
            this.m_agentManager.removeStateChangeListener(this);
            this.m_agentManager = null;
        }
    }

    @Override
    public JComponent[] getMenuItems(int type) {
        return new JComponent[0];
    }

    @Override
    public AbstractButton[] getToolbarItems() {
        return new AbstractButton[0];
    }

    @Override
    public Object getSelectedItem() {
        return null;
    }

    @Override
    public Object[] getSelectedItems() {
        return new Object[0];
    }

    @Override
    public void domainStateChanged(StateChangeEvent evt) {
        this.doStateChanged(evt);
    }

    public IPlugin getRunTimePathToPlugin(String path) {
        return this._getPathToPlugin(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStateChanged(StateChangeEvent evt) {
        String containerPath = evt.getContainerConfigName();
        String componentName = evt.getComponentName();
        IState state = evt.getState();
        if (containerPath == null) {
            return;
        }
        AbstractRuntimePlugin containerPlugin = (AbstractRuntimePlugin)this.getRunTimePathToPlugin(containerPath);
        if (containerPlugin == null) {
            return;
        }
        TreeNode treeNode = containerPlugin.getParent();
        synchronized (treeNode) {
            if (componentName.equals("AGENT")) {
                IIdentity id;
                boolean refreshParentContentPane = false;
                IState existingState = containerPlugin.getAttributes().getState();
                if (existingState == null || existingState.getState() != state.getState()) {
                    refreshParentContentPane = true;
                }
                if (!((id = containerPlugin.getRuntimeID()) != null && id.getCanonicalName().equals(state.getRuntimeIdentity().getCanonicalName()) || state.getState() == 0)) {
                    containerPlugin.setRuntimeID(state.getRuntimeIdentity(), state);
                    refreshParentContentPane = true;
                }
                containerPlugin.getAttributes().setState(state);
                containerPlugin.refresh();
                this.refreshContentPaneIfShown(containerPlugin);
                if (refreshParentContentPane) {
                    this.refreshContentPaneIfShown((IPlugin)((Object)containerPlugin.getParent()), containerPlugin);
                }
                this.updateToolbarIfRequired(containerPlugin);
            } else {
                String componentPath = containerPath + "/" + componentName;
                IPlugin plugin = this.getRunTimePathToPlugin(componentPath);
                if (plugin == null) {
                    containerPlugin.refresh();
                    plugin = this.getRunTimePathToPlugin(componentPath);
                }
                if (plugin != null) {
                    plugin.getAttributes().setState(state);
                    plugin.refresh();
                    this.refreshContentPaneIfShown(containerPlugin, plugin);
                    this.updateToolbarIfRequired(plugin);
                }
                IContainerState containerState = this.m_agentManager.getContainerStateByRuntimeID(containerPlugin.getRuntimeID().getCanonicalName());
                containerPlugin.getAttributes().setState((IState)containerState);
                ((DefaultTreeModel)this.m_tree.getModel()).nodeChanged(containerPlugin);
                this.refreshContentPaneIfShown((IPlugin)((Object)containerPlugin.getParent()), containerPlugin);
                this.updateToolbarIfRequired(containerPlugin);
            }
        }
    }
}

