/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui;

import com.sonicsw.ma.gui.ActionMenu;
import com.sonicsw.ma.gui.ApplicationListener;
import com.sonicsw.ma.gui.ApplicationListenerSupport;
import com.sonicsw.ma.gui.EditMenu;
import com.sonicsw.ma.gui.HelpMenu;
import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.ShutDownCancelledException;
import com.sonicsw.ma.gui.ToolBar;
import com.sonicsw.ma.gui.ToolsMenu;
import com.sonicsw.ma.gui.ViewMenu;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.domain.JDomainConnectionDialog;
import com.sonicsw.ma.gui.messagelog.JMessageInternalFrame;
import com.sonicsw.ma.gui.messagelog.MessageTableModel;
import com.sonicsw.ma.gui.perms.ManagementSecurityUtils;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JMADesktopPane;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JMAStatusBar;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JProgressDialog;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.SwingWorker;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IFilePlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.PluginContext;
import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFProxyException;
import com.sonicsw.mf.common.MFProxyRuntimeException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.security.ManagementPermissionDeniedException;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IdentityOnlyConfigBean;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.model.ModelPropagationException;
import modelobjects.framework.model.ModelValidationException;
import sun.security.action.GetPropertyAction;

public class MgmtConsole
extends JMAFrame
implements IApplication {
    public static final boolean DEVELOPER_MODE = System.getProperty("developer", "false").equalsIgnoreCase("true");
    public static final boolean LOCAL_CLASSES = System.getProperty("localclasses", "false").equalsIgnoreCase("true");
    public static final boolean FLUSH_PREFS = System.getProperty("flushprefs", "false").equalsIgnoreCase("true");
    public static final Level LOG_LEVEL = MgmtConsole.getLogLevel(System.getProperty("loglevel"), Level.INFO);
    public static final int CLIP_ACTION_CUT = 0;
    public static final int CLIP_ACTION_COPY = 1;
    private static boolean m_logToFile = false;
    private static volatile boolean s_initialized = false;
    private int m_clipAction;
    private Object m_clipObject;
    private JMADesktopPane m_desktopPane;
    private ToolBar m_toolbar;
    private JMAStatusBar m_statusbar;
    private MessageTableModel m_messageModel;
    private JMessageInternalFrame m_messageWindow;
    private MouseHandler m_mouseHandler;
    private ViewMenu m_viewMenu;
    private EditMenu m_editMenu;
    private PreferenceManager m_prefManager;
    private ApplicationListenerSupport m_appListenerSupport = new ApplicationListenerSupport();
    protected IPluginContext m_context;
    protected static final String SEE_MSGVIEWER_MESSAGE = "\nSee the Message Viewer for details and trace information about this notice.";
    public static final DataFlavor fileFlavor = new DataFlavor(IFilePlugin.class, "Sonic File Object");
    public static final DataFlavor configFlavor = new DataFlavor(IConfigPlugin.class, "Sonic Configuration Object");

    public static MgmtConsole getMgmtConsole() {
        return MgmtConsoleHolder.INSTANCE;
    }

    public static boolean isInitialized() {
        return s_initialized;
    }

    private static Level getLogLevel(String logLevelText, Level defaultLevel) {
        Level res = defaultLevel;
        try {
            if (logLevelText != null) {
                res = Level.parse(logLevelText.toUpperCase());
            }
        }
        catch (Exception e) {
            MgmtConsole.displayMessage(64, e.getMessage(), e, false);
        }
        return res;
    }

    public static void resetLogToFile(boolean value) {
        m_logToFile = value;
    }

    public static boolean isLogToFileReset() {
        return m_logToFile;
    }

    public WorkspaceWindow getSelectedWorkspaceWindow() {
        if (this.getDesktopPane().getSelectedFrame() != null && this.getDesktopPane().getSelectedFrame() instanceof WorkspaceWindow) {
            return (WorkspaceWindow)this.getDesktopPane().getSelectedFrame();
        }
        return null;
    }

    private MgmtConsole() {
        super("console");
    }

    private void initialize() {
        this.m_messageModel = new MessageTableModel();
        Helper.getLogger().setLevel(LOG_LEVEL);
        if (DEVELOPER_MODE) {
            Helper.getLogger().setUseParentHandlers(false);
            Helper.getLogger().addHandler(new DebugMessageHandler());
        }
        Helper.getLogger().addHandler(new SMCMessageHandler());
        Helper.logInfoMessage("Sonic Management Console started.");
        this.m_prefManager = PreferenceManager.getInstance();
        if (FLUSH_PREFS) {
            System.out.println("Reset the user preferences in the preference manager");
            this.m_prefManager.resetUserPreferences();
        }
        this.m_desktopPane = new JMADesktopPane();
        this.m_mouseHandler = new MouseHandler();
        this.prepareMgmtConsole();
    }

    private void prepareMgmtConsole() {
        if (DEVELOPER_MODE) {
            this.setTitle(this.getTitle() + " - DEVELOPER");
        }
        this.setImageIcon((ImageIcon)ResourceManager.getApplicationIcon(this.getClass(), "Application", 36));
        this.setJMenuBar(this.initMenuBar());
        this.m_toolbar = new ToolBar();
        this.m_statusbar = new JMAStatusBar(null);
        this.getContentPane().add((Component)this.m_toolbar, "North");
        this.getContentPane().add((Component)this.m_statusbar, "South");
        this.getContentPane().add((Component)new ExtendedJScrollPane(this.m_desktopPane), "Center");
        this.showStatusBar(this.m_viewMenu.getShowStatus());
        this.showToolBar(this.m_viewMenu.getShowToolBar());
        IdentityOnlyConfigBean.setEnabled((boolean)true);
    }

    @Override
    public boolean canClose() {
        if (DEVELOPER_MODE) {
            return true;
        }
        return this.showConfirmDialog("Are you sure you want to exit the Sonic Management Console?", "Exit Application", 3, 0) == 0;
    }

    public void connectToDefaultDomain() {
        this.connectToDomain(new DomainConnectionModel(this.m_prefManager));
    }

    public void connectToDomain(DomainConnectionModel model) {
        if (model == null) {
            model = new DomainConnectionModel(this.m_prefManager);
        }
        JDomainConnectionDialog dialog = new JDomainConnectionDialog(this);
        dialog.pack();
        try {
            dialog.editInstance(null, model, true);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            this.notifyMessage(4, "Error in the connect dialog.", e, true);
        }
        if (dialog.getCloseCommand() != -1) {
            DomainConnectionModel dcm = (DomainConnectionModel)dialog.getModel();
            dcm.saveToPrefs(this.m_prefManager);
            JProgressDialog waitDlg = new JProgressDialog(this, "Connecting...", true);
            waitDlg.setContent(this.createConnectingPanel(dcm));
            MgmtConsole.getMgmtConsole().notifyMessage(1, "Connecting to " + dcm.getDomainDescription(), false);
            waitDlg.setWorker(new ConnectWorker(dcm, waitDlg));
            waitDlg.setVisible(true);
        }
        dialog.dispose();
    }

    private JPanel createConnectingPanel(DomainConnectionModel dcm) {
        JPartitionPanel dataPanel = new JPartitionPanel(false, "p,r", null);
        String connectionName = ResourceManager.getString(this.getClass(), "dialog.domain.general.connection_name.label");
        String domainName = ResourceManager.getString(this.getClass(), "dialog.domain.general.domain_name.label");
        String url = ResourceManager.getString(this.getClass(), "dialog.domain.general.connection_url.label");
        dataPanel.addRow(connectionName, (JComponent)new JLabel(dcm.getConnectionName()));
        dataPanel.addRow(domainName, (JComponent)new JLabel(dcm.getDomainName()));
        dataPanel.addRow(url, (JComponent)new JLabel(dcm.getUrl()));
        JLabel icon = new JLabel("", ResourceManager.getIcon(this.getClass(), "Connect"), 0);
        icon.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPartitionPanel topPanel = new JPartitionPanel(false, "p,r", "");
        topPanel.add(icon);
        topPanel.add(dataPanel);
        return topPanel;
    }

    @Override
    protected void maInitialize() {
    }

    @Override
    protected void maCleanup() {
        if (this.m_desktopPane != null) {
            this.m_desktopPane.maCleanup();
        }
    }

    public void launchWorkspaceWindow(IPluginContext context) {
        this.m_context = context;
        try {
            String windowTitle = context.getConnectionInfo().getDomainDescription();
            this.showInternalFrame(new WorkspaceWindow(windowTitle, context), true);
        }
        catch (Exception e) {
            this.notifyMessage(4, e.toString(), e, true);
        }
    }

    public void disconnect() {
        JInternalFrame selectedFrame = this.m_desktopPane.getSelectedFrame();
        if (selectedFrame != null && selectedFrame instanceof WorkspaceWindow) {
            selectedFrame.dispose();
        }
    }

    public void showInternalFrame(JInternalFrame internalFrame, boolean visible) {
        this.getDesktopPane().add(internalFrame);
        internalFrame.setVisible(visible);
    }

    public ToolBar getToolBar() {
        return this.m_toolbar;
    }

    private JMenuBar initMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(new ActionMenu(this.m_prefManager, this.m_mouseHandler));
        this.m_editMenu = new EditMenu(this.m_mouseHandler);
        menuBar.add(this.m_editMenu);
        this.m_viewMenu = new ViewMenu(this.m_prefManager, this.m_mouseHandler);
        menuBar.add(this.m_viewMenu);
        menuBar.add(new ToolsMenu(this.m_prefManager, this.m_mouseHandler, this.m_desktopPane));
        JMenu windowMenu = this.m_desktopPane.getInternalFramesMenu();
        windowMenu.setMnemonic('W');
        menuBar.add(windowMenu);
        menuBar.add(new HelpMenu(this.m_mouseHandler));
        return menuBar;
    }

    public ViewMenu getViewMenu() {
        return this.m_viewMenu;
    }

    public JMADesktopPane getDesktopPane() {
        return this.m_desktopPane;
    }

    public JMAStatusBar getStatusBar() {
        return this.m_statusbar;
    }

    public void showStatusBar(boolean state) {
        this.getStatusBar().setVisible(state);
        this.invalidate();
        this.validate();
    }

    public void showToolBar(boolean state) {
        this.getToolBar().setVisible(state);
        this.invalidate();
        this.validate();
    }

    public void showMessageLog(boolean show) {
        if (show) {
            if (this.m_messageWindow == null) {
                this.m_messageWindow = new JMessageInternalFrame(this.m_messageModel);
                this.m_messageWindow.addInternalFrameListener(new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosing(InternalFrameEvent evt) {
                        MgmtConsole.this.m_messageWindow = null;
                        ((BasicAction)MgmtConsole.this.m_viewMenu.getMessageLogAction()).setSelected(false);
                    }
                });
            }
            this.showInternalFrame(this.m_messageWindow, show);
        } else if (this.m_messageWindow != null) {
            this.m_messageWindow.dispose();
            this.m_messageWindow = null;
        }
    }

    public JMessageInternalFrame getMessageLog() {
        return this.m_messageWindow;
    }

    public String showInputDialog(String msg, String title) {
        return JOptionPane.showInputDialog(this, msg, title, 3);
    }

    public int showConfirmDialog(String msg, String title, int msgType, int optionType) {
        return this.showConfirmDialog(this, msg, title, msgType, optionType);
    }

    public int showConfirmDialog(Component parent, String msg, String title, int msgType, int optionType) {
        return JMAOptionPane.showConfirmDialog(parent, msg, title, optionType, msgType);
    }

    public static void displayMessage(int type, String message, boolean allowDialog) {
        MgmtConsole.displayMessage(type, message, null, allowDialog);
    }

    public static void displayMessage(int type, String message, Throwable throwable, boolean allowDialog) {
        MgmtConsole.displayMessage(null, type, message, throwable, allowDialog);
    }

    public static void displayMessage(Component parent, int type, String message, Throwable throwable, boolean allowDialog) {
        if (parent == null) {
            MgmtConsole.getMgmtConsole().notifyMessage(type, message, throwable, allowDialog);
        } else {
            String outputString = "";
            if (message != null && message.length() > 0) {
                outputString = outputString + message + " ";
            }
            if (throwable != null) {
                outputString = outputString + throwable.toString();
            }
            JOptionPane.showMessageDialog(parent, outputString);
        }
    }

    @Override
    public void notifyMessage(int type, String message, boolean allowDialog) {
        this.notifyMessage(type, message, null, allowDialog);
    }

    @Override
    public void notifyMessage(int type, String message, Throwable throwable, boolean allowDialog) {
        this.notifyMessage(this, type, message, throwable, allowDialog);
    }

    public void notifyMessage(Component parent, int type, String message, Throwable throwable, boolean allowDialog) {
        if (this.m_messageModel != null) {
            int msgType = -1;
            DisplayMessage msg = null;
            if (allowDialog) {
                msg = this.getNotifyMessage(message, throwable);
                if (msg.messageType != DisplayMessage.NONE) {
                    type = msg.messageType;
                }
            }
            switch (type) {
                case 0: 
                case 1: {
                    msgType = -1;
                    break;
                }
                case 2: {
                    msgType = 1;
                    break;
                }
                case 3: {
                    msgType = 2;
                    break;
                }
                case 4: {
                    msgType = 0;
                }
            }
            if (type != 0) {
                this.m_messageModel.addMessage(type, null, message, throwable);
            }
            if (type == 1 || type == 0) {
                this.getStatusBar().showStatusMessage(message);
            }
            if (allowDialog) {
                this.showConfirmDialog(parent, msg.messageString, "Attention", msgType, -1);
                this.getStatusBar().showStatusMessage(null);
            }
        }
    }

    private DisplayMessage getNotifyMessage(String message, Throwable throwable) {
        if (throwable == null) {
            return new DisplayMessage(message);
        }
        if (DEVELOPER_MODE) {
            Helper.logDebugMessage((message == null ? "(no message)" : message) + ", trace follows...");
            MgmtConsole.printExceptionInfo(throwable);
        }
        DisplayMessage xmsg = new DisplayMessage(throwable.getMessage());
        if (throwable instanceof ManagementPermissionDeniedException) {
            return new DisplayMessage(ManagementSecurityUtils.getErrorMessageFor((ManagementPermissionDeniedException)throwable) + SEE_MSGVIEWER_MESSAGE, 3);
        }
        if (throwable instanceof InvokeTimeoutCommsException) {
            xmsg = new DisplayMessage("This connection is no longer active. Try reconnecting.");
        } else if (throwable instanceof InvokeTimeoutException) {
            xmsg = new DisplayMessage("A timeout occured before the latest operation completed.");
        } else if (throwable instanceof ModelValidationException) {
            xmsg = MgmtConsole.getLinkedExceptionMessage(throwable);
        } else if (throwable instanceof ConfigServiceException) {
            xmsg = MgmtConsole.getLinkedExceptionMessage(throwable);
        } else if (throwable instanceof ViewValueConversionException) {
            xmsg = null;
        } else if (xmsg.messageString == null) {
            xmsg = MgmtConsole.getLinkedExceptionMessage(throwable);
        }
        if (xmsg == null || xmsg.messageString == null) {
            return new DisplayMessage(message);
        }
        if (message == null || message.equals("") || message.equals(xmsg.messageString)) {
            return xmsg;
        }
        xmsg.prepend(message + '\n');
        xmsg.append(SEE_MSGVIEWER_MESSAGE);
        return xmsg;
    }

    private static DisplayMessage getLinkedExceptionMessage(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof IllegalArgumentException) {
            Throwable cause = e.getCause();
            if (cause == null) {
                return null;
            }
            return MgmtConsole.getLinkedExceptionMessage(cause);
        }
        if (e instanceof ModelValidationException && ((ModelValidationException)e).getNestedException() != null) {
            return MgmtConsole.getLinkedExceptionMessage(((ModelValidationException)e).getNestedException());
        }
        if (e instanceof ModelPropagationException && ((ModelPropagationException)e).getNestedException() != null) {
            return MgmtConsole.getLinkedExceptionMessage(((ModelPropagationException)e).getNestedException());
        }
        if (e instanceof ManagementPermissionDeniedException) {
            String errorMessage = ManagementSecurityUtils.getErrorMessageFor((ManagementPermissionDeniedException)e);
            DisplayMessage displayMessage = new DisplayMessage(errorMessage, 3);
            displayMessage.append(SEE_MSGVIEWER_MESSAGE);
            displayMessage.isComplete = true;
            return displayMessage;
        }
        if (e instanceof ConfigServiceException && ((ConfigServiceException)e).getLinkedException() != null) {
            return MgmtConsole.getLinkedExceptionMessage(((ConfigServiceException)e).getLinkedException());
        }
        if (e.getMessage() != null) {
            return new DisplayMessage(e.getMessage());
        }
        if (e instanceof MFException && ((MFException)e).getLinkedException() != null) {
            return MgmtConsole.getLinkedExceptionMessage(((MFException)e).getLinkedException());
        }
        if (e instanceof MFRuntimeException && ((MFRuntimeException)e).getLinkedException() != null) {
            return MgmtConsole.getLinkedExceptionMessage(((MFRuntimeException)e).getLinkedException());
        }
        if (e instanceof ReflectionException) {
            return MgmtConsole.getLinkedExceptionMessage(((ReflectionException)e).getTargetException());
        }
        if (e instanceof MBeanException) {
            return MgmtConsole.getLinkedExceptionMessage(((MBeanException)e).getTargetException());
        }
        if (e instanceof InvocationTargetException) {
            return MgmtConsole.getLinkedExceptionMessage(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeOperationsException) {
            return MgmtConsole.getLinkedExceptionMessage(((RuntimeOperationsException)e).getTargetException());
        }
        if (e instanceof RuntimeMBeanException) {
            return MgmtConsole.getLinkedExceptionMessage(((RuntimeMBeanException)e).getTargetException());
        }
        if (e instanceof RuntimeErrorException) {
            return MgmtConsole.getLinkedExceptionMessage(((RuntimeErrorException)e).getTargetError());
        }
        if (e instanceof ProxyRuntimeException) {
            return MgmtConsole.getLinkedExceptionMessage(((ProxyRuntimeException)e).getTargetException());
        }
        return new DisplayMessage(e.getMessage());
    }

    public static void printExceptionInfo(Throwable e) {
        PrintWriter pw = new PrintWriter(System.err);
        MgmtConsole.printExceptionInfo(e, pw, false);
    }

    public static void printExceptionInfo(Throwable e, PrintWriter pw) {
        MgmtConsole.printExceptionInfo(e, pw, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printExceptionInfo(Throwable e, PrintWriter pw, boolean isCause) {
        if (e instanceof MFProxyException && ((MFProxyException)e).getActualException() != null) {
            e = ((MFProxyException)e).getActualException();
        } else if (e instanceof MFProxyRuntimeException && ((MFProxyRuntimeException)e).getActualException() != null) {
            e = ((MFProxyRuntimeException)e).getActualException();
        } else if (e instanceof ProxyRuntimeException && ((ProxyRuntimeException)e).getTargetException() != null) {
            e = ((ProxyRuntimeException)e).getTargetException();
        }
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            if (isCause) {
                pw.print("Caused by: ");
            }
            pw.println(e);
            StackTraceElement[] trace = e.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                pw.println("\tat " + trace[i]);
            }
            pw.flush();
        }
        if (e instanceof ModelValidationException && ((ModelValidationException)e).getNestedException() != null) {
            MgmtConsole.printExceptionInfo(((ModelValidationException)e).getNestedException(), pw, true);
        } else if (e instanceof ModelPropagationException && ((ModelPropagationException)e).getNestedException() != null) {
            MgmtConsole.printExceptionInfo(((ModelPropagationException)e).getNestedException(), pw, true);
        } else if (e instanceof ConfigServiceException && ((ConfigServiceException)e).getLinkedException() != null) {
            MgmtConsole.printExceptionInfo(((ConfigServiceException)e).getLinkedException(), pw, true);
        } else if (e instanceof MFException && ((MFException)e).getLinkedException() != null) {
            MgmtConsole.printExceptionInfo(((MFException)e).getLinkedException(), pw, true);
        } else if (e instanceof MFRuntimeException && ((MFRuntimeException)e).getLinkedException() != null) {
            MgmtConsole.printExceptionInfo(((MFRuntimeException)e).getLinkedException(), pw, true);
        } else if (e instanceof ReflectionException) {
            MgmtConsole.printExceptionInfo(((ReflectionException)e).getTargetException(), pw, true);
        } else if (e instanceof MBeanException) {
            MgmtConsole.printExceptionInfo(((MBeanException)e).getTargetException(), pw, true);
        } else if (e instanceof InvocationTargetException) {
            MgmtConsole.printExceptionInfo(((InvocationTargetException)e).getTargetException(), pw, true);
        } else if (e instanceof RuntimeOperationsException) {
            MgmtConsole.printExceptionInfo(((RuntimeOperationsException)e).getTargetException(), pw, true);
        } else if (e instanceof RuntimeMBeanException) {
            MgmtConsole.printExceptionInfo(((RuntimeMBeanException)e).getTargetException(), pw, true);
        } else if (e instanceof RuntimeErrorException) {
            MgmtConsole.printExceptionInfo(((RuntimeErrorException)e).getTargetError(), pw, true);
        } else if (e.getCause() != null) {
            MgmtConsole.printExceptionInfo(e.getCause(), pw, true);
        }
    }

    @Override
    public void addApplicationListener(ApplicationListener listener) {
        this.m_appListenerSupport.addApplicationListener(listener);
    }

    @Override
    public void removeApplicationListener(ApplicationListener listener) {
        this.m_appListenerSupport.removeApplicationListener(listener);
    }

    @Override
    public void shutDown() throws ShutDownCancelledException {
        this.m_appListenerSupport.fireApplicationShuttingDown(this);
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void lowOnMemory() {
        this.m_appListenerSupport.fireApplicationLowOnMemory(this);
    }

    public int getClipboardAction() {
        return this.m_clipAction;
    }

    public Object getClipboardObject() {
        return this.m_clipObject;
    }

    public void setClipboard(int action, Object object) {
        this.m_clipAction = action;
        this.m_clipObject = object;
    }

    public void clearClipboard() {
        this.setClipboard(this.getClipboardAction(), null);
    }

    public boolean isClipboardDataFlavorSupported(DataFlavor flavor) {
        boolean res = false;
        Object object = this.getClipboardObject();
        if (object != null) {
            if (flavor.equals(fileFlavor) && object instanceof IFilePlugin) {
                res = true;
            }
            if (flavor.equals(configFlavor) && object instanceof IConfigPlugin) {
                res = true;
            }
        }
        return res;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.connectToDefaultDomain();
        }
    }

    public static void main(String[] args) {
        try {
            UIDefaults uiDefaults;
            Color c;
            String lafName;
            String strLaf = MgmtConsole.getPreferredLookAndFeel();
            if (strLaf != null) {
                UIManager.setLookAndFeel(strLaf);
            }
            if ((lafName = UIManager.getLookAndFeel().getClass().getName()).equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") && !((c = (uiDefaults = UIManager.getLookAndFeelDefaults()).getColor("TextField.background")) instanceof ColorUIResource)) {
                for (final Object key : uiDefaults.keySet()) {
                    Object o = uiDefaults.get(key);
                    if (!(o instanceof Color) || o instanceof UIResource || o != UIManager.get(key)) continue;
                    UIManager.put(key, new UIDefaults.ActiveValue(){

                        @Override
                        public Object createValue(UIDefaults table) {
                            Color c = UIManager.getLookAndFeelDefaults().getColor(key);
                            if (c != null && !(c instanceof UIResource)) {
                                return new ColorUIResource(c);
                            }
                            return c;
                        }
                    });
                }
            }
            Object fixFont = UIManager.get("Label.font");
            UIManager.put("TextField.font", fixFont);
            UIManager.put("TextArea.font", fixFont);
            UIManager.put("TextFieldUI", "com.sonicsw.ma.gui.plaf.EditTextFieldUI");
            UIManager.put("TextAreaUI", "com.sonicsw.ma.gui.plaf.EditTextAreaUI");
            ToolTipManager.sharedInstance().setDismissDelay(20000);
        }
        catch (Exception e) {
            MgmtConsole.displayMessage(4, e.toString(), e, true);
        }
        MgmtConsole frame = MgmtConsole.getMgmtConsole();
        if (frame != null) {
            frame.setVisible(true);
        }
    }

    private static String getPreferredLookAndFeel() {
        String strResult = null;
        String strLaf = System.getProperty("Laf");
        if (strLaf != null) {
            if (strLaf.equals("windows")) {
                strResult = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            } else if (strLaf.equals("motif")) {
                strResult = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            }
        } else {
            strResult = UIManager.getSystemLookAndFeelClassName();
        }
        return strResult;
    }

    public IPluginContext getPluginContext() {
        return this.m_context;
    }

    private static class DisplayMessage {
        static int NONE = -1;
        String messageString;
        int messageType;
        private boolean isComplete;

        public DisplayMessage(String messageString) {
            this(messageString, NONE);
        }

        public DisplayMessage(String messageString, int messageTypePreference) {
            this.messageString = messageString;
            this.messageType = messageTypePreference;
        }

        public void prepend(String moreInfo) {
            if (!this.isComplete) {
                this.messageString = moreInfo + this.messageString;
            }
        }

        public void append(String moreInfo) {
            if (!this.isComplete) {
                this.messageString = this.messageString + moreInfo;
            }
        }

        public String toString() {
            return this.messageString;
        }
    }

    public class SMCMessageHandler
    extends Handler {
        public SMCMessageHandler() {
            this.setLevel();
        }

        private void setLevel() {
            this.setLevel(Level.INFO);
        }

        @Override
        public void publish(LogRecord logRecord) {
            if (this.isLoggable(logRecord)) {
                MgmtConsole.this.notifyMessage(this.getMessageLevel(logRecord.getLevel()), logRecord.getMessage(), logRecord.getThrown(), false);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        protected int getMessageLevel(Level level) {
            int nMessageLevel = 1;
            if (level == Level.SEVERE) {
                nMessageLevel = 4;
            } else if (level == Level.WARNING) {
                nMessageLevel = 3;
            } else if (level == Level.INFO) {
                nMessageLevel = 2;
            }
            return nMessageLevel;
        }
    }

    public class DebugMessageHandler
    extends ConsoleHandler {
        public DebugMessageHandler() {
            this.setFormatter();
        }

        private void setFormatter() {
            this.setFormatter(new DebugMessageFormatter());
        }

        public class DebugMessageFormatter
        extends SimpleFormatter {
            private Date date = new Date();
            private DateFormat df = DateFormat.getDateTimeInstance(3, 3);
            private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

            @Override
            public synchronized String format(LogRecord record) {
                StringBuffer sb = new StringBuffer();
                this.date.setTime(record.getMillis());
                sb.append(this.df.format(this.date));
                sb.append(" ");
                sb.append(record.getLevel().getLocalizedName());
                sb.append(": ");
                sb.append(this.formatMessage(record));
                sb.append(this.lineSeparator);
                return sb.toString();
            }
        }
    }

    private static class JMAOptionPane
    extends JOptionPane {
        public JMAOptionPane(String msg, int msgType, int optionType) {
            super(msg, msgType, optionType);
        }

        public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) throws HeadlessException {
            JMAOptionPane pane = new JMAOptionPane(message.toString(), messageType, optionType);
            JDialog dialog = pane.createDialog(parentComponent, title);
            pane.selectInitialValue();
            Dimension sz = dialog.getPreferredSize();
            if (sz.width < 50 || sz.height < 50) {
                dialog.setSize(400, 100);
            }
            dialog.validate();
            sz = dialog.getPreferredSize();
            dialog.setSize(sz.width + 8, sz.height + 8);
            dialog.show();
            Object selectedValue = pane.getValue();
            dialog.dispose();
            if (selectedValue != null && selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 60;
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            AbstractButton button;
            Action action;
            if (evt.getSource() instanceof AbstractButton && (action = (button = (AbstractButton)evt.getSource()).getAction()) != null && !(button instanceof JMenu)) {
                String message = (String)action.getValue("LongDescription");
                MgmtConsole.this.getStatusBar().showStatusMessage(message);
            }
        }
    }

    public static class StatusStopAction
    extends BasicGuiAction {
        public StatusStopAction(Action target) {
            super("statusbar.stop", target);
        }
    }

    class JCancelThreadButton
    extends JButton {
        public JCancelThreadButton(Action threadAction) {
            super(new StatusStopAction(threadAction));
            this.setMargin();
        }

        private void setMargin() {
            this.setMargin(new Insets(1, 1, 1, 1));
        }

        @Override
        public String getText() {
            return null;
        }
    }

    class ConnectWorker
    extends SwingWorker {
        JProgressDialog m_dialog;
        DomainConnectionModel m_model;
        IPluginContext m_context;
        boolean m_cancelled = false;

        public ConnectWorker(DomainConnectionModel model, JProgressDialog dialog) {
            this.m_model = model;
            this.m_dialog = dialog;
        }

        @Override
        public Object construct() {
            Object res = null;
            this.m_context = new PluginContext(this.m_model);
            try {
                this.m_context.create();
                res = this.m_context;
            }
            catch (Throwable e) {
                res = e;
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished() {
            JWaitCursor wc = new JWaitCursor(MgmtConsole.this);
            try {
                if (this.m_dialog != null) {
                    this.m_dialog.setVisible(false);
                }
                if (this.m_cancelled) {
                    this.disconnectConnection();
                    return;
                }
                if (this.getValue() == null) {
                    return;
                }
                this.m_dialog.getCancelButton().setEnabled(false);
                if (this.getValue() instanceof Throwable) {
                    Throwable th = (Throwable)this.getValue();
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to connect to " + this.m_context.getConnectionInfo().getDomainDescription(), new Exception("Could not establish a connection on the specified URL(s).\r\n" + th.getMessage(), th), true);
                    this.disconnectConnection();
                } else if (!this.m_cancelled) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            MgmtConsole.this.launchWorkspaceWindow(ConnectWorker.this.m_context);
                            MgmtConsole.getMgmtConsole().notifyMessage(1, "Successfully connected to " + ConnectWorker.this.m_context.getConnectionInfo().getDomainDescription(), false);
                        }
                    });
                    t.start();
                }
            }
            finally {
                if (this.m_dialog != null) {
                    this.m_dialog.setWorker(null);
                    this.m_dialog.dispose();
                    this.m_dialog = null;
                }
                wc.release();
            }
        }

        @Override
        public void interrupt() {
            this.m_cancelled = true;
            this.m_context.destroy();
            MgmtConsole.getMgmtConsole().notifyMessage(2, "Connection attempt to " + this.m_context.getConnectionInfo().getDomainDescription() + " cancelled by user", false);
            super.interrupt();
        }

        private void disconnectConnection() {
            try {
                this.m_model.disconnect();
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to disconnect " + e.getMessage(), e, false);
            }
        }
    }

    private static class MgmtConsoleHolder {
        private static final MgmtConsole INSTANCE = new MgmtConsole();

        private MgmtConsoleHolder() {
        }

        static {
            MgmtConsoleHolder.INSTANCE.initialize();
            s_initialized = true;
        }
    }
}

