/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui;

import com.sonicsw.ma.gui.MgmtConsole;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public enum PreferenceManager {
    INSTANCE;

    private HashMap m_nodeMap = new HashMap();
    private Preferences m_root = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());

    public static PreferenceManager getInstance() {
        return INSTANCE;
    }

    public void resetUserPreferences() {
        try {
            this.m_root.removeNode();
            this.m_root = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
            this.m_nodeMap = new HashMap();
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to reset User Preferences", e, true);
        }
    }

    public String getString(String path, String name, String defVal) {
        Preferences node = this.findNode(path);
        return node != null ? node.get(this.createPreferredKey(name), defVal) : null;
    }

    public boolean getBoolean(String path, String name, boolean defVal) {
        Preferences node = this.findNode(path);
        return node != null ? node.getBoolean(this.createPreferredKey(name), defVal) : defVal;
    }

    public int getInt(String path, String name, int defVal) {
        Preferences node = this.findNode(path);
        return node != null ? node.getInt(this.createPreferredKey(name), defVal) : defVal;
    }

    public void setBoolean(String path, String name, boolean value, boolean flush) {
        Preferences node = this.findNode(path);
        if (node != null) {
            node.putBoolean(this.createPreferredKey(name), value);
            if (flush) {
                this.flush(node);
            }
        }
    }

    public void setInt(String path, String name, int value, boolean flush) {
        Preferences node = this.findNode(path);
        if (node != null) {
            node.putInt(this.createPreferredKey(name), value);
            if (flush) {
                this.flush(node);
            }
        }
    }

    public void setString(String path, String name, String value, boolean flush) {
        Preferences node = this.findNode(path);
        if (node != null) {
            node.put(this.createPreferredKey(name), value);
            if (flush) {
                this.flush(node);
            }
        }
    }

    public void remove(String path, String name, boolean flush) {
        Preferences node = this.findNode(path);
        if (node != null && node.get(this.createPreferredKey(name), null) != null) {
            node.remove(name);
            if (flush) {
                this.flush(node);
            }
        }
    }

    public void flush() {
        this.flush(this.m_root);
    }

    public void flush(String path) {
        this.flush(this.findNode(path));
    }

    public String[] getChildrenNames(String path) {
        try {
            Preferences node = this.findNode(path);
            return node.childrenNames();
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to get children names: " + path, e, true);
            return null;
        }
    }

    public void removeNode(String path) {
        try {
            Preferences node = this.findNode(path);
            node.removeNode();
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to remove node: " + path, e, true);
        }
    }

    private void flush(Preferences node) {
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to flush preferences", e, true);
        }
    }

    private String createPreferredKey(String strKeyName) {
        if (strKeyName != null && strKeyName.length() > 80) {
            strKeyName = strKeyName.substring(strKeyName.length() - 80, strKeyName.length());
        }
        return strKeyName;
    }

    private synchronized Preferences findNode(String path) {
        String pathPreferred = this.createPreferredKey(path);
        Preferences node = (Preferences)this.m_nodeMap.get(pathPreferred);
        if (node == null) {
            node = this.m_root.node(pathPreferred.replace('.', '/'));
            this.m_nodeMap.put(pathPreferred, node);
        }
        return node;
    }
}

