/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.BasicResourceAction;
import com.sonicsw.ma.gui.util.ButtonActionPropertyChangeListener;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPlugin;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.tree.DefaultMutableTreeNode;

public class ToolBar
extends JToolBar {
    protected BasicResourceAction fileConnectAction = new FileConnectAction();
    protected BasicResourceAction fileNewFolderAction = new FileNewFolderAction();
    protected BasicResourceAction fileNewAction = new FileNewAction();
    protected BasicResourceAction editCutAction = new EditCutAction();
    protected BasicResourceAction editCopyAction = new EditCopyAction();
    protected BasicResourceAction editPasteAction = new EditPasteAction();
    protected BasicResourceAction editDeleteAction = new EditDeleteAction();
    protected BasicResourceAction editPropertiesAction = new EditPropertiesAction();
    protected BasicResourceAction viewRefreshAction = new ViewRefreshAction();
    protected BasicResourceAction viewGotoInstanceAction = new ViewGotoInstanceAction();
    protected BasicResourceAction viewGotoConfigurationAction = new ViewGotoConfigurationAction();
    protected BasicResourceAction runtimeMetricsAction = new RuntimeMetricsAction();
    protected BasicResourceAction runtimeNotificationsAction = new RuntimeNotificationsAction();
    protected BasicResourceAction viewLogAction = new ViewLogAction();
    private Object m_lastObject;

    public ToolBar() {
        this.prepareToolBar();
    }

    private void prepareToolBar() {
        this.setFloatable(false);
        this.setRollover(true);
        this.addDefaultItems();
    }

    @Override
    public JButton add(Action a) {
        JToolBarButton b = new JToolBarButton(a);
        this.add(b);
        return b;
    }

    public void addDefaultItems() {
        if (this.getComponentCount() > 0) {
            this.removeAll();
        }
        this.add(this.fileConnectAction);
        this.addSeparator();
        this.add(this.fileNewFolderAction);
        this.add(this.fileNewAction);
        this.addSeparator();
        this.add(this.editCutAction);
        this.add(this.editCopyAction);
        this.add(this.editPasteAction);
        this.add(this.editDeleteAction);
        this.addSeparator();
        this.add(this.viewRefreshAction);
        super.add(new JToolBarToggleButton(MgmtConsole.getMgmtConsole().getViewMenu().getMessageLogAction()));
        this.add(this.viewGotoInstanceAction);
        this.add(this.viewGotoConfigurationAction);
        this.addSeparator();
        this.add(this.editPropertiesAction);
        this.addSeparator();
        this.add(this.runtimeMetricsAction);
        this.add(this.runtimeNotificationsAction);
        this.addSeparator();
        this.add(this.viewLogAction);
        this.clearActions();
    }

    public void clearActions() {
        this.m_lastObject = null;
        this.clearAction(this.fileNewFolderAction);
        this.clearAction(this.fileNewAction);
        this.clearAction(this.editCutAction);
        this.clearAction(this.editCopyAction);
        this.clearAction(this.editPasteAction);
        this.clearAction(this.editDeleteAction);
        this.clearAction(this.viewRefreshAction);
        this.clearAction(this.viewGotoInstanceAction);
        this.clearAction(this.viewGotoConfigurationAction);
        this.clearAction(this.editPropertiesAction);
        this.clearAction(this.runtimeMetricsAction);
        this.clearAction(this.runtimeNotificationsAction);
        this.clearAction(this.viewLogAction);
    }

    private void clearAction(BasicResourceAction action) {
        action.setTargetAction(null);
        action.setEnabled(false);
    }

    public void setActions(DefaultMutableTreeNode selectedNode) {
        if (this.m_lastObject == selectedNode) {
            return;
        }
        this.clearActions();
        this.m_lastObject = selectedNode;
        if (selectedNode != null && selectedNode instanceof IPlugin) {
            IPlugin node = (IPlugin)((Object)selectedNode);
            this.setActions(node, 1);
            this.setActions(node, 3);
            this.setActions(node, 4);
            this.setActions(node, 5);
            this.setActions(node, 6);
        }
    }

    public void setActions(IContentPane cp) {
        this.clearActions();
        this.m_lastObject = cp;
        if (cp != null) {
            this.setActions(cp, 1);
            this.setActions(cp, 3);
            this.setActions(cp, 4);
            this.setActions(cp, 5);
            this.setActions(cp, 6);
        }
    }

    public void setActions(IPlugin node, int type) {
        try {
            this.setActions(node.getMenuItems(type), type);
        }
        catch (Exception e) {
            MgmtConsole.displayMessage(3, "Failed to generate the menu items for node '" + node.getClass().getName() + "'", e, false);
        }
    }

    private void setActions(IContentPane cp, int type) {
        this.setActions(cp.getMenuItems(type), type);
    }

    private void setActions(JComponent[] menuItems, int type) {
        if (menuItems != null && menuItems.length > 0) {
            switch (type) {
                case 1: {
                    if (menuItems[0] instanceof JMenu) {
                        JMenu menu = (JMenu)menuItems[0];
                        for (int i = 0; i < menu.getItemCount(); ++i) {
                            String actionValue;
                            Action action;
                            JMenuItem menuItem = menu.getItem(i);
                            if (menuItem == null || (action = menuItem.getAction()) == null || (actionValue = (String)action.getValue("ActionCommandKey")) == null) continue;
                            if (actionValue.equals("file.new.folder")) {
                                this.fileNewFolderAction.setTargetAction(action);
                                continue;
                            }
                            if (!actionValue.equals("file.new.configuration")) continue;
                            this.fileNewAction.setTargetAction(action);
                        }
                        break;
                    }
                    if (!(menuItems[0] instanceof JMenuItem)) break;
                    this.fileNewAction.setTargetAction(((JMenuItem)menuItems[0]).getAction());
                    break;
                }
                case 3: {
                    for (int i = 0; i < menuItems.length; ++i) {
                        String actionValue;
                        JMenuItem menuItem;
                        Action action;
                        if (!(menuItems[i] instanceof JMenuItem) || (action = (menuItem = (JMenuItem)menuItems[i]).getAction()) == null || (actionValue = (String)action.getValue("ActionCommandKey")) == null) continue;
                        if (actionValue.equals("edit.cut")) {
                            this.editCutAction.setTargetAction(action);
                            continue;
                        }
                        if (actionValue.equals("edit.copy")) {
                            this.editCopyAction.setTargetAction(action);
                            continue;
                        }
                        if (!actionValue.equals("edit.paste")) continue;
                        this.editPasteAction.setTargetAction(action);
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < menuItems.length; ++i) {
                        String actionValue;
                        JMenuItem menuItem;
                        Action action;
                        if (menuItems[i] instanceof JMenu) {
                            JMenu menu = (JMenu)menuItems[i];
                            for (int j = 0; j < menu.getItemCount(); ++j) {
                                String actionValue2;
                                Action action2;
                                JMenuItem menuItem2 = menu.getItem(j);
                                if (menuItem2 == null || (action2 = menuItem2.getAction()) == null || (actionValue2 = (String)action2.getValue("ActionCommandKey")) == null || !actionValue2.equals("runtime.viewlog")) continue;
                                this.viewLogAction.setTargetAction(action2);
                            }
                            continue;
                        }
                        if (!(menuItems[i] instanceof JMenuItem) || (action = (menuItem = (JMenuItem)menuItems[i]).getAction()) == null || (actionValue = (String)action.getValue("ActionCommandKey")) == null) continue;
                        if (actionValue.equals("edit.delete") || actionValue.equals("folder.delete")) {
                            this.editDeleteAction.setTargetAction(action);
                            continue;
                        }
                        if (!actionValue.equals("runtime.viewlog")) continue;
                        this.viewLogAction.setTargetAction(action);
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < menuItems.length; ++i) {
                        String actionValue;
                        JMenuItem menuItem;
                        Action action;
                        if (!(menuItems[i] instanceof JMenuItem) || (action = (menuItem = (JMenuItem)menuItems[i]).getAction()) == null || (actionValue = (String)action.getValue("ActionCommandKey")) == null) continue;
                        if (actionValue.equals("view.refresh")) {
                            this.viewRefreshAction.setTargetAction(action);
                            continue;
                        }
                        if (actionValue.equals("view.gotoinstance")) {
                            this.viewGotoInstanceAction.setTargetAction(action);
                            continue;
                        }
                        if (!actionValue.equals("view.gotoconfiguration")) continue;
                        this.viewGotoConfigurationAction.setTargetAction(action);
                    }
                    break;
                }
                case 6: {
                    for (int i = 0; i < menuItems.length; ++i) {
                        String actionValue;
                        JMenuItem menuItem;
                        Action action;
                        if (!(menuItems[i] instanceof JMenuItem) || (action = (menuItem = (JMenuItem)menuItems[i]).getAction()) == null || (actionValue = (String)action.getValue("ActionCommandKey")) == null) continue;
                        if (actionValue.equals("edit.properties")) {
                            this.editPropertiesAction.setTargetAction(action);
                            continue;
                        }
                        if (actionValue.equals("ComponentPlugin.notifications")) {
                            this.runtimeNotificationsAction.setTargetAction(action);
                            continue;
                        }
                        if (!actionValue.equals("ComponentPlugin.metrics")) continue;
                        this.runtimeMetricsAction.setTargetAction(action);
                    }
                    break;
                }
            }
        }
    }

    class JToolBarToggleButton
    extends JToggleButton {
        public JToolBarToggleButton(Action action) {
            super(action);
        }

        @Override
        protected void configurePropertiesFromAction(Action a) {
            String[] types = new String[]{"SmallIcon", "ShortDescription", "LongDescription", "enabled"};
            Helper.configurePropertiesFromAction(this, a, types);
        }

        @Override
        protected void fireActionPerformed(ActionEvent evt) {
            ((BasicAction)this.getAction()).setSelected(this.isSelected());
            super.fireActionPerformed(evt);
        }

        @Override
        protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
            return new ButtonActionPropertyChangeListener(this, a);
        }
    }

    class JToolBarButton
    extends JButton {
        public JToolBarButton(Action action) {
            super(action);
        }

        @Override
        protected void configurePropertiesFromAction(Action a) {
            String[] types = new String[]{"SmallIcon", "ShortDescription", "LongDescription", "enabled"};
            Helper.configurePropertiesFromAction(this, a, types);
        }
    }

    class ViewLogAction
    extends BasicGuiAction {
        public ViewLogAction() {
            super("runtime.viewlog");
        }
    }

    class RuntimeNotificationsAction
    extends BasicGuiAction {
        public RuntimeNotificationsAction() {
            super("runtime.notifications");
        }
    }

    class RuntimeMetricsAction
    extends BasicGuiAction {
        public RuntimeMetricsAction() {
            super("runtime.metrics");
        }
    }

    class EditPropertiesAction
    extends BasicGuiAction {
        public EditPropertiesAction() {
            super("edit.properties");
        }
    }

    class ViewGotoConfigurationAction
    extends BasicGuiAction {
        public ViewGotoConfigurationAction() {
            super("view.gotoconfiguration");
        }
    }

    class ViewGotoInstanceAction
    extends BasicGuiAction {
        public ViewGotoInstanceAction() {
            super("view.gotoinstance");
        }
    }

    class ViewRefreshAction
    extends BasicGuiAction {
        public ViewRefreshAction() {
            super("view.refresh");
        }
    }

    class EditDeleteAction
    extends BasicGuiAction {
        public EditDeleteAction() {
            super("edit.delete");
        }
    }

    class EditPasteAction
    extends BasicGuiAction {
        public EditPasteAction() {
            super("edit.paste");
        }
    }

    class EditCopyAction
    extends BasicGuiAction {
        public EditCopyAction() {
            super("edit.copy");
        }
    }

    class EditCutAction
    extends BasicGuiAction {
        public EditCutAction() {
            super("edit.cut");
        }
    }

    class FileNewAction
    extends BasicGuiAction {
        public FileNewAction() {
            super("file.new.configuration");
            this.putSmallIconValue();
        }

        private void putSmallIconValue() {
            this.putValue("SmallIcon", new ExtendedImageIcon((Icon)this.getValue("SmallIcon"), ResourceManager.getIcon(this.getClass(), "newoverlay")));
        }
    }

    class FileNewFolderAction
    extends BasicGuiAction {
        public FileNewFolderAction() {
            super("file.new.folder");
            this.putSmallIconValue();
        }

        private void putSmallIconValue() {
            this.putValue("SmallIcon", new ExtendedImageIcon((Icon)this.getValue("SmallIcon"), ResourceManager.getIcon(this.getClass(), "newoverlay")));
        }
    }

    class FileConnectAction
    extends BasicGuiAction {
        public FileConnectAction() {
            super("file.connect.new");
            this.putSmallIconValue();
        }

        private void putSmallIconValue() {
            this.putValue("SmallIcon", new ExtendedImageIcon((Icon)this.getValue("SmallIcon"), ResourceManager.getIcon(this.getClass(), "newoverlay")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MgmtConsole.getMgmtConsole().connectToDefaultDomain();
        }
    }
}

