/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui;

import com.sonicsw.ma.gui.IDomainWorkspaceWindow;
import com.sonicsw.ma.gui.JPreferencesDialog;
import com.sonicsw.ma.gui.JTypeManagerDialog;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.gui.util.JMADesktopPane;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JProgressDialog;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.SwingWorker;
import com.sonicsw.ma.plugin.ClasspathToolInfo;
import com.sonicsw.ma.plugin.ToolInfo;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.Version;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mx.config.ConfigServerUtility;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.management.ObjectName;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;

final class ToolsMenu
extends JBasicMenu {
    private static final ToolInfo[] HARDWIRED_TOOLS = new ToolInfo[]{new ClasspathToolInfo("&JMS Administered Objects", "JMS Administered Objects Tool", "com.sonicsw.mq.gui.adminobjs.ExplorerClient")};
    private PreferenceManager m_preferences;
    private JMADesktopPane m_desktop;
    private BasicGuiAction m_prefAction;
    private BasicGuiAction m_exportLocalAction;
    private BasicGuiAction m_exportRemoteAction;
    private BasicGuiAction m_repairAction;
    private BasicGuiAction m_typeManagerAction;
    private BasicGuiAction m_launchSMCAction;

    ToolsMenu(PreferenceManager preferences, MouseListener mouseListener, JMADesktopPane desktop) {
        super(new ToolsAction());
        this.m_preferences = preferences;
        this.m_desktop = desktop;
        this.m_prefAction = new ToolPrefsAction();
        this.m_exportLocalAction = new ToolExportDSAction(true);
        this.m_exportRemoteAction = new ToolExportDSAction(false);
        this.m_repairAction = new ToolRepairDSAction();
        this.m_typeManagerAction = new ToolTypeManagerAction();
        this.m_launchSMCAction = new LaunchSMCAction();
        this.setMouseListener(mouseListener);
        this.buildMenu(null);
    }

    public Action getPrefAction() {
        return this.m_prefAction;
    }

    @Override
    public void menuSelected(MenuEvent evt) {
        ArrayList<JSeparator> list = new ArrayList<JSeparator>();
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof IDomainWorkspaceWindow)) continue;
            ArrayList<JComponent> frameList = new ArrayList<JComponent>();
            IDomainWorkspaceWindow frame = (IDomainWorkspaceWindow)((Object)frames[i]);
            JComponent[] frameItems = frame.getContext().getLibrary().getToolsMenuItems();
            for (int j = 0; j < frameItems.length; ++j) {
                if (this.alreadyInList(list, frameItems[j])) continue;
                frameList.add(frameItems[j]);
            }
            if (frameList.isEmpty()) continue;
            if (!list.isEmpty()) {
                list.add(new JSeparator());
            }
            for (int k = 0; k < frameList.size(); ++k) {
                list.add((JSeparator)frameList.get(k));
            }
        }
        this.buildMenu(list.toArray(new JComponent[list.size()]));
        super.menuSelected(evt);
    }

    private boolean alreadyInList(ArrayList list, JComponent c) {
        for (JComponent item : list) {
            if (!(c instanceof JMenuItem) || !(item instanceof JMenuItem)) continue;
            JMenuItem miC = (JMenuItem)c;
            JMenuItem miItem = (JMenuItem)item;
            if (miC == null || !miC.getActionCommand().equals(miItem.getActionCommand())) continue;
            return true;
        }
        return false;
    }

    private void buildMenu(JComponent[] items) {
        this.removeAll();
        for (int iTool = 0; iTool < HARDWIRED_TOOLS.length; ++iTool) {
            this.add(HARDWIRED_TOOLS[iTool].getMenuItem());
        }
        this.add(this.m_launchSMCAction);
        JBasicMenu exportMenu = new JBasicMenu(new ToolExportAction());
        exportMenu.add(this.m_exportRemoteAction);
        exportMenu.add(this.m_exportLocalAction);
        this.add(exportMenu);
        if (MgmtConsole.DEVELOPER_MODE) {
            this.add(this.m_repairAction);
            this.add(this.m_typeManagerAction);
        }
        if (this.getItemCount() > 0) {
            if (items != null && items.length > 0) {
                this.addSeparator();
                for (int i = 0; i < items.length; ++i) {
                    this.add(items[i]);
                }
            }
            this.addSeparator();
        }
        this.add(this.m_prefAction);
    }

    class LaunchSMCAction
    extends ToolAction {
        public LaunchSMCAction() {
            super("tool.jmsTestClient");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String sonicHome = System.getProperty("sonicsw.home");
            String mqHome = sonicHome + File.separator + "MQ" + this.getMajorMinorVersion();
            String startMCFile = mqHome + File.separator + "bin" + File.separator + "testClient." + this.getFileExtn();
            File mqDir = new File(mqHome);
            try {
                Process process = Runtime.getRuntime().exec(startMCFile, null, mqDir);
            }
            catch (IOException e) {
                e.printStackTrace();
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
        }

        public String getMajorMinorVersion() {
            return Version.getMajorVersion() + "." + Version.getMinorVersion();
        }

        private String getFileExtn() {
            String osName = System.getProperty("os.name");
            if (osName.toLowerCase().indexOf("win") != -1) {
                return "bat";
            }
            return "sh";
        }
    }

    class RepairDSWorker
    extends SwingWorker {
        JProgressDialog m_dialog;
        DomainConnectionModel m_model;
        ConfigServerUtility m_csu;
        boolean m_cancelled = false;

        public RepairDSWorker(DomainConnectionModel model, JProgressDialog dialog) {
            this.m_model = model;
            this.m_dialog = dialog;
        }

        @Override
        public Object construct() {
            Throwable res = null;
            this.m_csu = new ConfigServerUtility();
            try {
                this.m_csu.connect(this.m_model.getDirectoryService(), false);
                this.m_csu.repairDanglingBeanReferences();
                res = this.m_csu;
            }
            catch (Throwable e) {
                res = e;
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished() {
            JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
            try {
                if (this.m_dialog != null) {
                    this.m_dialog.setVisible(false);
                }
                if (this.m_cancelled) {
                    this.disconnect();
                    return;
                }
                if (this.getValue() == null) {
                    return;
                }
                if (this.getValue() instanceof Throwable) {
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to repair Directory Service", (Throwable)this.getValue(), true);
                    this.disconnect();
                } else if (!this.m_cancelled) {
                    // empty if block
                }
            }
            finally {
                if (this.m_dialog != null) {
                    this.m_dialog.dispose();
                }
                wc.release();
            }
        }

        @Override
        public void interrupt() {
            this.m_cancelled = true;
            super.interrupt();
        }

        public void disconnect() {
            try {
                this.m_csu.disconnect();
                this.m_csu = null;
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to disconnect " + e.getMessage(), e, false);
            }
        }
    }

    class ToolRepairDSAction
    extends ToolAction {
        public ToolRepairDSAction() {
            super("tool.repairDS");
        }

        @Override
        public boolean isEnabled() {
            return this.getCurrentWorkspaceWindow() != null;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                IDomainWorkspaceWindow window = this.getCurrentWorkspaceWindow();
                JProgressDialog dlg = new JProgressDialog(MgmtConsole.getMgmtConsole(), "Repair Directory Service", true);
                dlg.setContent(new JLabel("Please wait..."));
                dlg.setWorker(new RepairDSWorker(window.getContext().getConnectionInfo(), dlg));
                dlg.setVisible(true);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to repair directory service.", e, true);
            }
        }
    }

    class ToolTypeManagerAction
    extends ToolAction {
        public ToolTypeManagerAction() {
            super("tool.typeManager");
        }

        @Override
        public boolean isEnabled() {
            return this.getCurrentWorkspaceWindow() != null;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                IDomainWorkspaceWindow window = this.getCurrentWorkspaceWindow();
                IDirectoryAdminService ds = (IDirectoryAdminService)window.getContext().getConnectionInfo().getDirectoryService();
                JTypeManagerDialog dlg = new JTypeManagerDialog((JMAFrame)MgmtConsole.getMgmtConsole(), ds);
                dlg.setVisible(true);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Type Manager", e, true);
            }
        }
    }

    class JCheckedFileChooser
    extends JFileChooser {
        JCheckedFileChooser() {
        }

        @Override
        public void approveSelection() {
            File selectedFile = this.getSelectedFile();
            if (selectedFile != null && selectedFile.exists() && JOptionPane.showConfirmDialog(this, "The file " + selectedFile.getName() + " already exists. Do you want to replace the existing file?", "Attention", 1) != 0) {
                return;
            }
            super.approveSelection();
        }
    }

    class ToolExportDSAction
    extends ToolAction {
        private String m_exportPath;
        private boolean m_local;

        public ToolExportDSAction(boolean local) {
            super(local ? "tool.exportDS.local" : "tool.exportDS.remote");
            this.m_exportPath = null;
            this.m_local = local;
        }

        @Override
        public boolean isEnabled() {
            return this.getCurrentWorkspaceWindow() != null;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.m_local) {
                this.exportLocal();
            } else {
                this.exportRemote();
            }
        }

        private void exportLocal() {
            JCheckedFileChooser fc = new JCheckedFileChooser();
            fc.setDialogTitle("Export Directory Service Configuration");
            if (this.m_exportPath == null) {
                String domain = this.getCurrentWorkspaceWindow().getContext().getConnectionInfo().getDomainName();
                StringBuffer sb = new StringBuffer();
                sb.append("dump.").append(domain).append(".xml");
                this.m_exportPath = sb.toString();
            }
            try {
                fc.setSelectedFile(new File(this.m_exportPath));
            }
            catch (Exception e) {
                MgmtConsole.displayMessage(4, e.toString(), e, true);
            }
            if (fc.showSaveDialog(MgmtConsole.getMgmtConsole()) == 0) {
                this.m_exportPath = fc.getSelectedFile().getPath();
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ToolExportDSAction.this.exportConfig(ToolExportDSAction.this.m_exportPath);
                    }
                });
                t.start();
            }
        }

        private void exportRemote() {
            IDomainWorkspaceWindow window = this.getCurrentWorkspaceWindow();
            if (window == null) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Can't export configuration if no domain selected!", true);
                return;
            }
            try {
                DomainConnectionModel dcm = window.getContext().getConnectionInfo();
                ((IDirectoryAdminService)dcm.getDirectoryService()).dumpContentsToXML();
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to export directory service configuration.", e, true);
            }
        }

        private void exportConfig(String exportPath) {
            IDomainWorkspaceWindow window = this.getCurrentWorkspaceWindow();
            if (window == null) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Can't export configuration if no domain selected!", true);
                return;
            }
            boolean notFinished = true;
            DomainConnectionModel dcm = window.getContext().getConnectionInfo();
            JMSConnectorClient server = (JMSConnectorClient)dcm.getMBeanServer();
            int timeout = dcm.getTimeout() * 1000 * 4;
            while (notFinished) {
                try {
                    ObjectName dsName = new ObjectName(dcm.getDirectoryServiceName());
                    String dump = null;
                    dump = server != null ? (String)server.invoke(dsName, "exportDirectoryToXML", new Object[]{"/"}, new String[]{String.class.getName()}, (long)timeout) : ((IDirectoryAdminService)dcm.getDirectoryService()).exportDirectoryToXML("/");
                    if (dump == null) {
                        throw new Exception("Directory Service has nothing to export!");
                    }
                    FileWriter writer = new FileWriter(exportPath);
                    writer.write(dump);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    notFinished = false;
                }
                catch (InvokeTimeoutException e) {
                    String value = (String)JOptionPane.showInputDialog(MgmtConsole.getMgmtConsole(), "Failed to export directory service configuration.\nTimeout waiting for response.\n\nTo retry please enter a new timeout (in seconds):", "Attention", 0, null, null, Integer.toString(timeout / 1000));
                    if (value == null || value.trim().length() == 0) {
                        notFinished = false;
                        continue;
                    }
                    try {
                        timeout = Integer.parseInt(value.trim()) * 1000;
                        if (timeout > 0) continue;
                        timeout = dcm.getTimeout() * 1000 * 4;
                    }
                    catch (NumberFormatException eNFE) {
                        MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to export directory service configuration.\nInvalid timeout!", e, true);
                        notFinished = false;
                    }
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to export directory service configuration.", e, true);
                    notFinished = false;
                }
            }
        }
    }

    class ToolExportAction
    extends ToolAction {
        public ToolExportAction() {
            super("tool.exportDS");
        }

        @Override
        public boolean isEnabled() {
            return this.getCurrentWorkspaceWindow() != null;
        }
    }

    abstract class ToolAction
    extends BasicGuiAction {
        public ToolAction(String resourceId) {
            super(resourceId);
        }

        public ToolAction(String resourceId, Action targetAction) {
            super(resourceId, targetAction);
        }

        protected IDomainWorkspaceWindow getCurrentWorkspaceWindow() {
            IDomainWorkspaceWindow res = null;
            try {
                JInternalFrame frame = ToolsMenu.this.m_desktop.getSelectedFrame();
                if (frame instanceof IDomainWorkspaceWindow) {
                    res = (IDomainWorkspaceWindow)((Object)frame);
                }
            }
            catch (Exception e) {
                res = null;
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
            return res;
        }
    }

    class ToolPrefsAction
    extends BasicGuiAction {
        public ToolPrefsAction() {
            super("tool.prefs");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JPreferencesDialog dialog = new JPreferencesDialog((JMAFrame)MgmtConsole.getMgmtConsole(), ToolsMenu.this.m_preferences);
            dialog.setVisible(true);
        }
    }

    static class ToolsAction
    extends BasicGuiAction {
        public ToolsAction() {
            super("tool");
        }
    }
}

