/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui;

import com.sonicsw.ma.gui.IWorkspaceWindow;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JBasicCheckBoxMenuItem;
import com.sonicsw.ma.gui.util.JBasicMenu;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;

final class ViewMenu
extends JBasicMenu {
    public static String VIEW = "view";
    public static String SHOW_TOOLBAR = "showToolBar";
    public static String SHOW_STATUSBAR = "showStatusBar";
    private PreferenceManager m_preferences;
    private JBasicCheckBoxMenuItem m_statusBarMenuItem;
    private JBasicCheckBoxMenuItem m_messageLogMenuItem;
    private JBasicCheckBoxMenuItem m_toolBarMenuItem;

    ViewMenu(PreferenceManager preferences, MouseListener mouseListener) {
        super(new ViewAction());
        this.m_preferences = preferences;
        this.m_statusBarMenuItem = new JBasicCheckBoxMenuItem(new StatusBarAction());
        this.m_messageLogMenuItem = new JBasicCheckBoxMenuItem(new MessageLogAction());
        this.m_toolBarMenuItem = new JBasicCheckBoxMenuItem(new ToolBarAction());
        this.setMouseListener(mouseListener);
        this.buildMenu(null);
        this.setMenuItemStates();
    }

    protected void setMenuItemStates() {
        this.m_toolBarMenuItem.setSelected(this.m_preferences.getBoolean(VIEW, SHOW_TOOLBAR, true));
        this.m_statusBarMenuItem.setSelected(this.m_preferences.getBoolean(VIEW, SHOW_STATUSBAR, true));
    }

    @Override
    public void menuSelected(MenuEvent evt) {
        JInternalFrame innerFrame = MgmtConsole.getMgmtConsole().getDesktopPane().getSelectedFrame();
        JComponent[] viewItems = null;
        if (innerFrame != null && innerFrame instanceof IWorkspaceWindow) {
            viewItems = ((IWorkspaceWindow)((Object)innerFrame)).getSelectedMenuItems(5);
        }
        this.buildMenu(viewItems);
        super.menuSelected(evt);
    }

    boolean getShowStatus() {
        return this.m_statusBarMenuItem.isSelected();
    }

    public Action getMessageLogAction() {
        return this.m_messageLogMenuItem.getAction();
    }

    boolean getShowToolBar() {
        return this.m_toolBarMenuItem.isSelected();
    }

    private void buildMenu(JComponent[] items) {
        this.removeAll();
        this.add(this.m_toolBarMenuItem);
        this.add(this.m_statusBarMenuItem);
        this.addSeparator();
        this.add(this.m_messageLogMenuItem);
        if (items != null && items.length > 0) {
            this.add(new JSeparator());
            for (int i = 0; i < items.length; ++i) {
                this.add(items[i]);
            }
        }
    }

    class MessageLogAction
    extends BasicGuiAction {
        public MessageLogAction() {
            super("view.messagelog");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MgmtConsole.getMgmtConsole().showMessageLog(this.isSelected());
        }
    }

    class StatusBarAction
    extends BasicGuiAction {
        public StatusBarAction() {
            super("view.statusbar");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MgmtConsole.getMgmtConsole().showStatusBar(ViewMenu.this.m_statusBarMenuItem.isSelected());
            ViewMenu.this.m_preferences.setBoolean(VIEW, SHOW_STATUSBAR, ViewMenu.this.m_statusBarMenuItem.isSelected(), true);
        }
    }

    class ToolBarAction
    extends BasicGuiAction {
        public ToolBarAction() {
            super("view.toolbar");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MgmtConsole.getMgmtConsole().showToolBar(ViewMenu.this.m_toolBarMenuItem.isSelected());
            ViewMenu.this.m_preferences.setBoolean(VIEW, SHOW_TOOLBAR, ViewMenu.this.m_toolBarMenuItem.isSelected(), true);
        }
    }

    static class ViewWorkspaceAction
    extends BasicGuiAction {
        public ViewWorkspaceAction() {
            super("view.workspace");
        }
    }

    class ViewConsoleAction
    extends BasicGuiAction {
        public ViewConsoleAction() {
            super("view.console");
        }
    }

    static class ViewAction
    extends BasicGuiAction {
        public ViewAction() {
            super("view");
        }
    }
}

