/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui;

import com.sonicsw.ma.gui.GUIMonitorPluginListener;
import com.sonicsw.ma.gui.GUIPluginListener;
import com.sonicsw.ma.gui.IDomainWorkspaceWindow;
import com.sonicsw.ma.gui.JWorkspaceConfigPanel;
import com.sonicsw.ma.gui.JWorkspacePanel;
import com.sonicsw.ma.gui.JWorkspaceRuntimePanel;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.ToolBar;
import com.sonicsw.ma.gui.dev.JDevWorkspacePanel;
import com.sonicsw.ma.gui.runtime.AbstractRuntimePlugin;
import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.ITableContentPane;
import com.sonicsw.ma.gui.util.DescriptionPanel;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAInternalFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IMonitorPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.PluginContext;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WorkspaceWindow
extends JMAInternalFrame
implements IDomainWorkspaceWindow,
ChangeListener {
    private IPluginContext m_context;
    private JTabbedPane m_tab;
    private Object m_selected = null;
    private int m_lastWorkspace = -1;
    private EventListenerList m_listenerList = new EventListenerList();
    private DescriptionPanel m_panelDescription = null;
    private HashMap m_trackedDialogMap = new HashMap();

    public WorkspaceWindow(String title, IPluginContext context) {
        super("workspace");
        this.prepareWSWindow(title, context);
    }

    private void prepareWSWindow(String title, IPluginContext context) {
        try {
            this.setTitle(title);
            this.setFrameIcon(ResourceManager.getIcon(this.getClass(), "Connect"));
            this.m_context = context;
            ((PluginContext)context).setWorkspace(this);
            this.m_tab = new JTabbedPane(1);
            this.m_tab.addChangeListener(this);
            this.getContentPane().setLayout(new BorderLayout());
            this.m_panelDescription = new DescriptionPanel("Test Description");
            this.getContentPane().add((Component)this.m_panelDescription, "North");
            this.m_panelDescription.setBorder(BorderFactory.createEmptyBorder(0, 0, JPartitionPanel.BORDER_SIZE, 0));
            this.getContentPane().add((Component)this.m_tab, "Center");
            Class[] classes = this.getPanelClasses();
            for (int i = 0; i < classes.length; ++i) {
                JWorkspacePanel panel = (JWorkspacePanel)classes[i].newInstance();
                this.m_tab.add((Component)panel, panel.getName());
                this.m_tab.setIconAt(i, panel.getIcon());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
    }

    @Override
    public boolean canClose() {
        return MgmtConsole.getMgmtConsole().showConfirmDialog("Are you sure you want to close connection:\n\t" + this.getTitle(), "Close Connection", 3, 0) == 0;
    }

    private Class[] getPanelClasses() {
        ArrayList<Class<JDevWorkspacePanel>> res = new ArrayList<Class<JDevWorkspacePanel>>();
        res.add(JWorkspaceConfigPanel.class);
        res.add(JWorkspaceRuntimePanel.class);
        if (MgmtConsole.DEVELOPER_MODE) {
            res.add(JDevWorkspacePanel.class);
        }
        return res.toArray(new Class[0]);
    }

    public void updateDescription(String strSelection) {
        this.m_panelDescription.setExtendedText(strSelection);
    }

    @Override
    protected void maInitialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void maCleanup() {
        this.m_tab.removeChangeListener(this);
        for (int i = 0; i < this.m_tab.getTabCount(); ++i) {
            JWorkspacePanel panel = (JWorkspacePanel)this.m_tab.getComponentAt(i);
            panel.dispose();
        }
        this.m_tab.removeAll();
        try {
            this.m_context.getConnectionInfo().disconnect();
            MgmtConsole.getMgmtConsole().getToolBar().clearActions();
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to disconnect", e, false);
        }
        finally {
            if (this.m_context != null) {
                this.m_context.destroy();
            }
            this.m_context = null;
            this.m_tab = null;
        }
    }

    @Override
    public IPluginContext getContext() {
        return this.m_context;
    }

    @Override
    public JComponent[] getSelectedMenuItems(int type) {
        JComponent[] items = null;
        try {
            for (Component comp = this.getComponentWithFocus(); comp != null; comp = comp.getParent()) {
                if (comp instanceof JTree) {
                    DefaultMutableTreeNode node;
                    IPlugin plugin = null;
                    if (((JTree)comp).getSelectionCount() > 0 && (node = (DefaultMutableTreeNode)((JTree)comp).getSelectionPath().getLastPathComponent()) instanceof IPlugin) {
                        plugin = (IPlugin)((Object)node);
                    }
                    if (plugin == null) continue;
                    items = plugin.getMenuItems(type);
                    continue;
                }
                if (!(comp instanceof IContentPane)) continue;
                items = ((IContentPane)((Object)comp)).getMenuItems(type);
                break;
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return items;
    }

    private MouseEvent createMouseEvent(Component source, int x, int y, int eventType) {
        return new MouseEvent(source, eventType, System.currentTimeMillis(), 0, x, y, 1, true, 3);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        JWorkspacePanel workspace;
        block8: {
            Component focusComp;
            ToolBar toolbar;
            block9: {
                int index = this.m_tab.getSelectedIndex();
                if (index == this.m_lastWorkspace) {
                    return;
                }
                this.m_lastWorkspace = index;
                workspace = this.getSelectedWorkspacePanel();
                toolbar = MgmtConsole.getMgmtConsole().getToolBar();
                toolbar.clearActions();
                if (focusComp == null) break block8;
                if (focusComp != workspace.getTree()) break block9;
                JTree tree = (JTree)focusComp;
                TreePath treePath = tree.getSelectionPath();
                if (treePath == null) break block8;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                toolbar.setActions(node);
                break block8;
            }
            if (focusComp instanceof JRowTable) {
                for (focusComp = this.getComponentWithFocus(); focusComp != null; focusComp = focusComp.getParent()) {
                    if (!(focusComp instanceof IContentPane)) continue;
                    toolbar.setActions((IContentPane)((Object)focusComp));
                    break;
                }
            }
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 121 && e.getID() == 401 && (e.getModifiersEx() & 0x40) > 0) {
                    MouseEvent me = null;
                    Component compWithFocus = WorkspaceWindow.this.getComponentWithFocus();
                    if (compWithFocus instanceof JTree) {
                        JTree treeComp = (JTree)compWithFocus;
                        TreePath selectionPath = treeComp.getSelectionPath();
                        Rectangle pathBounds = treeComp.getPathBounds(selectionPath);
                        int x = Double.valueOf(pathBounds.getX()).intValue();
                        int y = Double.valueOf(pathBounds.getY()).intValue();
                        me = WorkspaceWindow.this.createMouseEvent(treeComp, x, y, 501);
                        treeComp.dispatchEvent(me);
                        me = WorkspaceWindow.this.createMouseEvent(treeComp, x, y, 502);
                        treeComp.dispatchEvent(me);
                        e.consume();
                        return true;
                    }
                    if (compWithFocus instanceof JRowTable) {
                        JRowTable tableComp = (JRowTable)compWithFocus;
                        Rectangle r = tableComp.getCellRect(tableComp.getSelectedRow(), tableComp.getSelectedColumn(), true);
                        int x = Double.valueOf(r.getX()).intValue();
                        int y = Double.valueOf(r.getY()).intValue();
                        me = WorkspaceWindow.this.createMouseEvent(tableComp, x, y, 501);
                        tableComp.dispatchEvent(me);
                        me = WorkspaceWindow.this.createMouseEvent(tableComp, x, y, 502);
                        tableComp.dispatchEvent(me);
                        e.consume();
                        return true;
                    }
                }
                return false;
            }
        });
        IContentPane contentPane = workspace.getContentPane();
        if (contentPane != null) {
            contentPane.refresh();
        }
        this.updateSelection(this.getSelected());
        this.m_panelDescription.setText(workspace.getName());
        this.m_panelDescription.getDescriptionLabel().setIcon(workspace.getIcon());
        if (workspace.getSelectedNode() != null && workspace.getSelectedNode() instanceof IPlugin) {
            this.m_panelDescription.setExtendedText(((IPlugin)((Object)workspace.getSelectedNode())).getPluginPath());
        } else {
            this.m_panelDescription.setExtendedText(null);
        }
        if (workspace.getFocusComponent() != null) {
            workspace.getFocusComponent().requestFocus();
        } else {
            workspace.getTree().requestFocus();
        }
    }

    protected void setSelectedTab(int tab) {
        this.m_tab.getModel().setSelectedIndex(tab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JWorkspacePanel getSelectedWorkspacePanel() {
        JWorkspacePanel panelWkspc = (JWorkspacePanel)this.m_tab.getSelectedComponent();
        if (!panelWkspc.isInitialized()) {
            JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
            try {
                panelWkspc.initialize(this.m_context);
            }
            finally {
                wc.release();
            }
        }
        return panelWkspc;
    }

    public JWorkspacePanel getWorkspacePanel(String name) {
        for (int i = 0; i < this.m_tab.getTabCount(); ++i) {
            JWorkspacePanel panel = (JWorkspacePanel)this.m_tab.getComponentAt(i);
            if (!panel.getName().equals(name)) continue;
            return panel;
        }
        return null;
    }

    public IPlugin findConfiguration(String path) {
        return this.goToConfiguration(path, true, false, false);
    }

    public IPlugin goToConfiguration(String path, boolean isConfig) {
        return this.goToConfiguration(path, isConfig, true);
    }

    public IPlugin goToConfiguration(String path, boolean isConfig, boolean changeSelection) {
        return this.goToConfiguration(path, isConfig, changeSelection, true);
    }

    public IPlugin goToConfiguration(String path, boolean isConfig, boolean changeSelection, boolean isVisual) {
        JWorkspacePanel panelConfig = this.getWorkspacePanel("Configure");
        JTree treeConfig = panelConfig.getTree();
        path = "Configured Objects" + path;
        if (isVisual) {
            this.m_tab.setSelectedIndex(this.m_tab.indexOfComponent(panelConfig));
        }
        TreeNode node = (TreeNode)((DefaultTreeModel)treeConfig.getModel()).getRoot();
        StringTokenizer tokens = new StringTokenizer(path, "/");
        while (node != null && tokens.hasMoreTokens()) {
            node = ((AbstractGUIPlugin)node).findChildNode(tokens.nextToken());
        }
        if (node != null) {
            if (isVisual) {
                TreePath pathToNode = new TreePath(((DefaultMutableTreeNode)node).getPath());
                treeConfig.expandPath(pathToNode);
                if (changeSelection) {
                    treeConfig.setSelectionPath(pathToNode);
                }
                treeConfig.invalidate();
            }
        } else {
            Helper.logErrorMessage("Failed to find configuration node with path '" + path + "'");
        }
        return (IPlugin)((Object)node);
    }

    public void updateCollectionState(String path) {
        JWorkspacePanel panelRuntime = this.getWorkspacePanel("Manage");
        JTree treeRuntime = panelRuntime.getTree();
        TreeNode node = (TreeNode)((DefaultTreeModel)treeRuntime.getModel()).getRoot();
        if (node instanceof AbstractGUIPlugin) {
            StringTokenizer tokens = new StringTokenizer(path, "/");
            while (tokens.hasMoreTokens() && node != null) {
                node = ((AbstractGUIPlugin)node).findChildNode(tokens.nextToken());
            }
            if (node != null) {
                ((AbstractRuntimePlugin)node).getState(true);
            }
        }
    }

    public void goToInstance(String path, String compRuntimeID, boolean isConfig) {
        JWorkspacePanel panelRuntime = this.getWorkspacePanel("Manage");
        JTree treeRuntime = panelRuntime.getTree();
        this.m_tab.setSelectedIndex(this.m_tab.indexOfComponent(panelRuntime));
        TreeNode node = (TreeNode)((DefaultTreeModel)treeRuntime.getModel()).getRoot();
        StringTokenizer tokens = new StringTokenizer(path, "/");
        while (tokens.hasMoreTokens() && node != null) {
            node = ((AbstractGUIPlugin)node).findChildNode(tokens.nextToken());
        }
        if (node != null) {
            TreePath pathToNode = new TreePath(((DefaultMutableTreeNode)node).getPath());
            boolean bOldMode = panelRuntime.getTreeExpansionMode();
            panelRuntime.setTreeExpansionMode(false);
            treeRuntime.expandPath(pathToNode);
            panelRuntime.setTreeExpansionMode(bOldMode);
            if (compRuntimeID != null) {
                Enumeration<? extends TreeNode> children = node.children();
                while (children.hasMoreElements()) {
                    node = (AbstractRuntimePlugin)children.nextElement();
                    if (!((AbstractRuntimePlugin)node).getRuntimeID().getCanonicalName().equals(compRuntimeID)) continue;
                    pathToNode = new TreePath(((DefaultMutableTreeNode)node).getPath());
                    break;
                }
            }
            treeRuntime.setSelectionPath(pathToNode);
        }
    }

    private String getComponentName(String runtimeID) {
        int index = runtimeID.indexOf(":ID=");
        return runtimeID.substring(index + IComponentIdentity.DELIMITED_ID_PREFIX_LENGTH);
    }

    public IPlugin getSelectedPlugin() {
        Object obj = this.getSelected();
        if (obj instanceof IPlugin) {
            return (IPlugin)obj;
        }
        return null;
    }

    public Object getSelected() {
        Object res = null;
        for (Component comp = this.getComponentWithFocus(); comp != null; comp = comp.getParent()) {
            if (comp instanceof JTree) {
                if (((JTree)comp).getSelectionCount() <= 0) break;
                res = ((JTree)comp).getSelectionPath().getLastPathComponent();
                break;
            }
            if (comp instanceof ITableContentPane) {
                JRowTable table = ((ITableContentPane)((Object)comp)).getTable();
                int selRow = table.getSelectedRow();
                res = ((IModelTableModel)table.getModel()).getRowModel(selRow);
                continue;
            }
            if (!(comp instanceof IContentPane)) continue;
            res = ((IContentPane)((Object)comp)).getSelectedItem();
            break;
        }
        return res;
    }

    private Component getComponentWithFocus() {
        JWorkspacePanel panel;
        Component comp = null;
        int nIndex = this.m_tab.getSelectedIndex();
        if (nIndex != -1 && (panel = (JWorkspacePanel)this.m_tab.getComponentAt(nIndex)) != null) {
            comp = panel.getFocusComponent();
        }
        return comp;
    }

    public void updateSelection() {
        this.updateSelection(this.getSelected());
    }

    void updateSelection(Object obj) {
        if (obj == null) {
            return;
        }
        this.m_selected = obj;
        if (this.m_selected instanceof IPlugin) {
            this.fireGUIPluginChanged((IPlugin)this.m_selected);
        }
        if (this.m_selected instanceof IMonitorPlugin) {
            this.fireGUIMonitorPluginChanged((IMonitorPlugin)this.m_selected);
        }
    }

    public void addGUIPluginListener(GUIPluginListener l) {
        this.m_listenerList.add(GUIPluginListener.class, l);
    }

    public void removeGUIPluginListener(GUIPluginListener l) {
        this.m_listenerList.remove(GUIPluginListener.class, l);
    }

    public GUIPluginListener[] getGUIPluginListeners() {
        return (GUIPluginListener[])this.listenerList.getListeners(GUIPluginListener.class);
    }

    public void fireGUIPluginChanged(IPlugin plugin) {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GUIPluginListener.class) continue;
            ((GUIPluginListener)listeners[i + 1]).guiPluginChanged(plugin);
        }
    }

    public void addGUIMonitorPluginListener(GUIMonitorPluginListener l) {
        this.m_listenerList.add(GUIMonitorPluginListener.class, l);
    }

    public void removeGUIMonitorPluginListener(GUIMonitorPluginListener l) {
        this.m_listenerList.remove(GUIMonitorPluginListener.class, l);
    }

    public GUIMonitorPluginListener[] getGUIMonitorPluginListeners() {
        return (GUIMonitorPluginListener[])this.listenerList.getListeners(GUIMonitorPluginListener.class);
    }

    public void fireGUIMonitorPluginChanged(IMonitorPlugin plugin) {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GUIMonitorPluginListener.class) continue;
            ((GUIMonitorPluginListener)listeners[i + 1]).guiMonitorPluginChanged(plugin);
        }
    }

    public JMADialog getTrackedDialog(Object id) {
        return (JMADialog)this.m_trackedDialogMap.get(id);
    }

    public void addTrackedDialog(Object id, JMADialog dialog) {
        this.m_trackedDialogMap.put(id, dialog);
    }

    public JMADialog removeTrackedDialog(Object id) {
        return (JMADialog)this.m_trackedDialogMap.remove(id);
    }
}

