/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.action;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IAnnotationProvider;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;
import java.awt.event.ActionEvent;

public class AnnotationPluginAction
extends BasicPluginAction {
    private static final long serialVersionUID = 1L;

    public AnnotationPluginAction(IConfigPlugin plugin) {
        super(plugin, "view.annotation");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        IConfigPlugin plugin = (IConfigPlugin)this.getPlugin();
        if (plugin.getModel() instanceof ConfigBeanModel) {
            IConfigBean bean = (IConfigBean)((ConfigBeanModel)plugin.getModel()).getData();
            if (this.isTemplate(bean)) {
                Helper.logDebugMessage("Attempt to add or edit annotations in a template. Annotations not supported on templates");
            } else if (bean.isPrototypeInstance()) {
                Helper.logDebugMessage("Attempt to add or edit annotations in a template instance. Annotations not supported on template instances");
            } else {
                String newAnnotation;
                String annotation = bean.getAnnotation();
                if (this.annotationsChanged(annotation, newAnnotation = this.openAnnotationEditor(annotation))) {
                    bean.setAnnotation(newAnnotation.trim().length() == 0 ? null : newAnnotation);
                    IConfigServer server = bean.getConfigServer();
                    try {
                        server.storeConfigElement((IConfigElement)bean);
                    }
                    catch (ConfigServiceException e) {
                        MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to save new annotations to server: " + AnnotationPluginAction.getNullValidString(newAnnotation), e, true);
                    }
                }
            }
        }
    }

    protected boolean isTemplate(IConfigBean bean) {
        return bean instanceof IConfigPrototype;
    }

    public static final String getNullValidString(String str) {
        if (null == str) {
            return "null";
        }
        return str;
    }

    protected boolean annotationsChanged(String annotation, String newAnnotation) {
        boolean retValue = false;
        Helper.logDebugMessage("annotations (IN: " + AnnotationPluginAction.getNullValidString(annotation) + ", OUT: " + AnnotationPluginAction.getNullValidString(newAnnotation) + ")");
        if (annotation != newAnnotation) {
            if (newAnnotation == null) {
                retValue = annotation != null;
            } else if (null == annotation) {
                retValue = newAnnotation != null;
            } else if (!newAnnotation.equals(annotation)) {
                retValue = true;
            }
        }
        if (retValue) {
            Helper.logDebugMessage("Annotations have changed from " + AnnotationPluginAction.getNullValidString(annotation) + " to " + AnnotationPluginAction.getNullValidString(newAnnotation));
        } else {
            Helper.logDebugMessage("Annotations have NOT changed. Old Value: \"" + AnnotationPluginAction.getNullValidString(annotation) + "\", value from editor:  \"" + AnnotationPluginAction.getNullValidString(newAnnotation) + "\"");
        }
        return retValue;
    }

    protected String openAnnotationEditor(String inA) {
        String outA = inA;
        try {
            IConfigPlugin plugin = (IConfigPlugin)this.getPlugin();
            String type = plugin.getAttributes().getType();
            String cVersion = plugin.getAttributes().getConfigVersion();
            String pVersion = plugin.getAttributes().getProductVersion();
            IAnnotationProvider provider = this.getPlugin().getPluginContext().getLibrary().getAnnotationProvider(type, cVersion, pVersion);
            if (null != type) {
                outA = provider.openAnnotationEditor(type, cVersion, pVersion, inA, this.getContext().getMgmtConsole());
            } else {
                Helper.logDebugMessage("type == null, therefore a Folder, Annotations are not supported for Folders");
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to edit annotations.", e, true);
        }
        return outA;
    }

    @Override
    public boolean isEnabled() {
        IConfigPlugin plugin = (IConfigPlugin)this.getPlugin();
        String type = plugin.getAttributes().getType();
        String cVersion = plugin.getAttributes().getConfigVersion();
        String pVersion = plugin.getAttributes().getProductVersion();
        IAnnotationProvider provider = this.getPlugin().getPluginContext().getLibrary().getAnnotationProvider(type, cVersion, pVersion);
        if (null == provider) {
            return false;
        }
        if (!(plugin.getModel() instanceof ConfigBeanModel)) {
            return false;
        }
        IConfigBean bean = (IConfigBean)((ConfigBeanModel)plugin.getModel()).getData();
        return provider.isAnnotationSupported(type, cVersion, pVersion) && !this.isTemplate(bean) && !bean.isPrototypeInstance() && null != type;
    }
}

