/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.action;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.AbstractConfigFolderElementPlugin;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.SwingWorker;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IFilePlugin;
import com.sonicsw.ma.plugin.IFolderPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;
import java.awt.event.ActionEvent;
import java.util.Set;

public class DeletePluginAction
extends BasicPluginAction {
    private String m_name;

    public DeletePluginAction(IPlugin plugin) {
        this(plugin, null);
    }

    public DeletePluginAction(IPlugin plugin, String name) {
        super(plugin, "edit.delete");
        this.m_name = name;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.getTargetAction() != null) {
            super.actionPerformed(event);
        } else {
            String name;
            String msg;
            boolean canTransact;
            block15: {
                String path;
                IPlugin plugin = this.getPlugin();
                canTransact = true;
                msg = null;
                String string = name = this.m_name == null ? plugin.getPluginName() : this.m_name;
                if (plugin.getModel() instanceof ConfigBeanModel) {
                    IConfigBean bean = (IConfigBean)((ConfigBeanModel)plugin.getModel()).getData();
                    String string2 = path = plugin instanceof AbstractConfigFolderElementPlugin ? ((AbstractConfigFolderElementPlugin)plugin)._getPluginPath() : plugin.getPluginPath();
                    if (plugin.getPluginContext().getConnectionInfo().getAgentManagerConnection().activeComponentExists(path)) {
                        msg = "Configuration '" + name + "' is deployed and running.\nAre you sure you want to delete it?";
                    }
                    if (bean instanceof IConfigPrototype || bean.isPrototypeInstance()) {
                        canTransact = false;
                    }
                    if (bean instanceof IConfigPrototype) {
                        IConfigPrototype prototype = (IConfigPrototype)bean;
                        try {
                            if (prototype.getPrototypeInstances().size() > 0) {
                                MgmtConsole.getMgmtConsole().notifyMessage(3, "Can't delete template configuration because linked instances still exist!", true);
                                return;
                            }
                        }
                        catch (ConfigServiceException e) {
                            MgmtConsole.getMgmtConsole().notifyMessage(4, e.getMessage(), e, false);
                        }
                    }
                } else if (plugin instanceof IFolderPlugin) {
                    try {
                        IConfigServer configServer = this.getPlugin().getPluginContext().getConfigContext().getConfigServer();
                        path = plugin.getPluginPath();
                        Set set = configServer.list(path);
                        if (set == null || set.isEmpty()) break block15;
                        if (plugin instanceof IFilePlugin) {
                            msg = "Are you sure you want to delete the folder '" + plugin.getPluginName() + "' and all its contents";
                            break block15;
                        }
                        MgmtConsole.getMgmtConsole().notifyMessage(3, "Can't delete folder because it isn't empty.", true);
                        return;
                    }
                    catch (ConfigServiceException e) {
                        MgmtConsole.getMgmtConsole().notifyMessage(4, e.getMessage(), e, false);
                    }
                }
            }
            final boolean transacted = canTransact;
            int ok = MgmtConsole.getMgmtConsole().showConfirmDialog(MgmtConsole.getMgmtConsole(), msg != null ? msg : "Are you sure you want to delete '" + name + "'", "Delete Confirmation", 3, 0);
            if (ok == 0) {
                SwingWorker w = new SwingWorker(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object construct() {
                        Exception error = null;
                        JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
                        IConfigServer configServer = null;
                        try {
                            configServer = transacted ? DeletePluginAction.this.getPlugin().getPluginContext().getConfigContext().getConfigServer().connectTransacted() : DeletePluginAction.this.getPlugin().getPluginContext().getConfigContext().getConfigServer().connect();
                            DeletePluginAction.this.getPlugin().deletePlugin(configServer);
                            if (configServer.isTransacted()) {
                                configServer.commit();
                            }
                            if (MgmtConsole.getMgmtConsole().getClipboardObject() == DeletePluginAction.this.getPlugin()) {
                                MgmtConsole.getMgmtConsole().clearClipboard();
                            }
                        }
                        catch (Exception e) {
                            error = e;
                        }
                        finally {
                            if (configServer != null) {
                                try {
                                    configServer.close();
                                }
                                catch (Exception e) {
                                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                                }
                            }
                            wc.release();
                        }
                        return error;
                    }

                    @Override
                    public void finished() {
                        if (this.getValue() != null) {
                            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to delete configuration '" + name + "'", (Throwable)this.getValue(), true);
                        }
                    }
                };
                w.start();
            }
        }
    }

    @Override
    public boolean canDisplay() {
        return this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        IPlugin plugin = this.getPlugin();
        if (plugin != null) {
            return !plugin.getAttributes().isSystem();
        }
        return false;
    }
}

