/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.action;

import com.sonicsw.ma.gui.JWorkspacePanel;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IFileExistHandler;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ExportPluginAction
extends BasicPluginAction {
    private static final String YES = "Yes";
    private static final String YES_TO_ALL = "Yes to All";
    private static final String NO = "No";
    private static final String CANCEL = "Cancel";
    private static String[] OPTIONS = new String[]{"Yes", "No"};
    private static String[] OPTIONS_ALL = new String[]{"Yes", "Yes to All", "No", "Cancel"};
    public static final String BOOT_PATH_PREFS = "preferences.export";
    public static final String BASEPATH = "basePath";

    public ExportPluginAction(IPlugin plugin) {
        super(plugin, "export.plugin");
    }

    @Override
    public boolean isEnabled() {
        return this.getPlugin().getPluginContext().getConnectionInfo().isConnected();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        PreferenceManager pm = PreferenceManager.getInstance();
        String basePath = pm.getString(BOOT_PATH_PREFS, BASEPATH, "");
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Select Export Location");
        fc.setFileSelectionMode(1);
        fc.setApproveButtonText("Export");
        fc.setSelectedFile(new File(basePath));
        if (fc.showSaveDialog(MgmtConsole.getMgmtConsole()) == 0) {
            String path = fc.getSelectedFile().getPath();
            pm.setString(BOOT_PATH_PREFS, BASEPATH, path, true);
            this.export(path);
        }
    }

    private void export(final String exportPath) {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
                try {
                    IPlugin plugin = ExportPluginAction.this.getPlugin();
                    JWorkspacePanel wp = MgmtConsole.getMgmtConsole().getSelectedWorkspaceWindow().getSelectedWorkspacePanel();
                    Object[] selItem = wp.getSelectedItems();
                    ArrayList<String> list = new ArrayList<String>();
                    if (selItem != null) {
                        for (int i = 0; i < selItem.length; ++i) {
                            list.add(((IPlugin)selItem[i]).getPluginPath());
                        }
                    }
                    ConfigServerUtility csu = ExportPluginAction.this.getPlugin().getPluginContext().getConnectionInfo().getConfigServerUtility();
                    String[] paths = list.toArray(new String[0]);
                    IFileExistHandler handler = new IFileExistHandler(){

                        public int fileExists(File file, boolean isPartOfGroup) {
                            PromptRunnable r = new PromptRunnable(file, isPartOfGroup);
                            try {
                                SwingUtilities.invokeAndWait(r);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            return r.getRetValue();
                        }
                    };
                    csu.exportBeanPath(paths, exportPath, handler, true, true);
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to export.", e, true);
                }
                finally {
                    wc.release();
                }
            }
        });
        t.start();
    }

    private String getDateString(long timestamp) {
        StringBuffer sb = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        cal.setTimeInMillis(System.currentTimeMillis());
        if (year == cal.get(1) && month == cal.get(2) && day == cal.get(5)) {
            sb.append("Today");
        }
        sb.append(", ").append(DateFormat.getDateTimeInstance().format(new Date(timestamp)));
        return sb.toString();
    }

    private String getSizeString(long size) {
        StringBuffer sb = new StringBuffer();
        long kb = size / 1024L;
        if (kb > 0L) {
            String kbS = Long.toString(kb);
            if (kbS.length() > 3) {
                sb.append(kbS.substring(0, kbS.length() - 3));
                sb.append(',');
                sb.append(kbS.substring(kbS.length() - 3));
            } else {
                sb.append(kbS);
            }
            sb.append(" KB");
        } else {
            sb.append(Long.toString(size)).append(" bytes");
        }
        return sb.toString();
    }

    private class PromptRunnable
    implements Runnable {
        private int m_retValue = 0;
        private File m_file = null;
        private boolean m_partOfGroup;

        public PromptRunnable(File file, boolean isPartOfGroup) {
            this.m_file = file;
            this.m_partOfGroup = isPartOfGroup;
        }

        @Override
        public void run() {
            Object[] options = this.m_partOfGroup ? OPTIONS_ALL : OPTIONS;
            String defOption = ExportPluginAction.YES;
            int res = JOptionPane.showOptionDialog(MgmtConsole.getMgmtConsole(), "<html>" + MessageFormat.format("This folder already contains a file named ''{0}''.", this.m_file.getName()) + "<br><br><br>" + "Would you like to replace the existing file?<br><br>" + "&nbsp&nbsp&nbsp&nbsp " + ExportPluginAction.this.getSizeString(this.m_file.length()) + "<br>" + "&nbsp&nbsp&nbsp&nbsp modified: " + ExportPluginAction.this.getDateString(this.m_file.lastModified()) + "<br>" + "</html>", "Confirm File Replace", 0, 3, null, options, defOption);
            if (((String)options[res]).equals(ExportPluginAction.YES)) {
                this.m_retValue = 2;
            } else if (((String)options[res]).equals(ExportPluginAction.YES_TO_ALL)) {
                this.m_retValue = 3;
            } else if (((String)options[res]).equals(ExportPluginAction.NO)) {
                this.m_retValue = 1;
            }
        }

        public int getRetValue() {
            return this.m_retValue;
        }
    }
}

