/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.action;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.mx.config.ConfigServerUtility;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;

public class ImportPluginAction
extends BasicPluginAction {
    public ImportPluginAction(IConfigPlugin plugin) {
        super(plugin, "import.plugin");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        PreferenceManager pm = PreferenceManager.getInstance();
        String basePath = pm.getString("preferences.export", "basePath", "");
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Select Import Path");
        fc.setApproveButtonText("Import");
        fc.setFileSelectionMode(2);
        fc.setSelectedFile(new File(basePath));
        if (fc.showOpenDialog(MgmtConsole.getMgmtConsole()) == 0) {
            String path = fc.getSelectedFile().getPath();
            pm.setString("preferences.export", "basePath", path, true);
            if (MgmtConsole.getMgmtConsole().showConfirmDialog("Are you sure you want to import configuration(s) from '" + path + "'?\r\nThis will overwrite any existing configurations with the same names.", "Import Configurations", 3, 0) == 0) {
                this.importPath(path);
            }
        }
    }

    private void importPath(final String path) {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
                try {
                    ConfigServerUtility csu = ImportPluginAction.this.getPlugin().getPluginContext().getConnectionInfo().getConfigServerUtility();
                    csu.importBeanPath(path, true);
                    csu.repairDanglingBeanReferences();
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to import configurations.", e, true);
                }
                finally {
                    wc.release();
                }
            }
        });
        t.start();
    }
}

