/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.action;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.ConfigFolderPlugin;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IFilePlugin;
import com.sonicsw.ma.plugin.IFolderPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mx.config.IConfigServer;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;

public class PastePluginAction
extends BasicPluginAction {
    public static final String[] FORMAT_COPY = new String[]{"{0}", "Copy {1,choice,1#|1<{1,number,integer} }of {0}"};
    public static final String[] FORMAT_NEW = new String[]{"New {0}{1,choice,1#|1< {1,number,integer}}"};
    public static final String[] FORMAT_NEW_INSTANCE = new String[]{"Instance {1,choice,1#|1<{1,number,integer} }of {0}"};

    public PastePluginAction(IPlugin plugin) {
        super(plugin, "edit.paste");
    }

    public PastePluginAction(IPlugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.paste(false);
    }

    protected void paste(final boolean convert) {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
                try {
                    IPlugin dstPlugin = PastePluginAction.this.getPlugin();
                    if (dstPlugin != null && dstPlugin instanceof IFolderPlugin) {
                        if (MgmtConsole.getMgmtConsole().isClipboardDataFlavorSupported(MgmtConsole.configFlavor)) {
                            PastePluginAction.pasteConfigElement(dstPlugin, convert);
                        } else if (MgmtConsole.getMgmtConsole().isClipboardDataFlavorSupported(MgmtConsole.fileFlavor)) {
                            PastePluginAction.this.pasteFileElement(dstPlugin, convert);
                        }
                    }
                }
                finally {
                    wc.release();
                }
            }
        });
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void pasteConfigElement(IPlugin parentPlugin, boolean convert) {
        IConfigPlugin childPlugin = (IConfigPlugin)MgmtConsole.getMgmtConsole().getClipboardObject();
        boolean isCut = MgmtConsole.getMgmtConsole().getClipboardAction() == 0;
        IConfigServer server = null;
        try {
            IPluginContext context = parentPlugin.getPluginContext();
            IDirectoryFileSystemService ds = context.getConnectionInfo().getDirectoryService();
            server = context.getConfigContext().getConfigServer().connectTransacted();
            if (isCut) {
                String parentPath = parentPlugin.getPluginPath();
                StringBuffer sbPath = new StringBuffer(parentPath);
                if (!parentPath.endsWith("/")) {
                    sbPath.append("/");
                }
                sbPath.append(childPlugin.getPluginName());
                String newPath = sbPath.toString();
                if (server.pathExists(newPath)) {
                    throw new Exception("Configuration already exists!");
                }
                childPlugin.renamePlugin(server, newPath);
            } else {
                String newPath = PastePluginAction.getValidPath(server, parentPlugin.getPluginPath(), childPlugin.getPluginName(), PastePluginAction.getNameFormat(convert, childPlugin));
                Helper.logDebugMessage("PASTE as '" + newPath + "' (" + childPlugin.getPluginPath() + ")");
                childPlugin.copyPlugin(server, newPath, new Boolean(convert));
            }
            if (server.isTransacted()) {
                server.commit();
            }
            if (isCut) {
                MgmtConsole.getMgmtConsole().clearClipboard();
            }
        }
        catch (Exception e) {
            if (e instanceof UnsupportedOperationException) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, e.getMessage(), e, false);
            } else {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to paste configuration", e, true);
            }
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
            }
        }
    }

    public static String[] getNameFormat(boolean convert, IConfigPlugin plugin) {
        ConfigBeanModel model;
        String[] res = FORMAT_COPY;
        if (convert && (model = (ConfigBeanModel)plugin.getModel()).isTemplate()) {
            res = FORMAT_NEW_INSTANCE;
        }
        return res;
    }

    private void pasteFileElement(IPlugin parentPlugin, boolean convert) {
        IFilePlugin childPlugin = (IFilePlugin)MgmtConsole.getMgmtConsole().getClipboardObject();
        try {
            IConfigServer server = parentPlugin.getPluginContext().getConfigContext().getConfigServer();
            String newPath = PastePluginAction.getValidPath(server, parentPlugin.getPluginPath(), childPlugin.getPluginName(), FORMAT_COPY);
            this.duplicateFileElement(childPlugin, newPath);
            if (MgmtConsole.getMgmtConsole().getClipboardAction() == 0) {
                childPlugin.deletePlugin(this.getPlugin().getPluginContext().getConfigContext().getConfigServer());
                MgmtConsole.getMgmtConsole().clearClipboard();
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to paste file", e, true);
        }
    }

    private void duplicateFileElement(IFilePlugin pluginToPaste, String strNewPath) {
        String strTempFilename = null;
        try {
            File tmpBlob = null;
            if (pluginToPaste.hasContent()) {
                tmpBlob = File.createTempFile("sonicfs", null);
                tmpBlob.deleteOnExit();
                pluginToPaste.exportFile(tmpBlob);
            }
            ((ConfigFolderPlugin)this.getPlugin()).addFile(tmpBlob, this.getFilename(strNewPath), false);
            if (tmpBlob != null) {
                tmpBlob.delete();
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Unable to open file: " + strTempFilename != null ? strTempFilename : "", e, true);
        }
    }

    private String getFilename(String strPath) {
        String strResult = strPath;
        int index = strResult.lastIndexOf("/");
        if (index != -1) {
            strResult = strResult.substring(index + 1);
        }
        return strResult;
    }

    @Override
    public boolean canDisplay() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        String srcDomain;
        IPlugin dstPlugin = this.getPlugin();
        IPlugin srcPlugin = (IPlugin)MgmtConsole.getMgmtConsole().getClipboardObject();
        if (!(dstPlugin instanceof IFolderPlugin) || srcPlugin == null || dstPlugin == null) {
            return false;
        }
        String dstDomain = dstPlugin.getPluginContext().getConnectionInfo().getDomainName();
        return dstDomain.equals(srcDomain = srcPlugin.getPluginContext().getConnectionInfo().getDomainName());
    }

    public static final String getValidPath(IConfigServer server, String basePath, String name, String pattern) {
        return PastePluginAction.getValidPath(server, basePath, name, new String[]{pattern});
    }

    public static final String getValidPath(IConfigServer server, String basePath, String name, String[] pattern) {
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        int i = 0;
        while (true) {
            String p = i >= pattern.length ? pattern[pattern.length - 1] : pattern[i];
            String candidate = MessageFormat.format(p, name, new Integer(i)).trim();
            String newPath = basePath + candidate;
            if (!server.pathExists(newPath)) {
                return newPath;
            }
            ++i;
        }
    }
}

