/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.action;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.PastePluginAction;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.IConfigBean;
import java.awt.event.ActionEvent;
import java.util.HashMap;

public class PasteSpecialAction
extends PastePluginAction {
    public PasteSpecialAction(IPlugin plugin) {
        super(plugin, "edit.paste.special");
        Object obj;
        if (plugin != null && (obj = MgmtConsole.getMgmtConsole().getClipboardObject()) != null && obj instanceof IConfigPlugin) {
            if (((IConfigPlugin)obj).isTemplatePrototype()) {
                this.putNameValue("Paste as Configuration");
            } else {
                this.putNameValue("Paste as Template");
            }
        }
    }

    private void putNameValue(String value) {
        this.putValue("Name", value);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.paste(true);
    }

    @Override
    public boolean isEnabled() {
        boolean res = super.isEnabled();
        if (!res) {
            return res;
        }
        if (MgmtConsole.getMgmtConsole().getClipboardAction() == 0) {
            res = false;
        } else if (MgmtConsole.getMgmtConsole().isClipboardDataFlavorSupported(MgmtConsole.configFlavor)) {
            IConfigPlugin pastePlugin = (IConfigPlugin)MgmtConsole.getMgmtConsole().getClipboardObject();
            if (pastePlugin.isTemplatePrototype()) {
                res = true;
            } else if (pastePlugin.isTemplateInstance()) {
                res = false;
            } else {
                try {
                    HashMap attrs;
                    IConfigBean bean = (IConfigBean)((ConfigBeanModel)pastePlugin.getModel()).getData();
                    if (bean != null && (attrs = bean.getMetaAttributes()).containsKey("EXCLUDE_TEMPLATE_TYPE")) {
                        return false;
                    }
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
                res = pastePlugin.getAttributes().isTemplatable();
            }
        } else if (MgmtConsole.getMgmtConsole().isClipboardDataFlavorSupported(MgmtConsole.fileFlavor)) {
            res = false;
        }
        return res;
    }
}

