/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.action;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.upgrade.ConfigUpgrade;
import com.sonicsw.mf.common.config.upgrade.ConfigurationDependencies;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class UpgradePluginAction
extends BasicPluginAction {
    public UpgradePluginAction(IConfigPlugin plugin) {
        super(plugin, "upgrade.plugin");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            String name = this.getPlugin().getPluginPath();
            Vector dependencies = this.getDependencies(name);
            JDependenciesDialog dialog = new JDependenciesDialog(MgmtConsole.getMgmtConsole(), name, dependencies);
            dialog.setVisible(true);
            if (dialog.getCloseCommand() == 0) {
                this.upgrade(dependencies, dialog.getControlNumber());
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to upgrade configurations.", e, true);
        }
    }

    @Override
    public boolean isEnabled() {
        IPlugin plugin = this.getPlugin();
        PluginAttributes attrs = plugin.getAttributes();
        return ConfigUpgrade.isUpgradeSupported((String)attrs.getType(), (String)attrs.getProductVersion());
    }

    private void upgrade(final Vector dependencies, final String controlNumber) throws Exception {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
                try {
                    IDirectoryFileSystemService ds = UpgradePluginAction.this.getPlugin().getPluginContext().getConnectionInfo().getDirectoryService();
                    UpgradePluginAction.this.upgrade(dependencies, ds, controlNumber);
                    MgmtConsole.getMgmtConsole().notifyMessage(2, "Upgrade of configuration(s) complete.", true);
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to upgrade configuration(s) " + e.getMessage(), e, true);
                }
                finally {
                    wc.release();
                }
            }
        });
        t.start();
    }

    private void upgrade(Vector configs, IDirectoryFileSystemService ds, String controlNumber) throws Exception {
        Properties upgradeEnv = new Properties();
        upgradeEnv.put("sonic.mq.controlNumber", controlNumber);
        upgradeEnv.put("ds.domain", ds.getDomain());
        upgradeEnv.put("migrate.debug", new Boolean(System.getProperty("DebugAll.debug", "false").equals("true")));
        ConfigUpgrade configUpgrade = new ConfigUpgrade(ds, upgradeEnv);
        configUpgrade.upgradeConfigs(configs);
    }

    private Vector getDependencies(String path) throws Exception {
        IDirectoryFileSystemService ds = this.getPlugin().getPluginContext().getConnectionInfo().getDirectoryService();
        ConfigurationDependencies cd = new ConfigurationDependencies(ds);
        HashMap containerComponentMap = cd.findConfigDependencies(path);
        Vector<String> configNames = new Vector<String>();
        Iterator idsIterator = containerComponentMap.keySet().iterator();
        while (idsIterator.hasNext()) {
            configNames.add(((IElementIdentity)idsIterator.next()).getName());
        }
        return configNames;
    }

    class JDependenciesDialog
    extends JMADialog {
        private String m_name;
        private Vector m_dependencies;
        private JTextField m_controlNumber;

        public JDependenciesDialog(JMAFrame parent, String name, Vector dependencies) {
            super(parent, "upgrade.dependencies");
            this.m_controlNumber = new JTextField("");
            this.m_name = name;
            this.m_dependencies = dependencies;
        }

        @Override
        public void maInitialize() {
            JTextArea textArea = new JTextArea(8, 32);
            this.filterNames(textArea);
            textArea.setBackground(UIManager.getColor("Panel.background"));
            textArea.setEditable(false);
            JPartitionPanel msgPanel = new JPartitionPanel(false, "p", "", 5, 5, 5);
            msgPanel.add(new JLabel("Upgrade the configuration for:"));
            msgPanel.add(new JLabel("'" + this.m_name + "'?"));
            JPartitionPanel dependPanel = new JPartitionPanel(true, "p,r", "", 5, 5, 5);
            dependPanel.add(new JLabel("The following configurations will be upgraded:"));
            dependPanel.add(new ExtendedJScrollPane(textArea));
            JPartitionPanel controlPanel = new JPartitionPanel(true, "p,p", "", 5, 5, 5);
            controlPanel.add(new JLabel(Helper.toHtml("If a licensed configuration (Broker) will be upgraded, enter a control number for the new version")));
            controlPanel.add(this.m_controlNumber);
            JPartitionPanel topPanel = new JPartitionPanel(true, "p,r,r", null);
            topPanel.add(msgPanel);
            topPanel.add(dependPanel);
            topPanel.add(controlPanel);
            this.getContentPane().add(topPanel);
        }

        public String getControlNumber() {
            return this.m_controlNumber.getText();
        }

        @Override
        public void maCleanup() {
        }

        private void filterNames(JTextArea list) {
            for (int i = 0; i < this.m_dependencies.size(); ++i) {
                String name = (String)this.m_dependencies.get(i);
                if (name.endsWith("_Default")) {
                    name = name.substring(0, name.lastIndexOf(47));
                }
                list.append(name + "\n");
            }
        }
    }
}

