/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.JWorkspacePanel;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.AnnotationPluginAction;
import com.sonicsw.ma.gui.action.CopyPluginAction;
import com.sonicsw.ma.gui.action.CutPluginAction;
import com.sonicsw.ma.gui.action.DeletePluginAction;
import com.sonicsw.ma.gui.action.ExportPluginAction;
import com.sonicsw.ma.gui.action.GoToInstanceAction;
import com.sonicsw.ma.gui.action.GoToTemplateAction;
import com.sonicsw.ma.gui.action.PastePluginAction;
import com.sonicsw.ma.gui.action.PasteSpecialAction;
import com.sonicsw.ma.gui.action.PropSheetAction;
import com.sonicsw.ma.gui.action.RefreshPluginAction;
import com.sonicsw.ma.gui.action.RenamePluginAction;
import com.sonicsw.ma.gui.action.UpgradePluginAction;
import com.sonicsw.ma.gui.config.AbstractConfigFolderElementPlugin;
import com.sonicsw.ma.gui.config.revert.RevertAction;
import com.sonicsw.ma.gui.domain.AgentManagerConnection;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IAnnotationProvider;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IConfigPluginFactory;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mf.common.runtime.IIdentity;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.ConfigServiceRuntimeException;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IConfigType;
import com.sonicsw.mx.config.util.ConfigHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;

public abstract class AbstractConfigPlugin
extends AbstractGUIPlugin
implements IConfigPlugin {
    protected ConfigBeanModel m_model = null;

    public AbstractConfigPlugin(IPluginContext context, String name, Map metaMap) {
        super(context, name);
        this.setAttributes();
        this.getAttributes().put(metaMap);
    }

    private void setAttributes() {
        this.setAttributes(new PluginAttributes());
    }

    @Override
    protected JWorkspacePanel getWorkspacePanel() {
        return this.getPluginContext().getWorkspace().getWorkspacePanel("Configure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Helper.logDebugMessage("refresh config plugin - " + this.getClass().getName());
        JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
        try {
            Object objModel = this.getModel();
            if (objModel instanceof ConfigBeanModel && ((ConfigBeanModel)objModel).getData() instanceof IConfigBean) {
                IConfigBean bean = (IConfigBean)((ConfigBeanModel)objModel).getData();
                bean.refresh();
            }
            super.refresh();
        }
        catch (ConfigServiceException cse) {
            Helper.logWarningMessage(cse.getMessage());
            MgmtConsole.getMgmtConsole().notifyMessage(64, cse.getMessage(), cse, false);
        }
        finally {
            wc.release();
        }
    }

    @Override
    public boolean isTemplatePrototype() {
        String tType;
        boolean bTemplatePrototype = false;
        if (this.getAttributes().containsKey("TEMPLATE_TYPE") && (tType = (String)this.getAttributes().get("TEMPLATE_TYPE")).equals("prototype")) {
            bTemplatePrototype = true;
        }
        return bTemplatePrototype;
    }

    @Override
    public boolean isTemplateInstance() {
        String tType;
        boolean bTemplateInstance = false;
        if (this.getAttributes().containsKey("TEMPLATE_TYPE") && (tType = (String)this.getAttributes().get("TEMPLATE_TYPE")).equals("instance")) {
            bTemplateInstance = true;
        }
        return bTemplateInstance;
    }

    @Override
    public BasicAction getDefaultAction() {
        Action action;
        JComponent[] c = this.getPropertiesMenuItems();
        if (c != null && c.length > 0 && c[c.length - 1] instanceof AbstractButton && (action = ((AbstractButton)c[c.length - 1]).getAction()) instanceof BasicAction) {
            return (BasicAction)action;
        }
        return null;
    }

    @Override
    public List getToolTipList() {
        List list = super.getToolTipList();
        if (this.isTemplatePrototype()) {
            list.add(this.formatToolTipText("Template", "yes"));
        } else if (this.isTemplateInstance()) {
            String template = "COULD NOT DETERMINE";
            try {
                ConfigBeanModel model = (ConfigBeanModel)this.getModel();
                IConfigPrototype prototype = ((IConfigBean)model.getData()).getPrototype();
                if (prototype == null) {
                    template = "na";
                } else {
                    String name = prototype.getName();
                    if (name.endsWith("_Default")) {
                        name = name.substring(0, name.lastIndexOf("_Default") - 1);
                    }
                    template = name;
                }
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Unable to determine template linkage", e, false);
            }
            list.add(this.formatToolTipText("Linked to template", template));
        }
        return list;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_model = null;
    }

    protected HashMap createModelMetaAttributes(boolean isTemplate, boolean isInstance) {
        HashMap<String, String> map = new HashMap<String, String>();
        PluginAttributes attributes = this.getAttributes();
        map.put("TYPE", attributes.getType());
        map.put("PRODUCT_VERSION", attributes.getProductVersion());
        map.put("CONFIG_VERSION", attributes.getConfigVersion());
        if (isTemplate) {
            map.put("TEMPLATE_TYPE", "prototype");
        } else if (isInstance) {
            map.put("TEMPLATE_TYPE", "instance");
        }
        return map;
    }

    @Override
    public Object createModel(IConfigServer server, boolean isTemplate) {
        if (this.m_model != null) {
            return this.m_model;
        }
        IConfigBean bean = null;
        try {
            Helper.logDebugMessage("createModel(" + this._getPluginPath() + ")");
            bean = server.createConfigBean(this._getPluginPath(), this.getAttributes().getType(), this.getAttributes().getConfigVersion(), isTemplate);
            HashMap metaMap = this.createModelMetaAttributes(isTemplate, false);
            if (metaMap != null && !metaMap.isEmpty()) {
                Helper.logDebugMessage("Setting meta attributes on configuration: " + bean.getName());
                bean.setMetaAttributes(metaMap);
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to create model: " + this._getPluginPath(), e, false);
        }
        if (bean != null) {
            this.m_model = new ConfigBeanModel(bean, this.getPluginName());
        }
        return this.m_model;
    }

    @Override
    public Object getModel() {
        if (this.m_model != null) {
            return this.m_model;
        }
        IConfigBean bean = null;
        try {
            Helper.logDebugMessage("getModel(" + this._getPluginPath() + ")");
            IConfigServer server = this.getPluginContext().getConfigContext().getConfigServer();
            String path = this._getPluginPath();
            bean = (IConfigBean)server.loadConfigElement(path);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to load model: " + this.getPath(), e, false);
        }
        if (bean != null) {
            this.m_model = new ConfigBeanModel(bean, this.getPluginName());
        }
        return this.m_model;
    }

    protected IConfigType getModelMetaData() {
        IConfigType res = null;
        PluginAttributes attributes = this.getAttributes();
        String type = attributes.getType();
        if (type != null) {
            Helper.logDebugMessage("getModelMetaData(" + attributes.getType() + ")");
            try {
                IConfigServer server = this.getPluginContext().getConfigContext().getConfigServer();
                String version = attributes.getConfigVersion();
                res = server.loadConfigType(type, version);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to load meta data: " + attributes.getType(), e, false);
            }
        }
        return res;
    }

    protected JComponent getEditCutMenuItem() {
        return new JBasicMenuItem(new CutPluginAction(this));
    }

    protected JComponent getEditCopyMenuItem() {
        return new JBasicMenuItem(new CopyPluginAction(this));
    }

    protected JComponent getEditPasteMenuItem() {
        return new JBasicMenuItem(new PastePluginAction(this));
    }

    protected JComponent getEditPasteSpecialMenuItem() {
        return new JBasicMenuItem(new PasteSpecialAction(this));
    }

    protected JComponent getEditRevertMenuItem() {
        return new JBasicMenuItem(new RevertAction(this));
    }

    @Override
    protected JComponent[] getPropertiesMenuItems() {
        return new JComponent[]{new JBasicMenuItem(new PropSheetAction(this))};
    }

    @Override
    protected JComponent[] getEditMenuItems() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        JComponent c = null;
        c = this.getEditCutMenuItem();
        if (c != null) {
            list.add(c);
        }
        if ((c = this.getEditCopyMenuItem()) != null) {
            list.add(c);
        }
        if ((c = this.getEditPasteMenuItem()) != null) {
            list.add(c);
        }
        if ((c = this.getEditPasteSpecialMenuItem()) != null) {
            list.add(c);
        }
        if ((c = this.getEditRevertMenuItem()) != null) {
            list.add(c);
        }
        return list.toArray(new JComponent[list.size()]);
    }

    @Override
    protected JComponent[] getSystemMenuItems() {
        ArrayList<JBasicMenuItem> list = new ArrayList<JBasicMenuItem>();
        list.add(new JBasicMenuItem(new DeletePluginAction(this)));
        list.add(new JBasicMenuItem(new RenamePluginAction(this)));
        list.add(new JBasicMenuItem(new ExportPluginAction(this)));
        list.add(new JBasicMenuItem(new UpgradePluginAction(this)));
        return list.toArray(new JComponent[0]);
    }

    @Override
    protected JComponent[] getViewMenuItems() {
        ArrayList<JBasicMenuItem> list = new ArrayList<JBasicMenuItem>();
        list.add(new JBasicMenuItem(new RefreshPluginAction(this)));
        String type = this.getAttributes().getType();
        String cVersion = this.getAttributes().getConfigVersion();
        String pVersion = this.getAttributes().getProductVersion();
        IConfigPluginFactory factory = this.getPluginContext().getConfigContext().getPluginFactory(type, cVersion, pVersion);
        boolean isTemplate = this.isTemplatePrototype();
        boolean isTemplateInstance = this.isTemplateInstance();
        if (factory != null && (factory.getAttributes().isCreatable() || factory.getAttributes().isComponent())) {
            if (!isTemplate) {
                list.add(new JBasicMenuItem(new GoToInstanceAction(this)));
            }
            if (isTemplateInstance) {
                list.add(new JBasicMenuItem(new GoToTemplateAction(this)));
            }
        }
        if (!isTemplateInstance && !isTemplate) {
            this.addAnnotationMenu(list);
        }
        return list.toArray(new JComponent[list.size()]);
    }

    protected void addAnnotationMenu(List list) {
        String type = this.getAttributes().getType();
        String cVersion = this.getAttributes().getConfigVersion();
        String pVersion = this.getAttributes().getProductVersion();
        IAnnotationProvider provider = this.getPluginContext().getLibrary().getAnnotationProvider(type, cVersion, pVersion);
        if (null != provider) {
            list.add(new JBasicMenuItem(new AnnotationPluginAction(this)));
        }
    }

    public void goToInstance() {
        IIdentity[] runtimeIDs;
        AgentManagerConnection amc = this.getPluginContext().getConnectionInfo().getAgentManagerConnection();
        String path = this.getPluginPath();
        if (this instanceof AbstractConfigFolderElementPlugin) {
            path = ((AbstractConfigFolderElementPlugin)this)._getPluginPath();
        }
        if ((runtimeIDs = amc.getActiveComponentIdentitiesByConfigID(path)).length > 0) {
            IIdentity identity = runtimeIDs[0];
            String containerRuntimeID = identity.getDomainName() + "." + identity.getContainerName();
            String containerPath = amc.runtimeIDToConfigName(containerRuntimeID);
            this.getPluginContext().getWorkspace().goToInstance(containerPath, identity.getCanonicalName(), false);
        } else {
            this.getPluginContext().getMgmtConsole().notifyMessage(4, "There are no active instances of configuration " + this.getPluginName(), true);
        }
    }

    @Override
    public void goToTemplate() {
        IConfigPrototype prototype = ((IConfigBean)((ConfigBeanModel)this.getModel()).getData()).getPrototype();
        if (prototype != null) {
            String path = prototype.getName();
            if (path.endsWith("_Default") || path.endsWith("_MFDomainDescriptor") || path.endsWith("_MQPolicyDescriptor")) {
                path = path.substring(0, path.lastIndexOf(47));
            }
            this.getPluginContext().getWorkspace().goToConfiguration(path, true);
        } else {
            this.getPluginContext().getMgmtConsole().notifyMessage(4, "Template name isn't valid", true);
        }
    }

    @Override
    public void onRenamed(String newName) {
        super.onRenamed(newName);
        this.m_model = null;
    }

    protected void buildModelInternalDefaults(IConfigBean beanModel) {
    }

    @Override
    public void renamePlugin(IConfigServer configServer, String newPath) throws Exception {
        if (this._getPluginPath().trim().equals(newPath.trim())) {
            throw new Exception("Can't rename - new path is same as old path");
        }
        configServer.rename(this._getPluginPath(), newPath);
    }

    @Override
    public void deletePlugin(IConfigServer configServer) throws Exception {
        configServer.removeConfigElement(this._getPluginPath());
    }

    @Override
    public void copyPlugin(IConfigServer server, String path, Object copyData) throws Exception {
        IConfigBean bean = (IConfigBean)server.loadConfigElement(this._getPluginPath());
        if (bean == null) {
            throw new Exception("Failed to copy plugin - no configuration data available");
        }
        IConfigBean copyBean = null;
        boolean convert = copyData != null && copyData.equals(Boolean.TRUE);
        Helper.logDebugMessage("copying Element '" + path + "'");
        if (convert) {
            copyBean = bean instanceof IConfigPrototype ? (IConfigBean)((IConfigPrototype)bean).newInstance(path) : (IConfigBean)bean.createPrototype(path);
        } else if (bean.isPrototypeInstance()) {
            copyBean = (IConfigBean)bean.clonePrototypeInstance(path);
        } else {
            copyBean = (IConfigBean)bean.clone();
            copyBean.setName(path);
        }
        if (copyBean != null) {
            copyBean.setMetaAttributes((HashMap)this.convertMetaAttributes(bean.getMetaAttributes(), convert));
            server.storeConfigElement((IConfigElement)copyBean);
        }
    }

    protected Map convertMetaAttributes(Map metaMap, boolean convert) {
        if (convert) {
            String templateType = (String)metaMap.get("TEMPLATE_TYPE");
            if (templateType == null) {
                metaMap.put("TEMPLATE_TYPE", "prototype");
            } else if (templateType.equals("prototype")) {
                metaMap.put("TEMPLATE_TYPE", "instance");
            }
        }
        return metaMap;
    }

    @Override
    public boolean isDragSupported(int dropAction) {
        return false;
    }

    @Override
    public boolean isDropSupported(int dropAction) {
        return false;
    }

    @Override
    public void drop(IConfigPlugin dropPlugin, int dropAction) {
        Helper.logDebugMessage("Drop '" + dropPlugin + "' into '" + this + "' (" + dropAction + ") - not handled");
    }

    protected void cloneBean(boolean convert, CloneMapper[] map, IAttributeMap oData, IAttributeMap cData) {
        this.cloneBean(new HashMap(), convert, map, oData, cData);
    }

    protected void cloneBean(boolean convert, CloneMapper[] map, IAttributeList oData, IAttributeList cData) {
        this.cloneBean(new HashMap(), convert, map, oData, cData);
    }

    private void cloneBean(HashMap handled, boolean convert, CloneMapper[] map, IAttributeMap oData, IAttributeMap cData) {
        Iterator i = oData.keySet().iterator();
        while (i.hasNext()) {
            boolean alreadyHandled = false;
            String attributeName = (String)i.next();
            Object oObj = this.getAttribute(oData, attributeName);
            Object cObj = this.getAttribute(cData, attributeName);
            if (oObj == null || cObj == null) continue;
            if (oObj instanceof IConfigBean) {
                try {
                    String beanName = ((IConfigBean)oObj).getName();
                    IConfigBean beanValue = (IConfigBean)handled.get(beanName);
                    if (beanValue == null) {
                        beanValue = this.createCloneElement(convert, map, (IConfigBean)oObj);
                        if (beanValue != cObj) {
                            cObj = beanValue;
                            cData.setAttribute(attributeName, (Object)beanValue);
                            Helper.logDebugMessage("clone attribute map entry '" + attributeName + "' bean = '" + beanName + "' type=" + (oObj instanceof IConfigPrototype ? "template" : "instance") + " convert=" + convert);
                        } else {
                            alreadyHandled = true;
                        }
                        handled.put(beanName, cObj);
                    } else {
                        alreadyHandled = true;
                        if (beanValue != cObj) {
                            cData.setAttribute(attributeName, (Object)beanValue);
                        }
                    }
                }
                catch (Exception e) {
                    Helper.logWarningMessage("Failed to create clone for sub bean - " + e.getMessage());
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
            }
            if (alreadyHandled) continue;
            if (oObj instanceof IAttributeMap) {
                this.cloneBean(handled, convert, map, (IAttributeMap)oObj, (IAttributeMap)cObj);
                continue;
            }
            if (!(oObj instanceof IAttributeList)) continue;
            this.cloneBean(handled, convert, map, (IAttributeList)oObj, (IAttributeList)cObj);
        }
    }

    private void cloneBean(HashMap handled, boolean convert, CloneMapper[] map, IAttributeList oData, IAttributeList cData) {
        for (int i = 0; i < oData.size(); ++i) {
            boolean alreadyHandled = false;
            Integer key = new Integer(i);
            Object oObj = this.getAttribute(oData, key);
            Object cObj = this.getAttribute(cData, key);
            if (oObj == null || cObj == null) continue;
            if (oObj instanceof IConfigBean) {
                try {
                    String beanName = ((IConfigBean)oObj).getName();
                    IConfigBean beanValue = (IConfigBean)handled.get(beanName);
                    if (beanValue == null) {
                        beanValue = this.createCloneElement(convert, map, (IConfigBean)oObj);
                        if (beanValue != cObj) {
                            cObj = beanValue;
                            cData.set(i, (Object)beanValue);
                            Helper.logDebugMessage("clone attribute list item '" + key + "' bean = '" + beanName + "' type=" + (oObj instanceof IConfigPrototype ? "template" : "instance") + " convert=" + convert);
                        } else {
                            alreadyHandled = true;
                        }
                        handled.put(beanName, beanValue);
                    } else {
                        alreadyHandled = true;
                        if (beanValue != cObj) {
                            cData.set(i, (Object)beanValue);
                        }
                    }
                }
                catch (Exception e) {
                    Helper.logWarningMessage("Failed to create clone for sub bean - " + e.getMessage());
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
            }
            if (alreadyHandled) continue;
            if (oObj instanceof IAttributeMap) {
                this.cloneBean(handled, convert, map, (IAttributeMap)oObj, (IAttributeMap)cObj);
                continue;
            }
            if (!(oObj instanceof IAttributeList)) continue;
            this.cloneBean(handled, convert, map, (IAttributeList)oObj, (IAttributeList)cObj);
        }
    }

    private Object getAttribute(Object attribute, Object key) {
        Object res = null;
        try {
            if (attribute instanceof IAttributeList) {
                res = ((IAttributeList)attribute).getAttribute(((Integer)key).intValue());
            } else if (attribute instanceof IAttributeMap) {
                res = ((IAttributeMap)attribute).getAttribute(key.toString());
            } else if (attribute == null) {
                Helper.logDebugMessage("getAttribute(" + key + ") with null attribute!!!");
            }
        }
        catch (ConfigServiceRuntimeException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return res;
    }

    protected IConfigBean createCloneElement(boolean convert, CloneMapper[] map, IConfigBean oObj) throws Exception {
        IConfigBean cObj = oObj;
        CloneMapper mapper = this.findCloneMapper(map, oObj);
        String newName = this.generateNameFromOldName(mapper, oObj);
        if (newName != null) {
            cObj = convert ? (oObj instanceof IConfigPrototype ? ConfigHelper.createInstanceBean((IConfigPrototype)((IConfigPrototype)oObj), (String)newName) : ConfigHelper.createPrototypeBean((IConfigBean)oObj, (String)newName)) : ConfigHelper.copyBean((IConfigBean)oObj, (String)newName);
            if (mapper.isAttributesOnParent()) {
                HashMap metaMap = cObj.getMetaAttributes();
                String parentPath = newName.substring(0, newName.lastIndexOf(47));
                cObj.getConfigServer().setMetaAttributes(parentPath, (Map)metaMap);
            }
        }
        return cObj;
    }

    private CloneMapper findCloneMapper(CloneMapper[] map, IConfigBean bean) {
        String beanPath = bean.getName();
        for (int i = 0; i < map.length; ++i) {
            if (!beanPath.startsWith(map[i].getOldPath())) continue;
            if (map[i].getType() != null) {
                if (!bean.getConfigType().getName().equals(map[i].getType())) continue;
                return map[i];
            }
            return map[i];
        }
        return null;
    }

    private String generateNameFromOldName(CloneMapper map, IConfigBean bean) {
        String beanPath = bean.getName();
        if (map == null) {
            return null;
        }
        return map.getNewPath() + "/" + beanPath.substring(beanPath.lastIndexOf(47) + 1);
    }

    protected IConfigBean[] getReferencedBeans(IConfigServer server, IAttributeMap data) {
        List list = this.getReferencedBeanList(new ArrayList(), data);
        for (int i = 0; i < list.size(); ++i) {
            String beanPath = (String)list.get(i);
            try {
                list.set(i, server.loadConfigElement(beanPath));
                continue;
            }
            catch (ConfigServiceException e) {
                Helper.logDebugMessage("Failed to getReferencedBeans: " + e.getMessage());
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                list.set(i, null);
            }
        }
        return list.toArray(new IConfigBean[list.size()]);
    }

    protected List getReferencedBeanList(List list, IAttributeMap data) {
        Iterator iter = data.keySet().iterator();
        while (iter.hasNext()) {
            String name;
            Object obj = data.get((Object)((String)iter.next()));
            if (obj instanceof IConfigBean && !list.contains(name = ((IConfigBean)obj).getName())) {
                list.add(name);
            }
            if (obj instanceof IAttributeMap) {
                this.getReferencedBeanList(list, (IAttributeMap)obj);
                continue;
            }
            if (!(obj instanceof IAttributeList)) continue;
            this.getReferencedBeanList(list, (IAttributeList)obj);
        }
        return list;
    }

    protected List getReferencedBeanList(List list, IAttributeList data) {
        for (Object obj : data) {
            String name;
            if (obj instanceof IConfigBean && !list.contains(name = ((IConfigBean)obj).getName())) {
                list.add(name);
            }
            if (obj instanceof IAttributeMap) {
                this.getReferencedBeanList(list, (IAttributeMap)obj);
                continue;
            }
            if (!(obj instanceof IAttributeList)) continue;
            this.getReferencedBeanList(list, (IAttributeList)obj);
        }
        return list;
    }

    public class CloneMapper {
        private String m_oldPath;
        private String m_newPath;
        private String m_type;
        private boolean m_attr;

        public CloneMapper(String oldPath, String newPath) {
            this(oldPath, newPath, null, false);
        }

        public CloneMapper(String oldPath, String newPath, String type, boolean metaAttributesOnFolder) {
            this.m_oldPath = oldPath;
            this.m_newPath = newPath;
            this.m_type = type;
            this.m_attr = metaAttributesOnFolder;
            Helper.logDebugMessage("CloneMapper: " + this.m_oldPath + " > " + this.m_newPath);
        }

        public String getOldPath() {
            return this.m_oldPath;
        }

        public String getNewPath() {
            return this.m_newPath;
        }

        public String getType() {
            return this.m_type;
        }

        public boolean isAttributesOnParent() {
            return this.m_attr;
        }

        public String toString() {
            return new StringBuffer(this.getClass().getName()).append(" {old=").append(this.m_oldPath).append(", new=").append(this.m_newPath).append(", type=").append(this.m_type).append("}").toString();
        }
    }
}

