/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.JRowTableAspectAdapter;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPluginFactory;
import com.sonicsw.ma.plugin.PluginAttributes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import modelobjects.framework.EditRule;
import modelobjects.framework.IntToStringConverter;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

public class AbstractDomainFolderDialog
extends JPropSheetTabbedDialog {
    protected JRowTable m_table;
    protected JTextField m_path = new JTextField();
    protected JTextField m_type = new JTextField();
    protected JCheckBox m_system = new JCheckBox();
    protected JTextField m_connection = new JTextField();
    protected JTextField m_domainName = new JTextField();
    protected JTextField m_url = new JTextField();
    protected JTextField m_user = new JTextField();
    protected JTextField m_timeout = new JTextField();
    protected JTextField m_node = new JTextField();
    protected JCheckBox m_useNode = new JCheckBox();
    protected JCheckBox m_loadBalancing = new JCheckBox();

    public AbstractDomainFolderDialog(JMAFrame parent, Class modelClass) {
        this(parent, "domain", modelClass);
    }

    public AbstractDomainFolderDialog(JMAFrame parent, String name, Class modelClass) {
        super(parent, name, modelClass);
    }

    @Override
    public Action[] getButtonActions() {
        return new Action[]{new CloseAction((Action)this.getDefaultCancelAction())};
    }

    @Override
    public void initUI() throws Exception {
        String generalTab = ResourceManager.getString(this.getClass(), "dialog.domain.tab.general.label");
        String pluginsTab = ResourceManager.getString(this.getClass(), "dialog.domain.tab.plugins.label");
        String advancedTab = ResourceManager.getString(this.getClass(), "dialog.domain.tab.advanced.label");
        this.addTabPanel(generalTab, JPartitionPanel.wrap(this.createGeneralPanel()));
        this.addTabPanel(pluginsTab, this.createPluginPanel());
        this.contributeToUI();
        this.addTabPanel(advancedTab, JPartitionPanel.wrap(this.createAdvancedPanel()));
    }

    private JPanel createAdvancedPanel() {
        String paramGroup = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.group.parameters.label");
        String routeGroup = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.group.manage.label");
        String timeout = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.timeout.label");
        String useNode = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.use_node.label");
        String node = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.node.label");
        String loadBalancing = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.load_balancing.label");
        JPartitionPanel panel = new JPartitionPanel(true, "p,p,r", null, 0, 0, 0);
        String unitSec = ResourceManager.getString(this.getClass(), new Object[]{"unit", "seconds"});
        JPartitionPanel panel1 = new JPartitionPanel(paramGroup);
        panel1.addRow(timeout, (JComponent)this.m_timeout, unitSec);
        panel1.addRow(loadBalancing, (JComponent)this.m_loadBalancing);
        JPartitionPanel panel2 = new JPartitionPanel(routeGroup);
        panel2.addRow(useNode, (JComponent)this.m_useNode);
        panel2.addRow(node, (JComponent)this.m_node);
        panel.add(panel1);
        panel.add(panel2);
        return panel;
    }

    protected void contributeToUI() {
    }

    @Override
    public void initForm() throws Exception {
        new JTextFieldAdapter(ModelAspectId.forName("path"), this.m_path, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("type"), this.m_type, EditRule.NEVER, null, this.getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("system"), this.m_system, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("connectionName"), this.m_connection, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("domainName"), this.m_domainName, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("url"), this.m_url, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("userName"), this.m_user, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("timeout"), this.m_timeout, EditRule.NEVER, new IntToStringConverter(), this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("managementNode"), this.m_node, EditRule.NEVER, null, this.getMediator());
        new JTableListAdapter(ModelAspectId.forName("pluginFactories"), this.m_table, this.getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("usingManagement"), this.m_useNode, EditRule.NEVER, null, this.getMediator(), false);
        new JCheckBoxAdapter(ModelAspectId.forName("loadBalancing"), this.m_loadBalancing, EditRule.NEVER, null, this.getMediator(), false);
    }

    @Override
    protected void maCleanup() {
        super.maCleanup();
        if (this.m_table != null) {
            this.m_table.cleanup();
        }
    }

    protected JPanel createGeneralPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        JPartitionPanel panelTop = new JPartitionPanel(false, "p,r", "");
        panelTop.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.path.label"), (JComponent)this.m_path);
        panelTop.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.type.label"), (JComponent)this.m_type);
        panelTop.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.system.label"), (JComponent)this.m_system);
        panel.add((Component)panelTop, "Center");
        JPartitionPanel panelBottom = new JPartitionPanel(false, "p,r", ResourceManager.getString(this.getClass(), "dialog.domain.general.parameters.label"));
        panelBottom.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.general.connection_name.label"), (JComponent)this.m_connection);
        panelBottom.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.general.domain_name.label"), (JComponent)this.m_domainName);
        panelBottom.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.general.connection_url.label"), (JComponent)this.m_url);
        panelBottom.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.general.user_name.label"), (JComponent)this.m_user);
        panel.add((Component)panelBottom, "South");
        return panel;
    }

    private JPanel createPluginPanel() {
        String name = ResourceManager.getString(this.getClass(), "dialog.domain.plugin.table.column.name.label");
        String vProduct = ResourceManager.getString(this.getClass(), "dialog.domain.plugin.table.column.product_version.label");
        String vConfig = ResourceManager.getString(this.getClass(), "dialog.domain.plugin.table.column.config_version.label");
        String revision = ResourceManager.getString(this.getClass(), "dialog.domain.plugin.table.column.revision.label");
        JPartitionPanel outerPanel = new JPartitionPanel(false, "r", null);
        TableColumn[] COLUMNS = new TableColumn[]{new StringTableColumn(0, name, 0, 40), new StringTableColumn(1, vProduct, 1, 20), new StringTableColumn(2, vConfig, 2, 20), new StringTableColumn(3, revision, 3, 20)};
        this.m_table = new JRowTable(COLUMNS, this.getClass().getName());
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.m_table);
        outerPanel.add(scrollPane);
        return outerPanel;
    }

    @Override
    protected boolean canClose() {
        return true;
    }

    class JTableListAdapter
    extends JRowTableAspectAdapter {
        public JTableListAdapter(ModelAspectId modelAspectId, JRowTable table, ModelEditMediator modelEditMediator) {
            super(modelAspectId, table, null, EditRule.NEVER, modelEditMediator);
        }

        @Override
        protected void setViewAspectValue(Object viewAspectValue) throws IllegalArgumentException {
            ((IModelTableModel)this.table.getModel()).setContents((List)viewAspectValue);
        }
    }

    class StringTableColumn
    extends RowTableColumn {
        public static final int NAME_COLUMN_HEADING = 0;
        public static final int PRODUCT_VERSION_COLUMN_HEADING = 1;
        public static final int CONFIG_VERSION_COLUMN_HEADING = 2;
        public static final int REVISION_COLUMN_HEADING = 3;
        protected int m_index;

        public StringTableColumn(int modelIndex, String name, int id, int width) {
            super(modelIndex, name, width);
            this.m_index = id;
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            String value = "";
            if (rowModel != null) {
                if (!(rowModel instanceof IPluginFactory)) {
                    return value;
                }
                PluginAttributes attributes = ((IPluginFactory)rowModel).getAttributes();
                switch (this.m_index) {
                    case 0: {
                        value = attributes.getDisplayType();
                        break;
                    }
                    case 1: {
                        value = attributes.getProductVersionsString();
                        break;
                    }
                    case 2: {
                        value = attributes.getConfigVersion();
                        break;
                    }
                    case 3: {
                        value = attributes.getPluginRevision();
                    }
                }
            }
            return value;
        }
    }

    public class CloseAction
    extends BasicGuiAction {
        public CloseAction(Action targetAction) {
            this("dialog.close", targetAction);
        }

        public CloseAction(String name, Action targetAction) {
            super(name, targetAction);
        }
    }
}

