/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.JLightConfigTree;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.mx.config.IConfigServer;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ComponentChooserDialog
extends JPropSheetDialog {
    private JLightConfigTree m_tree;
    private IPluginFilter m_filter;
    private boolean m_multiSelect;
    private IConfigServer m_server;
    private IPluginContext m_context;
    private JPanel m_generalPanel;

    public ComponentChooserDialog(JPropSheetDialog parent, String name, IPluginContext context, IConfigServer server, IPluginFilter filter, boolean multiSelect) {
        super(parent, name, HashMap.class);
        this.m_context = context;
        this.m_server = server;
        this.m_filter = filter;
        this.m_multiSelect = multiSelect;
    }

    public ComponentChooserDialog(JMAFrame parent, String name, IPluginContext context, IConfigServer server, IPluginFilter filter, boolean multiSelect) {
        super(parent, name, HashMap.class);
        this.m_context = context;
        this.m_server = server;
        this.m_filter = filter;
        this.m_multiSelect = multiSelect;
    }

    @Override
    public void maCleanup() {
        super.maCleanup();
        this.m_context = null;
        this.m_tree = null;
        this.m_filter = null;
        this.m_server = null;
    }

    @Override
    public void initUI() throws Exception {
        this.m_generalPanel = this.makeGeneralPanel();
        this.getContentPane().add(this.m_generalPanel);
        this.updateState();
    }

    @Override
    public void initForm() throws Exception {
    }

    public JPanel getGeneralPanel() {
        return this.m_generalPanel;
    }

    public IPluginFilter getFilter() {
        return this.m_filter;
    }

    protected void updateTree() {
        this.m_tree.rebuildTree(this.m_server, this.m_filter);
    }

    private JPanel makeGeneralPanel() {
        this.m_tree = new JLightConfigTree(this.m_context, this.m_server, "/", this.m_filter);
        this.m_tree.setRootLabel("Domain");
        this.m_tree.setRootIcon(ResourceManager.getTypeIcon("ConfigDomain"));
        this.m_tree.expandRow(0);
        this.m_tree.getSelectionModel().setSelectionMode(this.m_multiSelect ? 4 : 1);
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                ComponentChooserDialog.this.updateState();
            }
        });
        this.m_tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    TreePath path = ComponentChooserDialog.this.m_tree.getPathForLocation(evt.getX(), evt.getY());
                    if (path == null || !((TreeNode)path.getLastPathComponent()).isLeaf()) {
                        return;
                    }
                    try {
                        JButtonPanel btnPanel = (JButtonPanel)ComponentChooserDialog.this.getButtonPanel();
                        String okCommand = (String)ComponentChooserDialog.this.getDefaultOKAction().getValue("ActionCommandKey");
                        btnPanel.getButton(okCommand).doClick();
                    }
                    catch (Exception e) {
                        MgmtConsole.displayMessage(4, "Error making the general panel.", e, true);
                    }
                }
            }
        });
        JPartitionPanel panel = new JPartitionPanel(true, "r,p", null);
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.m_tree);
        panel.add(scrollPane);
        return panel;
    }

    private void updateState() {
        TreePath[] path = this.m_tree.getSelectionPaths();
        String okCommand = (String)this.getDefaultOKAction().getValue("ActionCommandKey");
        JButton okBtn = ((JButtonPanel)this.getButtonPanel()).getButton(okCommand);
        Action okAction = okBtn.getAction();
        boolean state = true;
        if (path == null || path.length == 0) {
            state = false;
        } else if (path.length > 1 && !this.m_multiSelect) {
            state = false;
        } else {
            for (int i = 0; i < path.length; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path[i].getLastPathComponent();
                if (this.m_tree.isNodeTyped(node)) continue;
                state = false;
                break;
            }
        }
        okAction.setEnabled(state);
    }

    @Override
    public Action[] getButtonActions() {
        ArrayList<BasicAction> list = new ArrayList<BasicAction>();
        list.add(new AddAction((Action)this.getDefaultOKAction()));
        list.add(this.getDefaultCancelAction());
        return list.toArray(new Action[list.size()]);
    }

    class AddAction
    extends BasicGuiAction {
        public AddAction(Action target) {
            super(null, target);
            this.setCheckTargetValue(true);
        }

        private String convertTreeToViewPath(TreePath path) {
            StringBuffer sb = new StringBuffer();
            for (int j = 1; j < path.getPathCount(); ++j) {
                sb.append('/').append(path.getPathComponent(j).toString());
            }
            return sb.toString();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TreePath[] paths = ComponentChooserDialog.this.m_tree.getSelectionPaths();
            if (paths != null) {
                HashMap map = (HashMap)ComponentChooserDialog.this.getModel();
                for (int i = 0; i < paths.length; ++i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                    String type = (String)((HashMap)node.getUserObject()).get("TYPE");
                    String name = node.toString();
                    if (map.containsKey(name)) continue;
                    map.put(name, type);
                }
            }
            super.actionPerformed(evt);
        }
    }
}

