/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.AbstractConfigPlugin;
import com.sonicsw.ma.gui.config.metrics.model.MetricsModel;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.IConfigPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class ComponentPlugin
extends AbstractConfigPlugin {
    public static final IConfigPath CLASSNAME = ConfigFactory.createConfigPath((String)"CLASSNAME");
    public static final String TRACKID_TOOLS = "MANAGED_TOOLS_DIALOG";
    private MetricsModel m_metricsModel;

    public ComponentPlugin(IPluginContext context, String id, Map data) {
        super(context, id, data);
    }

    @Override
    public JPropSheetDialog getPropSheetDialog() {
        return null;
    }

    @Override
    public boolean expand() {
        return false;
    }

    @Override
    public String[] getAllSupportedMonitors() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.isMonitorSupported("_MetricsConfig")) {
            res.add("_MetricsConfig");
        }
        return res.toArray(new String[res.size()]);
    }

    @Override
    public boolean isMonitorSupported(String monitorId) {
        boolean res = false;
        if (monitorId != null && monitorId.equals("_MetricsConfig")) {
            String type = this.getAttributes().getType();
            String cVersion = this.getAttributes().getConfigVersion();
            String path = "/meta-inf/" + type + "/" + cVersion + "/metrics";
            res = this.getMetricInfo(path) != null;
        }
        return res;
    }

    @Override
    public Object getMonitorModel(String monitorId) {
        MetricsModel res = null;
        if (this.isMonitorSupported(monitorId) && monitorId.equals("_MetricsConfig")) {
            try {
                IRemoteMBeanServer server = this.getPluginContext().getRuntimeContext().getMBeanServer();
                String domainName = this.getPluginContext().getConnectionInfo().getDomainName();
                String type = this.getAttributes().getType();
                String cVersion = this.getAttributes().getConfigVersion();
                String path = "/meta-inf/" + type + "/" + cVersion + "/metrics";
                IMetricInfo[] info = this.getMetricInfo(path);
                this.m_metricsModel = new MetricsModel(server, new ObjectName(domainName + "." + this.getPluginName() + ":ID=AGENT"), info);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to get metrics info: " + e.getMessage(), e, false);
                this.m_metricsModel = null;
            }
            res = this.m_metricsModel;
        }
        return res;
    }

    public IMetricInfo[] getMetricInfo(String path) {
        IMetricInfo[] res = null;
        try {
            DirectoryServiceProxy directoryService = this.getDS();
            IDirElement element = directoryService.getElement(path, true);
            IAttributeSet attributes = element.getAttributes();
            Set keys = attributes.getAttributes().keySet();
            res = new IMetricInfo[keys.size()];
            Iterator iterator = keys.iterator();
            int ctr = 0;
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                AttributeSet attribSet = (AttributeSet)attributes.getAttribute(key);
                res[ctr++] = this.createMetricInfo(attribSet, key);
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return res;
    }

    private IMetricInfo createMetricInfo(AttributeSet attribSet, String key) {
        String ATTRIB_VALUE_TYPE = "VALUE_TYPE";
        String ATTRIB_DESCRIPTION = "DESCRIPTION";
        String ATTRIB_EXTENDED_DATA = "EXTENDED_DATA";
        String ATTRIB_INSTANCE_METRIC = "INSTANCE_METRIC";
        String ATTRIB_DYNAMIC = "DYNAMIC";
        String ATTRIB_SUPPORTS_HIGH_THRESHOLDS = "SUPPORTS_HIGH_THRESHOLDS";
        String ATTRIB_SUPPORTS_LOW_THRESHOLDS = "SUPPORTS_LOW_THRESHOLDS";
        String ATTRIB_UNITS = "";
        short valueType = 0;
        String description = "";
        String extData = "";
        boolean instanceMetric = false;
        boolean dynamic = false;
        boolean supportsHighThreshold = false;
        boolean supportsLowThreshold = false;
        String units = "";
        try {
            Object attribValueType = attribSet.getAttribute(ATTRIB_VALUE_TYPE);
            valueType = attribValueType instanceof Number ? ((Number)attribValueType).shortValue() : Short.parseShort((String)attribValueType);
        }
        catch (Exception e) {
            valueType = 0;
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        try {
            description = (String)attribSet.getAttribute(ATTRIB_DESCRIPTION);
        }
        catch (Exception e) {
            description = "";
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        try {
            extData = (String)attribSet.getAttribute(ATTRIB_EXTENDED_DATA);
        }
        catch (Exception e) {
            extData = "";
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        try {
            Object attribute = attribSet.getAttribute(ATTRIB_INSTANCE_METRIC);
            instanceMetric = (Boolean)attribute;
        }
        catch (Exception e) {
            instanceMetric = false;
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        try {
            dynamic = (Boolean)attribSet.getAttribute(ATTRIB_DYNAMIC);
        }
        catch (Exception e) {
            dynamic = false;
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        try {
            supportsHighThreshold = (Boolean)attribSet.getAttribute(ATTRIB_SUPPORTS_HIGH_THRESHOLDS);
        }
        catch (Exception e) {
            supportsHighThreshold = false;
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        try {
            supportsLowThreshold = (Boolean)attribSet.getAttribute(ATTRIB_SUPPORTS_LOW_THRESHOLDS);
        }
        catch (Exception e) {
            supportsLowThreshold = false;
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        try {
            units = (String)attribSet.getAttribute(ATTRIB_UNITS);
        }
        catch (Exception e) {
            units = "";
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        IMetricIdentity metricIdentity = MetricsFactory.createMetricIdentity((String)key);
        return MetricsFactory.createMetricInfo((IMetricIdentity)metricIdentity, (short)valueType, (String)description, (String)extData, (boolean)instanceMetric, (boolean)dynamic, (boolean)supportsHighThreshold, (boolean)supportsLowThreshold, (String)units);
    }

    private DirectoryServiceProxy getDS() throws MalformedObjectNameException {
        DomainConnectionModel connectionInfo = this.getPluginContext().getConnectionInfo();
        JMSConnectorClient server = (JMSConnectorClient)connectionInfo.getMBeanServer();
        String domain = connectionInfo.getDomainName();
        String dsName = domain + ".DIRECTORY SERVICE:ID=DIRECTORY SERVICE";
        DirectoryServiceProxy proxy = new DirectoryServiceProxy((IRemoteMBeanServer)server, new ObjectName(dsName));
        return proxy;
    }
}

