/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.AbstractDomainFolderDialog;
import com.sonicsw.ma.gui.config.ConfigDomainFolderPlugin;
import com.sonicsw.ma.gui.config.ConfigDomainFolderPluginModel;
import com.sonicsw.ma.gui.perms.ManagementSecurityUtils;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JBrowseButton;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.QueryConverter;
import com.sonicsw.ma.gui.util.ReferenceToStringConverter;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.Utils;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigServer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import modelobjects.framework.EditRule;
import modelobjects.framework.IntToStringConverter;
import modelobjects.framework.LongToStringConverter;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JComboBoxAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

public class ConfigDomainFolderDialog
extends AbstractDomainFolderDialog {
    protected JCheckBox enableSecurity = new JCheckBox();
    protected JComboBox authenticationDomains = new JComboBox();
    private MyQueryConverter authDomainConverter;
    protected JCheckBox auditConfigChanges = new JCheckBox();
    protected JCheckBox auditMgmtOps = new JCheckBox();
    protected JCheckBox propogateAuditToDS = new JCheckBox();
    protected JTextField configFile = new JTextField();
    protected JButton configFileChooser = new JBrowseButton();
    protected JCheckBox enableCentralizedLogging = new JCheckBox();
    protected JTextField centralizedLogDir = new JTextField();
    protected JTextField logFileThreshold = new JTextField();
    protected JTextField logFileRolloverThreshold = new JTextField();
    protected JTextField logFileRolloverTimeInterval = new JTextField();

    public ConfigDomainFolderDialog(JMAFrame parent) {
        this(parent, ConfigDomainFolderPluginModel.class);
    }

    protected ConfigDomainFolderDialog(JMAFrame parent, Class modelClass) {
        super(parent, "domain", modelClass);
    }

    @Override
    public void initForm() throws Exception {
        super.initForm();
        new JCheckBoxAdapter(ModelAspectId.forName("securityEnabled"), this.enableSecurity, EditRule.ALWAYS, null, this.getMediator());
        this.authDomainConverter = new MyQueryConverter(this.getPlugin().getPluginContext().getConfigContext().getConfigServer(), "MF_AUTHENTICATION_DOMAIN", "_MFDomainDescriptor");
        new JComboBoxAdapter(ModelAspectId.forName("authenticationDomain"), this.authenticationDomains, EditRule.ALWAYS, this.authDomainConverter, this.getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("auditConfigureEvents"), this.auditConfigChanges, EditRule.ALWAYS, null, this.getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("auditManageEvents"), this.auditMgmtOps, EditRule.ALWAYS, null, this.getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("enableCentralizedAudit"), this.propogateAuditToDS, EditRule.ALWAYS, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("defautlManagementAuditConfig"), this.configFile, EditRule.ALWAYS, null, this.getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("enforeCentralizedLogging"), this.enableCentralizedLogging, EditRule.ALWAYS, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("centralizedLogFile"), this.centralizedLogDir, EditRule.ALWAYS, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("logFileSizeThreshold"), this.logFileThreshold, EditRule.ALWAYS, new LongToStringConverter(), this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("logFileRolloverSizeThreshold"), this.logFileRolloverThreshold, EditRule.ALWAYS, new LongToStringConverter(), this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("logFileRolloverTimeInterval"), this.logFileRolloverTimeInterval, EditRule.ALWAYS, new IntToStringConverter(), this.getMediator());
    }

    @Override
    protected void maInitialize() {
        this.refreshModel();
        if (!this.isAdmin()) {
            this.enableSecurity.setEnabled(false);
            this.authenticationDomains.setEnabled(false);
        } else if (!this.isSecEnabled()) {
            this.authenticationDomains.setEnabled(false);
        }
        this.checkForAnyAudit();
        super.maInitialize();
    }

    @Override
    protected void contributeToUI() {
        String securityAuditingTab = ResourceManager.getString(this.getClass(), "dialog.domain.tab.security.label");
        String loggingAuditingTab = ResourceManager.getString(this.getClass(), "dialog.domain.tab.logging_and_auditing.label");
        this.addTabPanel(securityAuditingTab, JPartitionPanel.wrap(this.createSecurityAuditingPanel()));
        this.addTabPanel(loggingAuditingTab, JPartitionPanel.wrap(this.createLoggingAuditingPanel()));
    }

    @Override
    public Action[] getButtonActions() {
        return new Action[]{new OKAction((Action)this.getDefaultOKAction()), new AbstractDomainFolderDialog.CloseAction("dialog.cancel", this.getDefaultCancelAction())};
    }

    protected JPanel createSecurityAuditingPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        JPartitionPanel mgmtPermsGroup = new JPartitionPanel(false, "p,r", ResourceManager.getString(this.getClass(), "dialog.domain.security_and_auditing.mgmt_perms.title"));
        mgmtPermsGroup.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.security_and_auditing.mgmt_perms.enable.label"), (JComponent)this.enableSecurity);
        this.enableSecurity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigDomainFolderDialog.this.enableSecurity.isSelected()) {
                    ConfigDomainFolderDialog.this.authenticationDomains.setEnabled(true);
                    ConfigDomainFolderDialog.this.authenticationDomains.setSelectedItem(ConfigDomainFolderDialog.this.authDomainConverter.getDefaultDomain());
                } else {
                    ConfigDomainFolderDialog.this.authenticationDomains.setSelectedItem(ConfigDomainFolderDialog.this.authDomainConverter.getNone());
                    ConfigDomainFolderDialog.this.authenticationDomains.setEnabled(false);
                }
            }
        });
        mgmtPermsGroup.addRow(new JComponent[]{new JLabel("Warning: Enforcement requires enablement of"), new JLabel("security and JMSXUserID features at all management brokers.")});
        mgmtPermsGroup.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.security_and_auditing.mgmt_perms.authentication_domain.label"), (JComponent)this.authenticationDomains);
        panel.add((Component)mgmtPermsGroup, "North");
        return panel;
    }

    protected JPanel createLoggingAuditingPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        JPartitionPanel loggingGroup = new JPartitionPanel(false, "p,r,p", ResourceManager.getString(this.getClass(), "dialog.domain.logging_and_auditing.logging.title"));
        loggingGroup.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.logging_and_auditing.logging.enable_centralized_logging.label"), (JComponent)this.enableCentralizedLogging);
        loggingGroup.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.logging_and_auditing.logging.centralized_log_dir.label"), (JComponent)this.centralizedLogDir);
        loggingGroup.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.logging_and_auditing.logging.log_file_threshold.label"), (JComponent)this.logFileThreshold, "bytes");
        loggingGroup.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.logging_and_auditing.logging.log_file_rollover_threshold.label"), (JComponent)this.logFileRolloverThreshold, "bytes");
        loggingGroup.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.logging_and_auditing.logging.log_file_rollover_time_interval.label"), (JComponent)this.logFileRolloverTimeInterval, "minutes");
        panel.add((Component)loggingGroup, "North");
        JPartitionPanel auditGroup = new JPartitionPanel(false, "p,r,p", ResourceManager.getString(this.getClass(), "dialog.domain.security_and_auditing.auditing.title"));
        auditGroup.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.security_and_auditing.auditing.enable_audit_config_changes.label"), new JComponent[]{this.auditConfigChanges});
        auditGroup.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.security_and_auditing.auditing.enable_audit_mgmt_ops.label"), new JComponent[]{this.auditMgmtOps});
        auditGroup.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.security_and_auditing.auditing.enable_propagate_audit.label"), new JComponent[]{this.propogateAuditToDS});
        auditGroup.addRow(ResourceManager.getString(this.getClass(), "dialog.domain.security_and_auditing.auditing.default_log4j.label"), new JComponent[]{this.configFile, this.configFileChooser});
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigDomainFolderDialog.this.checkForAnyAudit();
            }
        };
        this.auditConfigChanges.addActionListener(l);
        this.auditMgmtOps.addActionListener(l);
        this.configFileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String file = Utils.chooseFile(ConfigDomainFolderDialog.this, ConfigDomainFolderDialog.this.getPlugin(), ManagementSecurityUtils.getAllowedLog4jConfigExtensions());
                if (file != null) {
                    ConfigDomainFolderDialog.this.configFile.setText(file);
                }
            }
        });
        panel.add((Component)auditGroup, "South");
        return panel;
    }

    private void checkForAnyAudit() {
        boolean anyAudit;
        boolean bl = anyAudit = this.auditConfigChanges.isSelected() || this.auditMgmtOps.isSelected();
        if (this.propogateAuditToDS.isSelected() && !anyAudit) {
            this.propogateAuditToDS.setSelected(false);
        }
        this.propogateAuditToDS.setEnabled(anyAudit);
        this.configFile.setEnabled(anyAudit);
        this.configFileChooser.setEnabled(anyAudit);
    }

    private boolean isAdmin() {
        ConfigDomainFolderPlugin plugin = (ConfigDomainFolderPlugin)this.getPlugin();
        return plugin.getPluginContext().getConnectionInfo().getUserName().equals("Administrator");
    }

    private boolean isSecEnabled() {
        ConfigDomainFolderPlugin plugin = (ConfigDomainFolderPlugin)this.getPlugin();
        return ((ConfigDomainFolderPluginModel)plugin.getModel()).getSecurityEnabled();
    }

    private void refreshModel() {
        ConfigDomainFolderPlugin plugin = (ConfigDomainFolderPlugin)this.getPlugin();
        ((ConfigDomainFolderPluginModel)plugin.getModel()).initSecurityAndAuditSettings();
    }

    @Override
    protected boolean canClose() {
        int res = 0;
        if (this.getMediator().hasUnappliedChanges()) {
            res = JOptionPane.showConfirmDialog(this, "There are unapplied changes.\nAre you sure you want to cancel?", "Confirm Cancel", 0, 2);
        }
        return res == 0;
    }

    public class MyQueryConverter
    extends QueryConverter {
        public MyQueryConverter(IConfigServer server, String type, String suffix) {
            super(server, type, suffix);
        }

        public MyQueryConverter(IConfigServer server, String type) {
            super(server, type);
        }

        @Override
        public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
            IConfigElement o = (IConfigElement)super.viewValueToModel(viewValue);
            if (o == null) {
                return o;
            }
            return o.getName();
        }

        @Override
        public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
            if (modelValue == null) {
                return NONE;
            }
            if (modelValue instanceof String) {
                String name = (String)modelValue;
                name = this.stripDefaulSuffix(name);
                return ReferenceToStringConverter.convertToView(name);
            }
            throw new ViewValueConversionException("Value not a com.sonicsw.mx.config.IConfigBean");
        }

        @Override
        public String[] getViewStringValues() {
            Object[] viewStringValues = super.getViewStringValues();
            if (viewStringValues.length > 1) {
                Arrays.sort(viewStringValues, 1, viewStringValues.length);
            }
            return viewStringValues;
        }

        @Override
        public Class getModelClass() {
            return String.class;
        }

        public String getNone() {
            return NONE;
        }

        public String getDefaultDomain() {
            String[] viewStringValues = this.getViewStringValues();
            for (int i = 0; i < viewStringValues.length; ++i) {
                String string = viewStringValues[i];
                if (string.equals(NONE)) continue;
                return string;
            }
            return NONE;
        }
    }

    public class OKAction
    extends BasicGuiAction {
        private static final long MIN_ROLLOVER_TIME = 1L;
        private static final long MAX_ROLLOVER_TIME = 1440L;

        public OKAction(Action targetAction) {
            super("dialog.ok", targetAction);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.validateLogRolloverTimeInterval()) {
                return;
            }
            super.actionPerformed(evt);
        }

        private boolean validateLogRolloverTimeInterval() {
            try {
                int value = new Integer(ConfigDomainFolderDialog.this.logFileRolloverTimeInterval.getText());
                if ((long)value < 1L) {
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Rollover time interval cannot be less than 1 minute.", true);
                    return true;
                }
                if ((long)value > 1440L) {
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Rollover time interval cannot be greater than 1440 minutes", true);
                    return true;
                }
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Not a valid value", e, true);
            }
            return false;
        }
    }
}

