/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.plugin.ConfigFactoryInfo;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IPluginFactory;
import com.sonicsw.ma.plugin.RuntimeFactoryInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConfigDomainFolderModel {
    protected IPluginContext m_context;
    protected DomainConnectionModel m_model;

    public ConfigDomainFolderModel(IPluginContext context) {
        this.m_context = context;
        this.m_model = context.getConnectionInfo();
    }

    public String getConnectionName() {
        return this.m_model.getConnectionName();
    }

    public String getDomainName() {
        return this.m_model.getDomainName();
    }

    public String getUrl() {
        return this.m_model.getUrl();
    }

    public String getUserName() {
        return this.m_model.getUserName();
    }

    public int getTimeout() {
        return this.m_model.getTimeout();
    }

    public String getManagementNode() {
        return this.m_model.getManagementNode();
    }

    public boolean isUsingManagement() {
        return this.m_model.isUseDRA();
    }

    public boolean isLoadBalancing() {
        return this.m_model.isLoadBalancing();
    }

    protected HashMap getFactoryMap() {
        return this.m_context.getLibrary().getConfigRootFactoryMap();
    }

    public List getPluginFactories() {
        ArrayList<IPluginFactory> res = new ArrayList<IPluginFactory>();
        HashMap map = this.getFactoryMap();
        for (ArrayList factories : map.values()) {
            for (int i = 0; i < factories.size(); ++i) {
                Object factoryInfo = factories.get(i);
                if (factoryInfo instanceof ConfigFactoryInfo) {
                    res.add(((ConfigFactoryInfo)factoryInfo).getRootFactory());
                    continue;
                }
                if (!(factoryInfo instanceof RuntimeFactoryInfo)) continue;
                res.add(((RuntimeFactoryInfo)factoryInfo).getRootFactory());
            }
        }
        return res;
    }
}

