/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.ImportPluginAction;
import com.sonicsw.ma.gui.config.ConfigDomainFolderDialog;
import com.sonicsw.ma.gui.config.ConfigDomainFolderModel;
import com.sonicsw.ma.gui.config.ConfigDomainFolderPluginModel;
import com.sonicsw.ma.gui.config.ConfigFolderPlugin;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.security.IManagementSecurityConfigurator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.ModelObjectValidator;
import modelobjects.framework.model.ModelValidationException;

public class ConfigDomainFolderPlugin
extends ConfigFolderPlugin {
    public static final String PLUGIN_NAME = "Configured Objects";
    public static final String PLUGIN_TYPE = "ConfigDomain";
    public static final String DISPLAY_TYPE = "ConfigDomain";
    private static final Object[][] ATTRIBUTES = new Object[][]{{"TYPE", "ConfigDomain"}, {"SYSTEM", "true"}, {"DISPLAY_TYPE", "ConfigDomain"}};
    private ConfigDomainFolderModel m_model = null;
    private ConfigDomainFolderDialog configDomainFolderDialog;

    public ConfigDomainFolderPlugin(IPluginContext context) {
        super(context, null, null);
        this.getAttributes().put(ATTRIBUTES);
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginPath() {
        return "/";
    }

    @Override
    public void dispose() {
        this.m_model = null;
    }

    @Override
    public JPropSheetDialog getPropSheetDialog() {
        this.configDomainFolderDialog = new ConfigDomainFolderDialog(this.getPluginContext().getMgmtConsole());
        DomainFolderValidator validator = new DomainFolderValidator();
        this.configDomainFolderDialog.setValidator(validator);
        return this.configDomainFolderDialog;
    }

    @Override
    protected JComponent[] getSystemMenuItems() {
        JComponent[] items = new JComponent[]{new JBasicMenuItem(new ImportPluginAction(this))};
        return Helper.combineMenu(items, super.getSystemMenuItems(), false);
    }

    @Override
    public Object getModel() {
        if (this.m_model == null) {
            this.m_model = new ConfigDomainFolderPluginModel(this, this.getPluginContext());
        }
        return this.m_model;
    }

    @Override
    public List getToolTipList() {
        DomainConnectionModel model = this.getPluginContext().getConnectionInfo();
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.formatToolTipText("Connection", model.getConnectionName()));
        list.add(this.formatToolTipText("Domain", model.getDomainName()));
        list.add(this.formatToolTipText("URL", model.getUrl()));
        String userName = model.getUserName();
        if (userName != null && userName.trim().length() > 0) {
            list.add(this.formatToolTipText("User Name", userName));
        }
        return list;
    }

    @Override
    public void drop(IConfigPlugin dropPlugin, int dropAction) {
    }

    public class DomainFolderValidator
    implements ModelObjectValidator {
        public static final String REMOVE_PERMS_QSTN = "Are you sure you want to disable the use of Management Permissions?\nAll defined permissions will be reset.";
        public static final String CREATE_PERMS_QSTN = "Allow all access for the Administrators group?\n(If you choose no, only the Administrator will have Management Permissions initially)";
        public static final String CHANGE_DOMAIN_QSTN = "Permissions checking will be temporarily disabled to establish the\nnew authentication domain and existing permissions will be removed. \nDo you want to continue?";

        @Override
        public void validateModelEdit(ModelObjectAdapter modelObjectAdapter) throws ModelValidationException {
            ConfigDomainFolderPluginModel model = (ConfigDomainFolderPluginModel)ConfigDomainFolderPlugin.this.m_model;
            if (model.getAuthenticationDomainChanged()) {
                int res = 0;
                IDirectoryFileSystemService ds = ConfigDomainFolderPlugin.this.getPluginContext().getConnectionInfo().getDirectoryService();
                if (model.getSecurityEnabled()) {
                    if (model.wasSecurityEnabled()) {
                        res = JOptionPane.showConfirmDialog(ConfigDomainFolderPlugin.this.configDomainFolderDialog, CHANGE_DOMAIN_QSTN, "Change Authentication Domain", 0, 1);
                        if (res == 0) {
                            try {
                                ((IManagementSecurityConfigurator)ds).removeAllManagementPermissions();
                            }
                            catch (Exception e) {
                                String message = "Creation of default Management Permissions failed.";
                                MgmtConsole.getMgmtConsole().notifyMessage(4, message, e, false);
                                throw new ModelValidationException(e);
                            }
                        } else {
                            model.unsetAuthenticationDomain();
                        }
                    }
                    if (res == 0 && (res = JOptionPane.showConfirmDialog(ConfigDomainFolderPlugin.this.configDomainFolderDialog, CREATE_PERMS_QSTN, "Administrators' Permissions", 0, 1)) == 0) {
                        try {
                            ((IManagementSecurityConfigurator)ds).setDefaultManagementPermissions();
                        }
                        catch (Exception e) {
                            String message = "Creation of default Management Permissions failed.";
                            MgmtConsole.getMgmtConsole().notifyMessage(4, message, e, false);
                            throw new ModelValidationException(e);
                        }
                    }
                } else {
                    res = JOptionPane.showConfirmDialog(ConfigDomainFolderPlugin.this.configDomainFolderDialog, REMOVE_PERMS_QSTN, "Disable Management Permissions", 0, 2);
                    if (res == 0) {
                        try {
                            ((IManagementSecurityConfigurator)ds).removeAllManagementPermissions();
                        }
                        catch (Exception e) {
                            String message = "Removal of Management Permissions failed.";
                            MgmtConsole.getMgmtConsole().notifyMessage(4, message, e, false);
                            throw new ModelValidationException(e);
                        }
                    } else {
                        model.unsetAuthenticationDomain();
                    }
                }
            }
            try {
                model.applyChanges();
            }
            catch (Exception e) {
                String message = "Saving changes failed.";
                MgmtConsole.getMgmtConsole().notifyMessage(4, message, e, false);
                throw new ModelValidationException(e);
            }
        }

        @Override
        public void validateModelCreation(ModelObjectAdapter modelObjectAdapter) throws ModelValidationException {
        }

        @Override
        public void validateModelDeletion(ModelObjectAdapter modelObjectAdapter) throws ModelValidationException {
        }
    }
}

