/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.ConfigDomainFolderModel;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.security.ConfigurePermissionDeniedException;
import com.sonicsw.mf.common.security.IManagementSecurityConfigurator;

public class ConfigDomainFolderPluginModel
extends ConfigDomainFolderModel {
    protected AbstractGUIPlugin m_plugin = null;
    public static final String PERMISSION_DENIED = "<Permission Denied>";
    public static final String AUTHENTICATION_DOMAIN = "AUTHENTICATION_DOMAIN";
    public static final String AUDIT_CONFIGURE_EVENTS = "AUDIT_CONFIGURE_EVENTS";
    public static final String AUDIT_MANAGE_EVENTS = "AUDIT_MANAGE_EVENTS";
    public static final String ENABLE_CENTRALIZED_AUDIT = "ENABLE_CENTRALIZED_AUDIT";
    public static final String DEFAULT_MANAGEMENT_AUDIT_CONFIG = "DEFAULT_MANAGEMENT_AUDIT_CONFIG";
    public static final String FORCE_CENTRALIZED_LOGGING = "FORCE_CENTRALIZED_LOGGING";
    public static final String CENTRALIZED_LOG_FILE = "CENTRALIZED_LOG_FILE";
    public static final String LOG_FILE_SIZE_THRESHOLD = "LOG_FILE_SIZE_THRESHOLD";
    public static final String LOG_FILE_ROLLOVER_SIZE_THRESHOLD = "LOG_FILE_ROLLOVER_SIZE_THRESHOLD";
    public static final String LOG_FILE_ROLLOVER_TIME_INTERVAL = "LOG_FILE_ROLLOVER_TIME_INTERVAL";
    private String authenticationDomain;
    private String originalDomain;
    private boolean auditConfigureEvents;
    private boolean auditManageEvents;
    private boolean enableCentralizedAudit;
    private String defautlManagementAuditConfig;
    private boolean enforeCentralizedLogging;
    private String centralizedLogFile;
    private long logFileSizeThreshold;
    private long logFileRolloverSizeThreshold;
    private int logFileRolloverTimeInterval;

    public ConfigDomainFolderPluginModel(AbstractGUIPlugin plugin, IPluginContext context) {
        super(context);
        this.m_plugin = plugin;
        this.initSecurityAndAuditSettings();
    }

    public final void initSecurityAndAuditSettings() {
        IDirectoryFileSystemService ds = this.m_plugin.getPluginContext().getConnectionInfo().getDirectoryService();
        IDirElement domainElement = null;
        try {
            domainElement = ((IManagementSecurityConfigurator)ds).getDomainElement(false);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, "Could not initialize Security & Audit settings", e, false);
            this.originalDomain = null;
            this.authenticationDomain = null;
            this.enableCentralizedAudit = false;
            this.auditConfigureEvents = false;
            this.defautlManagementAuditConfig = null;
            return;
        }
        IAttributeSet domainAttributes = domainElement.getAttributes();
        Reference authDomanRef = (Reference)domainAttributes.getAttribute(AUTHENTICATION_DOMAIN);
        if (authDomanRef == null || authDomanRef.getElementName() == null || authDomanRef.getElementName().length() == 0) {
            this.originalDomain = null;
            this.authenticationDomain = null;
        } else {
            try {
                this.authenticationDomain = this.originalDomain = ds.storageToLogical(authDomanRef.getElementName());
            }
            catch (ConfigurePermissionDeniedException cpde) {
                MgmtConsole.getMgmtConsole().notifyMessage(64, "Configure permission (read) required for Authentication Domain", cpde, false);
                this.authenticationDomain = PERMISSION_DENIED;
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(64, "Could not initialize Security & Audit settings", e, false);
                this.originalDomain = null;
                this.authenticationDomain = null;
            }
        }
        Boolean booleanAttr = null;
        Long longAttr = null;
        Integer intAttr = null;
        booleanAttr = (Boolean)domainAttributes.getAttribute(AUDIT_CONFIGURE_EVENTS);
        this.auditConfigureEvents = booleanAttr == null ? false : booleanAttr;
        booleanAttr = (Boolean)domainAttributes.getAttribute(AUDIT_MANAGE_EVENTS);
        this.auditManageEvents = booleanAttr == null ? false : booleanAttr;
        booleanAttr = (Boolean)domainAttributes.getAttribute(ENABLE_CENTRALIZED_AUDIT);
        this.enableCentralizedAudit = booleanAttr == null ? false : booleanAttr;
        this.defautlManagementAuditConfig = (String)domainAttributes.getAttribute(DEFAULT_MANAGEMENT_AUDIT_CONFIG);
        booleanAttr = (Boolean)domainAttributes.getAttribute(FORCE_CENTRALIZED_LOGGING);
        this.enforeCentralizedLogging = booleanAttr == null ? false : booleanAttr;
        this.centralizedLogFile = (String)domainAttributes.getAttribute(CENTRALIZED_LOG_FILE);
        longAttr = (Long)domainAttributes.getAttribute(LOG_FILE_SIZE_THRESHOLD);
        if (longAttr != null) {
            this.logFileSizeThreshold = longAttr;
        }
        if ((longAttr = (Long)domainAttributes.getAttribute(LOG_FILE_ROLLOVER_SIZE_THRESHOLD)) != null) {
            this.logFileRolloverSizeThreshold = longAttr;
        }
        this.logFileRolloverTimeInterval = (intAttr = (Integer)domainAttributes.getAttribute(LOG_FILE_ROLLOVER_TIME_INTERVAL)) != null && intAttr > 0 && intAttr <= 1440 ? intAttr : 1440;
    }

    public String getPath() {
        int index;
        String strResult = this.m_plugin.getPluginPath();
        if (strResult != null && (index = strResult.lastIndexOf("/")) != -1) {
            strResult = strResult.substring(0, index + 1);
        }
        return strResult;
    }

    public boolean isSystem() {
        return this.m_plugin != null ? this.m_plugin.getAttributes().isSystem() : false;
    }

    public String getType() {
        return this.m_plugin != null ? this.m_plugin.getAttributes().getDisplayType() : "Unknown";
    }

    public void setSecurityEnabled(boolean enabled) {
    }

    public boolean wasSecurityEnabled() {
        return this.originalDomain != null && this.originalDomain.trim().length() > 0;
    }

    public boolean getSecurityEnabled() {
        return this.authenticationDomain != null && this.authenticationDomain.trim().length() > 0;
    }

    public String getAuthenticationDomain() {
        return this.authenticationDomain;
    }

    public void setAuthenticationDomain(String authenticationDomain) {
        this.authenticationDomain = authenticationDomain;
    }

    public void unsetAuthenticationDomain() {
        this.authenticationDomain = this.originalDomain;
    }

    public boolean getAuthenticationDomainChanged() {
        return !String.valueOf(this.authenticationDomain).equals(String.valueOf(this.originalDomain));
    }

    public boolean isAuditConfigureEvents() {
        return this.auditConfigureEvents;
    }

    public void setAuditConfigureEvents(boolean auditConfigureEvents) {
        this.auditConfigureEvents = auditConfigureEvents;
    }

    public boolean isAuditManageEvents() {
        return this.auditManageEvents;
    }

    public void setAuditManageEvents(boolean auditManageEvents) {
        this.auditManageEvents = auditManageEvents;
    }

    public boolean isEnableCentralizedAudit() {
        return this.enableCentralizedAudit;
    }

    public void setEnableCentralizedAudit(boolean enableCentralizedAudit) {
        this.enableCentralizedAudit = enableCentralizedAudit;
    }

    public String getDefautlManagementAuditConfig() {
        return this.defautlManagementAuditConfig;
    }

    public void setDefautlManagementAuditConfig(String defautlManagementAuditConfig) {
        this.defautlManagementAuditConfig = defautlManagementAuditConfig;
    }

    public boolean isEnforeCentralizedLogging() {
        return this.enforeCentralizedLogging;
    }

    public void setEnforeCentralizedLogging(boolean enforeCentralizedLogging) {
        this.enforeCentralizedLogging = enforeCentralizedLogging;
    }

    public String getCentralizedLogFile() {
        return this.centralizedLogFile;
    }

    public void setCentralizedLogFile(String centralizedLogFile) {
        this.centralizedLogFile = centralizedLogFile;
    }

    public long getLogFileSizeThreshold() {
        return this.logFileSizeThreshold;
    }

    public void setLogFileSizeThreshold(long logFileSizeThreshold) {
        this.logFileSizeThreshold = logFileSizeThreshold;
    }

    public long getLogFileRolloverSizeThreshold() {
        return this.logFileRolloverSizeThreshold;
    }

    public void setLogFileRolloverSizeThreshold(long logFileRolloverSizeThreshold) {
        this.logFileRolloverSizeThreshold = logFileRolloverSizeThreshold;
    }

    public int getLogFileRolloverTimeInterval() {
        return this.logFileRolloverTimeInterval;
    }

    public void setLogFileRolloverTimeInterval(int logFileRolloverTimeInterval) {
        this.logFileRolloverTimeInterval = logFileRolloverTimeInterval;
    }

    public void applyChanges() throws ConfigException, ReadOnlyException, DirectoryServiceException {
        IDirectoryFileSystemService ds = this.m_plugin.getPluginContext().getConnectionInfo().getDirectoryService();
        IDirElement domainElement = ((IManagementSecurityConfigurator)ds).getDomainElement(true);
        IAttributeSet domainAttributes = domainElement.getAttributes();
        domainAttributes.setBooleanAttribute(AUDIT_CONFIGURE_EVENTS, this.auditConfigureEvents ? Boolean.TRUE : Boolean.FALSE);
        domainAttributes.setBooleanAttribute(AUDIT_MANAGE_EVENTS, this.auditManageEvents ? Boolean.TRUE : Boolean.FALSE);
        domainAttributes.setBooleanAttribute(ENABLE_CENTRALIZED_AUDIT, this.enableCentralizedAudit ? Boolean.TRUE : Boolean.FALSE);
        if (this.authenticationDomain == null) {
            domainAttributes.setReferenceAttribute(AUTHENTICATION_DOMAIN, null);
        } else {
            Reference domainRef = new Reference(ds.logicalToStorage(this.authenticationDomain));
            domainAttributes.setReferenceAttribute(AUTHENTICATION_DOMAIN, domainRef);
        }
        domainAttributes.setStringAttribute(DEFAULT_MANAGEMENT_AUDIT_CONFIG, this.defautlManagementAuditConfig);
        domainAttributes.setBooleanAttribute(FORCE_CENTRALIZED_LOGGING, this.enforeCentralizedLogging ? Boolean.TRUE : Boolean.FALSE);
        domainAttributes.setStringAttribute(CENTRALIZED_LOG_FILE, this.centralizedLogFile);
        domainAttributes.setLongAttribute(LOG_FILE_SIZE_THRESHOLD, new Long(this.logFileSizeThreshold));
        domainAttributes.setLongAttribute(LOG_FILE_ROLLOVER_SIZE_THRESHOLD, new Long(this.logFileRolloverSizeThreshold));
        domainAttributes.setIntegerAttribute(LOG_FILE_ROLLOVER_TIME_INTERVAL, new Integer(this.logFileRolloverTimeInterval));
        IBasicElement updatedElement = domainElement.doneUpdate();
        ((IManagementSecurityConfigurator)ds).setDomainElement((IDeltaDirElement)updatedElement);
        this.originalDomain = this.authenticationDomain;
    }
}

