/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.CreateFolderAction;
import com.sonicsw.ma.gui.action.ExportPluginAction;
import com.sonicsw.ma.gui.action.FolderPluginExpandAction;
import com.sonicsw.ma.gui.action.PasteSpecialAction;
import com.sonicsw.ma.gui.action.RefreshPluginAction;
import com.sonicsw.ma.gui.config.AbstractConfigPlugin;
import com.sonicsw.ma.gui.config.ConfigFolderContentPane;
import com.sonicsw.ma.gui.config.NewConfigurationAction;
import com.sonicsw.ma.gui.file.CreateFileAction;
import com.sonicsw.ma.gui.file.FileElementPlugin;
import com.sonicsw.ma.gui.file.FileFolderDialog;
import com.sonicsw.ma.gui.file.FileFolderPluginModel;
import com.sonicsw.ma.gui.file.ImportFileAction;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IConfigContext;
import com.sonicsw.ma.plugin.IConfigPluginFactory;
import com.sonicsw.ma.plugin.IFolderPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IConfigType;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.util.ConfigHelper;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.tree.DefaultMutableTreeNode;

public class ConfigFolderPlugin
extends AbstractConfigPlugin
implements IFolderPlugin {
    private static final String DISPLAY_TYPE = "Folder";
    private boolean m_preload = false;
    private static final Object[][] ATTRIBUTES = new Object[][]{{"DISPLAY_TYPE", "Folder"}, {"CHILD_BEARING", Boolean.TRUE}};
    private FileFolderPluginModel m_model = null;

    public ConfigFolderPlugin(IPluginContext context, String id, Map data) {
        super(context, id, data);
        this.getAttributes().put(ATTRIBUTES);
    }

    @Override
    protected IContentPane createReadablePluginContentPane() {
        return new ConfigFolderContentPane(this);
    }

    public void importFile(File file, String dsPath) throws Exception {
        this.doImportFile(this, file, dsPath);
    }

    public void addFile(final File file, final String fileName, boolean bAsync) {
        if (bAsync) {
            final ConfigFolderPlugin plugin = this;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    ConfigFolderPlugin.this.doAddFile(plugin, file, fileName);
                }
            });
            t.start();
        } else {
            this.doAddFile(this, file, fileName);
        }
    }

    @Override
    public BasicAction getDefaultAction() {
        return new FolderPluginExpandAction(this);
    }

    @Override
    protected JComponent[] getNewMenuItems() {
        JBasicMenu newMenu = new JBasicMenu(new BasicGuiAction("file.new"));
        newMenu.add(new JBasicMenuItem(new CreateFileAction(this)));
        newMenu.add(new JBasicMenuItem(new CreateFolderAction(this)));
        newMenu.add(new JSeparator());
        newMenu.add(new JBasicMenuItem(new NewConfigurationAction(this)));
        return new JComponent[]{newMenu};
    }

    @Override
    protected JComponent[] getViewMenuItems() {
        return new JComponent[]{new JBasicMenuItem(new RefreshPluginAction(this))};
    }

    @Override
    protected JComponent[] getSystemMenuItems() {
        JComponent[] menu = super.getSystemMenuItems();
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        for (int i = 0; i < menu.length; ++i) {
            if (menu[i] != null && menu[i] instanceof JMenuItem && ((JMenuItem)menu[i]).getAction() instanceof ExportPluginAction) {
                list.add(new JBasicMenuItem(new ImportFileAction(this)));
            }
            list.add(menu[i]);
        }
        return list.toArray(new JComponent[0]);
    }

    @Override
    protected JComponent[] getEditMenuItems() {
        Object clipObject;
        JComponent[] c = super.getEditMenuItems();
        ArrayList<JComponent> list = new ArrayList<JComponent>(Arrays.asList(super.getEditMenuItems()));
        if (MgmtConsole.DEVELOPER_MODE && (clipObject = MgmtConsole.getMgmtConsole().getClipboardObject()) != null && clipObject instanceof AbstractConfigPlugin && ((AbstractConfigPlugin)clipObject).isTemplatePrototype()) {
            JMenu tMenu = new JMenu("Create From Template");
            tMenu.add(new JBasicMenuItem(new CreateInstanceAction(5)));
            tMenu.add(new JBasicMenuItem(new CreateInstanceAction(10)));
            tMenu.add(new JBasicMenuItem(new CreateInstanceAction(15)));
            tMenu.add(new JBasicMenuItem(new CreateInstanceAction(20)));
            list.add(tMenu);
        }
        return list.toArray(new JComponent[list.size()]);
    }

    @Override
    public JPropSheetDialog getPropSheetDialog() {
        return new FileFolderDialog(MgmtConsole.getMgmtConsole(), this.getPluginName());
    }

    @Override
    public void deletePlugin(IConfigServer configServer) throws Exception {
        configServer.deleteFolder(this.getPluginPath());
    }

    @Override
    public void refresh() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (!(this.getChildAt(i) instanceof FileElementPlugin)) continue;
            FileElementPlugin fileElementPlugin = (FileElementPlugin)this.getChildAt(i);
            fileElementPlugin.refresh();
        }
        super.refresh();
    }

    public Object createModel(boolean isTemplate) {
        try {
            IConfigServer server = this.getPluginContext().getConfigContext().getConfigServer();
            String string = this.getPluginPath();
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to create model: " + this.getPluginPath(), e, false);
        }
        return null;
    }

    @Override
    public Object getModel() {
        if (this.m_model == null) {
            this.m_model = new FileFolderPluginModel(this);
        }
        return this.m_model;
    }

    @Override
    protected IConfigType getModelMetaData() {
        return null;
    }

    protected final void setPreloadElements(boolean preload) {
        this.m_preload = preload;
    }

    protected Set loadConfigElements() throws ConfigServiceException {
        String path;
        IConfigServer server = this.getPluginContext().getConfigContext().getConfigServer();
        if (!((ConfigServer)server)._pathExists(path = this._getPluginPath())) {
            return Collections.EMPTY_SET;
        }
        return server.loadConfigElements(path);
    }

    protected Set metaAttributeSet() throws ConfigServiceException {
        String path;
        IConfigServer server = this.getPluginContext().getConfigContext().getConfigServer();
        if (!((ConfigServer)server)._pathExists(path = this._getPluginPath())) {
            return Collections.EMPTY_SET;
        }
        return server.list(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expand() {
        boolean res = true;
        JProgressBar bar = MgmtConsole.getMgmtConsole().getStatusBar().getProgressBar();
        try {
            Set childSet;
            Set elements = null;
            if (this.m_preload) {
                MgmtConsole.getMgmtConsole().notifyMessage(0, "Preloading all config elements", null, false);
                elements = this.loadConfigElements();
            }
            Iterator i = (childSet = this.metaAttributeSet()) != null ? childSet.iterator() : null;
            int nPluginCount = childSet != null ? childSet.size() : 0;
            int nCount = 0;
            if (bar != null) {
                bar.setMinimum(0);
                bar.setMaximum(nPluginCount);
                bar.setVisible(true);
            }
            ArrayList<IPlugin> plugins = new ArrayList<IPlugin>();
            while (i != null && i.hasNext()) {
                HashMap row = (HashMap)i.next();
                MgmtConsole.getMgmtConsole().notifyMessage(0, "Loading config element " + ++nCount + " of " + nPluginCount, null, false);
                if (bar != null) {
                    bar.setValue(nCount);
                }
                IPlugin plugin = this.createChildPlugin(null, row);
                plugins.add(plugin);
                if (!this.m_preload || elements == null || elements.isEmpty()) continue;
                plugin.getModel();
            }
            this.setChildPlugins(plugins);
        }
        catch (Exception e) {
            this.setParent((DefaultMutableTreeNode)this.getParent());
            res = false;
            MgmtConsole.getMgmtConsole().notifyMessage(4, "ConfigFolderPlugin::expand failed", e, false);
        }
        finally {
            if (bar != null) {
                bar.setVisible(false);
                MgmtConsole.getMgmtConsole().getStatusBar().releaseProgressBar();
            }
        }
        return res;
    }

    @Override
    protected IPlugin createChildPlugin(String strName, Map metaAttributes) {
        IPlugin plugin = null;
        String metaName = null;
        boolean isFolder = false;
        try {
            if (metaAttributes.containsKey("_FOLDER_NAME")) {
                String folderName = (String)metaAttributes.remove("_FOLDER_NAME");
                int folderIndex = folderName.lastIndexOf(47);
                metaName = folderName.substring(folderIndex + 1);
                isFolder = true;
            } else if (metaAttributes.containsKey("_ELEMENT_IDENTITY")) {
                IElementIdentity eId = (IElementIdentity)metaAttributes.remove("_ELEMENT_IDENTITY");
                String[] comp = eId.getNameComponents();
                metaName = comp[comp.length - 1];
            } else {
                return null;
            }
            if (metaAttributes.containsKey("TYPE")) {
                String type = (String)metaAttributes.get("TYPE");
                if (type != null && type.equals("MF_DOMAIN")) {
                    return null;
                }
                String cVersion = (String)metaAttributes.get("CONFIG_VERSION");
                String pVersion = (String)metaAttributes.get("PRODUCT_VERSION");
                if (type != null && type.equals("MF_FILE")) {
                    plugin = new FileElementPlugin(this.getPluginContext(), metaName, metaAttributes);
                } else if (cVersion != null || pVersion != null) {
                    IConfigContext context = this.getPluginContext().getConfigContext();
                    IConfigPluginFactory factory = context.getPluginFactory(type, cVersion, pVersion);
                    if (factory != null) {
                        Helper.logDebugMessage("ConfigFolderPlugin::createChildPlugin(" + metaName + " " + type + " c=" + cVersion + " p=" + pVersion + ")");
                        plugin = factory.createPlugin(this.getPluginContext(), metaName, pVersion, metaAttributes);
                    } else {
                        MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to lookup config factory for " + type + " c=" + cVersion + " p=" + pVersion, false);
                    }
                }
            } else if (isFolder) {
                plugin = new ConfigFolderPlugin(this.getPluginContext(), metaName, metaAttributes);
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "ConfigFolderPlugin::createChildPlugin failed", e, false);
        }
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImportFile(AbstractGUIPlugin plugin, File file, String dsPath) throws Exception {
        int nOverwrite;
        boolean overwrite = plugin.pathExists(dsPath);
        if (overwrite && (nOverwrite = JOptionPane.showConfirmDialog(MgmtConsole.getMgmtConsole(), "The file " + dsPath + " already exists.  Do you want to overwrite the existing file?", "Verify File", 0)) != 0) {
            return;
        }
        Object bean = null;
        JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
        MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.getMgmtConsole(), 1, (overwrite ? "Overwriting " : "Creating ") + dsPath + "...", null, false);
        try {
            IConfigServer server = plugin.getPluginContext().getConfigContext().getConfigServer();
            String user = plugin.getPluginContext().getConnectionInfo().getUserName();
            if (file != null) {
                ConfigHelper.importFile((IConfigServer)server, (String)dsPath, (String)file.getAbsolutePath(), (String)user, (boolean)true);
            } else {
                ConfigHelper.createFile((IConfigServer)server, (String)dsPath, (String)user);
            }
        }
        finally {
            wc.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddFile(AbstractGUIPlugin plugin, File file, String fileName) {
        JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
        String strPathName = this.buildFilePath(plugin.getPluginPath(), fileName);
        try {
            this.doImportFile(plugin, file, strPathName);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, new StringBuffer("Failure importing ").append(strPathName).toString(), e, true);
        }
        finally {
            wc.release();
        }
    }

    public String buildFilePath(String path, String file) {
        StringBuffer buffer = new StringBuffer(path);
        if (buffer.charAt(buffer.length() - 1) != '/') {
            buffer.append('/');
        }
        buffer.append(file);
        return buffer.toString();
    }

    class CreateInstanceAction
    extends BasicGuiAction {
        int num;

        public CreateInstanceAction(int num) {
            super("sdf");
            this.putNameValue();
            this.num = num;
        }

        private void putNameValue() {
            this.putValue("Name", this.num + " instances");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            for (int i = 0; i < this.num; ++i) {
                PasteSpecialAction.pasteConfigElement(ConfigFolderPlugin.this, true);
            }
        }
    }
}

