/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.mf.common.config.IElementIdentity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FileElementFilter
implements IPluginFilter {
    private static String DEFAULT_FILTER = "*.*";
    private String m_selectedFilter = DEFAULT_FILTER;

    @Override
    public boolean isPluginVisible(Object destination, Object pluginData) {
        try {
            HashMap map = (HashMap)pluginData;
            String name = (String)map.get("_FOLDER_NAME");
            if (name == null) {
                try {
                    name = ((IElementIdentity)map.get("_ELEMENT_IDENTITY")).getName();
                }
                catch (Exception e) {
                    String message = e.getMessage() == null ? "Error filtering files." : e.getMessage();
                    MgmtConsole.getMgmtConsole().notifyMessage(4, message, e, false);
                    return false;
                }
            }
            if ((name = name.substring(name.lastIndexOf(47) + 1)).startsWith("_")) {
                return false;
            }
            String type = (String)map.get("TYPE");
            String version = (String)map.get("CONFIG_VERSION");
            if (type == null) {
                if (!map.containsKey("_FOLDER_NAME")) {
                    return false;
                }
            } else {
                if (!type.equals("MF_FILE")) {
                    return false;
                }
                String templateType = (String)map.get("TEMPLATE_TYPE");
                if (templateType != null && templateType.equalsIgnoreCase("prototype")) {
                    return false;
                }
                if (this.m_selectedFilter.equals(DEFAULT_FILTER)) {
                    return true;
                }
                if (!this.m_selectedFilter.equals(DEFAULT_FILTER) && !this.isValidExtension(name)) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            MgmtConsole.displayMessage(4, "Error filtering files.", e, true);
        }
        return true;
    }

    public void setSelectedFilter(String extention) {
        this.m_selectedFilter = extention;
    }

    public String getSelectedFilter() {
        return this.m_selectedFilter;
    }

    private String getExtension(String fileName) {
        String ext = null;
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            ext = fileName.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private boolean isValidExtension(String name) {
        String ext = "*." + this.getExtension(name);
        StringTokenizer tn = new StringTokenizer(this.m_selectedFilter, ",");
        ArrayList<String> exts = new ArrayList<String>(0);
        while (tn.hasMoreTokens()) {
            exts.add(tn.nextToken().trim());
        }
        if (exts.isEmpty()) {
            exts.add(this.m_selectedFilter);
        }
        return exts.contains(ext);
    }
}

