/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.DSFileChooser;
import com.sonicsw.ma.gui.config.FileElementFilter;
import com.sonicsw.ma.gui.config.propsheets.IConfigPanel;
import com.sonicsw.ma.gui.config.propsheets.JConfigDialog;
import com.sonicsw.ma.gui.propsheets.ClasspathPanel;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.mf.common.archive.SonicArchive;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JClassesPanel
extends JPartitionPanel
implements IConfigPanel {
    private static final IConfigPath ARCHIVE_NAME = ConfigFactory.createConfigPath((String)"ARCHIVE_NAME");
    protected String archiveGroupTitle = "Archive";
    JTextField m_archiveName = new JTextField();
    ClasspathPanel m_classpath = null;

    public JClassesPanel() {
        this("");
    }

    public JClassesPanel(String borderTitle) {
        super(true, "p,r", borderTitle);
    }

    @Override
    public String getTitle() {
        return "Resources";
    }

    @Override
    public JPanel getPanelComponent() {
        return this;
    }

    @Override
    public void initUI(JConfigDialog dialog) throws Exception {
        this.m_classpath = new ClasspathPanel(dialog);
        this.m_classpath.initUI();
        JPartitionPanel archivePanel = this.makeArchivePanel(dialog);
        this.add(archivePanel);
        JPartitionPanel pTmp = JPartitionPanel.merge("r", true, new JComponent[]{this.m_classpath});
        pTmp.setBorder(BorderFactory.createTitledBorder("Prepend Classpath"));
        this.add(pTmp);
    }

    protected JPartitionPanel makeArchivePanel(JConfigDialog dialog) {
        JPartitionPanel archivePanel = new JPartitionPanel(this.archiveGroupTitle);
        archivePanel.addRow(dialog.getResourceLabel(ARCHIVE_NAME), new JComponent[]{this.m_archiveName});
        return archivePanel;
    }

    @Override
    public void initForm(JConfigDialog dialog) throws Exception {
        dialog.createJTextFieldAdapter(ARCHIVE_NAME, this.m_archiveName, null);
        this.m_classpath.initForm();
    }

    @Override
    public void cleanup() throws Exception {
    }

    private class ArchiveNameBrowseAction
    extends BasicPluginAction {
        public ArchiveNameBrowseAction(IPlugin plugin) {
            super(plugin, "container.archive-name.browse");
            this.putNameValue();
        }

        private void putNameValue() {
            this.putValue("Name", "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String selectedFilter = "*.car";
            String[] m_filters = new String[]{selectedFilter, "*.*"};
            FileElementFilter filter = new FileElementFilter();
            JPropSheetDialog parentDialog = (JPropSheetDialog)Helper.getJDialog(JClassesPanel.this);
            filter.setSelectedFilter(selectedFilter);
            IConfigServer server = this.getPlugin().getPluginContext().getConfigContext().getConfigServer();
            DSFileChooser dialog = new DSFileChooser(parentDialog, "archive.choose", this.getPlugin().getPluginContext(), server, (IPluginFilter)filter, m_filters, false);
            try {
                HashMap selList;
                dialog.editInstance(this.getPlugin(), new HashMap(), false);
                dialog.setVisible(true);
                if (dialog.getCloseCommand() == 0 && (selList = (HashMap)dialog.getModel()) != null && !selList.isEmpty()) {
                    String carPath = (String)selList.keySet().iterator().next();
                    System.out.println("CAR File: " + carPath);
                    SonicFSFileSystem fs = new SonicFSFileSystem(this.getPlugin().getPluginContext().getConnectionInfo().getDirectoryService(), System.getProperty("user.name"));
                    File tmpFile = this.createTemporaryCarFile(fs.getContentBytes(carPath));
                    JClassesPanel.this.m_archiveName.setText(new SonicArchive(tmpFile).getName());
                }
            }
            catch (Exception e) {
                MgmtConsole.displayMessage(4, "Failed to set archive name.", e, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File createTemporaryCarFile(byte[] content) {
            File resFile = null;
            FilterOutputStream os = null;
            try {
                File tmpFile = File.createTempFile("SonicCarCheck", null);
                tmpFile.deleteOnExit();
                os = new BufferedOutputStream(new FileOutputStream(tmpFile));
                os.write(content);
                resFile = tmpFile;
            }
            catch (Exception e) {
                e.printStackTrace();
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                    }
                    os = null;
                }
            }
            return resFile;
        }
    }
}

