/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IConfigPluginFactory;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mx.config.IConfigServer;
import java.awt.Component;
import java.awt.Font;
import java.text.Collator;
import java.util.HashMap;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class JLightConfigTree
extends JTree {
    private IPluginContext m_context = null;
    private IPluginFilter m_filter = null;
    private String m_rootLabel = null;
    private Icon m_rootIcon = null;

    public JLightConfigTree(IPluginContext context, IConfigServer server, String rootPath) {
        this(context, server, rootPath, null);
    }

    public JLightConfigTree(IPluginContext context, IConfigServer server, String rootPath, IPluginFilter filter) {
        super(new LightConfigTreeNode(rootPath));
        this.m_context = context;
        this.m_filter = filter;
        this.prepareJLightConfigTree();
    }

    private void prepareJLightConfigTree() {
        this.setCellRenderer(new LightConfigTreeCellRenderer());
        ((LightConfigTreeNode)this.getModel().getRoot()).add(new DefaultMutableTreeNode(Boolean.TRUE));
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent evt) {
                LightConfigTreeNode node = (LightConfigTreeNode)evt.getPath().getLastPathComponent();
                if (node != JLightConfigTree.this.getModel().getRoot()) {
                    node.removeAllChildren();
                    node.add(new DefaultMutableTreeNode(Boolean.TRUE));
                    ((DefaultTreeModel)JLightConfigTree.this.getModel()).nodeStructureChanged(node);
                }
            }

            @Override
            public void treeExpanded(TreeExpansionEvent evt) {
                LightConfigTreeNode node = (LightConfigTreeNode)evt.getPath().getLastPathComponent();
                node.removeAllChildren();
                JLightConfigTree.this.build(JLightConfigTree.this.m_context.getConfigContext().getConfigServer(), JLightConfigTree.this.m_filter, node);
                ((DefaultTreeModel)JLightConfigTree.this.getModel()).nodeStructureChanged(node);
            }
        });
    }

    private DefaultMutableTreeNode build(IConfigServer server, IPluginFilter filter, LightConfigTreeNode parent) {
        try {
            HashMap parentMap = (HashMap)parent.getUserObject();
            String parentPath = (String)parentMap.get("_FOLDER_NAME");
            Set children = server.list(parentPath);
            for (HashMap cma : children) {
                if (filter != null && (filter == null || !filter.isPluginVisible(this, cma))) continue;
                LightConfigTreeNode child = new LightConfigTreeNode(cma);
                parent.insert(child, parent.getInsertIndex(child));
                if (!cma.containsKey("_FOLDER_NAME") || cma.containsKey("TYPE")) continue;
                child.add(new DefaultMutableTreeNode(Boolean.TRUE));
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return parent;
    }

    protected void rebuildTree(IConfigServer server, IPluginFilter filter) {
        this.m_filter = filter;
        LightConfigTreeNode rootNode = (LightConfigTreeNode)this.getModel().getRoot();
        rootNode.removeAllChildren();
        this.build(server, filter, rootNode);
        ((DefaultTreeModel)this.getModel()).reload(rootNode);
    }

    public boolean isNodeFolder(DefaultMutableTreeNode node) {
        HashMap map = (HashMap)node.getUserObject();
        return map.containsKey("_FOLDER_NAME");
    }

    public boolean isNodeTyped(DefaultMutableTreeNode node) {
        HashMap map = (HashMap)node.getUserObject();
        return map.containsKey("TYPE");
    }

    public void setRootLabel(String rootLabel) {
        this.m_rootLabel = rootLabel;
        ((DefaultTreeModel)this.getModel()).nodeChanged((TreeNode)this.getModel().getRoot());
    }

    public void setRootIcon(Icon rootIcon) {
        this.m_rootIcon = rootIcon;
        ((DefaultTreeModel)this.getModel()).nodeChanged((TreeNode)this.getModel().getRoot());
    }

    class LightConfigTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Font highlightFont = null;

        LightConfigTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int rowNum, boolean hasFocus) {
            IConfigPluginFactory factory;
            JLabel res = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, rowNum, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            HashMap map = obj instanceof HashMap ? (HashMap)node.getUserObject() : new HashMap();
            String type = (String)map.get("TYPE");
            String cVersion = (String)map.get("CONFIG_VERSION");
            String pVersion = (String)map.get("PRODUCT_VERSION");
            Class<?> objClass = this.getClass();
            if (type != null && (factory = JLightConfigTree.this.m_context.getConfigContext().getPluginFactory(type, cVersion, pVersion)) != null) {
                objClass = factory.getClass();
            }
            Icon icon = type != null ? ResourceManager.getTypeIcon(objClass, type) : UIManager.getIcon(selected ? "Tree.openIcon" : "Tree.closedIcon");
            String templateType = (String)map.get("TEMPLATE_TYPE");
            String name = node.toString();
            Font font = tree.getFont();
            if (templateType != null && templateType.equalsIgnoreCase("prototype")) {
                if (this.highlightFont == null) {
                    this.highlightFont = tree.getFont().deriveFont(3);
                }
                font = this.highlightFont;
            }
            if (node.isRoot()) {
                if (JLightConfigTree.this.m_rootLabel != null) {
                    name = JLightConfigTree.this.m_rootLabel;
                }
                if (JLightConfigTree.this.m_rootIcon != null) {
                    icon = JLightConfigTree.this.m_rootIcon;
                }
            }
            res.setFont(font);
            res.setIcon(icon);
            res.setText(name.substring(name.lastIndexOf(47) + 1));
            return res;
        }
    }

    static class LightConfigTreeNode
    extends DefaultMutableTreeNode {
        public LightConfigTreeNode(String folderName) {
            this.setUserObject(folderName);
        }

        private void setUserObject(String folderName) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("_FOLDER_NAME", folderName);
            this.setUserObject(map);
        }

        public LightConfigTreeNode(HashMap map) {
            super(map);
        }

        public int getInsertIndex(LightConfigTreeNode treeNode) {
            String treeNodeName = treeNode.toString();
            for (int i = 0; i < super.getChildCount(); ++i) {
                TreeNode node = this.getChildAt(i);
                Object aName = null;
                if (Collator.getInstance().compare(treeNodeName, node.toString()) > 0) continue;
                return i;
            }
            return super.getChildCount();
        }

        @Override
        public String toString() {
            HashMap map = (HashMap)this.getUserObject();
            if (map.containsKey("_FOLDER_NAME")) {
                return (String)map.get("_FOLDER_NAME");
            }
            return ((IElementIdentity)map.get("_ELEMENT_IDENTITY")).getName();
        }
    }
}

