/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.config.propsheets.IConfigPanel;
import com.sonicsw.ma.gui.config.propsheets.JConfigDialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.IConfigPath;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import modelobjects.framework.IntToStringConverter;

public class JMetricsPanel
extends JPartitionPanel
implements IConfigPanel {
    public static final IConfigPath DEFAULT_PREFIX = ConfigFactory.createConfigPath((String)"METRICS");
    public static final IConfigPath METRICS_REFRESH_INTERVAL_SECONDS = ConfigFactory.createConfigPath((String)"REFRESH_INTERVAL");
    public static final IConfigPath METRICS_COLLECTION_INTERVAL_MINUTES = ConfigFactory.createConfigPath((String)"COLLECTION_INTERVAL");
    protected JPartitionPanel panel = null;
    private JTextField m_metricsRefreshInterval = new JTextField();
    private JTextField m_metricsCollectionInterval = new JTextField();
    protected IConfigPath m_pathPrefix;
    private String m_borderTitle = null;

    public JMetricsPanel() {
        this("", DEFAULT_PREFIX);
    }

    public JMetricsPanel(IConfigPath pathPrefix) {
        this("", pathPrefix);
    }

    public JMetricsPanel(String borderTitle) {
        this(borderTitle, DEFAULT_PREFIX);
    }

    public JMetricsPanel(String borderTitle, IConfigPath pathPrefix) {
        super(true, "p,r", null);
        this.m_pathPrefix = pathPrefix;
        this.m_borderTitle = borderTitle;
    }

    private IConfigPath getRefreshPath() {
        return ConfigFactory.createConfigPath((IConfigPath)this.m_pathPrefix).append(METRICS_REFRESH_INTERVAL_SECONDS);
    }

    private IConfigPath getCollectionPath() {
        return ConfigFactory.createConfigPath((IConfigPath)this.m_pathPrefix).append(METRICS_COLLECTION_INTERVAL_MINUTES);
    }

    @Override
    public String getTitle() {
        return "Metrics";
    }

    @Override
    public JPanel getPanelComponent() {
        return this;
    }

    @Override
    public void initUI(JConfigDialog dialog) throws Exception {
        this.panel = new JPartitionPanel(this.m_borderTitle);
        this.panel.addRow(dialog.getResourceLabel(this.getRefreshPath()), (JComponent)this.m_metricsRefreshInterval, dialog.getResourceUnit("seconds"));
        this.panel.addRow(dialog.getResourceLabel(this.getCollectionPath()), (JComponent)this.m_metricsCollectionInterval, dialog.getResourceUnit("minutes"));
        this.add(this.panel);
    }

    @Override
    public void initForm(JConfigDialog dialog) throws Exception {
        dialog.createJTextFieldAdapter(this.getRefreshPath(), this.m_metricsRefreshInterval, new IntToStringConverter());
        dialog.createJTextFieldAdapter(this.getCollectionPath(), this.m_metricsCollectionInterval, new IntToStringConverter());
    }

    @Override
    public void cleanup() throws Exception {
    }
}

