/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.JWorkspacePanel;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.action.PastePluginAction;
import com.sonicsw.ma.gui.config.AbstractConfigPlugin;
import com.sonicsw.ma.gui.config.NewConfigurationDialog;
import com.sonicsw.ma.gui.config.propsheets.JConfigDialog;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.SwingWorker;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IConfigPluginFactory;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginFactory;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mx.config.ConfigServerFactory;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigServer;
import java.awt.event.ActionEvent;

public class NewConfigurationAction
extends BasicPluginAction {
    private IConfigPluginFactory m_factory;
    private String m_version;

    public NewConfigurationAction(IPlugin plugin) {
        this(plugin, null, null, "file.new.configuration");
    }

    public NewConfigurationAction(IPlugin plugin, IConfigPluginFactory factory, String version, String resourceName) {
        super(plugin, resourceName);
        this.m_factory = factory;
        this.m_version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
        try {
            if (this.m_factory != null) {
                this.displayPropSheet(this.m_factory, this.m_version, false);
            } else {
                NewConfigurationDialog dialog = new NewConfigurationDialog(this.getPlugin());
                dialog.setVisible(true);
                if (dialog.getCloseCommand() == 0) {
                    if (dialog.isConfigActiveTab()) {
                        Object[] obj = (Object[])dialog.getSelection();
                        if (obj != null) {
                            IConfigPluginFactory factory = (IConfigPluginFactory)obj[0];
                            String productVersion = (String)obj[1];
                            if (factory != null && productVersion != null) {
                                this.displayPropSheet(factory, productVersion, dialog.getIsTemplate());
                            }
                        }
                    } else {
                        this.displayPropSheet((String)dialog.getSelection());
                    }
                }
            }
        }
        finally {
            wc.release();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getPlugin().getPluginContext().getConnectionInfo().isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void displayPropSheet(IPluginFactory factory, String pVersion, boolean isTemplate) {
        IConfigServer server = null;
        try {
            IDirectoryFileSystemService ds = this.getContext().getConnectionInfo().getDirectoryService();
            server = ConfigServerFactory.connectTransactedConfigServer((IDirectoryFileSystemService)ds);
            String name = PastePluginAction.getValidPath(server, ((AbstractGUIPlugin)this.getPlugin())._getPluginPath(), factory.getAttributes().getDisplayType(), PastePluginAction.FORMAT_NEW);
            name = name.substring(name.lastIndexOf(47) + 1);
            IConfigPlugin plugin = (IConfigPlugin)factory.createPlugin(this.getContext(), name, pVersion, null);
            ((AbstractConfigPlugin)plugin).setDummyParentPath(this.getPlugin().getPluginPath());
            ConfigBeanModel model = (ConfigBeanModel)plugin.createModel(server, isTemplate);
            JConfigDialog dialog = (JConfigDialog)plugin.getPropSheetDialog();
            dialog.editInstance(plugin, model, true);
            dialog.setVisible(true);
            if (dialog.getCloseCommand() == -1) {
                plugin.dispose();
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to create configuration", e, true);
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
            }
        }
    }

    protected void displayPropSheet(String templatePath) {
        try {
            WorkspaceWindow workspace = this.getContext().getWorkspace();
            JWorkspacePanel panel = workspace.getSelectedWorkspacePanel();
            boolean oldMode = panel.getTreeExpansionMode();
            panel.setTreeExpansionMode(false);
            IConfigPlugin srcPlugin = (IConfigPlugin)workspace.goToConfiguration(templatePath, true, false);
            panel.setTreeExpansionMode(oldMode);
            new NewInstanceWorker(workspace, srcPlugin, (IConfigPlugin)this.getPlugin()).start();
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to create instance of template", e, true);
        }
    }

    private void logDebugMessage(String value) {
    }

    class NewInstanceWorker
    extends SwingWorker {
        boolean m_cancelled = false;
        WorkspaceWindow m_workspace;
        IConfigServer m_server;
        IConfigPlugin m_srcPlugin;
        IConfigPlugin m_dstPlugin;
        String m_newPath;
        JWaitCursor m_wc;

        public NewInstanceWorker(WorkspaceWindow workspace, IConfigPlugin srcPlugin, IConfigPlugin dstPlugin) throws ConfigServiceException {
            NewConfigurationAction.this.logDebugMessage("NewInstanceWorker::init");
            this.m_workspace = workspace;
            this.m_srcPlugin = srcPlugin;
            this.m_dstPlugin = dstPlugin;
            this.connect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object construct() {
            NewConfigurationAction.this.logDebugMessage("NewInstanceWorker::construct: " + this.m_newPath);
            Helper.invoke(new Runnable(){

                @Override
                public void run() {
                    NewInstanceWorker.this.m_wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
                }
            });
            Exception error = null;
            try {
                IConfigServer iConfigServer = this.m_server;
                synchronized (iConfigServer) {
                    this.m_srcPlugin.copyPlugin(this.m_server, this.m_newPath, Boolean.TRUE);
                }
                if (this.m_server != null && this.m_server.isTransacted()) {
                    this.m_server.commit();
                }
            }
            catch (Exception e) {
                error = e;
            }
            return error;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished() {
            NewConfigurationAction.this.logDebugMessage("finished: " + this.m_cancelled);
            Exception error = (Exception)this.getValue();
            if (!this.m_cancelled && error == null) {
                IConfigServer server = null;
                try {
                    IConfigPluginFactory factory = this.m_srcPlugin.getPluginContext().getLibrary().getChildConfigPluginFactory(this.m_srcPlugin.getAttributes().getType(), this.m_srcPlugin.getAttributes().getConfigVersion(), this.m_srcPlugin.getAttributes().getProductVersion());
                    IConfigPlugin newPlugin = (IConfigPlugin)factory.createPlugin(this.m_srcPlugin.getPluginContext(), this.m_newPath.substring(this.m_newPath.lastIndexOf(47) + 1), this.m_srcPlugin.getAttributes().getProductVersion(), null);
                    ((AbstractConfigPlugin)newPlugin).setDummyParentPath(this.m_newPath.substring(0, this.m_newPath.lastIndexOf(47)));
                    server = this.m_srcPlugin.getPluginContext().getConfigContext().getConfigServer().connectTransacted();
                    IConfigBean mainBean = (IConfigBean)((ConfigBeanModel)newPlugin.getModel()).getData();
                    IConfigBean txnBean = (IConfigBean)server.loadConfigElement(mainBean.getName());
                    ConfigBeanModel txnModel = new ConfigBeanModel(txnBean);
                    JConfigDialog dialog = (JConfigDialog)newPlugin.getPropSheetDialog();
                    dialog.editInstance(newPlugin, txnModel, true);
                    dialog.setVisible(true);
                }
                catch (Exception e) {
                    error = e;
                }
                finally {
                    if (server != null) {
                        try {
                            server.close();
                        }
                        catch (Exception e) {
                            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                        }
                    }
                }
            }
            if (error != null) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to create instance of template", error, true);
            }
            this.disconnect();
        }

        @Override
        public void interrupt() {
            this.m_cancelled = true;
            NewConfigurationAction.this.logDebugMessage("interrupt");
            super.interrupt();
        }

        public final void connect() throws ConfigServiceException {
            NewConfigurationAction.this.logDebugMessage("connect");
            String srcPath = this.m_srcPlugin.getPluginPath();
            String name = srcPath.substring(srcPath.lastIndexOf(47) + 1);
            this.m_server = this.m_srcPlugin.getPluginContext().getConfigContext().getConfigServer().connectTransacted();
            this.m_newPath = PastePluginAction.getValidPath(this.m_server, this.m_dstPlugin.getPluginPath(), name, PastePluginAction.FORMAT_NEW_INSTANCE);
        }

        public void disconnect() {
            NewConfigurationAction.this.logDebugMessage("disconnect");
            if (this.m_server != null) {
                try {
                    this.m_server.close();
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
            }
            this.m_server = null;
            if (this.m_wc != null) {
                this.m_wc.release();
                this.m_wc = null;
            }
        }
    }
}

