/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.JLightConfigTree;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.SwingWorker;
import com.sonicsw.ma.plugin.ConfigFactoryInfo;
import com.sonicsw.ma.plugin.IConfigPluginFactory;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IPluginFactory;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mf.common.config.IElementIdentity;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NewConfigurationDialog
extends JMADialog
implements ChangeListener,
TreeSelectionListener {
    protected IPlugin m_plugin;
    protected JTabbedPane m_tabbedPane;
    protected JTree m_configTree;
    protected JRadioButton m_configRadioButton;
    protected JRadioButton m_templateRadioButton;
    protected JComboBox m_versionCombo;
    protected List m_config;
    protected List m_template;
    protected JLightConfigTree m_tree;
    private boolean m_bInitialized = false;

    public NewConfigurationDialog(IPlugin plugin) {
        super(MgmtConsole.getMgmtConsole(), "new.configuration");
        this.m_plugin = plugin;
    }

    @Override
    protected void maInitialize() {
        if (!this.m_bInitialized) {
            this.m_tabbedPane = new JTabbedPane();
            this.m_tabbedPane.addChangeListener(this);
            this.m_tabbedPane.setBorder(new EmptyBorder(JPartitionPanel.BORDER_SIZE, JPartitionPanel.BORDER_SIZE, 0, JPartitionPanel.BORDER_SIZE));
            this.getContentPane().add(this.m_tabbedPane);
            this.m_tabbedPane.add((Component)this.createConfigTab(), ResourceManager.getString(this.getClass(), "NewConfigurationDialog.ConfigurationsTab"));
            this.m_tabbedPane.add((Component)this.createConfigFromTemplateTab(), ResourceManager.getString(this.getClass(), "NewConfigurationDialog.TemplatesTab"));
            super.getContentPane().add((Component)this.createButtonPanel(this.getButtonActions()), "South");
            this.m_bInitialized = true;
        }
    }

    @Override
    protected void maCleanup() {
    }

    private JPanel createConfigTab() {
        JPartitionPanel outerPanel = new JPartitionPanel(true, "p,r", null, 0, 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPartitionPanel groupBoxPanel = new JPartitionPanel(false, "p,p", ResourceManager.getString(this.getClass(), "NewConfigurationDialog.ConfigGroupBox"));
        outerPanel.add(groupBoxPanel);
        this.m_configRadioButton = new JRadioButton(ResourceManager.getString(this.getClass(), "NewConfigurationDialog.ConfigRadioButton"));
        groupBoxPanel.add(this.m_configRadioButton);
        buttonGroup.add(this.m_configRadioButton);
        this.m_templateRadioButton = new JRadioButton(ResourceManager.getString(this.getClass(), "NewConfigurationDialog.TemplateRadioButton"));
        groupBoxPanel.add(this.m_templateRadioButton);
        buttonGroup.add(this.m_templateRadioButton);
        ConfigItemListener itemListener = new ConfigItemListener();
        this.m_configRadioButton.addItemListener(itemListener);
        this.m_templateRadioButton.addItemListener(itemListener);
        JPartitionPanel listPanel = new JPartitionPanel(true, "p,r,p", null);
        outerPanel.add(listPanel);
        listPanel.add(new JLabel(ResourceManager.getString(this.getClass(), "NewConfigurationDialog.SelectConfigLabel")));
        this.createConfigTree();
        listPanel.add(new ExtendedJScrollPane(this.m_configTree));
        this.m_versionCombo = new JComboBox();
        JPartitionPanel versionPanel = new JPartitionPanel(false, "p, r", null);
        versionPanel.addRow("Product Version:", (JComponent)this.m_versionCombo);
        listPanel.add(versionPanel);
        return outerPanel;
    }

    private void createConfigTree() {
        this.m_configTree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.m_configTree.setRootVisible(false);
        this.m_configTree.setShowsRootHandles(true);
        this.m_configTree.setCellRenderer(new NewConfigTreeCellRenderer());
        this.m_configTree.getSelectionModel().setSelectionMode(1);
        this.m_configTree.addTreeSelectionListener(this);
        this.m_configTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JButton button;
                BasicAction action;
                if (evt.getClickCount() == 2 && (action = NewConfigurationDialog.this.getDefaultOKAction()) != null && (button = ((JButtonPanel)NewConfigurationDialog.this.getButtonPanel()).getButton((String)action.getValue("ActionCommandKey"))) != null) {
                    button.doClick();
                }
            }
        });
        SwingWorker sw = new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object construct() {
                JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
                try {
                    NewConfigurationDialog.this.m_config = NewConfigurationDialog.this.getConfigList(false);
                    NewConfigurationDialog.this.m_template = NewConfigurationDialog.this.getConfigList(true);
                }
                finally {
                    wc.release();
                }
                return null;
            }

            @Override
            public void finished() {
                if (NewConfigurationDialog.this.m_configRadioButton != null) {
                    NewConfigurationDialog.this.m_configRadioButton.setSelected(true);
                }
            }
        };
        sw.start();
        this.getDefaultOKAction().setEnabled(false);
    }

    @Override
    protected JPanel createButtonPanel(Action[] action) {
        return this.m_tabbedPane != null ? super.createButtonPanel(action) : null;
    }

    private List getConfigList(boolean template) {
        ArrayList res = new ArrayList();
        HashMap factories = this.m_plugin.getPluginContext().getLibrary().getConfigRootFactoryMap();
        Map productMap = this.buildProductFamilyMap(factories);
        for (String key : factories.keySet()) {
            List list = (List)factories.get(key);
            for (int i = 0; i < list.size(); ++i) {
                ConfigFactoryInfo info = (ConfigFactoryInfo)list.get(i);
                String productFamilyType = (String)productMap.get(key);
                if (productFamilyType == null) {
                    productFamilyType = "Unknown";
                }
                Iterator iter2 = info.getChildFactoryMap().values().iterator();
                while (iter2.hasNext()) {
                    this.addFactory(res, template, productFamilyType, (IPluginFactory)iter2.next());
                }
            }
        }
        return res;
    }

    private void addFactory(List factoryList, boolean template, String productFamily, IPluginFactory factory) {
        PluginAttributes attributes = factory.getAttributes();
        if (!attributes.isCreatable() || template && (!template || !attributes.isTemplatable())) {
            return;
        }
        boolean added = false;
        for (ConfigTypeInfo info : factoryList) {
            if (!info.addFactory(factory)) continue;
            added = true;
            break;
        }
        if (!added) {
            factoryList.add(new ConfigTypeInfo(productFamily, factory));
        }
    }

    private Map buildProductFamilyMap(Map cfiMap) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String productType : cfiMap.keySet()) {
            List list = (List)cfiMap.get(productType);
            for (int j = 0; j < list.size(); ++j) {
                ConfigFactoryInfo cfi = (ConfigFactoryInfo)list.get(j);
                String productFamilyType = cfi.getRootFactory().getAttributes().getProductFamilyId();
                if (productFamilyType == null) continue;
                if (res.containsKey(productType) && !res.get(productType).equals(productFamilyType)) {
                    System.err.println("Product Family Type for '" + productType + "' is not consistent across versions!");
                }
                res.put(productType, productFamilyType);
            }
        }
        return res;
    }

    private void rebuildTreeModel(DefaultTreeModel model, List ctiList) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)model.getRoot();
        rootNode.removeAllChildren();
        for (ConfigTypeInfo cti : ctiList) {
            DefaultMutableTreeNode productNode = NewConfigurationDialog.findProductNode(rootNode, cti.m_productDisplayType);
            if (productNode == null) {
                ConfigTypeInfo ctiProduct = new ConfigTypeInfo(cti.m_productDisplayType);
                productNode = new DefaultMutableTreeNode(ctiProduct);
                rootNode.insert(productNode, this.findInsertIndex(rootNode, ctiProduct));
            }
            productNode.insert(new DefaultMutableTreeNode(cti), this.findInsertIndex(productNode, cti));
            if (!cti.isPrimaryConfiguration()) continue;
            rootNode.insert(new DefaultMutableTreeNode(cti), this.findInsertIndex(rootNode, cti));
        }
        model.nodeStructureChanged(rootNode);
    }

    static final DefaultMutableTreeNode findProductNode(DefaultMutableTreeNode rootNode, String product) {
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            ConfigTypeInfo childInfo = (ConfigTypeInfo)childNode.getUserObject();
            if (childInfo == null || !childInfo.isProduct() || !childInfo.toString().equals(product)) continue;
            return childNode;
        }
        return null;
    }

    static final DefaultMutableTreeNode findNodeWithName(DefaultMutableTreeNode parentNode, String name) {
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            ConfigTypeInfo childInfo = (ConfigTypeInfo)childNode.getUserObject();
            if (childInfo == null || !childInfo.toString().equals(name)) continue;
            return childNode;
        }
        return null;
    }

    private int findInsertIndex(DefaultMutableTreeNode parentNode, ConfigTypeInfo cti) {
        int res = parentNode.getChildCount();
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            ConfigTypeInfo childInfo = (ConfigTypeInfo)childNode.getUserObject();
            if (cti.isPrimaryConfiguration() && childInfo.isProduct()) {
                return i;
            }
            if (cti.isProduct() && childInfo.isPrimaryConfiguration() || cti.toString().compareTo(childInfo.toString()) >= 0) continue;
            return i;
        }
        return res;
    }

    private JPanel createConfigFromTemplateTab() {
        JPartitionPanel panel = new JPartitionPanel(true, "p,r", null);
        panel.add(new JLabel(ResourceManager.getString(this.getClass(), "NewConfigurationDialog.SelectTemplateLabel")));
        this.m_tree = this.createTemplateTree();
        panel.add(new ExtendedJScrollPane(this.m_tree));
        return panel;
    }

    private JLightConfigTree createTemplateTree() {
        IPluginContext context = this.m_plugin.getPluginContext();
        JLightConfigTree tree = new JLightConfigTree(context, context.getConfigContext().getConfigServer(), "/", new TemplateFilter());
        tree.setRootLabel("Configured Objects");
        tree.setRootIcon(ResourceManager.getTypeIcon("ConfigDomain"));
        tree.expandRow(0);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(this);
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    JButton button;
                    TreePath path = NewConfigurationDialog.this.m_tree.getPathForLocation(evt.getX(), evt.getY());
                    if (path == null || !((TreeNode)path.getLastPathComponent()).isLeaf()) {
                        return;
                    }
                    BasicAction action = NewConfigurationDialog.this.getDefaultOKAction();
                    if (action != null && (button = ((JButtonPanel)NewConfigurationDialog.this.getButtonPanel()).getButton((String)action.getValue("ActionCommandKey"))) != null) {
                        button.doClick();
                    }
                }
            }
        });
        return tree;
    }

    public boolean isConfigActiveTab() {
        return this.m_tabbedPane.getSelectedIndex() == 0;
    }

    public Object getSelection() {
        if (this.isConfigActiveTab()) {
            FactoryVersionInfo versions = (FactoryVersionInfo)this.m_versionCombo.getSelectedItem();
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.m_configTree.getSelectionPath().getLastPathComponent();
            ConfigTypeInfo cti = (ConfigTypeInfo)selNode.getUserObject();
            for (int i = 0; i < cti.m_factory.size(); ++i) {
                IPluginFactory factory = (IPluginFactory)cti.m_factory.get(i);
                if (!factory.getAttributes().getConfigVersion().equals(versions.m_cVersion)) continue;
                return new Object[]{factory, versions.m_pVersion};
            }
            return null;
        }
        return this.m_tree.getSelectionPath().getLastPathComponent().toString();
    }

    public boolean getIsTemplate() {
        return this.m_templateRadioButton.isSelected();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (this.isConfigActiveTab()) {
            this.enableConfigTabButtons();
        } else {
            this.enableTemplateTabButtons();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        if (event.getSource() == this.m_tree) {
            this.enableTemplateTabButtons();
        } else if (event.getSource() == this.m_configTree) {
            this.enableConfigTabButtons();
        }
    }

    protected void enableConfigTabButtons() {
        TreePath selPath = this.m_configTree.getSelectionPath();
        DefaultMutableTreeNode selNode = selPath != null ? (DefaultMutableTreeNode)selPath.getLastPathComponent() : null;
        ConfigTypeInfo cti = selNode != null ? (ConfigTypeInfo)selNode.getUserObject() : null;
        this.updateVersionCombo(cti);
        this.getDefaultOKAction().setEnabled(!this.m_configTree.isSelectionEmpty() && cti != null && !cti.isProduct());
    }

    private void updateVersionCombo(ConfigTypeInfo cti) {
        boolean hasVersion = cti != null && !cti.isProduct();
        this.m_versionCombo.setEnabled(hasVersion);
        if (hasVersion) {
            ArrayList<FactoryVersionInfo> vList = new ArrayList<FactoryVersionInfo>();
            for (int i = 0; i < cti.m_factory.size(); ++i) {
                IPluginFactory factory = (IPluginFactory)cti.m_factory.get(i);
                String[] pVersions = factory.getAttributes().getProductVersions();
                String cVersion = factory.getAttributes().getConfigVersion();
                for (int j = 0; j < pVersions.length; ++j) {
                    vList.add(new FactoryVersionInfo(cVersion, pVersions[j]));
                }
            }
            Collections.sort(vList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    FactoryVersionInfo fvi1 = (FactoryVersionInfo)o1;
                    FactoryVersionInfo fvi2 = (FactoryVersionInfo)o2;
                    float f1 = Float.parseFloat(fvi1.m_pVersion);
                    float f2 = Float.parseFloat(fvi2.m_pVersion);
                    return Float.compare(f2, f1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj == this;
                }

                public int hashCode() {
                    return super.hashCode();
                }
            });
            this.m_versionCombo.setModel(new DefaultComboBoxModel(new Vector(vList)));
        } else {
            this.m_versionCombo.removeAllItems();
            this.m_versionCombo.addItem("None");
        }
    }

    protected void enableTemplateTabButtons() {
        if (this.m_tree.isSelectionEmpty()) {
            this.getDefaultOKAction().setEnabled(false);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
            HashMap map = (HashMap)node.getUserObject();
            boolean enable = map.containsKey("TYPE");
            this.getDefaultOKAction().setEnabled(enable);
        }
    }

    class NewConfigTreeCellRenderer
    extends DefaultTreeCellRenderer {
        NewConfigTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            ConfigTypeInfo cti = (ConfigTypeInfo)((DefaultMutableTreeNode)value).getUserObject();
            if (cti != null && !cti.isProduct()) {
                ConfigTypeInfo parentCti;
                IConfigPluginFactory factory = (IConfigPluginFactory)cti.m_factory.get(0);
                PluginAttributes attr = factory.getAttributes();
                String strType = attr.getType();
                Icon icon = ResourceManager.getTypeIcon(factory.getClass(), strType);
                if (cti.isPrimaryConfiguration() && (parentCti = this.getParentInfo((DefaultMutableTreeNode)value)) == null) {
                    icon = new ExtendedImageIcon(icon, ResourceManager.getTypeIcon(this.getClass(), "Shortcut"));
                    this.setText("Shortcut to " + this.getText());
                }
                this.setIcon(icon);
            }
            return this;
        }

        private ConfigTypeInfo getParentInfo(DefaultMutableTreeNode node) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            return (ConfigTypeInfo)parentNode.getUserObject();
        }
    }

    class TemplateFilter
    implements IPluginFilter {
        TemplateFilter() {
        }

        @Override
        public boolean isPluginVisible(Object destination, Object pluginData) {
            try {
                HashMap map = (HashMap)pluginData;
                String type = (String)map.get("TYPE");
                String cVersion = (String)map.get("CONFIG_VERSION");
                String pVersion = (String)map.get("PRODUCT_VERSION");
                String name = (String)map.get("_FOLDER_NAME");
                if (name != null && type == null && cVersion == null) {
                    return true;
                }
                if (name == null) {
                    name = ((IElementIdentity)map.get("_ELEMENT_IDENTITY")).getName();
                }
                if ((name = name.substring(name.lastIndexOf(47) + 1)).startsWith("_")) {
                    return false;
                }
                IConfigPluginFactory factory = NewConfigurationDialog.this.m_plugin.getPluginContext().getConfigContext().getPluginFactory(type, cVersion, pVersion);
                if (factory == null) {
                    return false;
                }
                if (!factory.getAttributes().isCreatable()) {
                    return false;
                }
                String templateType = (String)map.get("TEMPLATE_TYPE");
                if (templateType != null && templateType.equalsIgnoreCase("prototype")) {
                    return true;
                }
            }
            catch (Exception e) {
                MgmtConsole.displayMessage(4, "Error filtering components", e, false);
            }
            return false;
        }
    }

    static class ConfigTypeInfo {
        List m_factory = null;
        String m_productDisplayType;
        String m_configDisplayType;
        boolean m_product = false;

        public ConfigTypeInfo(String productDisplayType) {
            this.m_productDisplayType = productDisplayType;
            this.m_product = true;
        }

        public ConfigTypeInfo(String productDisplayType, IPluginFactory factory) {
            this.m_productDisplayType = productDisplayType;
            this.addFactory(factory);
        }

        public final boolean addFactory(IPluginFactory factory) {
            boolean res = true;
            if (this.m_factory == null) {
                this.m_factory = new ArrayList();
                this.m_factory.add(factory);
            } else {
                IPluginFactory f = (IPluginFactory)this.m_factory.get(0);
                if (f.getAttributes().getType().equals(factory.getAttributes().getType())) {
                    this.m_factory.add(factory);
                } else {
                    res = false;
                }
            }
            return res;
        }

        public String getDisplayType() {
            if (this.m_factory == null || this.m_factory.isEmpty()) {
                return null;
            }
            IPluginFactory f = (IPluginFactory)this.m_factory.get(0);
            return f.getAttributes().getDisplayType();
        }

        public boolean isProduct() {
            return this.m_product;
        }

        public String toString() {
            return this.isProduct() ? this.m_productDisplayType : this.getDisplayType();
        }

        public boolean isPrimaryConfiguration() {
            Iterator i;
            Iterator iterator = i = this.m_factory != null ? this.m_factory.iterator() : Collections.EMPTY_LIST.iterator();
            while (i.hasNext()) {
                IPluginFactory f = (IPluginFactory)i.next();
                if (!f.getAttributes().isPrimaryConfiguration()) continue;
                return true;
            }
            return false;
        }
    }

    public static class FactoryVersionInfo {
        String m_cVersion;
        String m_pVersion;

        public FactoryVersionInfo(String cVersion, String pVersion) {
            this.m_cVersion = cVersion;
            this.m_pVersion = pVersion;
        }

        public String toString() {
            return this.m_pVersion;
        }
    }

    class ConfigItemListener
    implements ItemListener {
        ConfigItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() != 1) {
                return;
            }
            String[] expanded = this.getExpandedProducts(NewConfigurationDialog.this.m_configTree);
            String[] selPath = this.getSelectedNodes(NewConfigurationDialog.this.m_configTree);
            NewConfigurationDialog.this.rebuildTreeModel((DefaultTreeModel)NewConfigurationDialog.this.m_configTree.getModel(), evt.getItem() == NewConfigurationDialog.this.m_configRadioButton ? NewConfigurationDialog.this.m_config : NewConfigurationDialog.this.m_template);
            this.setExpandedProducts(NewConfigurationDialog.this.m_configTree, expanded);
            this.setSelectedNodes(NewConfigurationDialog.this.m_configTree, selPath);
        }

        private String[] getSelectedNodes(JTree tree) {
            ArrayList<String> res = new ArrayList<String>();
            TreePath[] selPath = tree.getSelectionPaths();
            if (selPath != null) {
                for (int i = 0; i < selPath.length; ++i) {
                    TreePath path = selPath[i];
                    StringBuffer sb = new StringBuffer();
                    for (int j = 0; j < path.getPathCount(); ++j) {
                        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)path.getPathComponent(j);
                        if (aNode.isRoot()) {
                            sb.append("<root>");
                            continue;
                        }
                        sb.append(".").append(aNode.toString());
                    }
                    res.add(sb.toString());
                }
            }
            return res.toArray(new String[0]);
        }

        private void setSelectedNodes(JTree tree, String[] path) {
            ArrayList<TreePath> res = new ArrayList<TreePath>();
            if (path != null) {
                DefaultMutableTreeNode node = null;
                for (int i = 0; i < path.length; ++i) {
                    StringTokenizer st = new StringTokenizer(path[i], ".");
                    node = (DefaultMutableTreeNode)tree.getModel().getRoot();
                    while (st.hasMoreTokens()) {
                        String c = st.nextToken().trim();
                        if (c.equals("<root>") || node == null) continue;
                        node = NewConfigurationDialog.findNodeWithName(node, c);
                    }
                    if (node == null) continue;
                    res.add(new TreePath(node.getPath()));
                }
            }
            TreePath[] selPath = res.toArray(new TreePath[0]);
            tree.setSelectionPaths(selPath);
        }

        private String[] getExpandedProducts(JTree tree) {
            ArrayList<String> res = new ArrayList<String>();
            Enumeration<TreePath> en = tree.getExpandedDescendants(new TreePath(tree.getModel().getRoot()));
            while (en != null && en.hasMoreElements()) {
                TreePath path = en.nextElement();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                ConfigTypeInfo cti = (ConfigTypeInfo)node.getUserObject();
                if (cti == null) continue;
                res.add(cti.toString());
            }
            return res.toArray(new String[0]);
        }

        private void setExpandedProducts(JTree tree, String[] productName) {
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            for (int i = 0; i < productName.length; ++i) {
                DefaultMutableTreeNode productNode = NewConfigurationDialog.findProductNode((DefaultMutableTreeNode)tree.getModel().getRoot(), productName[i]);
                if (productNode == null) continue;
                NewConfigurationDialog.this.m_configTree.expandPath(new TreePath(productNode.getPath()));
            }
        }
    }
}

