/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config.metrics;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.metrics.model.MetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.AlertsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.IAlertsProvider;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceNode;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceParentNode;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AlertsDialog
extends JMADialog {
    private MetricsModel m_metricsModel;
    private AbstractNode m_node;
    protected JPanel m_panel;
    private JTextField m_highThresholds;
    private JTextField m_lowThresholds;
    private JTextField m_parentHighThresholds;
    private JTextField m_parentLowThresholds;
    private AlertsModel m_alertsModel;
    private AlertsModel m_parentAlertsModel;
    private static final Long[] EMPTY_LONG_ARRAY = new Long[0];

    public AlertsDialog(JMADialog parent, MetricsModel metricsModel, AbstractNode node) {
        super(parent, "metrics.alerts.setting");
        this.m_metricsModel = metricsModel;
        this.m_node = node;
        this.setTitle();
        this.m_alertsModel = ((IAlertsProvider)((Object)node)).getAlertsModel();
    }

    private void setTitle() {
        this.setTitle(this.getTitle() + " - " + this.m_metricsModel.getComponentName().toString());
    }

    @Override
    protected void maInitialize() {
        this.getContentPane().add(JPartitionPanel.wrap(this.makeMainPanel()));
        this.m_highThresholds.setText(this.thresholdsListToThresholdsString(this.m_alertsModel.getHighThresholdValues()));
        this.m_lowThresholds.setText(this.thresholdsListToThresholdsString(this.m_alertsModel.getLowThresholdValues()));
        if (this.m_parentAlertsModel != null) {
            this.m_parentHighThresholds.setText(this.thresholdsListToThresholdsString(this.m_parentAlertsModel.getHighThresholdValues()));
            this.m_parentLowThresholds.setText(this.thresholdsListToThresholdsString(this.m_parentAlertsModel.getLowThresholdValues()));
        }
    }

    @Override
    public Action[] getButtonActions() {
        ArrayList<BasicAction> list = new ArrayList<BasicAction>();
        list.add(new OKAction());
        list.add(this.getDefaultCancelAction());
        return list.toArray(new Action[list.size()]);
    }

    @Override
    protected void maCleanup() {
        this.m_metricsModel = null;
        this.m_node = null;
    }

    private JPanel makeMainPanel() {
        IMetricInfo info = (IMetricInfo)(this.m_node instanceof InstanceNode ? ((InstanceParentNode)this.m_node.getParent()).getUserObject() : this.m_node.getUserObject());
        this.m_highThresholds = new JTextField(30);
        if (!info.supportsHighThresholdAlerts()) {
            this.m_highThresholds.setEditable(false);
        }
        this.m_lowThresholds = new JTextField(30);
        if (!info.supportsLowThresholdAlerts()) {
            this.m_lowThresholds.setEditable(false);
        }
        if (this.m_parentAlertsModel != null) {
            this.m_parentHighThresholds = new JTextField(30);
            this.m_parentHighThresholds.setEditable(false);
            this.m_parentLowThresholds = new JTextField(30);
            this.m_parentLowThresholds.setEditable(false);
        }
        JPartitionPanel panel = new JPartitionPanel(false, "p,r", "Comma-delimited Threshold(s)");
        panel.addRow("High Threshold(s)", (JComponent)this.m_highThresholds);
        if (this.m_parentAlertsModel != null) {
            panel.addRow("Parent High Threshold(s)", (JComponent)this.m_parentHighThresholds);
        }
        panel.addRow("Low Threshold(s)", (JComponent)this.m_lowThresholds);
        if (this.m_parentAlertsModel != null) {
            panel.addRow("Parent Low Threshold(s)", (JComponent)this.m_parentLowThresholds);
        }
        return panel;
    }

    private String thresholdsListToThresholdsString(List data) {
        Collections.sort(data);
        StringBuffer values = new StringBuffer("");
        if (data == null) {
            return values.toString();
        }
        for (int i = 0; i < data.size(); ++i) {
            values.append(data.get(i)).append(",");
        }
        String result = values.toString();
        return result.length() == 0 ? result : result.substring(0, result.length() - 1);
    }

    private ArrayList thresholdsStringToThresholdsList(String data) throws Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        StringTokenizer st = new StringTokenizer(data, ", ");
        while (st.hasMoreTokens()) {
            String value = st.nextToken();
            try {
                list.add(Long.valueOf(value));
            }
            catch (NumberFormatException e) {
                throw new Exception("Invalid threshold value: " + value);
            }
        }
        return list;
    }

    private void updateAlerts() throws Exception {
        int i;
        ArrayList highThresholds = null;
        ArrayList lowThresholds = null;
        ArrayList highThresholdsDelta = null;
        ArrayList lowThresholdsDelta = null;
        Long[] existingHighThresholds = this.m_alertsModel.getHighThresholdValues().toArray(EMPTY_LONG_ARRAY);
        Long[] existingLowThresholds = this.m_alertsModel.getLowThresholdValues().toArray(EMPTY_LONG_ARRAY);
        highThresholds = this.m_highThresholds.isEnabled() ? this.thresholdsStringToThresholdsList(this.m_highThresholds.getText()) : new ArrayList();
        lowThresholds = this.m_lowThresholds.isEnabled() ? this.thresholdsStringToThresholdsList(this.m_lowThresholds.getText()) : new ArrayList();
        highThresholdsDelta = new ArrayList();
        if (this.m_highThresholds.isEnabled()) {
            for (i = 0; i < existingHighThresholds.length; ++i) {
                if (highThresholds.contains(existingHighThresholds[i])) continue;
                highThresholdsDelta.add(existingHighThresholds[i]);
            }
        }
        lowThresholdsDelta = new ArrayList();
        if (this.m_lowThresholds.isEnabled()) {
            for (i = 0; i < existingLowThresholds.length; ++i) {
                if (lowThresholds.contains(existingLowThresholds[i])) continue;
                lowThresholdsDelta.add(existingLowThresholds[i]);
            }
        }
        if (!highThresholdsDelta.isEmpty() || !lowThresholdsDelta.isEmpty()) {
            this.m_metricsModel.disableAlerts(this.m_node, highThresholdsDelta.toArray(EMPTY_LONG_ARRAY), lowThresholdsDelta.toArray(EMPTY_LONG_ARRAY));
        }
        if (this.m_highThresholds.isEnabled()) {
            for (i = 0; i < existingHighThresholds.length; ++i) {
                highThresholds.remove(existingHighThresholds[i]);
            }
            highThresholdsDelta = highThresholds;
        } else {
            highThresholdsDelta = new ArrayList();
        }
        if (this.m_lowThresholds.isEnabled()) {
            for (i = 0; i < existingLowThresholds.length; ++i) {
                lowThresholds.remove(existingLowThresholds[i]);
            }
            lowThresholdsDelta = lowThresholds;
        } else {
            lowThresholdsDelta = new ArrayList();
        }
        if (!highThresholdsDelta.isEmpty() || !lowThresholdsDelta.isEmpty()) {
            this.m_metricsModel.enableAlerts(this.m_node, highThresholdsDelta.toArray(EMPTY_LONG_ARRAY), lowThresholdsDelta.toArray(EMPTY_LONG_ARRAY));
        }
    }

    private class OKAction
    extends BasicGuiAction {
        public OKAction() {
            super("dialog.ok", AlertsDialog.this.getDefaultOKAction());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                AlertsDialog.this.updateAlerts();
                super.actionPerformed(evt);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, e.getMessage(), e, true);
            }
        }
    }
}

