/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config.metrics;

import com.sonicsw.ma.gui.config.metrics.InstanceEnablementSheet;
import com.sonicsw.ma.gui.config.metrics.model.MetricsModel;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.plugin.IPlugin;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

final class InstancePickSheet
extends JMADialog {
    private static final String SYSTEM_INSTANCE = "sonicmq.";
    private static final String TYPE_BROKER = "MQ_BROKER";
    private static final String TEMP_INSTANCE = "$ISYS.USERS.TemporaryQueues";
    private JTextField m_tfPattern = new JTextField();
    private JRadioButton m_btnPattern = new JRadioButton("<html>By defining a pattern that matches one or more instances</html>");
    private JRadioButton m_btnAll = new JRadioButton("<html>Enable all instance pattern metrics of this type</html>");
    private MetricsModel m_model;

    public InstancePickSheet(JMADialog parent, MetricsModel m_model) {
        super(parent, "metrics.pattern.pick");
        this.m_model = m_model;
    }

    private InstanceEnablementSheet getEnablementSheet() {
        return (InstanceEnablementSheet)this.getParent();
    }

    @Override
    public void maInitialize() {
        this.getContentPane().add(this.makePanel());
    }

    @Override
    public void maCleanup() {
    }

    @Override
    public Action[] getButtonActions() {
        return new Action[]{new OKAction(), this.getDefaultCancelAction()};
    }

    private JPanel makePanel() {
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.m_btnAll);
        btnGroup.add(this.m_btnPattern);
        this.m_btnAll.setVerticalTextPosition(1);
        this.m_btnPattern.setVerticalTextPosition(1);
        JPartitionPanel panel = new JPartitionPanel(true, "p,p,p,r", null, 5, 5, 5);
        panel.setBorder(panel.getPreferredBorder());
        panel.add(new JLabel("Add an instance pattern:"));
        panel.add(this.makeAllPanel());
        panel.add(this.makePatternPanel());
        this.m_tfPattern.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                InstancePickSheet.this.m_btnPattern.setSelected(true);
                InstancePickSheet.this.enableButtons();
            }
        });
        ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                InstancePickSheet.this.enableButtons();
            }
        };
        this.m_btnPattern.addChangeListener(cl);
        this.m_btnAll.addChangeListener(cl);
        this.m_btnAll.setSelected(true);
        this.m_tfPattern.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent evt) {
                InstancePickSheet.this.enableButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                InstancePickSheet.this.enableButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                InstancePickSheet.this.enableButtons();
            }
        });
        return panel;
    }

    private JPanel makeAllPanel() {
        JPartitionPanel panel = new JPartitionPanel(false, "r", null, 0, 0, 0);
        panel.add(this.m_btnAll);
        return panel;
    }

    private JPanel makePatternPanel() {
        JPartitionPanel panel = new JPartitionPanel(true, "r,r", null, 0, 0, 0);
        JPartitionPanel insetPanel = new JPartitionPanel(false, "p,p,r", null);
        insetPanel.add(new JLabel());
        insetPanel.add(new JLabel());
        insetPanel.add(new JLabel("e.g. Sample*"));
        insetPanel.add(new JPanel());
        insetPanel.add(new JLabel("Pattern: "));
        insetPanel.add(this.m_tfPattern);
        panel.add(this.m_btnPattern);
        panel.add(insetPanel);
        return panel;
    }

    private boolean isValidSource() {
        String type = "";
        if (this.m_model.getSource() instanceof IPlugin) {
            IPlugin plugin = (IPlugin)this.m_model.getSource();
            type = plugin.getAttributes().getType();
        }
        return TYPE_BROKER.equals(type);
    }

    private void enableButtons() {
        boolean enable = false;
        if (this.m_btnPattern.isSelected()) {
            enable = this.m_tfPattern.getText().trim().length() > 0;
        } else if (this.m_btnAll.isSelected()) {
            enable = true;
        }
        this.getOKButton().setEnabled(enable);
    }

    private JButton getOKButton() {
        return ((JButtonPanel)this.getButtonPanel()).getButton("dialog.ok");
    }

    private class OKAction
    extends BasicGuiAction {
        public OKAction() {
            super("dialog.ok", InstancePickSheet.this.getDefaultOKAction());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String[] value = null;
            if (InstancePickSheet.this.m_btnPattern.isSelected()) {
                value = new String[]{InstancePickSheet.this.m_tfPattern.getText().trim()};
            } else if (InstancePickSheet.this.m_btnAll.isSelected()) {
                value = new String[]{"*"};
            }
            if (value != null) {
                InstancePickSheet.this.getEnablementSheet().addPattern(value);
            }
            super.actionPerformed(evt);
        }
    }
}

