/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config.metrics.model;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.runtime.metrics.model.AbstractMetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.AlertsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.IAlertsProvider;
import com.sonicsw.ma.gui.runtime.metrics.model.IValueListener;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceNode;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceParentNode;
import com.sonicsw.ma.gui.runtime.metrics.model.Node;
import com.sonicsw.ma.gui.runtime.metrics.model.ParentNode;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;
import com.sonicsw.ma.plugin.IConfigMetricPlugin;
import com.sonicsw.ma.plugin.IMonitorPlugin;
import com.sonicsw.mf.common.metrics.IAlert;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.impl.MetricIdentity;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mx.util.ICollationKeyProvider;
import com.sonicsw.mx.util.Sorter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import javax.swing.tree.TreeNode;

public class MetricsModel
extends AbstractMetricsModel {
    private static final Long[] EMPTY_LONG_ARRAY = new Long[0];
    public static final int DISABLE_INSTANCE_NONE = 0;
    public static final int DISABLE_INSTANCE_ALL = 1;
    public static final int DISABLE_INSTANCE_WILDCARD = 2;
    private boolean m_hasMetricAlertsSupport = false;
    private boolean m_hasInstanceMetrics = false;
    private IMonitorPlugin source = null;

    public MetricsModel(IRemoteMBeanServer connector, ObjectName componentName, IMetricInfo[] infos) throws Exception {
        super(connector, componentName, infos);
        this.update(infos);
    }

    @Override
    public final void update(IMetricInfo[] info) {
        Sorter.sort((Object[])info, (ICollationKeyProvider)this, (int)info.length);
        Enumeration<TreeNode> en = this.m_treeRootNode.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            AbstractNode node = (AbstractNode)en.nextElement();
            if (node == this.m_treeRootNode) continue;
            String name = null;
            name = node instanceof Node || node instanceof InstanceParentNode ? ((IMetricInfo)node.getUserObject()).getMetricIdentity().getName() : ((IMetricIdentity)node.getUserObject()).getName();
            if (this.inList(info, name)) continue;
            try {
                this.disableMetric(node);
            }
            catch (Exception e) {
                e.printStackTrace();
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
        }
        this.constructTree(info);
    }

    private boolean inList(IMetricInfo[] list, String metricName) {
        boolean found = false;
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getMetricIdentity().getName().startsWith(metricName)) continue;
            found = true;
            break;
        }
        return found;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(IMonitorPlugin source) {
        this.source = source;
    }

    public void enableMetric(AbstractNode node) throws Exception {
        HashSet ids = new HashSet();
        this.setIdentities(node, ids, true, 0);
        IMetricIdentity[] metricIds = ids.toArray(new IMetricIdentity[ids.size()]);
        ((IConfigMetricPlugin)this.source).updateMetrics(true, metricIds);
        this.refreshTree();
        node.setEnabled(true);
        node.setParentEnabled();
        for (AbstractNode changeNode = node; changeNode != this.m_treeRootNode; changeNode = (AbstractNode)changeNode.getParent()) {
            super.nodeChanged(changeNode);
        }
        Enumeration<TreeNode> en = node.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            AbstractNode descendant = (AbstractNode)en.nextElement();
            super.nodeChanged(descendant);
        }
        super.nodeChanged(node);
    }

    private void setLeafNodeStates(AbstractNode node, HashSet enabledExactPatterns, HashSet activeMetrics, HashMap enabledAlertsSets) {
        if (node instanceof Node) {
            IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
            boolean enabled = activeMetrics.remove(metricId);
            ((Node)node).setEnabled(enabled);
            this.addAlerts(node, metricId, enabledAlertsSets);
        } else if (node instanceof ParentNode) {
            Enumeration<TreeNode> en = ((ParentNode)node).children();
            while (en.hasMoreElements()) {
                this.setLeafNodeStates((AbstractNode)en.nextElement(), enabledExactPatterns, activeMetrics, enabledAlertsSets);
            }
        } else if (node instanceof InstanceNode) {
            if (!activeMetrics.remove(node.getUserObject()) && !enabledExactPatterns.remove(node.getUserObject())) {
                node.removeFromParent();
            }
        } else if (node instanceof InstanceParentNode) {
            node.removeAllChildren();
            IMetricIdentity parentId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
            this.addAlerts(node, parentId, enabledAlertsSets);
            HashMap children = new HashMap();
            this.buildInstanceNodes(node, parentId, children, enabledExactPatterns, false);
            this.buildInstanceNodes(node, parentId, children, activeMetrics, true);
            if (!children.isEmpty()) {
                Object[] nodes = Sorter.sort((Object[])children.values().toArray(), (ICollationKeyProvider)this, (int)children.size());
                for (int i = 0; i < nodes.length; ++i) {
                    IMetricIdentity metricId = (IMetricIdentity)((InstanceNode)nodes[i]).getUserObject();
                    node.add((InstanceNode)nodes[i]);
                    this.addAlerts((InstanceNode)nodes[i], metricId, enabledAlertsSets);
                }
                node.setEnabled(true);
                node.setParentEnabled();
            }
            this.nodeStructureChanged(node);
        }
    }

    private void buildInstanceNodes(AbstractNode parentNode, IMetricIdentity parent, HashMap children, Set ids, boolean enabled) {
        IMetricIdentity[] metricsIds = ids.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        boolean hasWildCard = false;
        for (int i = 0; i < metricsIds.length; ++i) {
            if (!metricsIds[i].isInstanceOf(parent)) continue;
            if (this.containsWildcard(metricsIds[i])) {
                parentNode.setEnabled(true);
                parentNode.setParentEnabled();
                hasWildCard = true;
                continue;
            }
            ids.remove(metricsIds[i]);
            String[] nameComponents = metricsIds[i].getNameComponents();
            InstanceNode newChild = new InstanceNode(metricsIds[i], nameComponents[nameComponents.length - 1]);
            newChild.setEnabled(enabled);
            newChild.setParentEnabled();
            children.put(metricsIds[i], newChild);
        }
        if (hasWildCard || !children.isEmpty()) {
            parentNode.setEnabled(true);
        } else {
            parentNode.setEnabled(false);
        }
        parentNode.setParentEnabled();
    }

    private boolean containsWildcard(IMetricIdentity metricID) {
        String wildcard = "*";
        String metricName = metricID.getAbsoluteName();
        int index = metricName.indexOf(wildcard);
        if (index == -1) {
            return false;
        }
        String[] nameComponents = metricID.getNameComponents();
        if (!"queue".equals(nameComponents[0])) {
            return true;
        }
        if (metricName.indexOf("%.*%.*") > 0) {
            String modifiedStr = metricName.replaceAll("%\\.\\*%\\.\\*", "_");
            index = modifiedStr.indexOf(wildcard);
        }
        return index != -1;
    }

    private void addAlerts(AbstractNode node, IMetricIdentity metricId, HashMap enabledAlertsSets) {
        if (node instanceof IAlertsProvider) {
            HashSet alerts = (HashSet)enabledAlertsSets.remove(metricId);
            if (alerts != null) {
                AlertsModel alertsModel = ((IAlertsProvider)((Object)node)).getAlertsModel();
                ((IAlertsProvider)((Object)node)).getAlertsModel().setAlerts(alerts);
            } else {
                AlertsModel alertsModel = ((IAlertsProvider)((Object)node)).getAlertsModel();
                if (alertsModel != null) {
                    alertsModel.setAlerts(null);
                }
            }
        }
    }

    private void constructTree(IMetricInfo[] infos) {
        this.m_hasMetricAlertsSupport = false;
        this.m_hasInstanceMetrics = false;
        for (int i = 0; i < infos.length; ++i) {
            AbstractParentNode parent = this.m_treeRootNode;
            String[] nameTokens = infos[i].getMetricIdentity().getNameComponents();
            StringBuffer prefix = new StringBuffer();
            for (int j = 0; j < nameTokens.length; ++j) {
                if (j == nameTokens.length - 1) {
                    boolean isInstanceMetric = infos[i].isInstanceMetric();
                    if (isInstanceMetric) {
                        this.m_hasInstanceMetrics = true;
                    }
                    if (infos[i].supportsHighThresholdAlerts() || infos[i].supportsLowThresholdAlerts()) {
                        this.m_hasMetricAlertsSupport = true;
                    }
                    if (parent.getChild(nameTokens[j]) != null) continue;
                    parent.add(isInstanceMetric ? new InstanceParentNode(infos[i], nameTokens[j]) : new Node(infos[i], nameTokens[j]));
                    continue;
                }
                if (j > 0) {
                    prefix.append('.');
                }
                prefix.append(nameTokens[j]);
                AbstractParentNode childNode = (AbstractParentNode)parent.getChild(nameTokens[j]);
                if (childNode == null) {
                    childNode = new ParentNode(MetricsFactory.createMetricIdentity((String)prefix.toString()), nameTokens[j]);
                    parent.add(childNode);
                }
                parent = childNode;
            }
        }
    }

    @Override
    public void refreshTree() throws Exception {
        Object[] values = null;
        IMetricIdentity[] activeMetrics = new IMetricIdentity[]{};
        IAlert[] enabledAlerts = new IAlert[]{};
        values = ((IConfigMetricPlugin)this.source).getMetricAndAlertInfo();
        if (values != null) {
            if (values[0] != null) {
                activeMetrics = (IMetricIdentity[])values[0];
            }
            if (values[1] != null) {
                enabledAlerts = (IAlert[])values[1];
            }
        }
        HashSet<IMetricIdentity> enabledExactPatternsSet = new HashSet<IMetricIdentity>();
        for (int i = 0; i < activeMetrics.length; ++i) {
            enabledExactPatternsSet.add(activeMetrics[i]);
        }
        HashSet<IMetricIdentity> activeMetricsSet = new HashSet<IMetricIdentity>(activeMetrics.length);
        for (int i = 0; i < activeMetrics.length; ++i) {
            activeMetricsSet.add(activeMetrics[i]);
        }
        HashMap<IMetricIdentity, HashSet<IAlert>> enabledAlertsSets = new HashMap<IMetricIdentity, HashSet<IAlert>>();
        for (int i = 0; i < enabledAlerts.length; ++i) {
            HashSet<IAlert> alerts = (HashSet<IAlert>)enabledAlertsSets.get(enabledAlerts[i].getMetricIdentity());
            if (alerts == null) {
                alerts = new HashSet<IAlert>();
                enabledAlertsSets.put(enabledAlerts[i].getMetricIdentity(), alerts);
            }
            alerts.add(enabledAlerts[i]);
        }
        this.setLeafNodeStates(this.m_treeRootNode, enabledExactPatternsSet, activeMetricsSet, enabledAlertsSets);
        Enumeration<TreeNode> en = this.m_treeRootNode.depthFirstEnumeration();
        ParentNode lastParentNode = null;
        while (en.hasMoreElements()) {
            ParentNode parent;
            AbstractNode node = (AbstractNode)en.nextElement();
            if (!(node instanceof Node) || (parent = (ParentNode)node.getParent()) == null || parent == lastParentNode) continue;
            lastParentNode = parent;
            node.setParentEnabled();
        }
    }

    public void disableMetric(AbstractNode node) throws Exception {
        this.disableMetric(node, 1);
    }

    public void disableMetric(AbstractNode node, int instanceDisableMode) throws Exception {
        Enumeration<TreeNode> en;
        HashSet ids = new HashSet();
        this.setIdentities(node, ids, false, instanceDisableMode);
        IMetricIdentity[] metricIds = ids.toArray(new IMetricIdentity[ids.size()]);
        ((IConfigMetricPlugin)this.source).updateMetrics(false, metricIds);
        if (node instanceof InstanceNode) {
            InstanceParentNode parent = (InstanceParentNode)node.getParent();
            this.removeAlertWhenMetricsDisabled(parent);
            parent.remove(node);
            super.nodeStructureChanged(parent);
        } else if (node instanceof InstanceParentNode) {
            this.disableAlertsWhenMetricsDisabled(metricIds, node);
            node.removeAllChildren();
            this.refreshTree();
            super.nodeStructureChanged(node);
        } else if (node instanceof ParentNode) {
            ArrayList<AbstractNode> instanceParents = new ArrayList<AbstractNode>();
            en = node.depthFirstEnumeration();
            while (en.hasMoreElements()) {
                AbstractNode descendant = (AbstractNode)en.nextElement();
                if (!(descendant instanceof InstanceParentNode)) continue;
                instanceParents.add(descendant);
            }
            for (int i = instanceParents.size() - 1; i >= 0; --i) {
                ((InstanceParentNode)instanceParents.get(i)).removeAllChildren();
                super.nodeStructureChanged((InstanceParentNode)instanceParents.get(i));
            }
            this.refreshTree();
            super.nodeChanged(node);
        }
        node.setEnabled(false);
        this.refreshTree();
        node.setParentEnabled();
        for (AbstractNode changeNode = node; changeNode != this.m_treeRootNode; changeNode = (AbstractNode)changeNode.getParent()) {
            super.nodeChanged(changeNode);
        }
        en = node.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            AbstractNode descendant = (AbstractNode)en.nextElement();
            super.nodeChanged(descendant);
        }
        super.nodeChanged(node);
    }

    private void removeAlertWhenMetricsDisabled(AbstractNode node) {
        try {
            if (node instanceof Node) {
                AlertsModel alertsModel = ((IAlertsProvider)((Object)node)).getAlertsModel();
                if (alertsModel != null) {
                    alertsModel.setAlerts(null);
                }
            } else if (node instanceof ParentNode) {
                Enumeration<TreeNode> en = ((ParentNode)node).children();
                while (en.hasMoreElements()) {
                    this.removeAlertWhenMetricsDisabled((AbstractNode)en.nextElement());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
    }

    private void setIdentities(AbstractNode node, HashSet identities, boolean enable, int instanceDisableMode) {
        if (node instanceof Node) {
            IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
            identities.add(metricId);
        } else if (node instanceof ParentNode) {
            Enumeration<TreeNode> en = ((ParentNode)node).children();
            while (en.hasMoreElements()) {
                this.setIdentities((AbstractNode)en.nextElement(), identities, enable, instanceDisableMode);
            }
        } else if (node instanceof InstanceParentNode) {
            if (enable) {
                IMetricIdentity parentId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
                IMetricIdentity patternId = MetricsFactory.createMetricIdentity((IMetricIdentity)parentId, (String)"*");
                identities.add(patternId);
            } else {
                switch (instanceDisableMode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        try {
                            IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
                            Object[] metricAndAlertInfo = ((IConfigMetricPlugin)this.source).getMetricAndAlertInfo();
                            IMetricIdentity[] activeMetrics = (IMetricIdentity[])metricAndAlertInfo[0];
                            for (int i = 0; i < activeMetrics.length; ++i) {
                                IMetricIdentity activeMetric = activeMetrics[i];
                                if (!activeMetric.getName().startsWith(metricId.getName())) continue;
                                identities.add(activeMetric);
                            }
                            break;
                        }
                        catch (Exception e) {
                            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                            break;
                        }
                    }
                    default: {
                        IMetricIdentity parentId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
                        IMetricIdentity patternId = MetricsFactory.createMetricIdentity((IMetricIdentity)parentId, (String)"*");
                        identities.add(patternId);
                        break;
                    }
                }
            }
        } else if (node instanceof InstanceNode) {
            InstanceParentNode parent = (InstanceParentNode)node.getParent();
            IMetricIdentity parentId = ((IMetricInfo)parent.getUserObject()).getMetricIdentity();
            IMetricIdentity patternId = MetricsFactory.createMetricIdentity((IMetricIdentity)parentId, (String)node.toString());
            identities.add(patternId);
        }
    }

    public void enableAlerts(AbstractNode node, Long[] highThresholdAlerts, Long[] lowThresholdAlerts) throws Exception {
        int i;
        IMetricIdentity metricId = node instanceof InstanceNode ? (IMetricIdentity)node.getUserObject() : ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        IAlert[] alertArray = this.createAlertArray(metricId, highThresholdAlerts, lowThresholdAlerts);
        ((IConfigMetricPlugin)this.source).updateAlerts(alertArray, true);
        HashSet alerts = ((IAlertsProvider)((Object)node)).getAlertsModel().getAlerts();
        for (i = 0; i < highThresholdAlerts.length; ++i) {
            alerts.add(MetricsFactory.createAlert((IMetricIdentity)metricId, (boolean)true, (long)highThresholdAlerts[i]));
        }
        for (i = 0; i < lowThresholdAlerts.length; ++i) {
            alerts.add(MetricsFactory.createAlert((IMetricIdentity)metricId, (boolean)false, (long)lowThresholdAlerts[i]));
        }
        super.nodeChanged(node);
    }

    public void disableAlerts(AbstractNode node, Long[] highThresholdAlerts, Long[] lowThresholdAlerts) throws Exception {
        int i;
        IMetricIdentity metricId = node instanceof InstanceNode ? (IMetricIdentity)node.getUserObject() : ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        IAlert[] alertArray = this.createAlertArray(metricId, highThresholdAlerts, lowThresholdAlerts);
        ((IConfigMetricPlugin)this.source).updateAlerts(alertArray, false);
        HashSet alerts = ((IAlertsProvider)((Object)node)).getAlertsModel().getAlerts();
        for (i = 0; i < highThresholdAlerts.length; ++i) {
            this.removeAlert(alerts, true, highThresholdAlerts[i]);
        }
        for (i = 0; i < lowThresholdAlerts.length; ++i) {
            this.removeAlert(alerts, false, lowThresholdAlerts[i]);
        }
        super.nodeChanged(node);
    }

    private void disableAlertsWhenMetricsDisabled(IMetricIdentity[] metricIds, AbstractNode node) throws Exception {
        for (int i = 0; i < metricIds.length; ++i) {
            AlertsModel alertsModel = this.getAlertsModelForANode(node.children(), metricIds[i].getName());
            if (alertsModel == null) continue;
            ArrayList highThresholdValues = alertsModel.getHighThresholdValues();
            Long[] ht = highThresholdValues.toArray(new Long[0]);
            ArrayList lowThresholdValues = alertsModel.getLowThresholdValues();
            Long[] lt = lowThresholdValues.toArray(new Long[0]);
            this.disableAlerts(metricIds[i], ht, lt);
            this.removeAlertWhenMetricsDisabled(node);
        }
    }

    public void disableAlerts(IMetricIdentity metricId, Long[] highThresholdAlerts, Long[] lowThresholdAlerts) throws Exception {
        IAlert[] alertArray = this.createAlertArray(metricId, highThresholdAlerts, lowThresholdAlerts);
        ((IConfigMetricPlugin)this.source).updateAlerts(alertArray, false);
    }

    private IAlert[] createAlertArray(IMetricIdentity metricId, Long[] highThresholdAlerts, Long[] lowThresholdAlerts) {
        int i;
        int alertCount = (highThresholdAlerts == null ? 0 : highThresholdAlerts.length) + (lowThresholdAlerts == null ? 0 : lowThresholdAlerts.length);
        IAlert[] alerts = new IAlert[alertCount];
        if (lowThresholdAlerts != null) {
            for (i = lowThresholdAlerts.length - 1; i >= 0; --i) {
                alerts[--alertCount] = MetricsFactory.createAlert((IMetricIdentity)metricId, (boolean)false, (long)lowThresholdAlerts[i]);
            }
        }
        if (highThresholdAlerts != null) {
            for (i = highThresholdAlerts.length - 1; i >= 0; --i) {
                alerts[--alertCount] = MetricsFactory.createAlert((IMetricIdentity)metricId, (boolean)true, (long)highThresholdAlerts[i]);
            }
        }
        return alerts;
    }

    private void removeAlert(HashSet alerts, boolean isHighThreshold, long threshold) {
        for (IAlert alert : alerts) {
            if (alert.isHighThreshold() != isHighThreshold || alert.getThresholdValue() != threshold) continue;
            alerts.remove(alert);
            return;
        }
    }

    @Override
    public List getInstances(InstanceParentNode node) throws Exception {
        IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        String[] instances = new String[]{"Sample.Q1", "Sample.Q2"};
        ArrayList<String> instancesList = new ArrayList<String>(instances.length);
        for (int i = 0; i < instances.length; ++i) {
            instancesList.add(instances[i]);
        }
        return instancesList;
    }

    public String[] getEnabledMetricsPatterns(InstanceParentNode node) throws Exception {
        IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        Object[] metricAndAlertInfo = ((IConfigMetricPlugin)this.source).getMetricAndAlertInfo();
        IMetricIdentity[] activeMetrics = (IMetricIdentity[])metricAndAlertInfo[0];
        ArrayList<IMetricIdentity> instancesList = new ArrayList<IMetricIdentity>();
        for (int i = 0; i < activeMetrics.length; ++i) {
            IMetricIdentity activeMetric = activeMetrics[i];
            if (!activeMetric.getName().startsWith(metricId.getName()) || activeMetric.getName().equalsIgnoreCase(metricId.getName())) continue;
            instancesList.add(activeMetric);
        }
        String[] patterns = new String[instancesList.size()];
        for (int i = 0; i < instancesList.size(); ++i) {
            String[] patternId = ((IMetricIdentity)instancesList.get(i)).getNameComponents();
            patterns[i] = patternId[patternId.length - 1];
        }
        return patterns;
    }

    public void enableInstancePatterns(InstanceParentNode node, List instanceNames) throws Exception {
        this.updateInstancePatterns("enableMetrics", node, instanceNames);
        if (instanceNames.contains("*")) {
            this.enableMetric(node);
        } else if (!instanceNames.isEmpty()) {
            node.setEnabled(true);
            node.setParentEnabled();
        }
    }

    public void disableInstancePatterns(InstanceParentNode node, List instanceNames) throws Exception {
        this.updateInstancePatterns("disableMetrics", node, instanceNames);
    }

    private void updateInstancePatterns(String updateOperation, InstanceParentNode node, List instanceNames) throws Exception {
        IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        String[] nameComponents = metricId.getNameComponents();
        String[] instanceNameComponents = new String[nameComponents.length + 1];
        System.arraycopy(nameComponents, 0, instanceNameComponents, 0, nameComponents.length);
        int instanceNameComponentIndex = instanceNameComponents.length - 1;
        HashSet<IMetricIdentity> enabledIds = new HashSet<IMetricIdentity>();
        Iterator iterator = instanceNames.iterator();
        while (iterator.hasNext()) {
            instanceNameComponents = (String[])instanceNameComponents.clone();
            instanceNameComponents[instanceNameComponentIndex] = (String)iterator.next();
            enabledIds.add(MetricsFactory.createMetricIdentity((String[])instanceNameComponents));
        }
        IMetricIdentity[] metricIds = enabledIds.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        boolean opertaionType = updateOperation.equals("disableMetrics");
        ((IConfigMetricPlugin)this.source).updateMetrics(!opertaionType, metricIds);
        if (opertaionType) {
            this.disableAlertsWhenMetricsDisabled(metricIds, node);
        }
        this.refreshTree();
        super.nodeStructureChanged(node);
    }

    private AlertsModel getAlertsModelForANode(Enumeration enumeration, String metricName) {
        AlertsModel alertsModel = null;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                InstanceNode instanceNode = (InstanceNode)enumeration.nextElement();
                MetricIdentity userObject = (MetricIdentity)instanceNode.getUserObject();
                if (!userObject.getName().equalsIgnoreCase(metricName)) continue;
                alertsModel = instanceNode.getAlertsModel();
                break;
            }
        }
        return alertsModel;
    }

    @Override
    public void refreshMetricValues(IMetricIdentity[] id) {
    }

    @Override
    public void addValueListener(IMetricIdentity metricId, IValueListener listener) {
    }

    @Override
    public void removeValueListener(IMetricIdentity metricId, IValueListener listener) {
    }
}

