/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config.propsheets;

import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigPath;
import java.beans.PropertyVetoException;
import modelobjects.framework.model.ModelAspectAdapter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelObjectAdapter;

public class ConfigBeanModelAspectAdapter
extends ModelAspectAdapter {
    private IConfigPath m_path;
    private boolean m_readOnly;

    public ConfigBeanModelAspectAdapter(IConfigPath path, Class type, boolean readOnly) {
        super(ModelAspectId.forName(path.toString()), type);
        this.m_path = path;
        this.m_readOnly = readOnly;
    }

    @Override
    public boolean isReadonlyAspect() {
        return this.m_readOnly;
    }

    @Override
    protected Object getAspectValue(Object modelObject, ModelObjectAdapter modelObjectAdapter) {
        Object value = null;
        ConfigBeanModel bean = (ConfigBeanModel)modelObject;
        if (this.isViewName()) {
            value = bean.getViewName();
        } else {
            IAttributeDescription ad;
            value = bean.getData().getAttribute(this.m_path);
            if (value == null && (ad = bean.getData().getAttributeDescription().getAttributeDescription(this.m_path)) != null) {
                value = ad.getProperty("mx.config.default");
            }
        }
        return value;
    }

    @Override
    protected void setAspectValue(Object modelObject, Object newAspectValue, ModelObjectAdapter modelObjectAdapter) throws PropertyVetoException, IllegalArgumentException, UnsupportedOperationException {
        try {
            ConfigBeanModel bean = (ConfigBeanModel)modelObject;
            if (this.isViewName()) {
                if (newAspectValue == null) {
                    bean.setViewName(null);
                } else {
                    if (!(newAspectValue instanceof String)) {
                        throw new IllegalArgumentException("The value '" + newAspectValue.toString() + " is not a valid string.");
                    }
                    String newValue = ((String)newAspectValue).trim();
                    if (newValue.length() == 0) {
                        throw new IllegalArgumentException("You must enter a value for this field.");
                    }
                    bean.setViewName(newValue);
                }
            } else if (newAspectValue == null || newAspectValue instanceof String && ((String)newAspectValue).trim().length() == 0) {
                bean.getData().removeAttribute(this.m_path);
            } else {
                Object oldValue = bean.getData().getAttribute(this.m_path);
                if (!(oldValue == null || newAspectValue instanceof IAttributeMap && newAspectValue instanceof IAttributeList || !oldValue.equals(newAspectValue))) {
                    return;
                }
                boolean isDefault = this.isDefaultValue(bean.getData(), this.m_path, newAspectValue);
                if (this.createMissingOptionalAttributes(bean.getData(), this.m_path, isDefault)) {
                    bean.getData().setAttribute(this.m_path, newAspectValue);
                }
            }
        }
        catch (IllegalArgumentException e) {
            IllegalArgumentException iae = new IllegalArgumentException(this.m_path.toString());
            iae.initCause(e);
            throw iae;
        }
        catch (ConfigServiceException e) {
            IllegalArgumentException iae = new IllegalArgumentException(this.m_path.toString());
            iae.initCause(e);
            throw iae;
        }
    }

    protected boolean isViewName() {
        return this.m_path.equals(ConfigBeanModel.NAME);
    }

    private boolean createMissingOptionalAttributes(IAttributeMap data, IConfigPath path, boolean isDefault) throws ConfigServiceException {
        for (int i = 1; i < path.size(); ++i) {
            IConfigPath subPath = path.subPath(0, i);
            if (data.getAttribute(subPath) != null) continue;
            if (isDefault) {
                return false;
            }
            IAttributeDescription ad = data.getAttributeDescription().getAttributeDescription(subPath);
            Number minOccurs = (Number)ad.getProperty("mx.config.minOccurs");
            if (minOccurs == null || minOccurs.intValue() != 0) continue;
            if (ad.getType().equals(IAttributeMap.class)) {
                IAttributeMap map = data.createAttributeMap(subPath.toString());
                data.setAttribute(subPath, (Object)map);
                continue;
            }
            if (!ad.getType().equals(IAttributeList.class)) continue;
            IAttributeList list = data.createAttributeList(subPath.toString());
            data.setAttribute(subPath, (Object)list);
        }
        return true;
    }

    private boolean isDefaultValue(IAttributeMap map, IConfigPath path, Object value) {
        Object val = this.getDefaultValue(map, path);
        return val != null && value != null && val.equals(value);
    }

    private Object getDefaultValue(IAttributeMap map, IConfigPath path) {
        IAttributeDescription ad = map.getAttributeDescription().getAttributeDescription(path);
        return ad != null ? ad.getProperty("mx.config.default") : null;
    }
}

