/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config.propsheets;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigContext;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigServer;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.ModelObjectPropagator;
import modelobjects.framework.model.ModelPropagationException;

public class ConfigBeanPropagator
implements ModelObjectPropagator {
    private IConfigPlugin m_plugin;
    private String m_renameOld;
    private String m_renameNew;

    public ConfigBeanPropagator() {
        this(null);
    }

    public ConfigBeanPropagator(IConfigPlugin plugin) {
        this.setPlugin(plugin);
    }

    public IConfigPlugin getPlugin() {
        return this.m_plugin;
    }

    public final void setPlugin(IConfigPlugin plugin) {
        this.m_plugin = plugin;
    }

    protected IConfigContext getConfigContext() {
        return this.m_plugin.getPluginContext().getConfigContext();
    }

    @Override
    public void propagateModelEdit(ModelObjectAdapter adapter) throws ModelPropagationException {
        ConfigBeanModel model = (ConfigBeanModel)adapter.getModelObject();
        try {
            if (model.getData() instanceof IConfigBean) {
                IConfigServer server = ((IConfigBean)model.getData()).getConfigServer();
                server.storeConfigElement((IConfigElement)((IConfigBean)model.getData()));
                if (this.m_renameOld != null) {
                    server.rename(this.m_renameOld, this.m_renameNew);
                }
                if (server.isTransacted()) {
                    server.commit();
                }
            }
        }
        catch (Exception e) {
            if (model.getData() instanceof IConfigBean) {
                IConfigServer server = ((IConfigBean)model.getData()).getConfigServer();
                try {
                    server.rollback();
                }
                catch (ConfigServiceException cse) {
                    Helper.logDebugMessage("Failed to rollback changes: " + ((IConfigBean)model.getData()).getName());
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
            }
            throw new ModelPropagationException(e);
        }
    }

    protected String rename(ConfigBeanModel model) {
        IConfigBean bean = (IConfigBean)model.getData();
        String path = bean.getName();
        int index = path.lastIndexOf(47);
        String basePath = path.substring(0, index + 1);
        String beanName = model.getViewName();
        return basePath + beanName;
    }

    protected void delayedRename(String oldPath, String newPath) {
        this.m_renameOld = oldPath;
        this.m_renameNew = newPath;
    }

    @Override
    public void propagateModelCreation(ModelObjectAdapter adapter) throws ModelPropagationException {
        try {
            ConfigBeanModel model = (ConfigBeanModel)adapter.getModelObject();
            if (model.getData() instanceof IConfigBean) {
                IConfigBean bean = (IConfigBean)model.getData();
                String newName = this.rename(model);
                if (!newName.equals(bean.getName())) {
                    if (bean.getConfigServer().pathExists(newName)) {
                        throw new Exception("A configuration with name '" + newName + "' already exists");
                    }
                    if (bean.getConfigServer().pathExists(bean.getName())) {
                        this.delayedRename(bean.getName(), newName);
                    } else {
                        bean.setName(newName);
                    }
                }
            }
            this.propagateModelEdit(adapter);
        }
        catch (ModelPropagationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModelPropagationException(e);
        }
    }

    @Override
    public void propagateModelDeletion(ModelObjectAdapter adapter) throws ModelPropagationException {
        this.performModelDeletion((ConfigBeanModel)adapter.getModelObject());
    }

    public void performModelDeletion(ConfigBeanModel model) throws ModelPropagationException {
        try {
            if (model != null && model.getData() instanceof IConfigBean) {
                IConfigBean bean = (IConfigBean)model.getData();
                IConfigServer server = bean.getConfigServer();
                server.removeConfigElement(bean.getName());
                String[] names = this.getDeleteNames(bean);
                if (names == null) {
                    throw new IllegalArgumentException("No beans to delete");
                }
                server.removeConfigElements(names);
                if (server.isTransacted()) {
                    server.commit();
                }
            }
        }
        catch (Exception e) {
            throw new ModelPropagationException(e);
        }
    }

    protected String[] getDeleteNames(IConfigBean beanModel) {
        return new String[]{beanModel.getName()};
    }
}

