/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config.propsheets;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.propsheets.ConfigBeanModelDescriptor;
import com.sonicsw.ma.gui.config.propsheets.ConfigBeanPropagator;
import com.sonicsw.ma.gui.config.propsheets.ConfigBeanValidator;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.ConfigAttributeException;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMetaData;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigType;
import com.sonicsw.mx.config.util.ConfigHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import modelobjects.framework.EditRule;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelDescriptor;
import modelobjects.framework.model.ModelValidationException;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JComboBoxAdapter;
import modelobjects.framework.swing.JLabelAdapter;
import modelobjects.framework.swing.JTextAreaAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

public abstract class JConfigDialog
extends JPropSheetDialog {
    public static final Dimension MIN_SIZE = new Dimension(350, 400);
    public static final Dimension MAX_SIZE = new Dimension(550, 650);
    public static final Dimension DEF_SIZE = MIN_SIZE;
    private static final int VALUE_NOT_DEFINED = -1;
    private static final int VALUE_FROM_PROTOTYPE = 0;
    private static final int VALUE_FROM_BEAN = 1;

    public JConfigDialog(JMAFrame parent, String name, IAttributeDescription type) {
        super(parent, name, ConfigBeanModel.class);
        this.setDescriptorProperty(type);
        this.setValidator(new ConfigBeanValidator());
        this.setPropagator(new ConfigBeanPropagator());
    }

    public JConfigDialog(JConfigDialog parent, String name, IAttributeDescription type) {
        super(parent, name, ConfigBeanModel.class);
        this.setDescriptorProperty(type);
    }

    private void setDescriptorProperty(IAttributeDescription type) {
        ((ConfigBeanModelDescriptor)this.getDescriptor()).setType(type);
    }

    @Override
    public void pack() {
        super.pack();
        Rectangle bounds = this.getBounds();
        if (bounds.width > JConfigDialog.MAX_SIZE.width) {
            bounds.width = JConfigDialog.MAX_SIZE.width;
        } else if (bounds.width < JConfigDialog.MIN_SIZE.width) {
            bounds.width = JConfigDialog.MIN_SIZE.width;
        }
        if (bounds.height > JConfigDialog.MAX_SIZE.height) {
            bounds.height = JConfigDialog.MAX_SIZE.height;
        } else if (bounds.height < JConfigDialog.MIN_SIZE.height) {
            bounds.height = JConfigDialog.MIN_SIZE.height;
        }
        this.setBounds(bounds);
    }

    @Override
    protected ModelDescriptor makeModelDescriptor() {
        return new ConfigBeanModelDescriptor();
    }

    @Override
    public void editInstance(IPlugin plugin, Object model, boolean isNew) throws Exception {
        if (this.getPropagator() != null && this.getPropagator() instanceof ConfigBeanPropagator) {
            ((ConfigBeanPropagator)this.getPropagator()).setPlugin((IConfigPlugin)plugin);
        }
        super.editInstance(plugin, model, isNew);
        boolean isTemplate = ((IConfigPlugin)plugin).isTemplatePrototype();
        this.setTitle(this.getDialogTitle(isNew, isTemplate));
    }

    protected String getDialogTitle(boolean isNew, boolean isTemplate) {
        String result;
        if (isNew) {
            String titlePrefix = ResourceManager.getString(this.getClass(), isTemplate ? "JMADialog.newTemplateTitlePrefix" : "JMADialog.newTitlePrefix");
            result = titlePrefix + " " + this.getTitle();
        } else {
            String titlePrefix = ResourceManager.getString(this.getClass(), isTemplate ? "JMADialog.editTemplateTitlePrefix" : "JMADialog.editTitlePrefix");
            String titleSuffix = ResourceManager.getString(this.getClass(), "JMADialog.editTitleSuffix");
            result = titlePrefix + " " + this.getTitle() + " " + titleSuffix;
        }
        return result;
    }

    public IAttributeDescription getModelMetaData() {
        return ((ConfigBeanModelDescriptor)this.getDescriptor()).getType();
    }

    public JLabelAdapter createJLabelAdapter(IConfigPath attributePath, JLabel viewComponent, ViewValueConverter converter) {
        return new JLabelAdapter(this.getModelAspectId(attributePath), viewComponent, converter, this.getEditForm().getModelEditMediator());
    }

    public JTextFieldAdapter createJTextFieldAdapter(IConfigPath attributePath, JTextField viewComponent, ViewValueConverter converter) {
        return new JTextFieldAdapter(this.getModelAspectId(attributePath), viewComponent, this.isFieldEditOnInit(attributePath) ? EditRule.FOR_INIT : EditRule.ALWAYS, converter, this.getEditForm().getModelEditMediator());
    }

    public JTextAreaAdapter createJTextAreaAdapter(IConfigPath attributePath, JTextArea viewComponent, ViewValueConverter converter) {
        return new JTextAreaAdapter(this.getModelAspectId(attributePath), viewComponent, this.isFieldEditOnInit(attributePath) ? EditRule.FOR_INIT : EditRule.ALWAYS, converter, this.getEditForm().getModelEditMediator());
    }

    public JComboBoxAdapter createJComboBoxAdapter(IConfigPath attributePath, JComboBox viewComponent, ViewValueConverter converter) {
        return new JComboBoxAdapter(this.getModelAspectId(attributePath), viewComponent, this.isFieldEditOnInit(attributePath) ? EditRule.FOR_INIT : EditRule.ALWAYS, converter, this.getEditForm().getModelEditMediator());
    }

    public JCheckBoxAdapter createJCheckBoxAdapter(IConfigPath attributePath, JCheckBox viewComponent, ViewValueConverter converter) {
        return new JCheckBoxAdapter(this.getModelAspectId(attributePath), viewComponent, this.isFieldEditOnInit(attributePath) ? EditRule.FOR_INIT : EditRule.ALWAYS, converter, this.getEditForm().getModelEditMediator());
    }

    public ModelAspectId getModelAspectId(IConfigPath configPath) {
        return ModelAspectId.forName(configPath.toString());
    }

    public boolean isMandatoryField(IConfigPath path) {
        boolean res = true;
        if (path == null) {
            res = false;
        } else if (!path.equals(ConfigBeanModel.NAME)) {
            IAttributeDescription type = this.getModelMetaData();
            IAttributeDescription elem = type.getAttributeDescription(path);
            if (elem != null) {
                Object defValue = elem.getProperty("mx.config.default");
                if (defValue != null) {
                    res = false;
                } else {
                    Long min = (Long)elem.getProperty("mx.config.minOccurs");
                    Long max = (Long)elem.getProperty("mx.config.maxOccurs");
                    res = min != null && min == 1L && max != null && max == 1L;
                }
            } else {
                res = false;
            }
        }
        return res;
    }

    public int getAttributeValueSource(IConfigPath path) {
        ConfigBeanModel model = (ConfigBeanModel)this.getModel();
        int res = model.isTemplateInstance() ? 0 : 1;
        IAttributeMetaData meta = null;
        try {
            if (path != null) {
                if (model.getDataList() != null) {
                    meta = model.getDataList().getAttributeMetaData(path);
                } else if (model.getData() != null) {
                    meta = model.getData().getAttributeMetaData(path);
                }
                if (path.equals(ConfigBeanModel.NAME)) {
                    res = -1;
                } else if (meta != null) {
                    if (meta.isFromPrototype()) {
                        res = 0;
                    } else if (meta.isFromConfigBean()) {
                        res = 1;
                    } else if (meta.isFromConfigType()) {
                        // empty if block
                    }
                } else {
                    res = -1;
                }
            } else {
                res = -1;
            }
        }
        catch (ConfigServiceException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to find source of attribute '" + path + "'", e, false);
        }
        return res;
    }

    protected String getToolTipText(IConfigPath path, int source) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        if (path != null) {
            String methodName;
            int methodIndex;
            String tip = this.getResourceString(new Object[]{path, "help"});
            if (tip != null) {
                String[] split = this.splitOnWord(tip, 30);
                for (int i = 0; i < split.length; ++i) {
                    sb.append(split[i]);
                    sb.append("<br>");
                }
                sb.append("<br>");
            }
            if ((methodIndex = (methodName = path.toString()).lastIndexOf(46)) >= 0) {
                methodName = methodName.substring(methodIndex + 1);
            }
            sb.append("Method: ").append(ConfigHelper.generateName((String)methodName));
        }
        if (source == 0) {
            sb.append("<br>").append("Value from Template");
        }
        sb.append("</html>");
        return sb.toString();
    }

    private String[] splitOnWord(String tip, int max) {
        ArrayList<String> list = new ArrayList<String>();
        String delim = " /,.;:'<?\\~!@#$%^&*(+=";
        StringTokenizer st = new StringTokenizer(tip, delim, true);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (sb.length() + token.length() <= max) {
                sb.append(token);
                if (sb.length() != max) continue;
                list.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            list.add(sb.toString());
            sb = new StringBuffer();
            sb.append(token);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    protected boolean isFieldEditOnInit(IConfigPath path) {
        boolean res = false;
        if (path.equals(ConfigBeanModel.NAME)) {
            res = true;
        }
        return res;
    }

    public String[] getStringEnumeration(IConfigPath path) {
        return this.getStringEnumeration(path, null);
    }

    public String[] getStringEnumeration(IConfigPath path, String[] removeFilter) {
        ArrayList<String> res = new ArrayList<String>();
        try {
            IAttributeDescription ad = this.getModelMetaData().getAttributeDescription(path);
            IAttributeList list = (IAttributeList)ad.getProperty("mx.config.enumeration");
            for (String item : list) {
                boolean add = true;
                if (removeFilter != null) {
                    for (int iFilter = 0; iFilter < removeFilter.length; ++iFilter) {
                        if (removeFilter[iFilter] == null || !removeFilter[iFilter].equals(item)) continue;
                        add = false;
                        break;
                    }
                }
                if (!add) continue;
                res.add(item);
            }
        }
        catch (Exception e) {
            MgmtConsole.displayMessage(4, e.toString(), e, true);
        }
        return res.toArray(new String[res.size()]);
    }

    public String getResourceString(Object key) {
        return this.getResourceString(new Object[]{key});
    }

    public String getResourceString(Object[] key) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("config");
        if (this.getTypedResourceKey() != null) {
            list.add(this.getTypedResourceKey());
        }
        for (int i = 0; i < key.length; ++i) {
            list.add(key[i]);
        }
        return ResourceManager.getString(this.getClass(), list.toArray(new Object[list.size()]));
    }

    public String[] _getResourceStringArray(Object key) {
        return ResourceManager.getStringArray(this.getClass(), new Object[]{"config", key, "list"});
    }

    public JLabel getResourceLabel(IConfigPath path) {
        String resString = this.getResourceString(new Object[]{path, "label"});
        if (resString == null) {
            resString = "<NO RESOURCE>";
        }
        return this.getResourceLabel(resString, path);
    }

    public JLabel getResourceLabel(IConfigPath path, Object key) {
        String resString = ResourceManager.getString(this.getClass(), new Object[]{"config", key, "label"});
        if (resString == null) {
            resString = "<NO RESOURCE>";
        }
        return this.getResourceLabel(resString, path);
    }

    protected JLabel getResourceLabel(String resString, IConfigPath path) {
        int source = this.getAttributeValueSource(path);
        JLabel label = this.getResourceLabel(resString, this.isMandatoryField(path), source);
        if (source == 0) {
            label.setFont(label.getFont().deriveFont(3));
        }
        label.setToolTipText(this.getToolTipText(path, source));
        return label;
    }

    protected JLabel getResourceLabel(String resString, boolean mandatory, int source) {
        JLabel label = new JLabel();
        StringBuffer sb = new StringBuffer(resString);
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ':') {
            sb.append(':');
        }
        if (mandatory) {
            sb.insert(0, "*");
            if (source == -1) {
                label.setForeground(Color.RED);
            }
        }
        label.setText(sb.toString());
        return label;
    }

    public String getResourceUnit(Object key) {
        return ResourceManager.getString(this.getClass(), new Object[]{"unit", key});
    }

    public String getTypedResourceKey() {
        if (this.getModelMetaData() instanceof IConfigType) {
            return ((IConfigType)this.getModelMetaData()).getName();
        }
        return null;
    }

    @Override
    protected String getModelEditFailureMessage(Throwable throwable) {
        if (throwable instanceof ModelValidationException) {
            ModelValidationException e = (ModelValidationException)throwable;
            Throwable handleE = e.getNestedException();
            if (handleE != null) {
                if (handleE instanceof IllegalArgumentException && ((IllegalArgumentException)handleE).getCause() != null) {
                    handleE = ((IllegalArgumentException)handleE).getCause();
                }
                if (handleE instanceof ConfigServiceException) {
                    ConfigAttributeException cae;
                    if (handleE instanceof ConfigAttributeException && (cae = (ConfigAttributeException)handleE).getErrorKey().equals("am-validate-complete-req-attr-missing")) {
                        cae.setErrorKey(cae.getErrorKey() + "-mgmtconsole");
                    }
                    if (((ConfigServiceException)handleE).getLinkedException() != null) {
                        handleE = ((ConfigServiceException)handleE).getLinkedException();
                    }
                }
            } else {
                handleE = e;
            }
            return handleE.getMessage();
        }
        return super.getModelEditFailureMessage(throwable);
    }
}

