/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config.revert;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.revert.ConfigAttributeSource;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.mx.config.ConfigAttributeException;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IAttributeMetaData;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.impl.AttributeMapImpl;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public class ConfigAttributeTreeTableNode {
    IConfigPlugin m_plugin;
    ConfigAttributeTreeTableNode m_parent;
    String m_key;
    Object m_value;
    Object[] m_children;
    String m_label;
    private Method m_pluginMethodCache = null;
    private static final Comparator COMPARATOR = new NodeComparator();
    private static final Collator COLLATOR = Collator.getInstance();

    public ConfigAttributeTreeTableNode(IConfigPlugin plugin) {
        IConfigBean bean = (IConfigBean)((ConfigBeanModel)plugin.getModel()).getData();
        this.m_parent = null;
        this.m_key = bean.getName();
        this.m_value = bean;
        this.m_children = null;
        this.m_plugin = plugin;
        this.m_label = null;
    }

    public ConfigAttributeTreeTableNode(ConfigAttributeTreeTableNode parent, String key, Object value) {
        this.m_parent = parent;
        this.m_key = key;
        this.m_value = value;
        this.m_children = null;
        this.m_label = null;
    }

    public ConfigAttributeTreeTableNode getParent() {
        return this.m_parent;
    }

    public Object getValue() {
        return this.m_value;
    }

    public String getKey() {
        return this.m_key;
    }

    public String toString() {
        if (this.m_label == null) {
            IConfigBean parentBean = this.getParentConfigBean();
            IConfigPath path = this.getConfigPath(parentBean);
            if (this.isUnenumeratedItem()) {
                this.m_label = path.subPath(path.size() - 1).toString();
            } else {
                ArrayList<String> list = new ArrayList<String>();
                IConfigPath resPath = this.getResourcePath(parentBean);
                list.add("config");
                list.add(parentBean.getConfigType().getName());
                for (int i = 0; i < resPath.size(); ++i) {
                    list.add(resPath.getComponent(i));
                }
                list.add("label");
                this.m_label = ResourceManager.getString(this.getPlugin().getClass(), list.toArray(new Object[list.size()]));
                if (this.m_label == null) {
                    this.m_label = "";
                }
            }
        }
        return this.m_label;
    }

    public IConfigPlugin getPlugin() {
        Object plugin = null;
        ConfigAttributeTreeTableNode node = this;
        while (!node.isRoot()) {
            node = node.getParent();
        }
        return node.m_plugin;
    }

    public ConfigAttributeSource getConfigAttributeSource() {
        IConfigBean parent = this.getParentConfigBean();
        IConfigPath adjustedPath = this.getConfigPath(parent);
        return new ConfigAttributeSource(parent, adjustedPath);
    }

    private IConfigPath getResourcePath(IConfigBean parentBean) {
        IConfigPath path = ConfigFactory.createConfigPath();
        for (ConfigAttributeTreeTableNode node = this; node != null && node.getValue() != parentBean; node = node.getParent()) {
            String part = node.getKey();
            if (node != this && node.isUnenumeratedItem()) {
                IAttributeDescription ad = node.getAttributeDescription();
                part = (String)ad.getProperty("mx.config.schemaTypeName");
            }
            path.insert(0, part);
        }
        return path;
    }

    public IConfigPath getConfigPath() {
        return this.getConfigPath(null);
    }

    public IConfigPath getConfigPath(IConfigBean bean) {
        ConfigAttributeTreeTableNode node;
        IConfigPath path = ConfigFactory.createConfigPath();
        if (bean == null) {
            for (node = this; node != null && !node.isRoot(); node = node.getParent()) {
                path.insert(0, new String[]{node.getKey()});
            }
        } else {
            while (node != null && node.getValue() != bean) {
                path.insert(0, new String[]{node.getKey()});
                node = node.getParent();
            }
        }
        return path;
    }

    public IConfigBean getParentConfigBean() {
        IConfigBean bean = null;
        ConfigAttributeTreeTableNode node = this;
        if (this.getValue() instanceof IConfigBean && !node.isRoot()) {
            node = node.getParent();
        }
        while (node != null) {
            if (node.getValue() instanceof IConfigBean) {
                bean = (IConfigBean)node.getValue();
                break;
            }
            node = node.getParent();
        }
        return bean;
    }

    public IConfigBean getRootConfigBean() {
        return this.getConfigBean(false);
    }

    public IConfigBean getConfigBean() {
        return this.getConfigBean(true);
    }

    protected IConfigBean getConfigBean(boolean firstMatch) {
        IConfigBean bean = null;
        for (ConfigAttributeTreeTableNode node = this; node != null; node = node.getParent()) {
            if (!(node.getValue() instanceof IConfigBean)) continue;
            bean = (IConfigBean)node.getValue();
            if (firstMatch) break;
        }
        return bean;
    }

    private IAttributeDescription getAttributeDescription() {
        IConfigBean parent = this.getParentConfigBean();
        IConfigPath path = this.getConfigPath(parent);
        if (this.getValue() instanceof IAttributeMap) {
            return ((IAttributeMap)this.getValue()).getAttributeDescription();
        }
        if (this.getValue() instanceof IAttributeList) {
            return ((IAttributeList)this.getValue()).getAttributeDescription();
        }
        return parent.getAttributeDescription().getAttributeDescription(path);
    }

    protected Object[] getChildren() {
        if (this.m_children != null) {
            return this.m_children;
        }
        ArrayList<ConfigAttributeTreeTableNode> list = new ArrayList<ConfigAttributeTreeTableNode>();
        if (this.m_value instanceof IAttributeMap) {
            Iterator i = ((AttributeMapImpl)this.m_value).getAllAttributeNames().iterator();
            while (i.hasNext()) {
                try {
                    ConfigAttributeTreeTableNode child;
                    Object fixed;
                    IAttributeMap valueMap = (IAttributeMap)this.m_value;
                    String key = (String)i.next();
                    Object val = valueMap.getAttribute(key);
                    IAttributeMetaData meta = valueMap.getAttributeMetaData(key);
                    IAttributeDescription ad = valueMap.getAttributeDescription().getAttributeDescription(key);
                    if (!(val instanceof IConfigBean) && !this.isLocalReference(this.getConfigBean()) || (fixed = ad != null ? ad.getProperty("mx.config.fixed") : null) != null || meta == null || !meta.isFromConfigBean() || this.isAttributeFiltered((child = new ConfigAttributeTreeTableNode(this, key, val)).getConfigPath())) continue;
                    list.add(0, child);
                }
                catch (ConfigAttributeException e) {
                    e.printStackTrace();
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
            }
        } else if (this.m_value instanceof IAttributeList) {
            for (int i = 0; i < ((IAttributeList)this.m_value).size(); ++i) {
                ConfigAttributeTreeTableNode child;
                IAttributeList valueList = (IAttributeList)this.m_value;
                String key = Integer.toString(i);
                Object val = valueList.getAttribute(i);
                IAttributeMetaData meta = valueList.getAttributeMetaData(i);
                if (val instanceof IConfigBean && !this.isLocalReference((IConfigBean)val) || val == null || meta == null || !meta.isFromConfigBean() || this.isAttributeFiltered((child = new ConfigAttributeTreeTableNode(this, key, val)).getConfigPath())) continue;
                list.add(0, child);
            }
        }
        this.m_children = list.toArray(new Object[list.size()]);
        Arrays.sort(this.m_children, COMPARATOR);
        return this.m_children;
    }

    private boolean isAttributeFiltered(IConfigPath path) {
        IConfigPath[] filter = this.getFilteredAttributes(this.getPlugin());
        for (int i = 0; i < filter.length; ++i) {
            if (!filter[i].equals(path)) continue;
            return true;
        }
        return false;
    }

    private IConfigPath[] getFilteredAttributes(IConfigPlugin plugin) {
        try {
            if (this.m_pluginMethodCache == null) {
                this.m_pluginMethodCache = plugin.getClass().getMethod("getRevertFilteredAttributes", new Class[0]);
            }
            return (IConfigPath[])this.m_pluginMethodCache.invoke((Object)plugin, new Object[0]);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            return new IConfigPath[0];
        }
    }

    protected boolean isUnenumeratedItem() {
        Boolean unenum;
        IAttributeDescription ad;
        return !this.isRoot() && (ad = this.getParent().getAttributeDescription()) != null && (unenum = (Boolean)ad.getProperty("mx.config.unenumMap")) != null && unenum != false;
    }

    public boolean isRoot() {
        return this.m_parent == null;
    }

    private boolean isLocalReference(IConfigBean refBean) {
        IConfigBean rootBean = this.getRootConfigBean();
        String rootPath = rootBean.getName();
        int rootIndex = rootPath.lastIndexOf("_Default");
        if (rootIndex >= 0) {
            rootPath = rootPath.substring(0, rootIndex);
        }
        return refBean.getName().startsWith(rootPath);
    }

    public boolean isLeaf() {
        return !(this.m_value instanceof IAttributeMap) && !(this.m_value instanceof IAttributeList);
    }

    static class NodeComparator
    implements Comparator {
        NodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1 != null ? o1.toString() : "";
            String s2 = o2 != null ? o2.toString() : "";
            return COLLATOR.compare(s1, s2);
        }
    }
}

