/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config.revert;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.revert.ConfigAttributeSource;
import com.sonicsw.ma.gui.config.revert.ConfigAttributeTreeTableNode;
import com.sonicsw.ma.gui.config.revert.RevertAttributeTreeTableModel;
import com.sonicsw.ma.gui.treetable.JTreeTable;
import com.sonicsw.ma.gui.treetable.TreeTableModelAdapter;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.impl.AttributeMapImpl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;

public class JRevertDialog
extends JMADialog {
    private IConfigPlugin m_plugin;
    private JTreeTable m_treeTable;
    private JButton m_okButton = new JButton(new OKAction());

    public JRevertDialog(JMAFrame parent, IConfigPlugin plugin) {
        super(parent, "edit.config.revert");
        this.m_plugin = plugin;
    }

    @Override
    protected void maInitialize() {
        IConfigBean bean = (IConfigBean)((ConfigBeanModel)this.m_plugin.getModel()).getData();
        this.m_treeTable = new JTreeTable(new RevertAttributeTreeTableModel(this.getPlugin()));
        this.m_treeTable.setRootVisible(false);
        this.m_treeTable.getTree().setShowsRootHandles(true);
        this.getContentPane().add(JPartitionPanel.merge("r", true, new Component[]{new ExtendedJScrollPane(this.m_treeTable)}));
    }

    @Override
    protected void maCleanup() {
        this.m_plugin = null;
        this.m_treeTable = null;
    }

    public ConfigAttributeSource[] getAttributesToRevert() {
        int[] sel = this.m_treeTable.getSelectedRows();
        ArrayList<ConfigAttributeSource> res = new ArrayList<ConfigAttributeSource>(sel.length);
        TreeTableModelAdapter adapter = (TreeTableModelAdapter)this.m_treeTable.getModel();
        IConfigServer server = this.getBean().getConfigServer();
        for (int i = 0; i < sel.length; ++i) {
            ConfigAttributeTreeTableNode row = (ConfigAttributeTreeTableNode)adapter.getValueAt(sel[i], 0);
            res.add(row.getConfigAttributeSource());
        }
        return res.toArray(new ConfigAttributeSource[res.size()]);
    }

    private void validateAttributesToRevert() throws Exception {
        int[] sel = this.m_treeTable.getSelectedRows();
        ArrayList res = new ArrayList(sel.length);
        TreeTableModelAdapter adapter = (TreeTableModelAdapter)this.m_treeTable.getModel();
        IConfigServer server = this.getBean().getConfigServer();
        for (int i = 0; i < sel.length; ++i) {
            ConfigAttributeTreeTableNode instance = (ConfigAttributeTreeTableNode)adapter.getValueAt(sel[i], 0);
            Object value = instance.getValue();
            if (value == null) {
                ConfigAttributeTreeTableNode parent = instance.getParent();
                IConfigBean pBean = parent.getConfigBean();
                if (pBean == null || !pBean.isPrototypeInstance()) continue;
                IConfigPrototype prototype = pBean.getPrototype();
                value = prototype.getAttribute(parent.getConfigPath(pBean));
                this.validateAttribute(value, false);
                continue;
            }
            this.validateAttribute(value, true);
        }
    }

    private void validateAttribute(Object attribute, boolean isInstance) throws Exception {
        Object val;
        String key;
        if (attribute instanceof IConfigBean) {
            String pluginPath;
            String string = pluginPath = isInstance ? this.m_plugin.getPluginPath() : this.getPrototypePath();
            if (((IConfigBean)attribute).getName().startsWith(pluginPath)) {
                throw new Exception("Cannot revert the selected path(s). Within one of the selected path(s) there is a reference to another configuration.");
            }
        }
        if (attribute instanceof IAttributeMap) {
            Iterator i = ((AttributeMapImpl)attribute).getAllAttributeNames().iterator();
            while (i.hasNext()) {
                IAttributeMap valueMap = (IAttributeMap)attribute;
                key = (String)i.next();
                val = valueMap.getAttribute(key);
                this.validateAttribute(val, isInstance);
            }
        }
        if (attribute instanceof IAttributeList) {
            for (int i = 0; i < ((IAttributeList)attribute).size(); ++i) {
                IAttributeList valueList = (IAttributeList)attribute;
                key = Integer.toString(i);
                val = valueList.getAttribute(i);
                this.validateAttribute(val, isInstance);
            }
        }
    }

    private String getPrototypePath() {
        String path = null;
        IConfigBean bean = this.getBean();
        path = bean.getPrototype().getName();
        int index = path.lastIndexOf("_Default");
        if (index >= 0) {
            path = path.substring(0, index);
        }
        return path;
    }

    protected IConfigPlugin getPlugin() {
        return this.m_plugin;
    }

    protected IConfigBean getBean() {
        ConfigBeanModel model = (ConfigBeanModel)this.getPlugin().getModel();
        IConfigBean bean = (IConfigBean)model.getData();
        return bean;
    }

    @Override
    public Action[] getButtonActions() {
        return new Action[]{this.m_okButton.getAction(), this.getDefaultCancelAction()};
    }

    private class OKAction
    extends BasicGuiAction {
        public OKAction() {
            super("dialog.ok", JRevertDialog.this.getDefaultOKAction());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                JRevertDialog.this.validateAttributesToRevert();
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, e.getMessage(), e, true);
                return;
            }
            super.actionPerformed(evt);
        }
    }
}

