/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.config.revert;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.revert.ConfigAttributeSource;
import com.sonicsw.ma.gui.config.revert.JRevertDialog;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.impl.ConfigServer;
import java.awt.event.ActionEvent;

public class RevertAction
extends BasicPluginAction {
    public RevertAction(IPlugin plugin) {
        super(plugin, "edit.revert");
    }

    @Override
    public boolean isEnabled() {
        String pVersion;
        boolean res = false;
        if (this.getPlugin() instanceof IConfigPlugin && ((pVersion = ((IConfigPlugin)this.getPlugin()).getAttributes().getProductVersion()) == null || !pVersion.startsWith("5.") && !pVersion.equals("2.0")) && ((IConfigPlugin)this.getPlugin()).isTemplateInstance()) {
            res = true;
        }
        return res;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.getBean().getPrototype() == null) {
            MgmtConsole.getMgmtConsole().notifyMessage(3, "Meta-attributes mismatch - configuration is not a template instance", true);
            return;
        }
        IConfigServer server = this.getBean().getConfigServer();
        if (!(server instanceof ConfigServer)) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Can't perform revert operation - invalid ConfigServer", true);
        }
        JRevertDialog dlg = new JRevertDialog((JMAFrame)MgmtConsole.getMgmtConsole(), (IConfigPlugin)this.getPlugin());
        dlg.setVisible(true);
        if (dlg.getCloseCommand() == 0) {
            ConfigAttributeSource[] src = dlg.getAttributesToRevert();
            for (int i = 0; i < src.length; ++i) {
                try {
                    String name = src[i].getBean().getName();
                    IConfigPath[] paths = src[i].getPaths();
                    this.logRevert(name, paths);
                    ((ConfigServer)server).revertToTemplate(name, paths);
                    continue;
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to revert attribute(s)", e, false);
                }
            }
        }
    }

    private void logRevert(String name, IConfigPath[] paths) {
        StringBuffer sb = new StringBuffer("revert ");
        sb.append(name).append(" = ");
        for (int j = 0; j < paths.length; ++j) {
            if (j > 0) {
                sb.append(", ");
            }
            sb.append(paths[j]);
        }
        Helper.logDebugMessage(sb.toString());
    }

    protected IConfigBean getBean() {
        ConfigBeanModel model = (ConfigBeanModel)this.getPlugin().getModel();
        IConfigBean bean = (IConfigBean)model.getData();
        return bean;
    }
}

