/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.dev;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.dev.AbstractDevPlugin;
import com.sonicsw.ma.gui.dev.DevModel;
import com.sonicsw.ma.gui.dev.JDevPropertiesDialog;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigServer;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class DevElementPlugin
extends AbstractDevPlugin {
    public static final String PLUGIN_TYPE = "MF_FILE";
    public static final String CONFIG_VERSION = "100";
    public static final Object[][] ATTRIBUTES = new Object[][]{{"TYPE", "MF_FILE"}, {"DISPLAY_TYPE", "File"}, {"CONFIG_VERSION", "100"}};
    private DevModel m_model = null;

    public DevElementPlugin(IPluginContext context, String id, Map data) {
        super(context, id, data);
        this.getAttributes().put(ATTRIBUTES);
        this.getAttributes().put(data);
        this.setDisplayable(false);
    }

    @Override
    public void dispose() {
        this.m_model = null;
        super.dispose();
    }

    @Override
    public boolean expand() {
        return false;
    }

    @Override
    public JPropSheetDialog getPropSheetDialog() {
        return new JDevPropertiesDialog(MgmtConsole.getMgmtConsole());
    }

    @Override
    public List getToolTipList() {
        List list = super.getToolTipList();
        DevModel model = (DevModel)this.getModel();
        list.add(this.formatToolTipText("Size", this.formatSize(model.getSize())));
        list.add(this.formatToolTipText("Date Modified", model.getLastModifiedTime()));
        return list;
    }

    @Override
    protected JComponent[] getPluginMenuItems() {
        return super.getPluginMenuItems();
    }

    @Override
    protected JComponent[] getSystemMenuItems() {
        return super.getSystemMenuItems();
    }

    @Override
    public Object getModel() {
        if (this.m_model == null) {
            this.m_model = new DevModel(this);
        }
        return this.m_model;
    }

    @Override
    public boolean hasContent() {
        boolean res = false;
        try {
            IConfigBeanFile bean = this.getFileByPath(this.getPluginPath());
            if (bean != null && bean.getContents() != null) {
                res = true;
            }
        }
        catch (ConfigServiceException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return res;
    }

    @Override
    public void deletePlugin(IConfigServer configServer) throws Exception {
        configServer.removeConfigElement(this.getPluginPath());
    }
}

