/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.dev;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.FolderPluginExpandAction;
import com.sonicsw.ma.gui.dev.AbstractDevPlugin;
import com.sonicsw.ma.gui.dev.DevElementPlugin;
import com.sonicsw.ma.gui.dev.DevModel;
import com.sonicsw.ma.gui.dev.JDevPropertiesDialog;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.table.ObjectColumn;
import com.sonicsw.ma.gui.table.PluginAttributesTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginContentPane;
import com.sonicsw.ma.gui.table.PluginCreatedTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginModifiedTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginNameTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginSizeTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginTypeTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginVersionTableCellRenderer;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IFolderPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mx.config.IConfigServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class DevFolderPlugin
extends AbstractDevPlugin
implements IFolderPlugin {
    public static final String DISPLAY_TYPE = "Folder";
    private static final Object[][] ATTRIBUTES = new Object[][]{{"DISPLAY_TYPE", "Folder"}, {"CHILD_BEARING", Boolean.TRUE}};
    protected DevModel m_model = null;

    public DevFolderPlugin(IPluginContext context, String id, Map data) {
        super(context, id, data);
        String type;
        this.getAttributes().put(ATTRIBUTES);
        String string = type = data != null ? (String)data.get("TYPE") : null;
        if (type != null) {
            this.getAttributes().set("TYPE", type);
        }
    }

    @Override
    public IContentPane createPluginContentPane() {
        return new FileFolderContentPane();
    }

    @Override
    public BasicAction getDefaultAction() {
        return new FolderPluginExpandAction(this);
    }

    @Override
    public JPropSheetDialog getPropSheetDialog() {
        return new JDevPropertiesDialog(MgmtConsole.getMgmtConsole());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expand() {
        JProgressBar bar = MgmtConsole.getMgmtConsole().getStatusBar().getProgressBar();
        try {
            Set childSet = this.getPluginContext().getConfigContext().getConfigServer().list(this.getPluginPath());
            Iterator i = childSet != null ? childSet.iterator() : null;
            int nPluginCount = childSet != null ? childSet.size() : 0;
            int nCount = 0;
            if (bar != null) {
                bar.setMinimum(0);
                bar.setMaximum(nPluginCount);
                bar.setVisible(true);
            }
            while (i != null && i.hasNext()) {
                HashMap row = (HashMap)i.next();
                MgmtConsole.getMgmtConsole().notifyMessage(0, "Loading file element " + ++nCount + " of " + nPluginCount, null, false);
                if (bar != null) {
                    bar.setValue(nCount);
                }
                this.addChildPlugin(this.createChildPlugin(null, row), row);
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "FileFolderPlugin::expand failed", e, true);
        }
        finally {
            if (bar != null) {
                bar.setVisible(false);
                MgmtConsole.getMgmtConsole().getStatusBar().releaseProgressBar();
            }
        }
        return true;
    }

    @Override
    protected IPlugin createChildPlugin(String strName, Map metaAttributes) {
        AbstractDevPlugin plugin = null;
        try {
            if (metaAttributes.containsKey("_FOLDER_NAME")) {
                String metaName = (String)metaAttributes.get("_FOLDER_NAME");
                metaName = metaName.substring(metaName.lastIndexOf(47) + 1);
                metaAttributes.remove("_FOLDER_NAME");
                plugin = new DevFolderPlugin(this.getPluginContext(), metaName, metaAttributes);
            } else {
                IElementIdentity eid = (IElementIdentity)metaAttributes.get("_ELEMENT_IDENTITY");
                if (eid != null) {
                    String[] comp = eid.getNameComponents();
                    String metaName = comp[comp.length - 1];
                    metaAttributes.remove("_ELEMENT_IDENTITY");
                    plugin = new DevElementPlugin(this.getPluginContext(), metaName, metaAttributes);
                } else {
                    Helper.logDebugMessage("createChildPlugin: ELEMENT_IDENTITY is non-existant.");
                }
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "FileFolderPlugin::createChildPlugin failed", e, false);
        }
        return plugin;
    }

    @Override
    public Object getModel() {
        if (this.m_model == null) {
            this.m_model = new DevModel(this);
        }
        return this.m_model;
    }

    @Override
    public void deletePlugin(IConfigServer configServer) throws Exception {
        List list = this.buildDeleteList(configServer, this.getPluginPath(), new ArrayList());
        for (String entry : list) {
            if (entry.endsWith("/")) {
                configServer.deleteFolder(entry);
                continue;
            }
            configServer.removeConfigElement(entry);
        }
    }

    private List buildDeleteList(IConfigServer configServer, String path, List list) throws Exception {
        Iterator i = configServer.list(path).iterator();
        String tmp = path;
        if (!tmp.endsWith("/")) {
            tmp = tmp + "/";
        }
        list.add(0, tmp);
        while (i.hasNext()) {
            Map file = (Map)i.next();
            String type = (String)file.get("TYPE");
            String filePath = null;
            IElementIdentity ei = (IElementIdentity)file.get("_ELEMENT_IDENTITY");
            filePath = ei != null ? ei.getName() : (String)file.get("_FOLDER_NAME");
            if (type != null && !type.equals("MF_FILE")) {
                throw new Exception("Folder contain configuration '" + filePath + "'");
            }
            if (ei == null) {
                if (filePath == null) {
                    throw new Exception("Unknown entity found in File System under '" + path + "'");
                }
                this.buildDeleteList(configServer, filePath, list);
                continue;
            }
            list.add(0, ei.getName());
        }
        return list;
    }

    class FileFolderContentPane
    extends PluginContentPane {
        public FileFolderContentPane() {
            super(DevFolderPlugin.this);
        }

        @Override
        public TableColumn[] getColumns() {
            return new TableColumn[]{new ObjectColumn(0, "Name", 30, new PluginNameTableCellRenderer()), new ObjectColumn(1, "Size", 20, new PluginSizeTableCellRenderer()), new ObjectColumn(2, "Type", 30, new PluginTypeTableCellRenderer()), new ObjectColumn(3, "Date Modified", 25, new PluginModifiedTableCellRenderer()), new ObjectColumn(4, "Date Created", 25, new PluginCreatedTableCellRenderer()).setDefaultVisible(false), new ObjectColumn(5, "Attributes", 10, new PluginAttributesTableCellRenderer()).setDefaultVisible(false), new ObjectColumn(6, "Version", 15, new PluginVersionTableCellRenderer()).setDefaultVisible(false)};
        }

        @Override
        protected List getRowModel(IPlugin plugin) {
            IPluginFilter filter = plugin.getFilter();
            AbstractGUIPlugin parent = (AbstractGUIPlugin)plugin;
            ArrayList<IPlugin> list = new ArrayList<IPlugin>();
            for (int i = 0; i < parent.getChildCount(); ++i) {
                IPlugin child = (IPlugin)((Object)parent.getChildAt(i));
                if (child == null || filter == null || !filter.isPluginVisible(JTable.class, child)) continue;
                list.add(child);
            }
            return list;
        }
    }
}

