/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.dev;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.dev.AbstractDevPlugin;
import com.sonicsw.ma.gui.file.FileAssociationManager;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IFolderPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigElement;
import javax.swing.Icon;
import javax.swing.UIManager;

public class DevModel {
    private AbstractDevPlugin m_plugin = null;
    private IConfigBean m_bean;

    public DevModel(AbstractDevPlugin plugin) {
        this.m_plugin = plugin;
    }

    private IConfigBean getModel() {
        if (this.m_plugin instanceof IFolderPlugin) {
            return null;
        }
        if (this.m_bean == null) {
            this.m_bean = this.m_plugin.getAttributes().getType().equals("MF_FILE") ? this.m_plugin.getFileByPath(this.m_plugin.getPluginPath()) : (IConfigBean)this.getConfigElement(this.m_plugin.getPluginPath());
        }
        return this.m_bean;
    }

    public String getName() {
        return this.m_plugin.getPluginName();
    }

    public String getPath() {
        return this.m_plugin.getPluginPath();
    }

    public Long getSize() {
        IConfigBean model = this.getModel();
        if (model instanceof IConfigBeanFile) {
            return new Long(((IConfigBeanFile)model).getFileSize());
        }
        return null;
    }

    public String getLastModifiedTime() {
        IConfigBean model = this.getModel();
        if (model instanceof IConfigBeanFile) {
            return Helper.getDateTimeString(new Long(((IConfigBeanFile)model).getLastModifiedTime()));
        }
        return null;
    }

    public String getCreationTime() {
        long timestamp;
        IConfigBean model = this.getModel();
        if (model instanceof IConfigElement && (timestamp = model.getCreationTime()) != -1L) {
            return Helper.getDateTimeString(new Long(timestamp));
        }
        return null;
    }

    public String getCreatedBy() {
        IConfigBean model = this.getModel();
        if (model instanceof IConfigBeanFile) {
            return ((IConfigBeanFile)model).getCreateBy();
        }
        return null;
    }

    public String getType() {
        if (this.m_plugin instanceof IFolderPlugin) {
            return this.m_plugin.getAttributes().getDisplayType();
        }
        if (this.m_plugin.getAttributes().getType().equals("MF_FILE")) {
            return FileAssociationManager.getAssociation(this.m_plugin.getPluginName()).getDescription();
        }
        return "Configuration";
    }

    public Icon getTypeIcon() {
        ExtendedImageIcon icon = null;
        if (this.m_plugin instanceof IFolderPlugin) {
            icon = new ExtendedImageIcon(UIManager.getIcon("Tree.closedIcon"));
            if (this.m_plugin.getAttributes().getType() != null) {
                icon.addOverlay(ResourceManager.getIcon(this.getClass(), "configoverlay"));
            }
        } else {
            if (this.m_plugin.getAttributes().getType().equals("MF_FILE")) {
                return this.getModel() != null ? FileAssociationManager.getAssociation(this.getModel().getName()).getIcon() : null;
            }
            return ResourceManager.getTypeIcon(this.getClass(), "FileConfig");
        }
        return icon;
    }

    public static String getFileExtension(String strFilename) {
        String fileExt = new String("");
        int index = strFilename.lastIndexOf(46);
        if (index != -1) {
            fileExt = strFilename.substring(index + 1).toUpperCase();
        }
        return fileExt.trim();
    }

    public boolean isSystem() {
        return this.m_plugin != null ? this.m_plugin.getAttributes().isSystem() : false;
    }

    public String getDsXml(IConfigElement element) {
        String xml = null;
        try {
            IPluginContext context = this.m_plugin.getPluginContext();
            String storagePath = context.getConnectionInfo().getDirectoryService().logicalToStorage(element.getName());
            IDirectoryAdminService ds = (IDirectoryAdminService)context.getConnectionInfo().getDirectoryService();
            xml = ds.exportElementToXML(storagePath);
        }
        catch (Exception e) {
            xml = "Failed to exportBean - " + e.getMessage();
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return xml;
    }

    public IConfigElement getConfigElement(String logicalPath) {
        IConfigElement res = null;
        try {
            res = this.m_plugin.getPluginContext().getConfigContext().getConfigServer().loadConfigElement(logicalPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }
}

