/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.dev;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.dev.DevModel;
import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.table.PluginSizeTableCellRenderer;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IFolderPlugin;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPrototype;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import modelobjects.framework.EditRule;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

public class JDevPropertiesDialog
extends JPropSheetTabbedDialog {
    private JTextField m_path = new JTextField();
    private JTextField m_type = new JTextField();
    private JTextField m_creationTime = new JTextField();
    private JTextField m_lastModifiedTime = new JTextField();
    private JTextField m_size = new JTextField();
    private JTextField m_createdBy = new JTextField();
    private JCheckBox m_system = new JCheckBox();

    public JDevPropertiesDialog(JMAFrame parent) {
        super(parent, "file-element", DevModel.class);
    }

    @Override
    public void initUI() throws Exception {
        DevModel model = (DevModel)this.getModel();
        this.setTitle(model.getName() + " " + ResourceManager.getString(this.getClass(), "dialog.file-element.title"));
        String generalTab = ResourceManager.getString(this.getClass(), "dialog.file-element.tab.general.label");
        this.addTabPanel(generalTab, JPartitionPanel.wrap(this.createGeneralPanel()));
        if (!(this.getPlugin() instanceof IFolderPlugin) && !this.getPlugin().getAttributes().getType().equals("MF_FILE")) {
            IConfigElement ce = model.getConfigElement(this.getPlugin().getPluginPath());
            JTextArea taInstance = new JTextArea(model.getDsXml(ce));
            taInstance.setEditable(false);
            this.getTabbedPane().addTab("XML", new JScrollPane(taInstance));
            if (ce.isPrototypeInstance()) {
                JTextArea taTemplate = new JTextArea(model.getDsXml((IConfigElement)ce.getPrototype()));
                taTemplate.setEditable(false);
                this.getTabbedPane().addTab("Template XML", new JScrollPane(taTemplate));
            }
            this.getTabbedPane().addTab("Advanced", new JScrollPane(this.buildBeanInfo(ce)));
        }
    }

    @Override
    public void initForm() throws Exception {
        new JTextFieldAdapter(ModelAspectId.forName("path"), this.m_path, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("type"), this.m_type, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("creationTime"), this.m_creationTime, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("lastModifiedTime"), this.m_lastModifiedTime, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("size"), this.m_size, EditRule.NEVER, new SizeViewValueConverter(), this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("createdBy"), this.m_createdBy, EditRule.NEVER, null, this.getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("system"), this.m_system, EditRule.NEVER, null, this.getMediator());
    }

    private JPanel createGeneralPanel() {
        JPartitionPanel panel = new JPartitionPanel(false, "p,r", "");
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.path.label"), (JComponent)this.m_path);
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.type.label"), (JComponent)this.m_type);
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.creationTime.label"), (JComponent)this.m_creationTime);
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.lastModifiedTime.label"), (JComponent)this.m_lastModifiedTime);
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.size.label"), (JComponent)this.m_size);
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.createdBy.label"), (JComponent)this.m_createdBy);
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.system.label"), (JComponent)this.m_system);
        return panel;
    }

    private JTextArea buildBeanInfo(IConfigElement element) {
        IConfigPrototype prototype;
        JTextArea genPane = new JTextArea();
        genPane.setEditable(false);
        genPane.append("Name: " + element.getName() + "\n");
        if (element instanceof IConfigBean) {
            genPane.append("Type: " + ((IConfigBean)element).getConfigType().getName() + "\n");
            genPane.append("Version: " + ((IConfigBean)element).getConfigType().getVersion() + "\n");
        }
        genPane.append("\n");
        genPane.append("\nMODIFIED: " + element.isModified() + "\n");
        if (element instanceof IConfigPrototype) {
            genPane.append("TEMPLATE:\n");
            try {
                prototype = (IConfigPrototype)element;
                Set instances = prototype.getPrototypeInstances();
                for (IConfigElement instance : instances) {
                    if (instance == null) continue;
                    genPane.append(" > " + instance.getName() + "\n");
                }
            }
            catch (ConfigServiceException e) {
                genPane.append(" > FAILED TO RETRIEVE INSTANCE INFO\n");
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
        } else if (element.getPrototype() != null) {
            prototype = element.getPrototype();
            genPane.append("INSTANCE OF TEMPLATE: '" + prototype.getName() + "'" + "\n");
        }
        genPane.append("\nMETA ATTRIBUTES:\n");
        try {
            HashMap maMap = element.getMetaAttributes();
            for (String maKey : maMap.keySet()) {
                Object maValue = maMap.get(maKey);
                genPane.append(maKey + " = " + maValue + "\n");
            }
        }
        catch (ConfigServiceException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return genPane;
    }

    class SizeViewValueConverter
    implements ViewValueConverter {
        SizeViewValueConverter() {
        }

        @Override
        public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
            Object modelValue = null;
            try {
                if (viewValue != null) {
                    viewValue = Long.valueOf(viewValue.toString());
                }
            }
            catch (Exception e) {
                throw new ViewValueConversionException("Value is not a long!", e, ModelAspectId.forName("size"));
            }
            return modelValue;
        }

        @Override
        public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
            return modelValue != null ? PluginSizeTableCellRenderer.formatSize((Long)modelValue) : null;
        }

        @Override
        public String[] getViewStringValues() {
            return null;
        }

        @Override
        public boolean isViewValueToModelSupported() {
            return true;
        }

        @Override
        public Class getModelClass() {
            return Long.class;
        }

        @Override
        public Class getViewClass() {
            return String.class;
        }
    }
}

