/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.domain;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.domain.StateChangeEvent;
import com.sonicsw.ma.gui.domain.StateChangeListener;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.StateHelper;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IIdentity;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.IState;
import com.sonicsw.mf.common.runtime.ISubComponentState;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.ComponentState;
import com.sonicsw.mf.common.runtime.impl.ContainerState;
import com.sonicsw.mf.mgmtapi.runtime.IAgentManagerProxy;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import com.sonicsw.mx.config.IConfigServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationListener;

public class AgentManagerConnection
extends Thread
implements NotificationListener {
    private HashMap m_containerStatesByConfigID = new HashMap();
    private HashMap m_containerStatesByLogicalID = new HashMap();
    private HashMap m_containerStatesByRuntimeID = new HashMap();
    private Vector m_stateListeners = new Vector();
    private IAgentManagerProxy m_agentManager;
    private IConfigServer m_configServer;
    private boolean m_shutdown = false;
    private boolean m_pollImmediately = false;
    private Object m_agentManagerConnLockObj = new Object();
    public static final String EVENT_ONLINE = "Online";
    public static final String EVENT_OFFLINE = "Offline";
    public static final String EVENT_UNREACHABLE = "Unreachable";
    public static final String EVENT_STARTUP = "Startup";
    public static final String EVENT_SHUTDOWN = "Shutdown";
    public static final String EVENT_ACTIVATE = "Activate";
    public static final String EVENT_DEACTIVATE = "Deactivate";
    public static final String EVENT_LOAD = "Load";
    public static final String EVENT_UNLOAD = "Unload";
    public static final String EVENT_FAILOVER = "Failover";
    public static final String EVENT_FAILURE = "Failure";
    public static final String[] HANDLED_EVENTS = new String[]{"Online", "Offline", "Unreachable", "Startup", "Shutdown", "Activate", "Deactivate", "Load", "Unload", "Failover", "Failure"};
    public static final short OPERATION_LOAD = 5;
    public static final short OPERATION_UNLOAD = 6;
    private static final IContainerState[] EMPTY_CONTAINER_STATE_ARRAY = new IContainerState[0];
    private static final IIdentity[] EMPTY_IDENTITY_ARRAY = new IIdentity[0];

    public AgentManagerConnection(IAgentManagerProxy agentManager, IConfigServer configServer) {
        super("AgentManager monitor");
        this.m_agentManager = agentManager;
        this.m_configServer = configServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.m_agentManagerConnLockObj;
        synchronized (object) {
            this.m_shutdown = true;
            this.m_agentManagerConnLockObj.notifyAll();
        }
        this.m_agentManager = null;
        this.m_configServer = null;
    }

    public void startAMConnection() {
        if (this.m_agentManager != null) {
            boolean alive = this.isAlive();
            if (!this.isAlive()) {
                this.setDaemon(true);
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isUnreachableReported = false;
        while (!this.isInterrupted() && !this.m_shutdown) {
            Object object;
            long timestamp = System.currentTimeMillis();
            try {
                try {
                    Object object2 = this.m_agentManagerConnLockObj;
                    synchronized (object2) {
                        this.m_pollImmediately = false;
                    }
                    if (this.m_agentManager != null) {
                        this.setContainerStates((IContainerState[])this.m_agentManager.getCollectiveState(), true);
                    }
                    if (this.m_shutdown) break;
                    isUnreachableReported = false;
                }
                catch (ProxyRuntimeException e) {
                    if (!isUnreachableReported && !this.m_shutdown) {
                        MgmtConsole.getMgmtConsole().notifyMessage(4, "Agent Manager is unreacheable", e, false);
                        isUnreachableReported = true;
                    }
                    object = this.m_containerStatesByConfigID;
                    synchronized (object) {
                        this.setContainerStates(this.getAllContainerStates(), (short)0, timestamp);
                    }
                    if (e.getTargetException() instanceof InvokeTimeoutException) {
                        continue;
                    }
                }
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Error while updating domain state", e, false);
            }
            int interval = PreferenceManager.getInstance().getInt("preferences.general", "amPollFrequencySecs", 30);
            object = this.m_agentManagerConnLockObj;
            synchronized (object) {
                if (!this.m_pollImmediately) {
                    try {
                        this.m_agentManagerConnLockObj.wait(interval * 1000);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                if (this.m_shutdown) {
                    break;
                }
                if (this.m_pollImmediately) {
                    try {
                        this.m_agentManagerConnLockObj.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String containerRuntimeID;
        IComponentIdentity source;
        IContainerState containerState;
        INotification mfNotification = (INotification)notification;
        String eventName = mfNotification.getEventName();
        if (MgmtConsole.DEVELOPER_MODE) {
            Helper.logDebugMessage("EVENT name=" + eventName + ", source=" + mfNotification.getSourceIdentity().getCanonicalName());
        }
        if (eventName.equals(EVENT_ACTIVATE)) {
            return;
        }
        if (eventName.equals(EVENT_DEACTIVATE)) {
            return;
        }
        if (eventName.equals(EVENT_SHUTDOWN) && (containerState = this.getContainerStateByRuntimeID((source = mfNotification.getSourceIdentity()).getDomainName() + '.' + source.getContainerName())) != null) {
            IComponentState[] componentStates = containerState.getComponentStates();
            for (int i = 0; i < componentStates.length; ++i) {
                IComponentIdentity componentID = (IComponentIdentity)componentStates[i].getRuntimeIdentity();
                if (!componentID.getComponentName().equals("AGENT MANAGER") || !this.isOnlyAgentManager(componentID, this.getAllContainerStates())) continue;
                this.handleAgentManagerStateChange((short)1, mfNotification.getTimeStamp());
                return;
            }
        }
        if (eventName.equals(EVENT_FAILOVER) && (source = mfNotification.getSourceIdentity()).getComponentName().equals("AGENT MANAGER")) {
            this.handleAgentManagerStateChange((short)3, mfNotification.getTimeStamp());
            return;
        }
        if (eventName.equals(EVENT_UNREACHABLE) && (containerState = this.getContainerStateByRuntimeID(containerRuntimeID = (String)mfNotification.getAttributes().get("Container"))) != null && containerState.getState() == 1) {
            return;
        }
        this.pollImmediately();
    }

    public boolean containerExists(String logicalName) {
        return this.m_containerStatesByLogicalID.get(logicalName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activeComponentExists(String logicalName) {
        String configID = this.logicalToStorage(logicalName);
        if (configID == null) {
            return false;
        }
        HashMap hashMap = this.m_containerStatesByConfigID;
        synchronized (hashMap) {
            IContainerState[] containerStates = this.getAllContainerStates();
            for (int i = 0; i < containerStates.length; ++i) {
                IComponentState[] componentStates = containerStates[i].getComponentStates();
                for (int j = 0; j < componentStates.length; ++j) {
                    if (!componentStates[j].getRuntimeIdentity().getConfigIdentity().getName().equals(configID) || componentStates[j].getState() != 3) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIdentity[] getActiveComponentIdentitiesByConfigID(String logicalName) {
        ArrayList<IIdentity> activeComponentIDs = new ArrayList<IIdentity>();
        String configID = this.logicalToStorage(logicalName);
        if (configID == null) {
            return EMPTY_IDENTITY_ARRAY;
        }
        HashMap hashMap = this.m_containerStatesByConfigID;
        synchronized (hashMap) {
            IContainerState[] containerStates = this.getAllContainerStates();
            for (int i = 0; i < containerStates.length; ++i) {
                IComponentState[] componentStates = containerStates[i].getComponentStates();
                for (int j = 0; j < componentStates.length; ++j) {
                    IIdentity runtimeID = componentStates[j].getRuntimeIdentity();
                    if (!runtimeID.getConfigIdentity().getName().equals(configID) || componentStates[j].getState() != 3) continue;
                    activeComponentIDs.add(runtimeID);
                }
            }
        }
        return activeComponentIDs.toArray(EMPTY_IDENTITY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIdentity[] getActiveComponentIdentitiesByPluginType(String pluginType) {
        ArrayList<IIdentity> activeComponentIDs = new ArrayList<IIdentity>();
        HashMap hashMap = this.m_containerStatesByConfigID;
        synchronized (hashMap) {
            IContainerState[] containerStates = this.getAllContainerStates();
            for (int i = 0; i < containerStates.length; ++i) {
                IComponentState[] componentStates = containerStates[i].getComponentStates();
                for (int j = 0; j < componentStates.length; ++j) {
                    IIdentity runtimeID = componentStates[j].getRuntimeIdentity();
                    if (!runtimeID.getConfigIdentity().getType().equals(pluginType) || componentStates[j].getState() != 3) continue;
                    activeComponentIDs.add(runtimeID);
                }
            }
        }
        return activeComponentIDs.toArray(EMPTY_IDENTITY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runtimeIDToConfigName(String runtimeID) {
        if (runtimeID == null || runtimeID.length() == 0) {
            return null;
        }
        int index = runtimeID.indexOf(":ID=");
        String containerRuntimeID = index == -1 ? runtimeID : runtimeID.substring(0, index);
        HashMap hashMap = this.m_containerStatesByConfigID;
        synchronized (hashMap) {
            IContainerState containerState = this.getContainerStateByRuntimeID(containerRuntimeID);
            IIdentity identity = containerState.getRuntimeIdentity();
            if (identity.getCanonicalName().equals(runtimeID)) {
                return this.storageToLogical(identity.getConfigIdentity().getName());
            }
            IComponentState[] componentStates = containerState.getComponentStates();
            for (int j = 0; j < componentStates.length; ++j) {
                identity = componentStates[j].getRuntimeIdentity();
                if (!identity.getCanonicalName().equals(runtimeID)) continue;
                return this.storageToLogical(identity.getConfigIdentity().getName());
            }
        }
        return null;
    }

    public IContainerState getContainerStateByLogicalName(String logicalName) {
        return (IContainerState)this.m_containerStatesByLogicalID.get(logicalName);
    }

    private IContainerState[] getAllContainerStates() {
        return this.m_containerStatesByConfigID.values().toArray(EMPTY_CONTAINER_STATE_ARRAY);
    }

    public IContainerState getContainerStateByRuntimeID(String runtimeID) {
        CanonicalName canonicalName = new CanonicalName(runtimeID);
        canonicalName = new CanonicalName(canonicalName.getDomainName(), canonicalName.getContainerName(), "");
        if (runtimeID.indexOf(":ID=") == -1) {
            runtimeID = runtimeID + ":ID=AGENT";
        }
        return (IContainerState)this.m_containerStatesByRuntimeID.get(canonicalName.getCanonicalName());
    }

    public void addStateChangeListener(StateChangeListener listener) {
        this.m_stateListeners.add(listener);
    }

    public void removeStateChangeListener(StateChangeListener listener) {
        this.m_stateListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollImmediately() {
        Object object = this.m_agentManagerConnLockObj;
        synchronized (object) {
            this.m_pollImmediately = true;
            this.m_agentManagerConnLockObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContainerStates(IContainerState[] containerStates, boolean removeObsolete) {
        HashMap hashMap = this.m_containerStatesByConfigID;
        synchronized (hashMap) {
            String logicalID;
            String configID;
            if (removeObsolete) {
                IContainerState[] currentContainerStates = this.getAllContainerStates();
                block3: for (int i = 0; i < currentContainerStates.length; ++i) {
                    IIdentity runtimeID = currentContainerStates[i].getRuntimeIdentity();
                    configID = runtimeID.getConfigIdentity().getName();
                    logicalID = this.storageToLogical(configID);
                    for (int j = 0; j <= containerStates.length; ++j) {
                        if (j == containerStates.length) {
                            this.m_containerStatesByConfigID.remove(configID);
                            this.m_containerStatesByRuntimeID.remove(runtimeID.getCanonicalName());
                            if (logicalID == null) continue block3;
                            this.m_containerStatesByLogicalID.remove(logicalID);
                            continue block3;
                        }
                        if (containerStates[j].getRuntimeIdentity().getConfigIdentity().getName().equals(configID)) continue block3;
                    }
                }
            }
            for (int i = 0; i < containerStates.length; ++i) {
                int j;
                IIdentity runtimeID = containerStates[i].getRuntimeIdentity();
                String containerName = runtimeID.getContainerName();
                configID = runtimeID.getConfigIdentity().getName();
                logicalID = this.storageToLogical(configID);
                IContainerState existingContainerState = (IContainerState)this.m_containerStatesByConfigID.get(configID);
                if (existingContainerState == null || existingContainerState.getState() == 0 && containerStates[i].getState() == 1) {
                    IComponentState[] componentStates;
                    this.m_containerStatesByConfigID.put(configID, containerStates[i]);
                    this.m_containerStatesByRuntimeID.put(runtimeID.getCanonicalName(), containerStates[i]);
                    if (logicalID != null) {
                        this.m_containerStatesByLogicalID.put(logicalID, containerStates[i]);
                    }
                    if ((componentStates = containerStates[i].getComponentStates()).length == 0) {
                        this.fireStateChangeEvent(containerStates[i].getState(), configID, "AGENT", containerStates[i], null);
                        continue;
                    }
                    for (int j2 = 0; j2 < componentStates.length; ++j2) {
                        this.fireStateChangeEvent(componentStates[j2].getState(), configID, ((IComponentIdentity)componentStates[j2].getRuntimeIdentity()).getComponentName(), containerStates[i], componentStates[j2]);
                    }
                    continue;
                }
                if (existingContainerState.getTimeStamp() >= containerStates[i].getTimeStamp() && (existingContainerState.getTimeStamp() <= 0L || containerStates[i].getTimeStamp() != 0L || containerStates[i].getState() != 0) && (existingContainerState.getState() > 1 || containerStates[i].getState() != 3)) continue;
                boolean isCombinedState = false;
                this.m_containerStatesByConfigID.put(configID, containerStates[i]);
                this.m_containerStatesByRuntimeID.put(runtimeID.getCanonicalName(), containerStates[i]);
                if (logicalID != null) {
                    this.m_containerStatesByLogicalID.put(logicalID, containerStates[i]);
                }
                IComponentState[] existingStates = existingContainerState.getComponentStates();
                IComponentState[] newStates = containerStates[i].getComponentStates();
                block7: for (j = 0; j < existingStates.length; ++j) {
                    String componentName = ((IComponentIdentity)existingStates[j].getRuntimeIdentity()).getComponentName();
                    for (int k = 0; k <= newStates.length; ++k) {
                        if (k == newStates.length) {
                            this.fireStateChangeEvent((short)6, configID, "AGENT", containerStates[i], existingStates[j]);
                            continue block7;
                        }
                        if (((IComponentIdentity)newStates[k].getRuntimeIdentity()).getComponentName().equals(componentName)) continue block7;
                    }
                }
                block9: for (j = 0; j < newStates.length; ++j) {
                    IComponentIdentity componentID = (IComponentIdentity)newStates[j].getRuntimeIdentity();
                    String componentName = componentID.getComponentName();
                    for (int k = 0; k <= existingStates.length; ++k) {
                        short newSubComponentState = StateHelper.getSubComponentState((IState)newStates[j]);
                        short existingSubComponentState = 1;
                        if (k < existingStates.length && existingStates.length > 0) {
                            existingSubComponentState = StateHelper.getSubComponentState((IState)existingStates[k]);
                        }
                        if (!componentName.equalsIgnoreCase("Agent") && !isCombinedState && newSubComponentState != existingSubComponentState) {
                            isCombinedState = true;
                        }
                        if (k == existingStates.length) {
                            this.fireStateChangeEvent((short)5, configID, "AGENT", containerStates[i], newStates[j]);
                            continue block9;
                        }
                        if (!((IComponentIdentity)existingStates[k].getRuntimeIdentity()).getComponentName().equals(componentName)) continue;
                        if (newStates[j].getState() == existingStates[k].getState()) continue block9;
                        this.fireStateChangeEvent(newStates[j].getState(), configID, componentName, containerStates[i], newStates[j]);
                        if (!componentName.equals("AGENT MANAGER") || !this.isOnlyAgentManager(componentID, containerStates)) continue block9;
                        this.handleAgentManagerStateChange(newStates[j].getState(), containerStates[i].getTimeStamp());
                        continue block9;
                    }
                }
                if (!isCombinedState) continue;
                this.fireStateChangeEvent((short)6, configID, "AGENT", containerStates[i], null);
            }
            if (MgmtConsole.DEVELOPER_MODE) {
                StringBuffer buffer = new StringBuffer("ContainerStates\r\n");
                Set keys = this.m_containerStatesByLogicalID.keySet();
                for (String logicalName : keys) {
                    IContainerState state = (IContainerState)this.m_containerStatesByLogicalID.get(logicalName);
                    buffer.append(logicalName).append(" - ").append(state.toString());
                    buffer.append("\r\n");
                    IComponentState[] components = state.getComponentStates();
                    for (int i = 0; i < components.length; ++i) {
                        buffer.append("\t").append(components[i].getRuntimeIdentity().getCanonicalName());
                        buffer.append(" - ").append(components[i].getStateString());
                        buffer.append("\r\n");
                        buffer.append("\t\tSub Component States:\r\n");
                        Map subComponentStates = components[i].getSubComponentStates();
                        Set entrySet = subComponentStates.entrySet();
                        for (Map.Entry entry : entrySet) {
                            ISubComponentState[] subCompStates = (ISubComponentState[])entry.getValue();
                            for (int ctr = 0; ctr < subCompStates.length; ++ctr) {
                                buffer.append("\t\t\t").append(subCompStates[ctr].getSubComponentName()).append("-").append(subCompStates[ctr].getStateString());
                                buffer.append("\r\n");
                            }
                        }
                    }
                }
                Helper.logDebugMessage(buffer.toString());
            }
        }
    }

    private boolean isOnlyAgentManager(IComponentIdentity amID, IContainerState[] containerStates) {
        String amContainerID = amID.getDomainName() + '.' + amID.getContainerName();
        for (int j = 0; j < containerStates.length; ++j) {
            if (containerStates[j].getRuntimeIdentity().getCanonicalName().equals(amContainerID)) continue;
            IComponentState[] states = containerStates[j].getComponentStates();
            for (int k = 0; k < states.length; ++k) {
                String componentName = ((IComponentIdentity)states[k].getRuntimeIdentity()).getComponentName();
                if (!componentName.equals("AGENT MANAGER")) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContainerStates(IContainerState[] containerStates, short newState, long timestamp) {
        HashMap hashMap = this.m_containerStatesByConfigID;
        synchronized (hashMap) {
            for (int i = 0; i < containerStates.length; ++i) {
                String containerName = containerStates[i].getRuntimeIdentity().getContainerName();
                String configID = containerStates[i].getRuntimeIdentity().getConfigIdentity().getName();
                IContainerState existingContainerState = (IContainerState)this.m_containerStatesByConfigID.get(configID);
                if (existingContainerState.getTimeStamp() > containerStates[i].getTimeStamp() || existingContainerState.getState() == newState) continue;
                ((ContainerState)existingContainerState).setState(newState);
                ((ContainerState)existingContainerState).setTimestamp(timestamp);
                IComponentState[] componentStates = containerStates[i].getComponentStates();
                if (componentStates.length == 0) {
                    this.fireStateChangeEvent(containerStates[i].getState(), configID, "AGENT", containerStates[i], null);
                    continue;
                }
                for (int j = 0; j < componentStates.length; ++j) {
                    if (componentStates[j].getState() == newState) continue;
                    ((ComponentState)componentStates[j]).setState(newState);
                    this.fireStateChangeEvent(componentStates[j].getState(), configID, ((IComponentIdentity)componentStates[j].getRuntimeIdentity()).getComponentName(), existingContainerState, componentStates[j]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAgentManagerStateChange(short state, long timestamp) {
        if (state == 1) {
            HashMap hashMap = this.m_containerStatesByConfigID;
            synchronized (hashMap) {
                this.setContainerStates(this.getAllContainerStates(), (short)0, timestamp);
            }
        } else if (state == 3) {
            this.pollImmediately();
        }
    }

    private void fireStateChangeEvent(short operation, String configID, String componentName, IContainerState containerState, IComponentState componentState) {
        IContainerState state = componentName.equals("AGENT") ? containerState : componentState;
        String logicalName = this.storageToLogical(configID);
        if (logicalName == null) {
            return;
        }
        StateChangeEvent event = new StateChangeEvent(this, operation, logicalName, componentName, (IState)state);
        if (this.m_stateListeners.isEmpty()) {
            return;
        }
        if (MgmtConsole.DEVELOPER_MODE) {
            Helper.logDebugMessage("FIRE operation=" + event.getOperation() + ", configID=" + event.getContainerConfigName() + ", ID=" + event.getComponentName() + ", state=" + event.getState().getState() + " (" + IComponentState.STATE_TEXT[event.getState().getState()] + ")");
        }
        Vector m_stateListener_clone = (Vector)this.m_stateListeners.clone();
        Iterator iterator = m_stateListener_clone.iterator();
        while (iterator.hasNext()) {
            try {
                ((StateChangeListener)iterator.next()).domainStateChanged(event);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Error while notifying update to domain state", e, false);
            }
        }
    }

    public String logicalToStorage(String name) {
        String ret = null;
        if (this.m_configServer != null) {
            try {
                ret = this.m_configServer.logicalToStorage(name);
            }
            catch (Exception e) {
                Helper.logDebugMessage("Failed to perform logicalToStorage for " + name);
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
        }
        return ret;
    }

    public String storageToLogical(String id) {
        String ret = null;
        if (this.m_configServer != null) {
            try {
                ret = this.m_configServer.storageToLogical(id);
            }
            catch (Exception e) {
                Helper.logDebugMessage("Failed to perform storageToLogical for " + id);
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
        }
        return ret;
    }
}

