/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.domain;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.domain.AgentManagerConnection;
import com.sonicsw.ma.gui.domain.JFailoverDialog;
import com.sonicsw.mf.comm.IRetryCallback;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.Version;
import com.sonicsw.mf.common.security.ManagementPermissionDeniedException;
import com.sonicsw.mf.jmx.client.IConnectionListener;
import com.sonicsw.mf.jmx.client.IOrphanedReplyListener;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mf.mgmtapi.runtime.IAgentManagerProxy;
import com.sonicsw.mf.mgmtapi.runtime.MFProxyFactory;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.impl.ConfigServer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class DomainConnectionModel
implements IOrphanedReplyListener,
IConnectionListener,
IRetryCallback,
Serializable {
    public static final int DEF_TIMEOUT = 30;
    private static final int DEF_CONNECT_TIMEOUT = 10;
    private static final int DEF_SUBSCRIPTION_TIMEOUT = 600;
    private static final int DEF_SUBSCRIPTION_RENEWAL_INTERVAL = 30;
    private static final String DEF_DOMAIN_NAME = "Domain1";
    private static final String DEF_CONNECTION_URL = "tcp://localhost:2506";
    private static final String DEF_CONNECTION_NAME = "Connection1";
    public static final int DEF_MAX_CONNECTIONS = 10;
    public static final int DEF_SOCKET_CONNECT_TIMEOUT = 5;
    public static String PREFS_CONNECTION_NAME = "connectionName";
    public static String PREFS_DOMAIN_NAME = "domainName";
    public static String PREFS_URL = "url";
    public static String PREFS_TIMEOUT = "timeout";
    public static String PREFS_USER_NAME = "userName";
    public static String PREFS_PASSWORD = "password";
    public static String PREFS_USE_DRA = "useRouting";
    public static String PREFS_LOAD_BALANCING = "loadBalancing";
    public static String PREFS_ENABLE_COMPRESSION = "enableCompression";
    public static String PREFS_NODE = "managementNode";
    public static String PREFS_MAX_CONNECTIONS = "maxConnections";
    public static String PREFS_CONNECT_TIMEOUT = "connectTimeout";
    public static String PREFS_SUBSCRIPTION_TIMEOUT = "notificationSubscriptionTimeout";
    public static String PREFS_SUBSCRIPTION_RENEWAL_INTERVAL = "notificationSubscriptionRenewalTimeout";
    public static String PREFS_SOCKET_CONNECT_TIMEOUT = "socketConnectTimeout";
    private String m_connectionName = "Connection1";
    private String m_domainName = "Domain1";
    private String m_url = "tcp://localhost:2506";
    private int m_requestTimeout = 30;
    private int m_connectTimeout = 10;
    private int m_subscriptionTimeout = 600;
    private int m_subscriptionRenewalInterval = 30;
    private String m_userName = MgmtConsole.DEVELOPER_MODE ? "Administrator" : null;
    private String m_password = MgmtConsole.DEVELOPER_MODE ? "Administrator" : null;
    private String m_managementNode;
    private boolean m_loadBalancing = true;
    private boolean m_enableCompression = false;
    private boolean m_useDRA = false;
    private boolean m_default = false;
    private int m_socketConnectTimeout = 5;
    private ConfigServerUtility m_csu;
    private IAgentManagerProxy m_amProxy;
    private AgentManagerConnection m_amConnection;
    private ArrayList m_stateListenerRegistrationThreads;

    public DomainConnectionModel(PreferenceManager prefs) {
        this(prefs, DomainConnectionModel.getDefaultFromPrefs(prefs));
        this.setDefaultProperty(prefs);
    }

    private void setDefaultProperty(PreferenceManager prefs) {
        if (DomainConnectionModel.getDefaultFromPrefs(prefs) == null) {
            this.setDefault(true);
        }
    }

    public DomainConnectionModel(PreferenceManager prefs, String name) {
        this.initFromPrefs(prefs, name != null ? name : DEF_CONNECTION_NAME);
        if (MgmtConsole.DEVELOPER_MODE) {
            this.m_password = this.m_url.endsWith(".xml") ? null : this.m_password;
        }
    }

    public int getUniqueId() {
        return new StringBuffer(this.m_url).append("/").append(this.m_domainName).toString().hashCode();
    }

    public void connect() throws Exception {
        this.m_csu = new ConfigServerUtility();
        this.m_csu.setRequestTimeout((long)this.getTimeout());
        this.m_csu.setConnectTimeout((long)this.getConnectTimeout());
        this.m_csu.setLoadBalancing(this.isLoadBalancing());
        this.m_csu.setEnableCompression(this.isEnableCompression());
        this.m_csu.setUseDRA(this.isUseDRA());
        this.m_csu.setManagementNode(this.getManagementNode());
        this.m_csu.setRequiredVersion(new String(Version.getMajorVersion() + "." + Version.getMinorVersion()));
        this.m_csu.setSocketConnectTimeout(this.getSocketConnectTimeout());
        this.m_csu.connect(this.getDomainName(), this.getUrl(), this.getUserName(), this.getPassword(), true);
        IRemoteMBeanServer server = this.m_csu.getMBeanServer();
        if (server != null) {
            ((JMSConnectorClient)server).setOrphanedReplyListener((IOrphanedReplyListener)this);
            ((JMSConnectorClient)server).setConnectionListener((IConnectionListener)this);
            ((JMSConnectorClient)server).registerRetryCallback((IRetryCallback)this);
            ((JMSConnectorClient)server).setNotificationSubscriptionTimeout((long)this.getNotificationSubscriptionTimeout());
            ((JMSConnectorClient)server).setNotificationSubscriptionRenewalInterval((long)this.getNotificationSubscriptionRenewalInterval());
        }
        if (!this.m_csu.isLocal()) {
            this.m_amProxy = this.createAMProxy(server);
            this.m_amConnection = new AgentManagerConnection(this.m_amProxy, this.m_csu.getConfigServer());
            this.registerStateNotificationListener();
        } else {
            this.m_amConnection = new AgentManagerConnection(null, this.m_csu.getConfigServer());
        }
        if (this.m_amConnection != null) {
            this.m_amConnection.startAMConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws Exception {
        MgmtConsole console = MgmtConsole.getMgmtConsole();
        if (this.m_csu.getConfigServer() != null) {
            ((ConfigServer)this.m_csu.getConfigServer()).close(false);
        }
        if (this.m_stateListenerRegistrationThreads != null) {
            Object[] registrars = this.m_stateListenerRegistrationThreads.toArray();
            for (int i = 0; i < registrars.length; ++i) {
                if (!((Thread)registrars[i]).isAlive()) continue;
                ((Thread)registrars[i]).interrupt();
            }
        }
        try {
            if (this.m_amConnection != null) {
                this.m_amConnection.disconnect();
            }
        }
        catch (Throwable e) {
            console.notifyMessage(4, "Failed to disconnect Agent Manager connection", e, false);
        }
        finally {
            this.m_amConnection = null;
        }
        this.m_amProxy = null;
        IRemoteMBeanServer server = this.getMBeanServer();
        if (server != null) {
            ((JMSConnectorClient)server).deregisterRetryCallback();
            ((JMSConnectorClient)server).setOrphanedReplyListener(null);
        }
        if (this.m_csu != null) {
            try {
                this.m_csu.disconnect();
            }
            catch (Throwable e) {
                console.notifyMessage(4, "Failed to disconnect Config Server", e, false);
            }
            finally {
                this.m_csu = null;
            }
        }
    }

    public boolean isDefault() {
        return this.m_default;
    }

    public void setDefault(boolean value) {
        this.m_default = value;
    }

    public String getConnectionName() {
        return this.m_connectionName;
    }

    public void setConnectionName(String name) {
        this.m_connectionName = name != null ? name.trim() : null;
    }

    public void setTimeout(int timeout) {
        this.m_requestTimeout = timeout;
    }

    public int getTimeout() {
        return this.m_requestTimeout;
    }

    public String getDomainName() {
        return this.m_domainName;
    }

    public void setDomainName(String name) {
        this.m_domainName = name != null ? name.trim() : null;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) {
        this.m_url = url != null ? url.trim() : null;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public void setUserName(String name) {
        this.m_userName = name != null ? name.trim() : null;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String name) {
        this.m_password = name;
    }

    public boolean isLoadBalancing() {
        return this.m_loadBalancing;
    }

    public void setLoadBalancing(boolean value) {
        this.m_loadBalancing = value;
    }

    public void setEnableCompression(boolean value) {
        this.m_enableCompression = value;
    }

    public boolean isEnableCompression() {
        return this.m_enableCompression;
    }

    public boolean isUseDRA() {
        return this.m_useDRA;
    }

    public void setUseDRA(boolean value) {
        this.m_useDRA = value;
    }

    public String getManagementNode() {
        return this.m_managementNode;
    }

    public void setManagementNode(String node) {
        this.m_managementNode = node != null ? node.trim() : null;
    }

    public String getDomainDescription() {
        return this.m_connectionName + " (" + this.m_domainName + "@" + this.m_url + ")";
    }

    public int getSocketConnectTimeout() {
        return this.m_socketConnectTimeout;
    }

    public void setSocketConnectTimeout(int socketConnectTimeout) {
        this.m_socketConnectTimeout = socketConnectTimeout;
    }

    public void setConnectTimeout(int timeout) {
        this.m_connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.m_connectTimeout;
    }

    public void setNotificationSubscriptionTimeout(int timeout) {
        this.m_subscriptionTimeout = timeout;
    }

    public int getNotificationSubscriptionTimeout() {
        return this.m_subscriptionTimeout;
    }

    public void setNotificationSubscriptionRenewalInterval(int interval) {
        this.m_subscriptionRenewalInterval = interval;
    }

    public int getNotificationSubscriptionRenewalInterval() {
        return this.m_subscriptionRenewalInterval;
    }

    public IConfigServer getConfigServer() {
        return this.m_csu.getConfigServer();
    }

    public ConfigServerUtility getConfigServerUtility() {
        return this.m_csu;
    }

    public IRemoteMBeanServer getMBeanServer() {
        return this.m_csu.getMBeanServer();
    }

    public IDirectoryFileSystemService getDirectoryService() {
        return this.m_csu.getDirectoryService();
    }

    public IAgentManagerProxy getAgentManager() {
        return this.m_amProxy;
    }

    public AgentManagerConnection getAgentManagerConnection() {
        return this.m_amConnection;
    }

    public String getAgentManagerName() {
        return this.getDomainName() + '.' + "AGENT MANAGER" + ":ID=" + "AGENT MANAGER";
    }

    public String getDirectoryServiceName() {
        return this.getDomainName() + '.' + "DIRECTORY SERVICE" + ":ID=" + "DIRECTORY SERVICE";
    }

    public boolean isConnected() {
        IRemoteMBeanServer server = this.getMBeanServer();
        if (server != null) {
            return server.isConnected();
        }
        return true;
    }

    private IAgentManagerProxy createAMProxy(IRemoteMBeanServer server) throws Exception {
        String amName = this.getAgentManagerName();
        return MFProxyFactory.createAgentManagerProxy((JMSConnectorClient)((JMSConnectorClient)server), (ObjectName)new ObjectName(amName));
    }

    public void registerStateNotificationListener() {
        this.m_stateListenerRegistrationThreads = new ArrayList();
        try {
            NotificationFilterSupport filter = new NotificationFilterSupport();
            for (int i = 0; i < AgentManagerConnection.HANDLED_EVENTS.length; ++i) {
                filter.enableType("system.state." + AgentManagerConnection.HANDLED_EVENTS[i]);
            }
            ObjectName amName = new ObjectName(this.getAgentManagerName());
            new Registrar(amName, filter).start();
        }
        catch (Throwable e) {
            String msg = "Failed to establish notification listener's subscription - " + this.getDomainDescription();
            MgmtConsole.getMgmtConsole().notifyMessage(3, msg, e, false);
        }
    }

    public void unregisterStateNotificationListener() {
        try {
            ObjectName amName = new ObjectName(this.getAgentManagerName());
            IRemoteMBeanServer server = this.getMBeanServer();
            server.removeNotificationListener(amName, (NotificationListener)this.m_amConnection);
        }
        catch (Throwable e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to unregister state notification listener", e, false);
        }
    }

    private void initFromPrefs(PreferenceManager prefs, String name) {
        this.m_connectionName = prefs.getString("connections." + name, PREFS_CONNECTION_NAME, this.m_connectionName);
        this.m_domainName = prefs.getString("connections." + name, PREFS_DOMAIN_NAME, this.m_domainName);
        this.m_url = prefs.getString("connections." + name, PREFS_URL, this.m_url);
        int defTimeout = prefs.getInt("preferences.general", PREFS_TIMEOUT, 30);
        this.m_requestTimeout = prefs.getInt("connections." + name, PREFS_TIMEOUT, defTimeout);
        this.m_userName = prefs.getString("connections." + name, PREFS_USER_NAME, "");
        this.m_loadBalancing = prefs.getBoolean("connections." + name, PREFS_LOAD_BALANCING, true);
        this.m_enableCompression = prefs.getBoolean("connections." + name, PREFS_ENABLE_COMPRESSION, false);
        this.m_useDRA = prefs.getBoolean("connections." + name, PREFS_USE_DRA, false);
        this.m_managementNode = prefs.getString("connections." + name, PREFS_NODE, "");
        this.m_connectTimeout = prefs.getInt("connections." + name, PREFS_CONNECT_TIMEOUT, 10);
        this.m_socketConnectTimeout = prefs.getInt("connections." + name, PREFS_SOCKET_CONNECT_TIMEOUT, 5);
        this.m_subscriptionTimeout = prefs.getInt("connections." + name, PREFS_SUBSCRIPTION_TIMEOUT, 600);
        this.m_subscriptionRenewalInterval = prefs.getInt("connections." + name, PREFS_SUBSCRIPTION_RENEWAL_INTERVAL, 30);
        String defConnectionName = DomainConnectionModel.getDefaultFromPrefs(prefs);
        if (defConnectionName != null && name.equals(defConnectionName)) {
            this.m_default = true;
        }
    }

    public void saveToPrefs(PreferenceManager prefs) {
        ArrayList firstN = DomainConnectionModel.getFirstN(prefs);
        prefs.setString("connections." + this.m_connectionName, PREFS_CONNECTION_NAME, this.m_connectionName, false);
        prefs.setString("connections." + this.m_connectionName, PREFS_DOMAIN_NAME, this.m_domainName, false);
        prefs.setString("connections." + this.m_connectionName, PREFS_URL, this.m_url, false);
        if (this.m_requestTimeout == -1) {
            prefs.remove("connections." + this.m_connectionName, PREFS_TIMEOUT, false);
        } else {
            prefs.setInt("connections." + this.m_connectionName, PREFS_TIMEOUT, this.m_requestTimeout, false);
        }
        if (this.m_userName != null && this.m_userName.length() != 0) {
            prefs.setString("connections." + this.m_connectionName, PREFS_USER_NAME, this.m_userName, false);
        } else {
            prefs.remove("connections." + this.m_connectionName, PREFS_USER_NAME, false);
        }
        prefs.setBoolean("connections." + this.m_connectionName, PREFS_LOAD_BALANCING, this.m_loadBalancing, false);
        prefs.setBoolean("connections." + this.m_connectionName, PREFS_ENABLE_COMPRESSION, this.m_enableCompression, false);
        this.m_useDRA = this.m_managementNode != null && this.m_managementNode.trim().length() != 0;
        prefs.setBoolean("connections." + this.m_connectionName, PREFS_USE_DRA, this.m_useDRA, false);
        if (this.isUseDRA()) {
            prefs.setString("connections." + this.m_connectionName, PREFS_NODE, this.m_managementNode, false);
        } else {
            prefs.setString("connections." + this.m_connectionName, PREFS_NODE, "", false);
        }
        if (this.m_connectTimeout == -1) {
            prefs.remove("connections." + this.m_connectionName, PREFS_CONNECT_TIMEOUT, false);
        } else {
            prefs.setInt("connections." + this.m_connectionName, PREFS_CONNECT_TIMEOUT, this.m_connectTimeout, false);
        }
        if (this.m_socketConnectTimeout == -1) {
            prefs.remove("connections." + this.m_connectionName, PREFS_SOCKET_CONNECT_TIMEOUT, false);
        } else {
            prefs.setInt("connections." + this.m_connectionName, PREFS_SOCKET_CONNECT_TIMEOUT, this.m_socketConnectTimeout, false);
        }
        if (this.m_subscriptionTimeout == -1) {
            prefs.remove("connections." + this.m_connectionName, PREFS_SUBSCRIPTION_TIMEOUT, false);
        } else {
            prefs.setInt("connections." + this.m_connectionName, PREFS_SUBSCRIPTION_TIMEOUT, this.m_subscriptionTimeout, false);
        }
        if (this.m_subscriptionRenewalInterval == -1) {
            prefs.remove("connections." + this.m_connectionName, PREFS_SUBSCRIPTION_RENEWAL_INTERVAL, false);
        } else {
            prefs.setInt("connections." + this.m_connectionName, PREFS_SUBSCRIPTION_RENEWAL_INTERVAL, this.m_subscriptionRenewalInterval, false);
        }
        if (this.isDefault()) {
            DomainConnectionModel.saveDefaultToPrefs(prefs, this.m_connectionName);
        } else {
            String defName = DomainConnectionModel.getDefaultFromPrefs(prefs);
            if (defName != null && defName.equals(this.m_connectionName)) {
                DomainConnectionModel.removeDefaultFromPrefs(prefs);
            }
        }
        int maxConnections = prefs.getInt("preferences.general", PREFS_MAX_CONNECTIONS, 10);
        if (firstN.contains(this.m_connectionName)) {
            firstN.remove(this.m_connectionName);
        }
        firstN.add(0, this.m_connectionName);
        String defConName = DomainConnectionModel.getDefaultFromPrefs(prefs);
        while (firstN.size() > maxConnections) {
            String remove = (String)firstN.get(maxConnections);
            remove = defConName != null && defConName.equals(remove) ? (String)firstN.remove(maxConnections - 1) : (String)firstN.remove(maxConnections);
            prefs.removeNode("connections." + remove);
        }
        DomainConnectionModel.saveFirstN(prefs, firstN);
        prefs.flush("connections");
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DomainConnectionModel dcm = (DomainConnectionModel)object;
        return dcm.getDomainName().equals(this.getDomainName());
    }

    public int hashCode() {
        return Objects.hashCode(this.getDomainName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Connection (");
        sb.append("name=").append(this.getConnectionName()).append(", ");
        sb.append("domain=").append(this.getDomainName()).append(", ");
        sb.append("url=").append(this.getUrl()).append(", ");
        sb.append("user=").append(this.getUserName()).append(", ");
        sb.append("timeout=").append(this.getTimeout()).append(", ");
        sb.append("load balancing=").append(this.isLoadBalancing());
        if (this.getNotificationSubscriptionTimeout() >= 0) {
            sb.append("notification subscription timeout=").append(this.getNotificationSubscriptionTimeout());
        }
        if (this.getNotificationSubscriptionRenewalInterval() >= 0) {
            sb.append("notification subscription renewal interval=").append(this.getNotificationSubscriptionRenewalInterval());
        }
        String managementNode = this.getManagementNode();
        if (this.isUseDRA() && managementNode != null && managementNode.length() > 0) {
            sb.append(", management node=").append(managementNode);
        }
        sb.append("connect_timeout=").append(this.getConnectTimeout()).append(", ");
        sb.append("socket_connect_timeout=").append(this.getSocketConnectTimeout()).append(", ");
        sb.append("enable compresiion=").append(this.isEnableCompression()).append(", ");
        sb.append(")");
        return sb.toString();
    }

    public static ArrayList getFirstN(PreferenceManager prefs) {
        ArrayList<String> list = new ArrayList<String>();
        String value = prefs.getString("connections", "firstN", null);
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return list;
    }

    private static void saveFirstN(PreferenceManager prefs, ArrayList list) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append((String)list.get(i));
        }
        prefs.setString("connections", "firstN", buffer.toString(), false);
    }

    private static String getDefaultFromPrefs(PreferenceManager prefs) {
        return prefs.getString("connections", "defaultConnectionName", null);
    }

    private static void saveDefaultToPrefs(PreferenceManager prefs, String name) {
        prefs.setString("connections", "defaultConnectionName", name, false);
    }

    private static void removeDefaultFromPrefs(PreferenceManager prefs) {
        prefs.remove("connections", "defaultConnectionName", false);
    }

    public void onSuccess(String target, String operationName, Object returnValue, long requestReceived, long requestCompleted) {
        int duration = (int)((requestCompleted - requestReceived) / 1000L);
        String msg = "Operation '" + operationName + "' on '" + target + "' completed successfully (Duration " + duration + " seconds).";
        MgmtConsole.getMgmtConsole().notifyMessage(2, msg, false);
    }

    public void onFailure(String target, String operationName, Exception e, long requestReceived, long requestAborted) {
        int duration = (int)((requestAborted - requestReceived) / 1000L);
        String msg = "Operation '" + operationName + "' on '" + target + "' failed (Duration " + duration + " seconds).";
        MgmtConsole.getMgmtConsole().notifyMessage(2, msg, e, false);
    }

    public void onReconnect(String localRoutingNode) {
        String msg = "Reconnected to " + this.getDomainDescription();
        MgmtConsole.getMgmtConsole().notifyMessage(1, msg, false);
        this.m_amConnection.pollImmediately();
    }

    public void onDisconnect() {
        String msg = "Disconnected from " + this.getDomainDescription();
        MgmtConsole.getMgmtConsole().notifyMessage(1, msg, false);
    }

    public void onFailure(Exception e) {
        String msg = "Connection failure to " + this.getDomainDescription();
        MgmtConsole.getMgmtConsole().notifyMessage(1, msg, e, false);
    }

    public void onNotificationListenerRenewalFailure(Exception e) {
        String msg = "Failed to renew notification listener's subscription - " + this.getDomainDescription();
        MgmtConsole.getMgmtConsole().notifyMessage(3, msg, e, e instanceof ManagementPermissionDeniedException);
    }

    public short onRequestFailure(String failedTarget, String failedConnectionURL, Exception e, short[] allowedResponseValues) {
        short response = 0;
        JFailoverDialog dlg = new JFailoverDialog(MgmtConsole.getMgmtConsole(), failedTarget, failedConnectionURL, e, allowedResponseValues);
        dlg.setVisible(true);
        if (dlg.getDefaultCloseOperation() == 0) {
            response = dlg.getResponseValue();
        }
        return response;
    }

    protected boolean isAllowedValue(short[] allowedValues, short value) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (allowedValues[i] != value) continue;
            return true;
        }
        return false;
    }

    private class Registrar
    extends Thread {
        private ObjectName amName;
        private NotificationFilterSupport filter;

        private Registrar(ObjectName amName, NotificationFilterSupport filter) {
            super("State Notification Listener Registrar - " + amName.getCanonicalName());
            this.amName = amName;
            this.filter = filter;
            super.setDaemon(true);
            DomainConnectionModel.this.m_stateListenerRegistrationThreads.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IRemoteMBeanServer server = DomainConnectionModel.this.getMBeanServer();
            if (server != null && !this.isInterrupted()) {
                try {
                    server.addNotificationListener(this.amName, (NotificationListener)DomainConnectionModel.this.m_amConnection, (NotificationFilter)this.filter, null);
                }
                catch (Throwable e) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    String msg = "Failed to establish notification listener's subscription - " + DomainConnectionModel.this.getDomainDescription();
                    MgmtConsole.getMgmtConsole().notifyMessage(3, msg, e, false);
                }
                finally {
                    DomainConnectionModel.this.m_stateListenerRegistrationThreads.remove(this);
                }
            }
        }
    }
}

