/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.domain;

import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import modelobjects.framework.EditRule;
import modelobjects.framework.IntToStringConverter;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.ModelObjectValidator;
import modelobjects.framework.model.ModelValidationException;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

public class JDomainConnectionDialog
extends JPropSheetTabbedDialog {
    private JTextField m_connectionName = new JTextField(25);
    private JTextField m_domainName = new JTextField();
    private JTextField m_url = new JTextField();
    private JTextField m_userName = new JTextField();
    private JPasswordField m_password = new JPasswordField();
    private JCheckBox m_default = new JCheckBox();
    private JTextField m_managementNode = new JTextField();
    private JTextField m_connectTimeout = new JTextField();
    private JTextField m_socket_connect_timeout = new JTextField();
    private JTextField m_timeout = new JTextField();
    private JTextField m_subscriptionTimeout = new JTextField();
    private JTextField m_subscriptionRenewalInterval = new JTextField();
    private JCheckBox m_loadBalancing = new JCheckBox();
    private JCheckBox m_enableCompression = new JCheckBox();

    public JDomainConnectionDialog(JMAFrame parent) {
        super(parent, "domain.connection", DomainConnectionModel.class);
        this.setResizableProperty();
        this.setValidator(new DomainConnectionValidator());
    }

    private void setResizableProperty() {
        this.setResizable(false);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    @Override
    protected void initUI() throws Exception {
        String generalTab = ResourceManager.getString(this.getClass(), "dialog.domain.tab.general.label");
        String ftTab = ResourceManager.getString(this.getClass(), "dialog.domain.tab.ft.label");
        String advancedTab = ResourceManager.getString(this.getClass(), "dialog.domain.tab.advanced.label");
        this.addTabPanel(generalTab, this.createGeneralPanel());
        this.addTabPanel(advancedTab, this.createAdvancedPanel());
    }

    @Override
    protected void initForm() throws Exception {
        this.createJTextFieldAdapter("connectionName", this.m_connectionName, EditRule.ALWAYS);
        this.createJTextFieldAdapter("domainName", this.m_domainName, EditRule.ALWAYS);
        this.createJTextFieldAdapter("url", this.m_url, EditRule.ALWAYS);
        this.createJTextFieldAdapter("userName", this.m_userName, EditRule.ALWAYS);
        this.createJTextFieldAdapter("password", this.m_password, EditRule.ALWAYS);
        this.createJCheckBoxAdapter("default", this.m_default, EditRule.ALWAYS);
        this.createJTextFieldAdapter("managementNode", this.m_managementNode, EditRule.ALWAYS);
        this.createJTextFieldAdapter("connectTimeout", this.m_connectTimeout, EditRule.ALWAYS, new TimeoutConverter(10000L));
        this.createJTextFieldAdapter("socketConnectTimeout", this.m_socket_connect_timeout, EditRule.ALWAYS, new TimeoutConverter(0L));
        this.createJTextFieldAdapter("timeout", this.m_timeout, EditRule.ALWAYS, new TimeoutConverter(10000L));
        this.createJTextFieldAdapter("notificationSubscriptionTimeout", this.m_subscriptionTimeout, EditRule.ALWAYS, new IntToStringConverter());
        this.createJTextFieldAdapter("notificationSubscriptionRenewalInterval", this.m_subscriptionRenewalInterval, EditRule.ALWAYS, new IntToStringConverter());
        this.createJCheckBoxAdapter("loadBalancing", this.m_loadBalancing, EditRule.ALWAYS);
        this.createJCheckBoxAdapter("enableCompression", this.m_enableCompression, EditRule.ALWAYS);
    }

    private JPanel createGeneralPanel() {
        String paramGroup = ResourceManager.getString(this.getClass(), "dialog.domain.general.parameters.label");
        String connectionName = ResourceManager.getString(this.getClass(), "dialog.domain.general.connection_name.label");
        String domainName = ResourceManager.getString(this.getClass(), "dialog.domain.general.domain_name.label");
        String url = ResourceManager.getString(this.getClass(), "dialog.domain.general.connection_url.label");
        String user = ResourceManager.getString(this.getClass(), "dialog.domain.general.user_name.label");
        String password = ResourceManager.getString(this.getClass(), "dialog.domain.general.password.label");
        String cbDefault = ResourceManager.getString(this.getClass(), "dialog.domain.general.default.label");
        this.m_default.setText(cbDefault);
        JPartitionPanel panel1 = new JPartitionPanel("General Settings");
        panel1.addRow("*" + connectionName, (JComponent)this.m_connectionName);
        panel1.addRow("*" + domainName, (JComponent)this.m_domainName);
        panel1.addRow("*" + url, (JComponent)this.m_url);
        panel1.addRow(user, (JComponent)this.m_userName);
        panel1.addRow(password, (JComponent)this.m_password);
        panel1.addRow(this.m_default);
        JPartitionPanel panel = new JPartitionPanel(true, "p,p", null);
        panel.add(panel1);
        return panel;
    }

    private JPanel createAdvancedPanel() {
        String connGroup = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.group.connection.label");
        String node = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.node.label");
        String loadBalancing = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.load_balancing.label");
        String connect_timeout = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.connect_timeout.label");
        String socket_connect_timeout = ResourceManager.getString(this.getClass(), "dialog.domain.ft.socket_time_out.label");
        String timeout = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.timeout.label");
        String subscription_timeout = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.notification_subscription_timeout.label");
        String subscription_renewal_interval = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.notification_subscription_renewal_interval.label");
        String enableCompression = ResourceManager.getString(this.getClass(), "dialog.domain.advanced.enable_compression.label");
        String unitSec = ResourceManager.getString(this.getClass(), new Object[]{"unit", "seconds"});
        JPartitionPanel panel1 = new JPartitionPanel(connGroup);
        panel1.addRow(node, (JComponent)this.m_managementNode);
        panel1.addRow(connect_timeout, (JComponent)this.m_connectTimeout, unitSec);
        panel1.addRow(socket_connect_timeout, (JComponent)this.m_socket_connect_timeout, unitSec);
        panel1.addRow(timeout, (JComponent)this.m_timeout, unitSec);
        panel1.addRow(subscription_timeout, (JComponent)this.m_subscriptionTimeout, unitSec);
        panel1.addRow(subscription_renewal_interval, (JComponent)this.m_subscriptionRenewalInterval, unitSec);
        panel1.addRow(loadBalancing, (JComponent)this.m_loadBalancing);
        panel1.addRow(enableCompression, (JComponent)this.m_enableCompression);
        JPartitionPanel panel = new JPartitionPanel(true, "p,p", null);
        panel.add(panel1);
        return panel;
    }

    protected JTextFieldAdapter createJTextFieldAdapter(String propertyName, JTextField viewComponent, EditRule editRule) {
        return this.createJTextFieldAdapter(propertyName, viewComponent, editRule, null);
    }

    protected JTextFieldAdapter createJTextFieldAdapter(String propertyName, JTextField viewComponent, EditRule editRule, ViewValueConverter converter) {
        return new JTextFieldAdapter(ModelAspectId.forName(propertyName), viewComponent, editRule, converter, this.getMediator());
    }

    protected JCheckBoxAdapter createJCheckBoxAdapter(String propertyName, JCheckBox viewComponent, EditRule editRule) {
        return new JCheckBoxAdapter(ModelAspectId.forName(propertyName), viewComponent, editRule, null, this.getMediator());
    }

    @Override
    protected String getModelEditFailureMessage(Throwable throwable) {
        if (throwable instanceof ViewValueConversionException) {
            String msg = ((ViewValueConversionException)throwable).getMessage();
            int index = msg.lastIndexOf(44);
            return index != -1 ? msg.substring(0, index) : msg;
        }
        return super.getModelEditFailureMessage(throwable);
    }

    private class DomainConnectionValidator
    implements ModelObjectValidator {
        private DomainConnectionValidator() {
        }

        @Override
        public void validateModelEdit(ModelObjectAdapter modelObjectAdapter) throws ModelValidationException {
            String connectionName = (String)modelObjectAdapter.getAspectValue(ModelAspectId.forName("connectionName"));
            if (connectionName.trim().length() == 0) {
                throw new ModelValidationException("A value for 'Connection Name' isn't specified. This is a required field", new IllegalArgumentException("connectionName"));
            }
        }

        @Override
        public void validateModelCreation(ModelObjectAdapter modelObjectAdapter) throws ModelValidationException {
            this.validateModelEdit(modelObjectAdapter);
        }

        @Override
        public void validateModelDeletion(ModelObjectAdapter modelObjectAdapter) throws ModelValidationException {
        }
    }

    private class TimeoutConverter
    extends IntToStringConverter {
        private int m_minimum;

        public TimeoutConverter(long minimum) {
            super(false);
            this.m_minimum = (int)(minimum / 1000L);
        }

        @Override
        public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
            Integer res = (Integer)super.viewValueToModel(viewValue);
            int value = res;
            if (value < this.m_minimum) {
                throw new ViewValueConversionException("Invalid timeout - value must be >= " + this.m_minimum + " seconds.");
            }
            return res;
        }

        @Override
        public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
            if (modelValue instanceof Integer && (Integer)modelValue == -1) {
                return null;
            }
            return super.modelValueToView(modelValue);
        }
    }
}

