/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.domain;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JFailoverDialog
extends JDialog {
    short m_option = 0;
    short[] m_allowedValues;

    public JFailoverDialog(JMAFrame parent, String failedTarget, String failedConnectionURL, Exception e, short[] allowedResponseValues) {
        super(parent, "", true);
        this.m_allowedValues = allowedResponseValues;
        this.prepareJFailOverDialog(failedTarget, failedConnectionURL, e);
    }

    private void prepareJFailOverDialog(String failedTarget, String failedConnectionURL, Exception e) {
        String title = e instanceof InvokeTimeoutCommsException ? "Communication Failure" : "Request Failure";
        this.setTitle(title);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ect) {
                JFailoverDialog.this.doCancel();
            }
        });
        JButtonPanel btnPanel = new JButtonPanel(false);
        btnPanel.addButton(new FailoverAction());
        btnPanel.addButton(new RetryAction());
        btnPanel.addButton(new CancelAction());
        String text = null;
        text = e instanceof InvokeTimeoutException ? "Timeout while communicating with target" : (e instanceof InvokeTimeoutCommsException ? "Connection failure while communicating with target" : e.getMessage());
        MgmtConsole.getMgmtConsole().notifyMessage(1, text, e, false);
        JPartitionPanel failurePanel = new JPartitionPanel(false, "p,r", null);
        failurePanel.addRow("Target", (JComponent)new JLabel(failedTarget));
        failurePanel.addRow("URL", (JComponent)new JLabel(failedConnectionURL));
        failurePanel.addRow("Error message", (JComponent)new JLabel(text));
        ExtendedImageIcon image = new ExtendedImageIcon(ResourceManager.getIcon(this.getClass(), "Domain"), ResourceManager.getIcon(this.getClass(), "deleteoverlay"));
        JLabel icon = new JLabel("", image, 0);
        icon.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPartitionPanel topPanel = new JPartitionPanel(false, "p,r", "");
        topPanel.add(icon);
        topPanel.add(failurePanel);
        JPartitionPanel panel = new JPartitionPanel(true, "p,p", null);
        panel.add(topPanel);
        this.getContentPane().add(panel);
        this.getContentPane().add((Component)JPartitionPanel.merge("r,p,r", false, new Component[]{new JPanel(), btnPanel, new JPanel()}), "South");
        this.pack();
        this.setLocation(this.getCenteredLocation());
    }

    @Override
    public void setVisible(boolean state) {
        super.setVisible(state);
    }

    public short getResponseValue() {
        return this.m_option;
    }

    private void doCancel() {
        this.setVisible(false);
        this.dispose();
    }

    private Point getCenteredLocation() {
        Point pLoc = this.getParent().getLocation();
        Dimension pSize = this.getParent().getSize();
        Dimension cSize = this.getPreferredSize();
        return new Point(pLoc.x + (pSize.width - cSize.width) / 2, pLoc.y + (pSize.height - cSize.height) / 2);
    }

    protected boolean isAllowedValue(short value) {
        for (int i = 0; i < this.m_allowedValues.length; ++i) {
            if (this.m_allowedValues[i] != value) continue;
            return true;
        }
        return false;
    }

    private class FailoverAction
    extends BasicGuiAction {
        public FailoverAction() {
            super("dialog.failover");
        }

        @Override
        public boolean isEnabled() {
            return JFailoverDialog.this.isAllowedValue((short)2);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFailoverDialog.this.m_option = (short)2;
            JFailoverDialog.this.doCancel();
        }
    }

    private class RetryAction
    extends BasicGuiAction {
        public RetryAction() {
            super("dialog.retry");
        }

        @Override
        public boolean isEnabled() {
            return JFailoverDialog.this.isAllowedValue((short)1);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFailoverDialog.this.m_option = 1;
            JFailoverDialog.this.doCancel();
        }
    }

    private class CancelAction
    extends BasicGuiAction {
        public CancelAction() {
            super("dialog.cancel");
        }

        @Override
        public boolean isEnabled() {
            return JFailoverDialog.this.isAllowedValue((short)0);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFailoverDialog.this.m_option = 0;
            JFailoverDialog.this.doCancel();
        }
    }
}

